/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.seguimiento;

import controlador.Libraries.Effects;
import controlador.Libraries.Middlewares;
import controlador.Libraries.abstracts.AbstractVTN;
import controlador.principal.VtnPrincipalCTR;
import controlador.silabo.seguimiento.FrmSeguimientoEvalCTR;
import controlador.silabo.seguimiento.VtnConfigSeguimientoEvalCTR;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.event.ListSelectionEvent;
import modelo.curso.CursoMD;
import modelo.seguimientoSilabo.SeguimientoEvaluacionBD;
import modelo.seguimientoSilabo.SeguimientoEvaluacionMD;
import modelo.silabo.NEWCursoBD;
import modelo.silabo.NEWSilaboBD;
import modelo.silabo.SilaboMD;
import modelo.unidadSilabo.UnidadSilaboMD;
import utils.CONS;
import vista.silabos.seguimiento.VtnSeguimientoEvaluacion;

public class VtnSeguimientoEvaluacionCTR
extends AbstractVTN<VtnSeguimientoEvaluacion, SeguimientoEvaluacionMD> {
    private final NEWSilaboBD SILABO_CONN = NEWSilaboBD.single();
    private final NEWCursoBD CURSO_CONN = NEWCursoBD.single();
    private final SeguimientoEvaluacionBD CONN = SeguimientoEvaluacionBD.sigle();
    private List<SilaboMD> misSilabos = null;
    private List<CursoMD> misCursos = new ArrayList<CursoMD>();

    public VtnSeguimientoEvaluacionCTR(VtnPrincipalCTR desktop) {
        super(desktop);
        this.vista = new VtnSeguimientoEvaluacion();
    }

    @Override
    public void Init() {
        this.setTable(((VtnSeguimientoEvaluacion)this.vista).getTbl());
        new Thread(() -> {
            this.misSilabos = this.SILABO_CONN.getMisSilabosConUnidadesBy(CONS.USUARIO.getPersona().getIdentificacion());
            this.cargarCmbSilabos();
            super.Init();
        }).start();
        this.InitEventos();
    }

    private void InitEventos() {
        ((VtnSeguimientoEvaluacion)this.vista).getCmbSilabo().addItemListener(this::cmbUnidades);
        ((VtnSeguimientoEvaluacion)this.vista).getBtnAgregar().addActionListener(this::btnNuevo);
        ((VtnSeguimientoEvaluacion)this.vista).getCmbUnidad().addActionListener(e -> this.buscarSeguimientosBd());
        ((VtnSeguimientoEvaluacion)this.vista).getCmbCursos().addActionListener(e -> this.buscarSeguimientosBd());
        ((VtnSeguimientoEvaluacion)this.vista).getBtnEditar().addActionListener(this::btnEditar);
        ((VtnSeguimientoEvaluacion)this.vista).getTbl().getSelectionModel().addListSelectionListener(this::tblChangeSelect);
        ((VtnSeguimientoEvaluacion)this.vista).getBtnImprimir().addActionListener(this::btnImprimir);
    }

    private void buscarSeguimientosBd() {
        try {
            this.lista = this.CONN.getSeguimientosBy(this.getCurso().getId(), this.getUnidad().getID());
            this.cargarTabla(this.cargador());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private SeguimientoEvaluacionMD getSeguimiento() throws ArrayIndexOutOfBoundsException {
        Integer ID = Integer.valueOf(this.tableM.getValueAt(this.getSelectedRow(), 0).toString());
        return this.lista.stream().filter(item -> item.getID().equals(ID)).findFirst().get();
    }

    private SilaboMD getSilabo() {
        return this.misSilabos.stream().filter(item -> item.nombrePeriodoMateria().equals(((VtnSeguimientoEvaluacion)this.vista).getCmbSilabo().getSelectedItem().toString())).findFirst().orElse(null);
    }

    private UnidadSilaboMD getUnidad() throws NullPointerException {
        return this.getSilabo().getUnidades().stream().filter(item -> item.getNumeroUnidad() == Integer.valueOf(((VtnSeguimientoEvaluacion)this.vista).getCmbUnidad().getSelectedItem().toString()).intValue()).findFirst().orElse(null);
    }

    private CursoMD getCurso() throws NullPointerException {
        return this.misCursos.stream().filter(item -> item.getNombre().equals(((VtnSeguimientoEvaluacion)this.vista).getCmbCursos().getSelectedItem().toString())).findFirst().orElse(null);
    }

    private Consumer<SeguimientoEvaluacionMD> cargador() {
        return obj -> this.tableM.addRow(new Object[]{obj.getID(), obj.getEvaluacion().getIdUnidad().getNumeroUnidad(), obj.getEvaluacion().getInstrumento(), obj.getEvaluacion().getIdTipoActividad().getNombreTipoActividad(), obj.getEvaluacion().getValoracion(), SeguimientoEvaluacionMD.formatoToString(obj.getFormato())});
    }

    private void cargarCmbSilabos() {
        this.misSilabos.stream().map(c -> c.nombrePeriodoMateria()).forEach(((VtnSeguimientoEvaluacion)this.vista).getCmbSilabo()::addItem);
    }

    private void cargarCursos() {
        ((VtnSeguimientoEvaluacion)this.vista).getCmbCursos().removeAllItems();
        this.misCursos = this.CURSO_CONN.getMisCursosBy(CONS.USUARIO.getPersona().getIdentificacion(), this.getSilabo().getPeriodo().getID(), this.getSilabo().getMateria().getId());
        this.misCursos.stream().map(c -> c.getNombre()).forEach(((VtnSeguimientoEvaluacion)this.vista).getCmbCursos()::addItem);
    }

    private void setTxtDescripcion() {
    }

    private void cmbUnidades(ItemEvent e) {
        ((VtnSeguimientoEvaluacion)this.vista).getCmbUnidad().removeAllItems();
        this.misSilabos.stream().filter(item -> item.nombrePeriodoMateria().equals(((VtnSeguimientoEvaluacion)this.vista).getCmbSilabo().getSelectedItem().toString())).flatMap(c -> c.getUnidades().stream()).map(c -> c.getNumeroUnidad() + "").forEach(((VtnSeguimientoEvaluacion)this.vista).getCmbUnidad()::addItem);
        this.cargarCursos();
    }

    private void btnNuevo(ActionEvent e) {
        VtnConfigSeguimientoEvalCTR vtn = new VtnConfigSeguimientoEvalCTR(this.desktop);
        vtn.Init();
    }

    private void btnEditar(ActionEvent e) {
        FrmSeguimientoEvalCTR form = new FrmSeguimientoEvalCTR(this.desktop, this.getSilabo(), this.getUnidad(), this.getCurso());
        form.Init();
    }

    private void btnImprimir(ActionEvent e) {
        new Thread(() -> {
            Effects.setLoadCursor(this.vista);
            ((VtnSeguimientoEvaluacion)this.vista).getLblEstado().setVisible(true);
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("idCurso", this.getCurso().getId());
            params.put("idUnidadSilabo", this.getUnidad().getID());
            Middlewares.generarReporte(this.getClass().getResource("/vista/silabos/seguimiento/reportes/seguimientoEval/MAIN.jasper"), "Cuadro de Gestion de Actividades", params);
            ((VtnSeguimientoEvaluacion)this.vista).getLblEstado().setVisible(false);
            Effects.setDefaultCursor(this.vista);
        }).start();
    }

    private void tblChangeSelect(ListSelectionEvent e) {
        try {
            this.showTableMessage = false;
            ((VtnSeguimientoEvaluacion)this.vista).getTxtDescripcion().setText(this.getSeguimiento().getTxtAreaDescripcion());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.showTableMessage = true;
        }
    }
}

