/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.seguimiento;

import controlador.Libraries.Effects;
import controlador.Libraries.abstracts.AbstractVTN;
import controlador.principal.VtnPrincipalCTR;
import controlador.silabo.seguimiento.FrmSeguimientoEvalCTR;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import modelo.curso.CursoMD;
import modelo.seguimientoSilabo.SeguimientoEvaluacionBD;
import modelo.seguimientoSilabo.SeguimientoEvaluacionMD;
import modelo.silabo.NEWCursoBD;
import modelo.silabo.NEWSilaboBD;
import modelo.silabo.SilaboMD;
import modelo.unidadSilabo.UnidadSilaboMD;
import utils.CONS;
import vista.silabos.seguimiento.VtnConfigSeguimientoEval;

public class VtnConfigSeguimientoEvalCTR
extends AbstractVTN<VtnConfigSeguimientoEval, SeguimientoEvaluacionMD> {
    private final NEWSilaboBD SILABO_CONN = NEWSilaboBD.single();
    private final SeguimientoEvaluacionBD CONN = SeguimientoEvaluacionBD.sigle();
    private final NEWCursoBD CURSO_CONN = NEWCursoBD.single();
    private List<SilaboMD> misSilabos = null;
    private List<CursoMD> misCursos = null;
    private List<CursoMD> cursosRef = null;

    public VtnConfigSeguimientoEvalCTR(VtnPrincipalCTR desktop) {
        super(desktop);
        this.vista = new VtnConfigSeguimientoEval();
    }

    @Override
    public void Init() {
        super.Init();
        this.InitEventos();
        this.misSilabos = this.SILABO_CONN.getMisSilabosConUnidadesBy(CONS.USUARIO.getPersona().getIdentificacion());
        this.cargarCmbSilabos();
    }

    private void InitEventos() {
        ((VtnConfigSeguimientoEval)this.vista).getCmbSilabo().addItemListener(this::cmbUnidades);
        ((VtnConfigSeguimientoEval)this.vista).getCmbUnidad().addItemListener(this::cmbCursos);
        ((VtnConfigSeguimientoEval)this.vista).getBtnSiguiente().addActionListener(this::btnSiguiente);
    }

    private void validarCmbCursos() {
        ((VtnConfigSeguimientoEval)this.vista).getCmbCurso().removeAllItems();
        ((VtnConfigSeguimientoEval)this.vista).getCmbCursoRef().removeAllItems();
        if (this.misCursos.size() < 1) {
            ((VtnConfigSeguimientoEval)this.vista).getCmbCurso().setEnabled(false);
            ((VtnConfigSeguimientoEval)this.vista).getCmbCurso().addItem("UNIDAD COMPLETADA");
            ((VtnConfigSeguimientoEval)this.vista).getBtnSiguiente().setEnabled(false);
        } else {
            ((VtnConfigSeguimientoEval)this.vista).getCmbCurso().setEnabled(true);
            ((VtnConfigSeguimientoEval)this.vista).getBtnSiguiente().setEnabled(true);
            this.cursosRef = this.CURSO_CONN.getDeReferenciaSeguimientoEval(this.getUnidad().getID());
            if (this.cursosRef.size() < 1) {
                ((VtnConfigSeguimientoEval)this.vista).getCmbCursoRef().addItem("NO TIENE");
                ((VtnConfigSeguimientoEval)this.vista).getCmbCursoRef().setEnabled(false);
            } else {
                ((VtnConfigSeguimientoEval)this.vista).getCmbCursoRef().setEnabled(true);
                ((VtnConfigSeguimientoEval)this.vista).getCmbCursoRef().addItem("SI TIENE CURSOS DE REFERENCIA");
                this.cargarCursosRef();
            }
        }
    }

    private void cargarCursosRef() {
        this.cursosRef.stream().map(c -> c.getNombre()).forEach(((VtnConfigSeguimientoEval)this.vista).getCmbCursoRef()::addItem);
    }

    private void cargarCmbSilabos() {
        this.misSilabos.stream().map(c -> c.nombrePeriodoMateria()).forEach(((VtnConfigSeguimientoEval)this.vista).getCmbSilabo()::addItem);
    }

    private SilaboMD getSilabo() {
        return this.misSilabos.stream().filter(item -> item.nombrePeriodoMateria().equals(((VtnConfigSeguimientoEval)this.vista).getCmbSilabo().getSelectedItem().toString())).findFirst().orElse(null);
    }

    private UnidadSilaboMD getUnidad() throws NullPointerException {
        return this.getSilabo().getUnidades().stream().filter(item -> item.getNumeroUnidad() == Integer.valueOf(((VtnConfigSeguimientoEval)this.vista).getCmbUnidad().getSelectedItem().toString()).intValue()).findFirst().orElse(null);
    }

    private CursoMD getCurso() {
        return this.misCursos.stream().filter(item -> item.getNombre().equals(((VtnConfigSeguimientoEval)this.vista).getCmbCurso().getSelectedItem().toString())).findFirst().orElse(null);
    }

    private CursoMD getCursoRef() {
        return this.cursosRef.stream().filter(item -> item.getNombre().equals(((VtnConfigSeguimientoEval)this.vista).getCmbCursoRef().getSelectedItem().toString())).findFirst().orElse(null);
    }

    private void cmbUnidades(ItemEvent e) {
        ((VtnConfigSeguimientoEval)this.vista).getCmbUnidad().removeAllItems();
        this.misSilabos.stream().filter(item -> item.nombrePeriodoMateria().equals(((VtnConfigSeguimientoEval)this.vista).getCmbSilabo().getSelectedItem().toString())).flatMap(c -> c.getUnidades().stream()).map(c -> c.getNumeroUnidad() + "").forEach(((VtnConfigSeguimientoEval)this.vista).getCmbUnidad()::addItem);
    }

    private void cmbCursos(ItemEvent e) {
        try {
            this.misCursos = this.CURSO_CONN.getFaltantesSeguimientoEval(this.getSilabo(), this.getUnidad().getID());
            this.validarCmbCursos();
            this.misCursos.stream().map(c -> c.getNombre()).forEach(((VtnConfigSeguimientoEval)this.vista).getCmbCurso()::addItem);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void btnSiguiente(ActionEvent e) {
        new Thread(() -> {
            Effects.setLoadCursor(this.vista);
            FrmSeguimientoEvalCTR form = new FrmSeguimientoEvalCTR(this.desktop, this.getSilabo(), this.getUnidad(), this.getCurso());
            if (((VtnConfigSeguimientoEval)this.vista).getCmbCursoRef().getSelectedIndex() != 0) {
                this.CONN.copiarSeguimientos(this.getCurso().getId(), this.getUnidad().getID(), this.getCursoRef().getId());
            } else {
                this.CONN.crearSeguimientos(this.getUnidad().getID(), this.getCurso().getId());
            }
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(VtnConfigSeguimientoEvalCTR.class.getName()).log(Level.SEVERE, null, ex);
            }
            Effects.setDefaultCursor(this.vista);
            form.Init();
            ((VtnConfigSeguimientoEval)this.vista).dispose();
        }).start();
    }
}

