/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.seguimiento;

import controlador.Libraries.abstracts.AbstractVTN;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.curso.CursoMD;
import modelo.evaluacionSilabo.EvaluacionSilaboMD;
import modelo.evaluacionSilabo.NEWEvaluacionSilaboBD;
import modelo.seguimientoSilabo.SeguimientoEvaluacionBD;
import modelo.seguimientoSilabo.SeguimientoEvaluacionMD;
import modelo.silabo.SilaboMD;
import modelo.unidadSilabo.UnidadSilaboMD;
import utils.CONS;
import vista.silabos.seguimiento.FrmSeguimientoEvaluacion;

public class FrmSeguimientoEvalCTR
extends AbstractVTN<FrmSeguimientoEvaluacion, SeguimientoEvaluacionMD> {
    private final SeguimientoEvaluacionBD CONN = SeguimientoEvaluacionBD.sigle();
    private final NEWEvaluacionSilaboBD EVAL_CONN = NEWEvaluacionSilaboBD.single();
    private EvaluacionSilaboMD evaluacion = null;
    private final SilaboMD silabo;
    private final UnidadSilaboMD unidad;
    private final CursoMD curso;
    private List<EvaluacionSilaboMD> evaluaciones;

    public FrmSeguimientoEvalCTR(VtnPrincipalCTR desktop, SilaboMD silabo, UnidadSilaboMD unidad, CursoMD curso) {
        super(desktop);
        this.vista = new FrmSeguimientoEvaluacion();
        this.silabo = silabo;
        this.unidad = unidad;
        this.curso = curso;
    }

    @Override
    public void Init() {
        super.Init();
        ((FrmSeguimientoEvaluacion)this.vista).setTitle(this.silabo.nombrePeriodoMateria());
        ((FrmSeguimientoEvaluacion)this.vista).getLblUnidad().setText("UNIDAD: " + this.unidad.getNumeroUnidad() + ". " + this.unidad.getTituloUnidad() + " \t\nCURSO: " + this.curso.getNombre());
        this.evaluaciones = this.EVAL_CONN.getByUnidad(this.unidad.getID(), this.curso.getId());
        if (this.evaluaciones.isEmpty()) {
            ((FrmSeguimientoEvaluacion)this.vista).dispose();
            JOptionPane.showMessageDialog(this.vista, "TODAVIA NO HA CREADO INFORMES PARA ESTA UNIDAD", "AVISO", 1);
        }
        this.InitEventos();
        this.cargarCmbEvaluaciones();
        System.out.println("ID UNIDAD: " + this.unidad.getID());
        System.out.println("ID SILABO: " + this.silabo.getID());
        System.out.println("ID CURSO: " + this.curso.getId());
    }

    private void InitEventos() {
        ((FrmSeguimientoEvaluacion)this.vista).getCmbEval().addActionListener(this::cmbEval);
        ((FrmSeguimientoEvaluacion)this.vista).getCmbFormato().addActionListener(this::cmbFormato);
        ((FrmSeguimientoEvaluacion)this.vista).getBtnSaveCont().addActionListener(this::btnSaveCont);
        ((FrmSeguimientoEvaluacion)this.vista).getBtnSaveExit().addActionListener(this::btnSaveExit);
        ((FrmSeguimientoEvaluacion)this.vista).getTxtObservacion().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FrmSeguimientoEvalCTR.this.txtObservacion(e);
            }
        });
    }

    private EvaluacionSilaboMD getEvaluacion() {
        return this.evaluaciones.stream().filter(item -> item.getSeguimientoEvaluacion().getNombreCmb().equals(((FrmSeguimientoEvaluacion)this.vista).getCmbEval().getSelectedItem().toString())).findFirst().get();
    }

    private void cargarCmbEvaluaciones() {
        this.evaluaciones.stream().map(c -> c.getSeguimientoEvaluacion().getNombreCmb()).forEach(((FrmSeguimientoEvaluacion)this.vista).getCmbEval()::addItem);
    }

    private void cmbEval(ActionEvent e) {
        this.evaluacion = this.getEvaluacion();
        ((FrmSeguimientoEvaluacion)this.vista).getTxtInfoEvaluacion().setText(this.evaluacion.descripcionTextArea());
        ((FrmSeguimientoEvaluacion)this.vista).getCmbFormato().setSelectedItem(SeguimientoEvaluacionMD.formatoToString(this.evaluacion.getSeguimientoEvaluacion().getFormato()));
        ((FrmSeguimientoEvaluacion)this.vista).getTxtObservacion().setText(this.evaluacion.getSeguimientoEvaluacion().getObservacion());
    }

    private void txtObservacion(KeyEvent e) {
        this.evaluacion.getSeguimientoEvaluacion().setObservacion(((FrmSeguimientoEvaluacion)this.vista).getTxtObservacion().getText());
    }

    private void cmbFormato(ActionEvent e) {
        this.evaluacion.getSeguimientoEvaluacion().setFormato(SeguimientoEvaluacionMD.formatoToInt(((FrmSeguimientoEvaluacion)this.vista).getCmbFormato().getSelectedItem().toString()));
    }

    private void btnSaveCont(ActionEvent e) {
        this.CONN.editar(this.getEvaluacion().getSeguimientoEvaluacion());
        JOptionPane.showMessageDialog(this.vista, "SE HA GUARDADO CORRECTAMENTE", "AVISO", 1);
    }

    private void btnSaveExit(ActionEvent e) {
        CONS.getPool(2).submit(() -> {
            this.evaluaciones.parallelStream().map(c -> c.getSeguimientoEvaluacion()).forEach(this.CONN::editar);
            JOptionPane.showMessageDialog(this.vista, "SE HA GUARDADO CORRECTAMENTE", "AVISO", 1);
        });
        CONS.THREAD_POOL.shutdown();
        ((FrmSeguimientoEvaluacion)this.vista).dispose();
    }
}

