/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.planes_de_clases;

import controlador.Libraries.Middlewares;
import controlador.Libraries.abstracts.AbstractVTN;
import controlador.Libraries.cellEditor.ComboBoxCellEditor;
import controlador.principal.VtnPrincipalCTR;
import controlador.silabo.planes_de_clases.FrmConfigPlanCTR;
import controlador.silabo.planes_de_clases.FrmPlanDeClasesCTR;
import controlador.silabo.planes_de_clases.VtnCopiarPlanCTR;
import controlador.silabo.planes_de_clases.VtnEditarFechaPlanCTR;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import modelo.PlanClases.PlandeClasesBD;
import modelo.PlanClases.PlandeClasesMD;
import modelo.curso.CursoMD;
import modelo.jornada.JornadaBD;
import modelo.jornada.JornadaMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.silabo.NEWPeriodoLectivoBD;
import utils.CONS;
import vista.silabos.new_planes_de_clase.VtnPlanDeClases;

public class VtnPlanDeClasesCTR
extends AbstractVTN<VtnPlanDeClases, PlandeClasesMD> {
    private List<PeriodoLectivoMD> periodos;
    private List<JornadaMD> jornadas;
    private final Integer idPersona = CONS.USUARIO.getPersona().getIdPersona();
    private final PlandeClasesBD CON = PlandeClasesBD.single();

    public VtnPlanDeClasesCTR(VtnPrincipalCTR desktop) {
        super(desktop);
        this.vista = new VtnPlanDeClases();
    }

    @Override
    public void Init() {
        ((VtnPlanDeClases)this.vista).getChxSuperSu().setVisible(CONS.USUARIO.isIsSuperUser());
        this.setTable(((VtnPlanDeClases)this.vista).getTbl());
        this.periodos = this.getPeriodos();
        if (this.periodos != null) {
            this.jornadas = JornadaBD.cargarJornadas();
            this.cargarCmbPeriodos();
            this.cargarJornadas();
            this.setLista();
            this.cargarTabla(this.cargador());
        }
        ((VtnPlanDeClases)this.vista).getBtnEliminar().setVisible(CONS.ROL.getNombre().equalsIgnoreCase("COORDINADOR"));
        ((VtnPlanDeClases)this.vista).getBtnEditarFecha().setVisible(CONS.ROL.getNombre().equalsIgnoreCase("COORDINADOR"));
        this.InitEventos();
        super.Init();
    }

    private void InitEventos() {
        ((VtnPlanDeClases)this.vista).getChxSuperSu().addActionListener(this::chxSuperSU);
        ((VtnPlanDeClases)this.vista).getCmbPeriodos().addActionListener(this::cargarTablaAsEvent);
        ((VtnPlanDeClases)this.vista).getCmbJornadas().addActionListener(this::cargarTablaAsEvent);
        ((VtnPlanDeClases)this.vista).getBtnNuevo().addActionListener(this::btnNuevo);
        ((VtnPlanDeClases)this.vista).getBtnEditar().addActionListener(e -> this.btnEditar(e));
        ((VtnPlanDeClases)this.vista).getBtnEliminar().addActionListener(e -> this.btnEliminar(e));
        ((VtnPlanDeClases)this.vista).getBtnCopiar().addActionListener(e -> this.btnCopiar(e));
        ((VtnPlanDeClases)this.vista).getBtnEditarFecha().addActionListener(e -> this.btnEditarFecha(e));
        ((VtnPlanDeClases)this.vista).getBtnImprimir().addActionListener(e -> this.btnImprimir(e));
        ((VtnPlanDeClases)this.vista).getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VtnPlanDeClasesCTR.this.txtBuscar(e);
            }
        });
        boolean estado = CONS.ROL.getNombre().equalsIgnoreCase("COORDINADOR") || CONS.ROL.getNombre().equalsIgnoreCase("DEV") || CONS.USUARIO.isIsSuperUser();
        ((VtnPlanDeClases)this.vista).getTbl().getColumnModel().getColumn(6).setCellEditor(new ComboBoxCellEditor(estado, Arrays.asList("APROBADO", "PENDIENTE", "REVISAR")));
        this.tableM.addTableModelListener(new TableModelListener(){
            boolean active = false;

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!this.active && e.getType() == 0) {
                    this.active = true;
                    VtnPlanDeClasesCTR.this.cmbTblEstado();
                    this.active = false;
                }
            }
        });
    }

    private List<PeriodoLectivoMD> getPeriodos() {
        if (((VtnPlanDeClases)this.vista).getChxSuperSu().isSelected()) {
            return NEWPeriodoLectivoBD.selectAllDEV();
        }
        if (CONS.is("DOCENTE")) {
            return NEWPeriodoLectivoBD.getMisPeriodosBy(this.idPersona);
        }
        if (CONS.is("COORDINADOR")) {
            return NEWPeriodoLectivoBD.getPeriodosCoordinador(this.idPersona);
        }
        if (CONS.isSuperSU()) {
            return NEWPeriodoLectivoBD.selectAllDEV();
        }
        return null;
    }

    private void cargarCmbPeriodos() {
        ((VtnPlanDeClases)this.vista).getCmbPeriodos().removeAllItems();
        if (this.periodos != null) {
            this.periodos.stream().map(c -> c.getNombre()).forEach(((VtnPlanDeClases)this.vista).getCmbPeriodos()::addItem);
        } else {
            JOptionPane.showMessageDialog(this.vista, "NO TIENE PERIODOS LECTIVOS ASIGNADOS");
        }
    }

    private void cargarJornadas() {
        this.jornadas.stream().map(c -> c.getNombre()).forEachOrdered(((VtnPlanDeClases)this.vista).getCmbJornadas()::addItem);
    }

    private Consumer<PlandeClasesMD> cargador() {
        this.tableM.setRowCount(0);
        return obj -> this.setRow((PlandeClasesMD)obj);
    }

    private void setRow(PlandeClasesMD obj) {
        this.tableM.addRow(new Object[]{obj.getID(), this.tableM.getRowCount() + 1, obj.getInfoDocente(), obj.getCurso().getMateria().getNombre(), obj.getCurso().getNombre(), obj.getUnidad().getNumeroUnidad(), PlandeClasesMD.getEstadoStr(obj.getEstado()), obj.getFechaGeneracion()});
    }

    private void chxSuperSU(ActionEvent e) {
        this.periodos = this.getPeriodos();
        this.cargarCmbPeriodos();
    }

    private void setLista() {
        try {
            String periodo = ((VtnPlanDeClases)this.vista).getCmbPeriodos().getSelectedItem().toString();
            String cedulaDocente = CONS.USUARIO.getPersona().getIdentificacion();
            String jornada = ((VtnPlanDeClases)this.vista).getCmbJornadas().getSelectedItem().toString();
            boolean isSuperUserChecked = ((VtnPlanDeClases)this.vista).getChxSuperSu().isSelected();
            if (isSuperUserChecked) {
                // empty if block
            }
            if (((VtnPlanDeClases)this.vista).getChxSuperSu().isSelected()) {
                this.setLista(this.CON.getPlanesSuperSu(periodo, jornada));
            } else if (CONS.is("DOCENTE")) {
                this.setLista(this.CON.getPlanesBy(cedulaDocente, periodo, jornada));
            } else if (CONS.is("COORDINADOR")) {
                this.setLista(this.CON.getPlanesCoordinadorBy(cedulaDocente, periodo, jornada));
            } else if (CONS.isSuperSU()) {
                this.setLista(this.CON.getPlanesSuperSu(periodo, jornada));
            }
            this.cargarTabla(this.cargador());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void cargarTablaAsEvent(ActionEvent e) {
        try {
            this.setLista();
            this.cargarTabla(this.cargador());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void btnNuevo(ActionEvent e) {
        FrmConfigPlanCTR form = new FrmConfigPlanCTR(this.desktop);
        form.Init();
    }

    private void btnEditar(ActionEvent e) {
        int row = this.getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(null, "SELECCIONE UNA FILA PRIMERO!!");
        } else {
            int idPlan = Integer.valueOf(this.getTableM().getValueAt(row, 0).toString());
            PlandeClasesMD plandeClasesMD = PlandeClasesBD.getPlanBy(idPlan);
            if (plandeClasesMD.getEstado() != 1 || !this.user.isIsSuperUser() || !CONS.ROL.getNombre().equalsIgnoreCase("COORDINADOR")) {
                FrmPlanDeClasesCTR form = new FrmPlanDeClasesCTR(this.desktop);
                form.setAccion("edit");
                form.setModelo(plandeClasesMD);
                form.Init();
            } else {
                JOptionPane.showMessageDialog(null, "NO PUEDE EDITAR UN PLAN DE CLASES QUE YA ESTA APROBADO");
            }
        }
    }

    private void btnEliminar(ActionEvent e) {
        int row = this.getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(null, "SELECCIONE UNA FILA PRIMERO!!");
        } else {
            String MENSAJE_ELIMINAR = String.format("\u00bfESTA SEGURO DE ELIMINAR EL PLAN DE CLASES?\n", new Object[0]);
            int opcionEliminado = JOptionPane.showConfirmDialog(this.vista, MENSAJE_ELIMINAR, "\u00bfESTA SEGURO?", 0);
            if (opcionEliminado == 0) {
                int idPlan = Integer.valueOf(this.getTableM().getValueAt(row, 0).toString());
                PlandeClasesBD.eliminarPlanClase(idPlan);
                this.setLista();
                this.cargarTabla(this.cargador());
                JOptionPane.showMessageDialog(this.vista, "SE HA ELIMINADO CORRECTAMENTE");
            }
        }
    }

    private void btnCopiar(ActionEvent e) {
        int row = ((VtnPlanDeClases)this.vista).getTbl().getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(this.vista, "SELECCIONE UN PLAN DE CLASES PARA COPIAR", "AVISO!!", 0);
        } else {
            int idPlan = (Integer)((VtnPlanDeClases)this.vista).getTbl().getValueAt(row, 0);
            PlandeClasesMD plan = this.lista.stream().filter(item -> item.getID().equals(idPlan)).findFirst().get();
            List<CursoMD> cursos = this.CON.cursosSinPlanes(plan.getID());
            if (cursos.isEmpty()) {
                JOptionPane.showMessageDialog(this.vista, "NO TIENE CURSOS PENDIENTES", "AVISO!!", 0);
            } else {
                VtnCopiarPlanCTR vtn = new VtnCopiarPlanCTR(this.desktop);
                vtn.setModelo(plan);
                vtn.setCursos(cursos);
                vtn.Init();
            }
        }
    }

    private void btnEditarFecha(ActionEvent e) {
        int row = this.getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(null, "SELECCIONE UNA FILA PRIMERO!!");
        } else {
            int idPlan = Integer.valueOf(this.getTableM().getValueAt(row, 0).toString());
            PlandeClasesMD plan = this.lista.stream().filter(item -> item.getID() == idPlan).findFirst().get();
            VtnEditarFechaPlanCTR vtn = new VtnEditarFechaPlanCTR(this.desktop, plan);
            vtn.Init();
        }
    }

    private void btnImprimir(ActionEvent e) {
        int row = ((VtnPlanDeClases)this.vista).getTbl().getSelectedRow();
        if (row >= 0) {
            HashMap<String, String> parametro = new HashMap<String, String>();
            int idPlan = Integer.valueOf(this.getTableM().getValueAt(row, 0).toString());
            PlandeClasesMD plan = this.lista.stream().filter(item -> item.getID() == idPlan).findFirst().get();
            parametro.put("id_unidad", String.valueOf(plan.getUnidad().getID()));
            parametro.put("id_curso", String.valueOf(plan.getCurso().getId()));
            parametro.put("id_plan_clase", String.valueOf(idPlan));
            Middlewares.generarReporte(this.getClass().getResource("/vista/silabos/reportes/plan_de_clase/planClasePagPrincipal.jasper"), "PLAN DE CLASES", parametro);
        } else {
            JOptionPane.showMessageDialog(null, "DEBE SELECIONAR EL DOCUMENTO PARA IMPRIMIR");
        }
    }

    private void cmbTblEstado() {
        int colum = this.table.getSelectedColumn();
        int row = this.getSelectedRow();
        int idPlan = Integer.valueOf(this.getTableM().getValueAt(row, 0).toString());
        PlandeClasesMD plan = this.lista.stream().filter(item -> item.getID() == idPlan).findFirst().get();
        if (plan != null) {
            String estado = this.table.getValueAt(row, colum).toString();
            if (plan.getEstado() != PlandeClasesMD.getEstadoInt(estado).intValue()) {
                plan.setEstado(PlandeClasesMD.getEstadoInt(estado));
                PlandeClasesBD.editarEstado(idPlan, PlandeClasesMD.getEstadoInt(estado));
            }
        }
    }

    private void txtBuscar(KeyEvent e) {
        List<PlandeClasesMD> planes = this.lista.stream().filter(item -> item.getCurso().getDocente().getPrimerNombre().toLowerCase().contains(((VtnPlanDeClases)this.vista).getTxtBuscar().getText().toLowerCase()) || item.getCurso().getDocente().getSegundoNombre().toLowerCase().contains(((VtnPlanDeClases)this.vista).getTxtBuscar().getText().toLowerCase()) || item.getCurso().getDocente().getIdentificacion().toLowerCase().contains(((VtnPlanDeClases)this.vista).getTxtBuscar().getText().toLowerCase()) || item.getCurso().getDocente().getPrimerApellido().toLowerCase().contains(((VtnPlanDeClases)this.vista).getTxtBuscar().getText().toLowerCase()) || item.getCurso().getDocente().getSegundoApellido().toLowerCase().contains(((VtnPlanDeClases)this.vista).getTxtBuscar().getText().toLowerCase())).collect(Collectors.toList());
        planes.forEach(this.cargador());
    }
}

