/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.planes_de_clases;

import controlador.Libraries.abstracts.AbstractVTN;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.EstrategiasMetodologicas.EstrategiasMetodologicasMD;
import modelo.PlanClases.PlandeClasesBD;
import modelo.PlanClases.PlandeClasesMD;
import modelo.PlanClases.RecursosBD;
import modelo.PlanClases.RecursosMD;
import vista.silabos.new_planes_de_clase.FrmPlanDeClase;

public class FrmPlanDeClasesCTR
extends AbstractVTN<FrmPlanDeClase, PlandeClasesMD> {
    private List<RecursosMD> recursos;
    private DefaultTableModel tableRecursosM;
    private DefaultTableModel tableEstrategiasM;
    private String accion;

    public FrmPlanDeClasesCTR(VtnPrincipalCTR desktop) {
        super(desktop);
        this.vista = new FrmPlanDeClase();
    }

    public void setAccion(String accion) {
        this.accion = accion;
    }

    @Override
    public void Init() {
        this.recursos = RecursosBD.consultarRecursos();
        this.tableRecursosM = (DefaultTableModel)((FrmPlanDeClase)this.vista).getTblRecursos().getModel();
        this.tableEstrategiasM = (DefaultTableModel)((FrmPlanDeClase)this.vista).getTblEstrategias().getModel();
        this.cargarRecursos();
        this.setInformacionUnidad();
        this.cargarEstrategias();
        this.InitEventos();
        super.Init();
        try {
            ((FrmPlanDeClase)this.vista).setMaximum(true);
        }
        catch (PropertyVetoException ex) {
            Logger.getLogger(FrmPlanDeClasesCTR.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void InitEventos() {
        ((FrmPlanDeClase)this.vista).getTblRecursos().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FrmPlanDeClasesCTR.this.onTableRecursosClicked(e);
            }
        });
        ((FrmPlanDeClase)this.vista).getBtnAgregar().addActionListener(this::btnAgregar);
        ((FrmPlanDeClase)this.vista).getBtnQuitar().addActionListener(this::btnQuitar);
        ((FrmPlanDeClase)this.vista).getBtnCancelar().addActionListener(e -> ((FrmPlanDeClase)this.vista).dispose());
        ((FrmPlanDeClase)this.vista).getBtnGuardar().addActionListener(this::btnGuardar);
        ((FrmPlanDeClase)this.vista).getTxtTrabajoAutonomo().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FrmPlanDeClasesCTR.this.txtTrabajoAutonomo(e);
            }
        });
        ((FrmPlanDeClase)this.vista).getTxtObservaciones().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FrmPlanDeClasesCTR.this.txtObservaciones(e);
            }
        });
    }

    private void setInformacionUnidad() {
        ((FrmPlanDeClase)this.vista).getTxtTrabajoAutonomo().setText(((PlandeClasesMD)this.modelo).getTrabajoAutonomo());
        ((FrmPlanDeClase)this.vista).getTxtObservaciones().setText(((PlandeClasesMD)this.modelo).getObservaciones());
        String lblTitulo = ((FrmPlanDeClase)this.vista).getLblTitulo().getText().replace("{numero}", String.valueOf(((PlandeClasesMD)this.modelo).getUnidad().getNumeroUnidad())).replace("{titulo}", ((PlandeClasesMD)this.modelo).getUnidad().getTituloUnidad());
        String lblInfo1 = ((FrmPlanDeClase)this.vista).getLblInfo1().getText().replace("{fecha_inicio}", ((PlandeClasesMD)this.modelo).getUnidad().getFechaInicioUnidad().toString()).replace("{fecha_fin}", ((PlandeClasesMD)this.modelo).getUnidad().getFechaFinUnidad().toString()).replace("{duracion}", "");
        String lblInfo2 = ((FrmPlanDeClase)this.vista).getLblInfo2().getText().replace("{carrera}", ((PlandeClasesMD)this.modelo).getCurso().getPeriodo().getCarrera().getNombre()).replace("{asignatura}", ((PlandeClasesMD)this.modelo).getCurso().getMateria().getNombre()).replace("{codigoAsignatura}", ((PlandeClasesMD)this.modelo).getCurso().getMateria().getCodigo());
        String lblInfo3 = ((FrmPlanDeClase)this.vista).getLblInfo3().getText().replace("{curso}", ((PlandeClasesMD)this.modelo).getCurso().getNombre()).replace("{docente}", ((PlandeClasesMD)this.modelo).getCurso().getDocente().getInfoCompleta());
        ((FrmPlanDeClase)this.vista).getLblTitulo().setText(lblTitulo);
        ((FrmPlanDeClase)this.vista).getLblInfo1().setText(lblInfo1);
        ((FrmPlanDeClase)this.vista).getLblInfo2().setText(lblInfo2);
        ((FrmPlanDeClase)this.vista).getLblInfo3().setText(lblInfo3);
        ((FrmPlanDeClase)this.vista).getTxtObjetivos().setText(((PlandeClasesMD)this.modelo).getUnidad().getObjetivoEspecificoUnidad());
        ((FrmPlanDeClase)this.vista).getTxtResultadosAprendizaje().setText(((PlandeClasesMD)this.modelo).getUnidad().getResultadosAprendizajeUnidad());
        ((FrmPlanDeClase)this.vista).getTxtContenidos().setText(((PlandeClasesMD)this.modelo).getUnidad().getContenidosUnidad());
        DefaultListModel listModel = new DefaultListModel();
        ((PlandeClasesMD)this.modelo).getUnidad().getEstrategias().stream().map(c -> c.getEstrategia().getDescripcionEstrategia()).forEach(listModel::addElement);
        ((FrmPlanDeClase)this.vista).getTxtEstrategiasUnidad().setModel(listModel);
    }

    private RecursosMD getRecurso() {
        int row = ((FrmPlanDeClase)this.vista).getTblRecursos().getSelectedRow();
        RecursosMD recurso = null;
        if (row != -1) {
            int id = Integer.valueOf(this.tableRecursosM.getValueAt(row, 0).toString());
            recurso = this.recursos.stream().filter(item -> item.getId_recurso() == id).findFirst().get();
        }
        return recurso;
    }

    private void cargarRecursos() {
        this.tableRecursosM.setRowCount(0);
        this.recursos.stream().forEach(obj -> {
            boolean check = ((PlandeClasesMD)this.modelo).getRecursos().stream().map(c -> c.getId_recurso()).collect(Collectors.toList()).contains(obj.getId_recurso());
            obj.setChecked(check);
            this.tableRecursosM.addRow(new Object[]{obj.getId_recurso(), obj.getNombre_recursos(), check});
        });
    }

    private void cargarEstrategias() {
        this.tableEstrategiasM.setRowCount(0);
        ((PlandeClasesMD)this.modelo).getEstrategias().forEach(obj -> {
            String uuid = UUID.randomUUID().toString();
            obj.setUUID(uuid);
            this.tableEstrategiasM.addRow(new Object[]{uuid, obj.getNombre_estrategia(), obj.getTipo_estrategias_metodologicas()});
        });
    }

    private void onTableRecursosClicked(MouseEvent e) {
        boolean removed;
        RecursosMD recurso = this.getRecurso();
        if (recurso != null && !(removed = ((PlandeClasesMD)this.modelo).getRecursos().removeIf(item -> item.getId_recurso() == recurso.getId_recurso()))) {
            ((PlandeClasesMD)this.modelo).getRecursos().add(recurso);
            this.cargarRecursos();
        }
    }

    private void btnAgregar(ActionEvent e) {
        String descripcion = ((FrmPlanDeClase)this.vista).getTxtDescripcion().getText();
        if (descripcion.isEmpty()) {
            JOptionPane.showMessageDialog(null, "POR FAVOR INGRESE BIEN LA DESCRIPCION");
        } else {
            String tipo = ((FrmPlanDeClase)this.vista).getCmbTipo().getSelectedItem().toString();
            EstrategiasMetodologicasMD estrategia = new EstrategiasMetodologicasMD();
            estrategia.setNombre_estrategia(descripcion);
            estrategia.setTipo_estrategias_metodologicas(tipo);
            ((PlandeClasesMD)this.modelo).getEstrategias().add(estrategia);
            ((FrmPlanDeClase)this.vista).getTxtDescripcion().setText("");
            ((FrmPlanDeClase)this.vista).getCmbTipo().setSelectedIndex(0);
            this.cargarEstrategias();
        }
    }

    private void btnQuitar(ActionEvent e) {
        int row = ((FrmPlanDeClase)this.vista).getTblEstrategias().getSelectedRow();
        if (row == -1) {
            JOptionPane.showMessageDialog(null, "DEBE SELECCIONAR UNA FILA DE LA TABLA!!");
        } else {
            String uuid = this.tableEstrategiasM.getValueAt(row, 0).toString();
            ((PlandeClasesMD)this.modelo).getEstrategias().removeIf(item -> item.getUUID().equals(uuid));
            this.cargarEstrategias();
        }
    }

    private void txtTrabajoAutonomo(KeyEvent e) {
        String trabajoAutonomo = ((FrmPlanDeClase)this.vista).getTxtTrabajoAutonomo().getText();
        ((PlandeClasesMD)this.modelo).setTrabajoAutonomo(trabajoAutonomo);
    }

    private void txtObservaciones(KeyEvent e) {
        String observaciones = ((FrmPlanDeClase)this.vista).getTxtObservaciones().getText();
        ((PlandeClasesMD)this.modelo).setObservaciones(observaciones);
    }

    private void btnGuardar(ActionEvent e) {
        boolean guardado;
        JOptionPane.showMessageDialog(null, "SE VA A GUARDAR EL PLAN DE CLASES ESPERE UN MOMENTO");
        if ("add".equals(this.accion) && (guardado = PlandeClasesBD.crear((PlandeClasesMD)this.modelo))) {
            JOptionPane.showMessageDialog(null, "SE HA GUARDADO CORRECTAMENTE");
        }
        if ("edit".equals(this.accion) && (guardado = PlandeClasesBD.editar((PlandeClasesMD)this.modelo))) {
            JOptionPane.showMessageDialog(null, "SE HA GUARDADO CORRECTAMENTE");
        }
    }
}

