/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.planes_de_clases;

import controlador.Libraries.abstracts.AbstractVTN;
import controlador.principal.VtnPrincipalCTR;
import controlador.silabo.planes_de_clases.FrmPlanDeClasesCTR;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JOptionPane;
import modelo.EstrategiasMetodologicas.EstrategiasMetodologicasMD;
import modelo.PlanClases.PlandeClasesBD;
import modelo.PlanClases.PlandeClasesMD;
import modelo.PlanClases.RecursosMD;
import modelo.curso.CursoMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.silabo.NEWCursoBD;
import modelo.silabo.NEWPeriodoLectivoBD;
import modelo.silabo.NEWUnidadSilaboBD;
import modelo.unidadSilabo.UnidadSilaboMD;
import vista.silabos.new_planes_de_clase.FrmConfigPlan;

public class FrmConfigPlanCTR
extends AbstractVTN<FrmConfigPlan, PlandeClasesMD> {
    private final PlandeClasesBD CON = PlandeClasesBD.single();
    private final NEWCursoBD CURSO_CON = NEWCursoBD.single();
    private final List<PeriodoLectivoMD> periodos = NEWPeriodoLectivoBD.getMisPeriodosBy(this.personaCONS.getIdPersona(), true);
    private List<CursoMD> cursos;
    private List<UnidadSilaboMD> unidades;

    public FrmConfigPlanCTR(VtnPrincipalCTR desktop) {
        super(desktop);
        this.vista = new FrmConfigPlan();
    }

    @Override
    public void Init() {
        this.cargarCmbPeriodos();
        this.cargarCmbCursos();
        this.cargarCmbUnidades();
        super.Init();
        this.InitEventos();
    }

    private void InitEventos() {
        ((FrmConfigPlan)this.vista).getCmbPeriodos().addActionListener(e -> this.cmbPeriodos(e));
        ((FrmConfigPlan)this.vista).getCmbCursos().addActionListener(e -> this.cmbCursos(e));
        ((FrmConfigPlan)this.vista).getBtnSiguiente().addActionListener(this::btnSiguiente);
    }

    private void cargarCmbPeriodos() {
        this.periodos.stream().map(c -> c.getNombre()).forEach(((FrmConfigPlan)this.vista).getCmbPeriodos()::addItem);
    }

    private void cargarCmbCursos() {
        ((FrmConfigPlan)this.vista).getCmbCursos().removeAllItems();
        this.cursos = this.CURSO_CON.getCursosMateriasBy(((FrmConfigPlan)this.vista).getCmbPeriodos().getSelectedItem().toString(), this.personaCONS.getIdPersona());
        this.cursos.stream().map(c -> c.getCursoMateriaNombre()).forEach(((FrmConfigPlan)this.vista).getCmbCursos()::addItem);
    }

    private void cargarCmbUnidades() throws NullPointerException {
        ((FrmConfigPlan)this.vista).getCmbUnidades().removeAllItems();
        this.unidades = NEWUnidadSilaboBD.getUnidadesBy(this.getPeriodo().getID(), this.getCurso().getMateria().getId(), this.getCurso().getId());
        if (Objects.isNull(this.unidades)) {
            JOptionPane.showMessageDialog(null, "La materia: " + this.getCurso().getCursoMateriaNombre() + " no tiene el s\u00edlabo correctamente elaborado o  no tiene alumnos matriculados, por favor corriga para poder cargar unidades.");
        } else {
            if (this.unidades.size() > 0) {
                ((FrmConfigPlan)this.vista).getBtnSiguiente().setEnabled(true);
            } else {
                ((FrmConfigPlan)this.vista).getBtnSiguiente().setEnabled(false);
            }
            this.unidades.stream().map(c -> String.valueOf(c.getNumeroUnidad())).forEach(((FrmConfigPlan)this.vista).getCmbUnidades()::addItem);
        }
    }

    private PeriodoLectivoMD getPeriodo() {
        return this.periodos.stream().filter(item -> item.getNombre().equals(((FrmConfigPlan)this.vista).getCmbPeriodos().getSelectedItem().toString())).findFirst().get();
    }

    private CursoMD getCurso() {
        return this.cursos.stream().filter(item -> item.getCursoMateriaNombre().equals(((FrmConfigPlan)this.vista).getCmbCursos().getSelectedItem().toString())).findFirst().get();
    }

    private UnidadSilaboMD getUnidad() {
        return this.unidades.stream().filter(item -> item.getNumeroUnidad() == Integer.parseInt(((FrmConfigPlan)this.vista).getCmbUnidades().getSelectedItem().toString())).findFirst().get();
    }

    private void btnSiguiente(ActionEvent e) {
        PlandeClasesMD plandeClasesMD = new PlandeClasesMD();
        plandeClasesMD.setCurso(this.getCurso());
        plandeClasesMD.setUnidad(this.getUnidad());
        plandeClasesMD.setRecursos(new ArrayList<RecursosMD>());
        plandeClasesMD.setEstrategias(new ArrayList<EstrategiasMetodologicasMD>());
        FrmPlanDeClasesCTR form = new FrmPlanDeClasesCTR(this.desktop);
        form.setModelo(plandeClasesMD);
        form.setAccion("add");
        form.Init();
        ((FrmConfigPlan)this.vista).dispose();
    }

    private void cmbPeriodos(ActionEvent e) {
        if (this.periodos.size() > 0) {
            this.cargarCmbCursos();
        }
    }

    private void cmbCursos(ActionEvent e) {
        if (this.cursos.size() > 0) {
            try {
                this.cargarCmbUnidades();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

