/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.frm;

import com.toedter.calendar.JDateChooser;
import java.time.LocalDate;
import java.time.ZoneId;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import modelo.validaciones.Validar;

public class UtilsFRMSilaboCTR {
    private static UtilsFRMSilaboCTR USCTR;

    public static UtilsFRMSilaboCTR single() {
        if (USCTR == null) {
            USCTR = new UtilsFRMSilaboCTR();
        }
        return USCTR;
    }

    public double getHoraSPN(JSpinner spn) {
        double h = -1.0;
        String hs = spn.getValue().toString().trim();
        if (Validar.esNumerosDecimales(hs)) {
            h = Double.parseDouble(hs);
        }
        return h;
    }

    public void errorHoras(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Horas no permitidas", 2);
    }

    public void errorFecha(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Fechas incorrectas", 2);
    }

    public LocalDate getFechaJDC(JDateChooser jdc) {
        LocalDate fecha = null;
        if (jdc.getDate() != null) {
            fecha = jdc.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        return fecha;
    }

    public void errorFrmEvaluacion(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Error en el formulario de atividades", 0);
    }

    public void errorEstrategia(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Error en estrategias", 0);
    }

    public void errorGuardar(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Error al guardar", 0);
    }

    public void errorGuardarSilabo() {
        this.errorGuardar("Algo salio mal, no pudimos guardar su silabo, le recomendamos que verifique su conectividad con el servidor de internet. \nVuelva a intentar guardar en unos segudos no cierre la ventana del silabo.");
    }

    public String getIdLocalActividad(JTable tbl) {
        String code = "";
        int pos = tbl.getSelectedRow();
        if (pos >= 0) {
            code = tbl.getValueAt(pos, 0).toString();
        }
        return code;
    }

    public String getTextFromTxt(JTextField jtf) {
        return jtf.getText().trim();
    }

    public String getTextFromTxa(JTextArea jta) {
        return jta.getText().trim();
    }
}

