/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.frm;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import controlador.silabo.frm.FRMReferenciaSilaboCTR;
import controlador.silabo.frm.UtilsFRMSilaboCTR;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import modelo.estilo.TblEstilo;
import modelo.estrategiasAprendizaje.EstrategiasAprendizajeMD;
import modelo.estrategiasAprendizaje.NEWEstrategiaAprendizajeBD;
import modelo.estrategiasUnidad.EstrategiasUnidadMD;
import modelo.evaluacionSilabo.EvaluacionSilaboMD;
import modelo.evaluacionSilabo.NEWEvaluacionSilaboBD;
import modelo.referencias.ReferenciasMD;
import modelo.referenciasSilabo.ReferenciaSilaboMD;
import modelo.silabo.NEWEstrategiaUnidadBD;
import modelo.silabo.NEWPeriodoLectivoBD;
import modelo.silabo.NEWReferenciaSilaboBD;
import modelo.silabo.NEWSilaboBD;
import modelo.silabo.NEWTipoActividadBD;
import modelo.silabo.NEWUnidadSilaboBD;
import modelo.silabo.SilaboMD;
import modelo.tipoActividad.TipoActividadMD;
import modelo.unidadSilabo.UnidadSilaboMD;
import modelo.validaciones.Validar;
import vista.silabos.NEWFrmAcciones;
import vista.silabos.NEWFrmSilabo;

public class FRMSilaboCTR
extends DCTR {
    private final NEWFrmSilabo FRM_GESTION = new NEWFrmSilabo();
    private final NEWFrmAcciones FRM_ACCIONES;
    private final NEWSilaboBD SBD = NEWSilaboBD.single();
    private final NEWUnidadSilaboBD USBD = NEWUnidadSilaboBD.single();
    private final NEWEstrategiaUnidadBD EUBD = NEWEstrategiaUnidadBD.single();
    private final NEWReferenciaSilaboBD RSBD = NEWReferenciaSilaboBD.single();
    private final NEWTipoActividadBD TABD = NEWTipoActividadBD.single();
    private final NEWEvaluacionSilaboBD EVBD = NEWEvaluacionSilaboBD.single();
    private final NEWEstrategiaAprendizajeBD EABD = NEWEstrategiaAprendizajeBD.single();
    private final UtilsFRMSilaboCTR UFRMSCTR = UtilsFRMSilaboCTR.single();
    private List<UnidadSilaboMD> unidades;
    protected List<EstrategiasUnidadMD> estrategias;
    protected List<EvaluacionSilaboMD> evaluaciones;
    protected List<TipoActividadMD> tiposActividad;
    protected List<ReferenciasMD> biblioteca;
    protected List<ReferenciaSilaboMD> referenciasSilabo;
    protected List<EstrategiasAprendizajeMD> todasEstrategias;
    protected List<EstrategiasAprendizajeMD> filterEstrategias;
    private boolean existeEstrategia;
    private static final String[] TITULO_GESTION = new String[]{"IDL", "Indicador", "Instrumento", "Valoraci\u00f3n", "Fecha Env\u00edo", "Fecha Presentaci\u00f3n"};
    private static final String[] TITULO_ESTRATEGIAS = new String[]{"X", "Titulo"};
    private final DefaultTableModel mdTblAD = TblEstilo.modelTblSinEditar(TITULO_GESTION);
    private final DefaultTableModel mdTblAC = TblEstilo.modelTblSinEditar(TITULO_GESTION);
    private final DefaultTableModel mdTblGP = TblEstilo.modelTblSinEditar(TITULO_GESTION);
    private final DefaultTableModel mdTblGA = TblEstilo.modelTblSinEditar(TITULO_GESTION);
    private final DefaultTableModel mdTblES = TblEstilo.modelTblSinEditar(TITULO_ESTRATEGIAS);
    private final SilaboMD silabo;
    private UnidadSilaboMD unidadSelec;
    private double numHD = 0.0;
    private double numHP = 0.0;
    private double numHA = 0.0;
    private boolean cambioUnidad = false;
    private String actividadActual = "AD";
    private double totalGestion = 60.0;
    private EvaluacionSilaboMD evaluacionSelec;
    boolean eliminandoUnidad = false;
    private String msgErrorSilabo;
    private boolean eExisteEstrategia = false;

    public FRMSilaboCTR(VtnPrincipalCTR ctrPrin, SilaboMD silabo) {
        super(ctrPrin);
        if (silabo.getPeriodo().getFechaFinClases() == null) {
            silabo.getPeriodo().setFechaFinClases(silabo.getPeriodo().getFechaFin());
        }
        this.silabo = silabo;
        this.FRM_ACCIONES = new NEWFrmAcciones((Frame)ctrPrin.getVtnPrin(), false);
        this.FRM_ACCIONES.setLocationRelativeTo(this.FRM_GESTION);
    }

    public void nuevo(int num) {
        this.crearSilaboNuevo(num);
        this.iniciarSilabo();
        this.iniciarVentana();
    }

    public void referenciado(boolean conEvaluaciones) {
        NEWPeriodoLectivoBD PBD = NEWPeriodoLectivoBD.single();
        this.silabo.setPeriodo(PBD.getUltimoPorPeriodo(this.silabo.getPeriodo().getID()));
        this.unidades = this.USBD.getBySilaboParaReferencia(this.silabo.getID());
        if (conEvaluaciones) {
            this.evaluaciones = this.EVBD.getBySilaboReferencia(this.silabo.getID());
        }
        this.estrategias = this.EUBD.getBySilaboReferencia(this.silabo.getID());
        this.iniciarSilabo();
        this.iniciarVentana();
        int idSilaboGen = this.SBD.guardar(this.silabo);
        if (idSilaboGen > 0) {
            this.silabo.setID(idSilaboGen);
            this.guardar();
        } else {
            this.silabo.setID(0);
            this.UFRMSCTR.errorGuardarSilabo();
        }
    }

    public void editar() {
        this.unidades = this.USBD.getBySilabo(this.silabo.getID());
        this.evaluaciones = this.EVBD.getBySilabo(this.silabo.getID());
        this.estrategias = this.EUBD.getBySilabo(this.silabo.getID());
        this.iniciarSilabo();
        this.iniciarVentana();
    }

    private void estiloTablas() {
        TblEstilo.columnaMedida(this.FRM_GESTION.getTblEstrategias(), 0, 20);
        TblEstilo.ColumnaCentrar(this.FRM_GESTION.getTblEstrategias(), 0);
    }

    private void iniciarVentana() {
        this.FRM_GESTION.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                FRMSilaboCTR.this.cambioUnidad = true;
            }
        });
        this.FRM_GESTION.getBtnGuardar().addActionListener(e -> this.guardar());
        this.FRM_GESTION.getBtnSiguiente().addActionListener(e -> this.agregarBibliografia());
        this.estiloTablas();
        this.todasEstrategias = this.EABD.getAll();
        this.FRM_GESTION.setTitle(this.silabo.getPeriodo().getNombre() + " | " + this.silabo.getMateria().getNombre());
        this.actualizarHoras();
        this.iniciarCmbEstrategiasConBuscador();
        this.ctrPrin.agregarVtn(this.FRM_GESTION);
        this.cargarCmbUnidad();
        this.mostrarUnidad();
        this.iniciarAccionesActividades();
        this.iniciarEventoSPNHoras();
        this.iniciarEventosFecha();
        this.iniciarEventosFormulario();
        this.iniciarEventosUnidad();
        this.iniciarTblEstrategia();
        this.detectarPanel();
    }

    private void iniciarEventosFormulario() {
        this.FRM_GESTION.getTxtTitulo().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FRMSilaboCTR.this.unidadSelec.setTituloUnidad(FRMSilaboCTR.this.UFRMSCTR.getTextFromTxt(FRMSilaboCTR.this.FRM_GESTION.getTxtTitulo()));
            }
        });
        this.FRM_GESTION.getTxrContenidos().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FRMSilaboCTR.this.unidadSelec.setContenidosUnidad(FRMSilaboCTR.this.UFRMSCTR.getTextFromTxa(FRMSilaboCTR.this.FRM_GESTION.getTxrContenidos()));
            }
        });
        this.FRM_GESTION.getTxrObjetivos().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FRMSilaboCTR.this.unidadSelec.setObjetivoEspecificoUnidad(FRMSilaboCTR.this.UFRMSCTR.getTextFromTxa(FRMSilaboCTR.this.FRM_GESTION.getTxrObjetivos()));
            }
        });
        this.FRM_GESTION.getTxrResultados().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FRMSilaboCTR.this.unidadSelec.setResultadosAprendizajeUnidad(FRMSilaboCTR.this.UFRMSCTR.getTextFromTxa(FRMSilaboCTR.this.FRM_GESTION.getTxrResultados()));
            }
        });
    }

    private void iniciarEventosUnidad() {
        this.FRM_GESTION.getLblEliminarUnidad().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int r = JOptionPane.showConfirmDialog(FRMSilaboCTR.this.FRM_ACCIONES, "Esta seguro de eliminar la Unidad " + FRMSilaboCTR.this.unidadSelec.getNumeroUnidad() + " no tendra opcion de recuperarla.");
                if (r == 0) {
                    FRMSilaboCTR.this.eliminarUnidad();
                }
            }
        });
        this.FRM_GESTION.getLblAgregarUnidad().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FRMSilaboCTR.this.agregarUnidad();
            }
        });
        this.FRM_GESTION.getCmbUnidad().addActionListener(e -> this.mostrarUnidad());
    }

    private void iniciarAccionesActividades() {
        this.FRM_GESTION.getBtnAgregar().addActionListener(e -> this.nuevaActividad());
        this.FRM_GESTION.getBtnEditar().addActionListener(e -> this.editarActividad());
        this.FRM_GESTION.getBtnQuitar().addActionListener(e -> this.eliminarActividad());
        this.FRM_ACCIONES.getBtnGuardar().addActionListener(e -> this.guardarEvaluacion());
    }

    private void guardarEvaluacion() {
        if (this.frmEvaluacionValido()) {
            boolean guardando = false;
            if (this.evaluacionSelec == null) {
                guardando = true;
                this.evaluacionSelec = new EvaluacionSilaboMD();
            }
            this.evaluacionSelec.setIndicador(this.FRM_ACCIONES.getTxtIndicador().getText());
            this.evaluacionSelec.setInstrumento(this.FRM_ACCIONES.getTxtInstrumento().getText());
            this.evaluacionSelec.setValoracion(Double.parseDouble(this.FRM_ACCIONES.getSpnValoracion().getValue().toString()));
            this.evaluacionSelec.setFechaEnvio(this.UFRMSCTR.getFechaJDC(this.FRM_ACCIONES.getDchFechaEnvio()));
            this.evaluacionSelec.setFechaPresentacion(this.UFRMSCTR.getFechaJDC(this.FRM_ACCIONES.getDchFechaPresentacion()));
            if (guardando) {
                this.evaluacionSelec.setIdUnidad(this.unidadSelec);
                this.evaluacionSelec.getIdTipoActividad().setIdTipoActividad(this.getIdTipoActividad());
                this.evaluaciones.add(this.evaluacionSelec);
            }
            this.cargarEvaluaciones();
            this.FRM_ACCIONES.setVisible(false);
            this.recetearFrmActividad();
        }
    }

    private boolean frmEvaluacionValido() {
        String valor;
        boolean valido = true;
        if (this.FRM_ACCIONES.getTxtIndicador().getText().equals("") || this.FRM_ACCIONES.getTxtInstrumento().getText().equals("") || this.FRM_ACCIONES.getSpnValoracion().getValue() == null || this.FRM_ACCIONES.getDchFechaEnvio().getDate() == null || this.FRM_ACCIONES.getDchFechaPresentacion().getDate() == null) {
            valido = false;
            this.UFRMSCTR.errorFrmEvaluacion("Debe ingresar todos los campos");
        }
        String msg = "";
        if (valido && !(valido = Validar.esNumerosDecimales(valor = this.FRM_ACCIONES.getSpnValoracion().getValue().toString()))) {
            this.UFRMSCTR.errorFrmEvaluacion("La valoracion de la actividad es incorrecta.");
        }
        if (valido) {
            LocalDate fe = this.UFRMSCTR.getFechaJDC(this.FRM_ACCIONES.getDchFechaEnvio());
            LocalDate fp = this.UFRMSCTR.getFechaJDC(this.FRM_ACCIONES.getDchFechaPresentacion());
            if (fp.isBefore(fe)) {
                msg = msg + "La fecha de presentaci\u00f3n debe ser despues de la de envio.\n";
                valido = false;
            }
            if (valido) {
                if (this.unidadSelec.getFechaFinUnidad() != null) {
                    if (fe.isAfter(this.unidadSelec.getFechaFinUnidad())) {
                        msg = msg + "La fecha de envio debe ser antes del fin de la unidad.\n";
                        valido = false;
                    }
                    if (fp.isAfter(this.unidadSelec.getFechaFinUnidad())) {
                        msg = msg + "La fecha de presentacion no debe ser superior a la fecha de fin de unidad";
                        valido = false;
                    }
                }
                if (this.unidadSelec.getFechaInicioUnidad() != null) {
                    if (fe.isBefore(this.unidadSelec.getFechaInicioUnidad())) {
                        msg = msg + "La fecha de envio no puede ser anterior a la fecha de inicio de la unidad.\n";
                        valido = false;
                    }
                    if (fp.isBefore(this.unidadSelec.getFechaInicioUnidad())) {
                        msg = msg + "La fecha de presentacion no debe ser anterior a la fecha de inicio del periodo.\n";
                        valido = false;
                    }
                }
            }
        }
        if (!valido) {
            this.UFRMSCTR.errorFrmEvaluacion(msg);
        }
        return valido;
    }

    private void nuevaActividad() {
        if (this.totalGestion < 60.0) {
            this.recetearFrmActividad();
            this.mostrarFrmActividades("Nuevo " + this.actividadActual);
        } else {
            JOptionPane.showMessageDialog(this.FRM_ACCIONES, "Ya no es necesario que llenes esta informaci\u00f3n, se asigna por defecto los 60 puntos de forma autom\u00e1tica.", "Informaci\u00f3n Atividades", 1);
        }
    }

    private void editarActividad() {
        String code = this.getActividadSeleccionada();
        if (!"".equals(code)) {
            this.seleccionPorIdLocal(code);
            if (this.evaluacionSelec != null) {
                this.setearCamposActividad();
            }
        } else {
            JOptionPane.showMessageDialog(this.FRM_ACCIONES, "No selecciono ninguna actividad " + this.actividadActual + " para editarla, selecciona de la tabla correspondiente", "Editar Atividades", 2);
        }
    }

    private void setearCamposActividad() {
        this.FRM_ACCIONES.getTxtIndicador().setText(this.evaluacionSelec.getIndicador());
        this.FRM_ACCIONES.getTxtInstrumento().setText(this.evaluacionSelec.getInstrumento());
        this.FRM_ACCIONES.getSpnValoracion().setValue(this.evaluacionSelec.getValoracion());
        this.FRM_ACCIONES.getDchFechaEnvio().setDate(Date.from(this.evaluacionSelec.getFechaEnvio().atStartOfDay(ZoneId.systemDefault()).toInstant()));
        this.FRM_ACCIONES.getDchFechaPresentacion().setDate(Date.from(this.evaluacionSelec.getFechaPresentacion().atStartOfDay(ZoneId.systemDefault()).toInstant()));
        this.mostrarFrmActividades("Nuevo " + this.actividadActual + " ID: " + this.evaluacionSelec.getIdLocal());
    }

    private void eliminarActividad() {
        String code = this.getActividadSeleccionada();
        if (!"".equals(code)) {
            int r = JOptionPane.showConfirmDialog(this.FRM_ACCIONES, "Esta seguro de quitar la actividad.");
            if (r == 0) {
                this.seleccionPorIdLocal(code);
                if (this.evaluacionSelec != null) {
                    if (this.evaluacionSelec.getIdEvaluacion() > 0) {
                        this.EVBD.eliminar(this.evaluacionSelec.getIdEvaluacion());
                    }
                    this.evaluaciones.remove(this.evaluacionSelec);
                    this.cargarEvaluaciones();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.FRM_ACCIONES, "No selecciono ninguna actividad para quitarla", "Eliminar Atividades", 2);
        }
    }

    private String getActividadSeleccionada() {
        String code;
        switch (this.actividadActual) {
            case "AD": {
                code = this.UFRMSCTR.getIdLocalActividad(this.FRM_GESTION.getTblAsistidaDocente());
                break;
            }
            case "AC": {
                code = this.UFRMSCTR.getIdLocalActividad(this.FRM_GESTION.getTblAprendizajeColaborativo());
                break;
            }
            case "GP": {
                code = this.UFRMSCTR.getIdLocalActividad(this.FRM_GESTION.getTblPractica());
                break;
            }
            case "GA": {
                code = this.UFRMSCTR.getIdLocalActividad(this.FRM_GESTION.getTblAutonoma());
                break;
            }
            default: {
                code = "";
            }
        }
        return code;
    }

    private void recetearFrmActividad() {
        this.FRM_ACCIONES.getTxtIndicador().setText("");
        this.FRM_ACCIONES.getTxtInstrumento().setText("");
        this.FRM_ACCIONES.getSpnValoracion().setValue(0.1);
        this.FRM_ACCIONES.getDchFechaEnvio().setDate(null);
        this.FRM_ACCIONES.getDchFechaPresentacion().setDate(null);
    }

    private void mostrarFrmActividades(String titulo) {
        this.FRM_ACCIONES.getLblAccionActividades().setText(titulo);
        this.FRM_ACCIONES.setVisible(true);
    }

    private void seleccionPorIdLocal(String code) {
        for (EvaluacionSilaboMD e : this.evaluaciones) {
            if (e.getIdLocal() == Integer.parseInt(code)) {
                this.evaluacionSelec = e;
                break;
            }
            this.evaluacionSelec = null;
        }
    }

    private void cargarCmbUnidad() {
        this.FRM_GESTION.getCmbUnidad().removeAllItems();
        this.unidades.forEach(u -> this.FRM_GESTION.getCmbUnidad().addItem("Unidad " + u.getNumeroUnidad()));
        if (this.unidades.size() > 0) {
            this.FRM_GESTION.getCmbUnidad().setSelectedIndex(0);
        }
    }

    private void iniciarCmbEstrategiasConBuscador() {
        this.iniciarCmbEstrategias();
        this.FRM_GESTION.getCmbEstrategias().getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int i = FRMSilaboCTR.this.FRM_GESTION.getCmbEstrategias().getSelectedIndex();
                String a = FRMSilaboCTR.this.FRM_GESTION.getCmbEstrategias().getEditor().getItem().toString().trim();
                if (e.getKeyCode() == 10) {
                    if (i > 0 && !FRMSilaboCTR.this.eExisteEstrategia) {
                        FRMSilaboCTR.this.agregarEstrategia(i);
                    } else {
                        if (a.length() >= 1 && !FRMSilaboCTR.this.eExisteEstrategia) {
                            FRMSilaboCTR.this.buscarEstrategias(a);
                        }
                        FRMSilaboCTR.this.eExisteEstrategia = false;
                    }
                }
            }
        });
        this.FRM_GESTION.getCmbEstrategias().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int i = FRMSilaboCTR.this.FRM_GESTION.getCmbEstrategias().getSelectedIndex();
                if (i > 0) {
                    FRMSilaboCTR.this.agregarEstrategia(i);
                }
            }
        });
        this.FRM_GESTION.getLblAgregarEstrategia().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int i = FRMSilaboCTR.this.FRM_GESTION.getCmbEstrategias().getSelectedIndex();
                if (i > 0) {
                    FRMSilaboCTR.this.agregarEstrategia(i);
                }
            }
        });
    }

    private void iniciarCmbEstrategias() {
        this.FRM_GESTION.getCmbEstrategias().removeAllItems();
        this.FRM_GESTION.getCmbEstrategias().addItem("");
        this.filterEstrategias = null;
        this.filterEstrategias = new ArrayList<EstrategiasAprendizajeMD>();
        this.todasEstrategias.forEach(e -> {
            this.FRM_GESTION.getCmbEstrategias().addItem(e.getDescripcionEstrategia());
            this.filterEstrategias.add((EstrategiasAprendizajeMD)e);
        });
    }

    private void buscarEstrategias(String aguja) {
        this.filterEstrategias = null;
        this.filterEstrategias = new ArrayList<EstrategiasAprendizajeMD>();
        this.FRM_GESTION.getCmbEstrategias().removeAllItems();
        this.FRM_GESTION.getCmbEstrategias().addItem(aguja);
        this.todasEstrategias.forEach(e -> {
            if (e.getDescripcionEstrategia().toLowerCase().contains(aguja.toLowerCase())) {
                this.FRM_GESTION.getCmbEstrategias().addItem(e.getDescripcionEstrategia());
                this.filterEstrategias.add((EstrategiasAprendizajeMD)e);
            }
        });
        this.FRM_GESTION.getCmbEstrategias().showPopup();
    }

    private void agregarEstrategia(int index) {
        EstrategiasUnidadMD ne = new EstrategiasUnidadMD();
        ne.setUnidad(this.unidadSelec);
        ne.setEstrategia(this.filterEstrategias.get(index - 1));
        this.llenarTblEstrategiasUnidad(ne);
    }

    private void agregarEstrategia(EstrategiasAprendizajeMD estrategia) {
        EstrategiasUnidadMD ne = new EstrategiasUnidadMD();
        ne.setUnidad(this.unidadSelec);
        ne.setEstrategia(estrategia);
        this.llenarTblEstrategiasUnidad(ne);
    }

    private void iniciarSilabo() {
        this.FRM_GESTION.getTblAprendizajeColaborativo().setModel(this.mdTblAC);
        this.FRM_GESTION.getTblAsistidaDocente().setModel(this.mdTblAD);
        this.FRM_GESTION.getTblAutonoma().setModel(this.mdTblGA);
        this.FRM_GESTION.getTblPractica().setModel(this.mdTblGP);
        this.FRM_GESTION.getTblEstrategias().setModel(this.mdTblES);
        if (this.evaluaciones == null) {
            this.evaluaciones = new ArrayList<EvaluacionSilaboMD>();
        }
        this.biblioteca = new ArrayList<ReferenciasMD>();
        this.tiposActividad = this.TABD.getAll();
    }

    private void crearSilaboNuevo(int numUnidades) {
        this.unidades = new ArrayList<UnidadSilaboMD>();
        this.estrategias = new ArrayList<EstrategiasUnidadMD>();
        for (int i = 1; i <= numUnidades; ++i) {
            UnidadSilaboMD us = new UnidadSilaboMD();
            us.setNumeroUnidad(i);
            this.unidades.add(us);
        }
    }

    private void agregarBibliografia() {
        if (this.validarSilabo()) {
            if (this.silabo.getID() > 0) {
                this.guardar();
                FRMReferenciaSilaboCTR ctrReferencias = new FRMReferenciaSilaboCTR(this.ctrPrin, this.silabo, this.FRM_GESTION, this.cambioUnidad);
                ctrReferencias.iniciar();
            } else {
                this.silabo.setID(this.SBD.guardar(this.silabo));
                this.UFRMSCTR.errorGuardarSilabo();
            }
        }
    }

    private boolean validarSilabo() {
        this.msgErrorSilabo = "";
        if (this.numHD < (double)this.silabo.getMateria().getHorasDocencia()) {
            this.msgErrorSilabo = this.msgErrorSilabo + "Debe cumplir las horas establecidas en horas docencia en materia " + this.silabo.getMateria().getHorasDocencia() + "\n";
        }
        if (this.numHA < (double)this.silabo.getMateria().getHorasAutoEstudio()) {
            this.msgErrorSilabo = this.msgErrorSilabo + "Debe cumplir las horas establecidas en horas de autoestudio en materia " + this.silabo.getMateria().getHorasAutoEstudio() + "\n";
        }
        if (this.numHP < (double)this.silabo.getMateria().getHorasPracticas()) {
            this.msgErrorSilabo = this.msgErrorSilabo + "Debe cumplir las horas establecidas en horas practicas en materia " + this.silabo.getMateria().getHorasPracticas() + "\n";
        }
        this.unidades.forEach(u -> {
            if (u.getFechaInicioUnidad() == null) {
                this.msgErrorSilabo = this.msgErrorSilabo + "Debe ingresar la fecha  de inicio de la unidad " + u.getNumeroUnidad() + "\n";
            }
            if (u.getFechaFinUnidad() == null) {
                this.msgErrorSilabo = this.msgErrorSilabo + "Debe ingresar la fecha  de fin de la unidad " + u.getNumeroUnidad() + "\n";
            }
            if (u.getContenidosUnidad().trim().length() == 0) {
                this.msgErrorSilabo = this.msgErrorSilabo + "Debe ingresar  el contenido de la unidad " + u.getNumeroUnidad() + "\n";
            }
            if (u.getObjetivoEspecificoUnidad().trim().length() == 0) {
                this.msgErrorSilabo = this.msgErrorSilabo + "Debe ingresar  el objetivo de la unidad " + u.getNumeroUnidad() + "\n";
            }
            if (u.getResultadosAprendizajeUnidad().trim().length() == 0) {
                this.msgErrorSilabo = this.msgErrorSilabo + "Debe ingresar  el resultado de aprendizaje de la unidad " + u.getNumeroUnidad() + "\n";
            }
            if (u.getTituloUnidad().trim().length() == 0) {
                this.msgErrorSilabo = this.msgErrorSilabo + "Debe ingresar  el titulo de la unidad " + u.getNumeroUnidad() + "\n";
            }
        });
        return this.msgErrorSilabo.trim().length() == 0;
    }

    private void guardar() {
        new Thread(() -> {
            this.FRM_GESTION.getBtnGuardar().setEnabled(false);
            this.ctrPrin.getVtnPrin().setCursor(new Cursor(3));
            if (this.silabo.getID() == 0) {
                int idSilaboGen = this.SBD.guardar(this.silabo);
                this.silabo.setID(idSilaboGen);
            } else {
                this.SBD.setFechaEdicion(this.silabo.getID());
            }
            if (this.silabo.getID() > 0) {
                this.ctrPrin.getVtnPrin().getLblEstado().setText("Guardamos silabo con ID: " + this.silabo.getID());
                this.silabo.setID(this.silabo.getID());
                this.unidades.forEach(u -> {
                    int idUnidadGenerado = u.getID();
                    if (u.getID() == 0) {
                        idUnidadGenerado = this.USBD.guardar((UnidadSilaboMD)u, this.silabo.getID());
                    } else {
                        this.USBD.editar((UnidadSilaboMD)u);
                    }
                    this.ctrPrin.getVtnPrin().getLblEstado().setText("Guardamos unidad con ID: " + idUnidadGenerado);
                    if (idUnidadGenerado > 0) {
                        u.setId(idUnidadGenerado);
                        this.guardarEstrategias(idUnidadGenerado, u.getNumeroUnidad());
                        this.guardarEvaluaciones(idUnidadGenerado, u.getNumeroUnidad());
                    } else {
                        this.UFRMSCTR.errorGuardar("Algo salio mal. \nNo se pudo guardo la unidad " + u.getNumeroUnidad());
                    }
                });
            } else {
                this.UFRMSCTR.errorGuardarSilabo();
            }
            this.FRM_GESTION.getBtnGuardar().setEnabled(true);
            this.ctrPrin.getVtnPrin().setCursor(new Cursor(0));
        }).start();
    }

    private void guardarEstrategias(int idUnidadGenerado, int numeroUnidad) {
        this.estrategias.forEach(e -> {
            if (e.getUnidad().getNumeroUnidad() == numeroUnidad) {
                if (e.getIdEstrategiaUnidad() == 0) {
                    int idEstrategiaGen = this.EUBD.guardar((EstrategiasUnidadMD)e, idUnidadGenerado);
                    e.setIdEstrategiaUnidad(idEstrategiaGen);
                } else {
                    this.EUBD.editar((EstrategiasUnidadMD)e);
                }
            }
        });
    }

    private void guardarEvaluaciones(int idUnidadGenerado, int numeroUnidad) {
        this.evaluaciones.forEach(e -> {
            if (e.getIdUnidad().getNumeroUnidad() == numeroUnidad) {
                if (e.getIdEvaluacion() == 0) {
                    int idEvaluacionGen = this.EVBD.guardar((EvaluacionSilaboMD)e, idUnidadGenerado);
                    e.setIdEvaluacion(idEvaluacionGen);
                } else {
                    this.EVBD.editar((EvaluacionSilaboMD)e);
                }
            }
        });
    }

    private void detectarPanel() {
        this.FRM_GESTION.getTbpEvaluacion().addChangeListener(e -> {
            int selec = this.FRM_GESTION.getTbpEvaluacion().getSelectedIndex();
            switch (selec) {
                case 0: {
                    this.actividadActual = "AD";
                    break;
                }
                case 1: {
                    this.actividadActual = "AC";
                    break;
                }
                case 2: {
                    this.actividadActual = "GP";
                    break;
                }
                case 3: {
                    this.actividadActual = "GA";
                    break;
                }
                default: {
                    this.actividadActual = "";
                }
            }
        });
    }

    private void actualizarUnidadSeleccionada() {
        if (this.unidades.size() > 0) {
            this.unidadSelec = this.unidades.get(this.FRM_GESTION.getCmbUnidad().getSelectedIndex());
        }
    }

    private void mostrarUnidad() {
        this.cambioUnidad = true;
        if (this.unidades.size() > 0 && !this.eliminandoUnidad) {
            this.actualizarUnidadSeleccionada();
            this.FRM_GESTION.getTxtTitulo().setText(this.unidadSelec.getTituloUnidad());
            this.FRM_GESTION.getTxrContenidos().setText(this.unidadSelec.getContenidosUnidad());
            this.FRM_GESTION.getTxrObjetivos().setText(this.unidadSelec.getObjetivoEspecificoUnidad());
            this.FRM_GESTION.getTxrResultados().setText(this.unidadSelec.getResultadosAprendizajeUnidad());
            if (this.unidadSelec.getFechaInicioUnidad() != null) {
                this.FRM_GESTION.getDchFechaInicio().setDate(Date.from(this.unidadSelec.getFechaInicioUnidad().atStartOfDay(ZoneId.systemDefault()).toInstant()));
            } else {
                this.FRM_GESTION.getDchFechaInicio().setDate(null);
            }
            if (this.unidadSelec.getFechaFinUnidad() != null) {
                this.FRM_GESTION.getDchFechaFin().setDate(Date.from(this.unidadSelec.getFechaFinUnidad().atStartOfDay(ZoneId.systemDefault()).toInstant()));
            } else {
                this.FRM_GESTION.getDchFechaFin().setDate(null);
            }
            this.FRM_GESTION.getSpnHdocencia().setValue(this.unidadSelec.getHorasDocenciaUnidad());
            this.FRM_GESTION.getSpnHpracticas().setValue(this.unidadSelec.getHorasPracticaUnidad());
            this.FRM_GESTION.getSpnHautonomas().setValue(this.unidadSelec.getHorasAutonomoUnidad());
            this.cargarEvaluaciones();
            this.iniciarCmbEstrategias();
        }
        this.cambioUnidad = false;
    }

    private void cargarEvaluaciones() {
        this.evaluacionSelec = null;
        this.mdTblAC.setRowCount(0);
        this.mdTblAD.setRowCount(0);
        this.mdTblES.setRowCount(0);
        this.mdTblGA.setRowCount(0);
        this.mdTblGP.setRowCount(0);
        this.totalGestion = 60.0;
        this.evaluaciones.forEach(e -> {
            if (e.getIdUnidad().getNumeroUnidad() == this.unidadSelec.getNumeroUnidad()) {
                Object[] row = new Object[]{e.getIdLocal(), e.getIndicador(), e.getInstrumento(), e.getValoracion(), e.getFechaEnvio(), e.getFechaPresentacion(), e.getIdEvaluacion()};
                switch (e.getIdTipoActividad().getIdTipoActividad()) {
                    case 1: {
                        this.mdTblAD.addRow(row);
                        break;
                    }
                    case 2: {
                        this.mdTblAC.addRow(row);
                        break;
                    }
                    case 3: {
                        this.mdTblGP.addRow(row);
                        break;
                    }
                    case 4: {
                        this.mdTblGA.addRow(row);
                        break;
                    }
                }
            }
        });
        this.llenarTblEstrategiasUnidad();
        this.FRM_GESTION.getLblAcumuladoGestion().setText(this.totalGestion + "/60.0");
    }

    private void iniciarTblEstrategia() {
        this.FRM_GESTION.getTblEstrategias().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String estrategia;
                int s = FRMSilaboCTR.this.FRM_GESTION.getTblEstrategias().getSelectedRow();
                if (s >= 0 && (estrategia = FRMSilaboCTR.this.FRM_GESTION.getTblEstrategias().getValueAt(s, 1).toString()).length() > 0) {
                    if (estrategia.length() > 23) {
                        FRMSilaboCTR.this.FRM_GESTION.getLblEstrategiaSelec().setText(estrategia.substring(0, 23) + "...");
                    } else {
                        FRMSilaboCTR.this.FRM_GESTION.getLblEstrategiaSelec().setText(estrategia);
                    }
                    FRMSilaboCTR.this.FRM_GESTION.getLblEstrategiaSelec().setToolTipText(estrategia);
                }
            }
        });
        this.FRM_GESTION.getLblQuitarEstrategia().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FRMSilaboCTR.this.eliminarEstrategias();
            }
        });
    }

    private void eliminarEstrategias() {
        int r;
        int[] ss = this.FRM_GESTION.getTblEstrategias().getSelectedRows();
        if (ss.length > 0 && (r = JOptionPane.showConfirmDialog(this.FRM_ACCIONES, "\u00bfEsta seguro de eliminar " + ss.length + " estrategias de la unidad actual?")) == 0) {
            for (int s : ss) {
                System.out.println("Eliminamos estrategias : " + this.FRM_GESTION.getTblEstrategias().getValueAt(s, 0).toString());
                this.eliminarEstrategia(this.FRM_GESTION.getTblEstrategias().getValueAt(s, 0).toString());
            }
            this.llenarTblEstrategiasUnidad();
        }
    }

    private void eliminarEstrategia(String idLocal) {
        this.estrategias.removeIf(e -> {
            if (e.getIdLocal() == Integer.parseInt(idLocal)) {
                this.EUBD.eliminar(e.getIdEstrategiaUnidad());
            }
            return e.getIdLocal() == Integer.parseInt(idLocal);
        });
    }

    private void llenarTblEstrategiasUnidad() {
        this.mdTblES.setRowCount(0);
        this.estrategias.forEach(e -> {
            if (e.getUnidad().getNumeroUnidad() == this.unidadSelec.getNumeroUnidad()) {
                this.mdTblES.addRow(new Object[]{e.getIdLocal(), e.getEstrategia().getDescripcionEstrategia()});
            }
        });
    }

    private void llenarTblEstrategiasUnidad(EstrategiasUnidadMD estrategiaNueva) {
        this.existeEstrategia = false;
        this.estrategias.forEach(e -> {
            if (e.getUnidad().getNumeroUnidad() == this.unidadSelec.getNumeroUnidad() && e.getEstrategia().getDescripcionEstrategia().equals(estrategiaNueva.getEstrategia().getDescripcionEstrategia())) {
                this.existeEstrategia = true;
            }
        });
        if (!this.existeEstrategia) {
            this.estrategias.add(estrategiaNueva);
        } else if (!this.eExisteEstrategia) {
            this.eExisteEstrategia = true;
            this.UFRMSCTR.errorEstrategia("Ya agrego esta estrategia en esta unidad.");
        }
        this.mdTblES.setRowCount(0);
        this.estrategias.forEach(e -> {
            if (e.getUnidad().getNumeroUnidad() == this.unidadSelec.getNumeroUnidad()) {
                this.mdTblES.addRow(new Object[]{e.getIdLocal(), e.getEstrategia().getDescripcionEstrategia()});
            }
        });
    }

    private void agregarUnidad() {
        UnidadSilaboMD u = new UnidadSilaboMD();
        u.setNumeroUnidad(this.unidades.size() + 1);
        this.unidades.add(u);
        this.FRM_GESTION.getCmbUnidad().addItem("Unidad " + u.getNumeroUnidad());
        this.FRM_GESTION.getCmbUnidad().setSelectedIndex(this.unidades.size() - 1);
    }

    private void eliminarUnidad() {
        this.eliminandoUnidad = true;
        boolean eliminado = true;
        if (this.unidadSelec.getID() > 0) {
            eliminado = this.USBD.eliminar(this.unidadSelec.getID());
        }
        if (eliminado) {
            this.estrategias.removeIf(e -> e.getUnidad().getNumeroUnidad() == this.unidadSelec.getNumeroUnidad());
            this.evaluaciones.removeIf(e -> e.getIdUnidad().getNumeroUnidad() == this.unidadSelec.getNumeroUnidad());
            this.estrategias.forEach(e -> {
                if (e.getUnidad().getNumeroUnidad() > this.unidadSelec.getNumeroUnidad()) {
                    e.getUnidad().setNumeroUnidad(e.getUnidad().getNumeroUnidad() - 1);
                }
            });
            this.evaluaciones.forEach(e -> {
                if (e.getIdUnidad().getNumeroUnidad() > this.unidadSelec.getNumeroUnidad()) {
                    e.getIdUnidad().setNumeroUnidad(e.getIdUnidad().getNumeroUnidad() - 1);
                }
            });
            int numUnidad = this.unidadSelec.getNumeroUnidad();
            this.unidades.removeIf(u -> u.getNumeroUnidad() == this.unidadSelec.getNumeroUnidad());
            this.unidades.forEach(u -> {
                if (u.getNumeroUnidad() > numUnidad) {
                    u.setNumeroUnidad(u.getNumeroUnidad() - 1);
                }
            });
            this.guardar();
            this.cargarCmbUnidad();
            this.mostrarUnidad();
            this.llenarTblEstrategiasUnidad();
        }
        this.eliminandoUnidad = false;
    }

    private int getIdTipoActividad() {
        int id;
        switch (this.actividadActual) {
            case "AD": {
                id = 1;
                break;
            }
            case "AC": {
                id = 2;
                break;
            }
            case "GP": {
                id = 3;
                break;
            }
            case "GA": {
                id = 4;
                break;
            }
            default: {
                id = 0;
            }
        }
        return id;
    }

    private void iniciarEventosFecha() {
        this.FRM_GESTION.getDchFechaInicio().addPropertyChangeListener(e -> {
            if (!this.cambioUnidad) {
                this.validarFechaInicio();
            }
        });
        this.FRM_GESTION.getDchFechaFin().addPropertyChangeListener(e -> {
            if (!this.cambioUnidad) {
                this.validarFechaFin();
            }
        });
    }

    private void validarFechaInicio() {
        LocalDate fecha = this.UFRMSCTR.getFechaJDC(this.FRM_GESTION.getDchFechaInicio());
        if (fecha != null) {
            if (this.unidadSelec.getFechaFinUnidad() == null) {
                this.unidadSelec.setFechaInicioUnidad(fecha);
            } else {
                boolean valido = true;
                String msg = "";
                if (fecha.isBefore(this.silabo.getPeriodo().getFechaInicio())) {
                    msg = "La fecha de inicio debe ser mayor a la fecha de inicio del periodo. \nFecha inicio: " + fecha + "  Fecha periodo: " + this.silabo.getPeriodo().getFechaInicio() + "\n";
                    valido = false;
                }
                if (!fecha.isBefore(this.silabo.getPeriodo().getFechaFin())) {
                    msg = msg + "La fecha de fin inicio ser anterior a la fecha de fin de periodo. \n";
                }
                if (!fecha.isBefore(this.unidadSelec.getFechaFinUnidad())) {
                    msg = msg + "La fecha de inicio de la unidad debe ser anterior a la fecha de fin de la unidad.\n";
                    valido = false;
                }
                if (!valido) {
                    this.UFRMSCTR.errorFecha("Debe indicar una fecha de inicio correcta.\n" + msg);
                    this.FRM_GESTION.getDchFechaInicio().setDate(Date.from(this.unidadSelec.getFechaFinUnidad().atStartOfDay(ZoneId.systemDefault()).toInstant().minus(1L, ChronoUnit.DAYS)));
                } else {
                    this.unidadSelec.setFechaInicioUnidad(fecha);
                }
            }
        }
    }

    private void validarFechaFin() {
        LocalDate fecha = this.UFRMSCTR.getFechaJDC(this.FRM_GESTION.getDchFechaFin());
        if (fecha != null) {
            if (this.unidadSelec.getFechaInicioUnidad() == null) {
                this.unidadSelec.setFechaFinUnidad(fecha);
            } else {
                boolean valido = true;
                String msg = "";
                if (!fecha.isAfter(this.silabo.getPeriodo().getFechaInicio())) {
                    msg = "La fecha de fin debe ser mayor a la fecha de inicio del periodo.\n";
                    valido = false;
                }
                if (!fecha.isBefore(this.silabo.getPeriodo().getFechaFin())) {
                    msg = msg + "La fecha de fin debe ser anterior a la fecha de fin de periodo. \\n";
                }
                if (!fecha.isAfter(this.unidadSelec.getFechaInicioUnidad())) {
                    msg = msg + "La fecha de fin de la unidad debe ser posterior a la fecha de inicio.\n";
                    valido = false;
                }
                if (this.silabo.getPeriodo().getFechaFinClases().isBefore(fecha) && !this.silabo.getPeriodo().getFechaFinClases().equals(fecha)) {
                    msg = msg + "La fecha de fin de la unidad no debe ser superior a la fecha de fin de clases.\n";
                    valido = false;
                }
                if (!valido) {
                    this.UFRMSCTR.errorFecha("Debe indicar una fecha de fin correcta. \n" + msg);
                    this.FRM_GESTION.getDchFechaFin().setDate(Date.from(this.unidadSelec.getFechaInicioUnidad().atStartOfDay(ZoneId.systemDefault()).toInstant().plus(1L, ChronoUnit.DAYS)));
                } else {
                    this.unidadSelec.setFechaFinUnidad(fecha);
                }
            }
        }
    }

    private void iniciarEventoSPNHoras() {
        this.FRM_GESTION.getSpnHautonomas().addChangeListener(e -> this.validarHA());
        this.FRM_GESTION.getSpnHdocencia().addChangeListener(e -> this.validarHD());
        this.FRM_GESTION.getSpnHpracticas().addChangeListener(e -> this.validarHP());
    }

    private void validarHA() {
        double h = this.UFRMSCTR.getHoraSPN(this.FRM_GESTION.getSpnHautonomas());
        if (h >= 0.0 && h != this.unidadSelec.getHorasAutonomoUnidad()) {
            double nh = h + this.numHA - this.unidadSelec.getHorasAutonomoUnidad();
            if (nh <= (double)this.silabo.getMateria().getHorasAutoEstudio()) {
                this.numHA = nh;
                this.unidadSelec.setHorasAutonomoUnidad(h);
                this.reescribirHoras();
            } else {
                this.FRM_GESTION.getSpnHautonomas().setValue(this.unidadSelec.getHorasAutonomoUnidad());
                this.UFRMSCTR.errorHoras("Las horas autonomas superan la hora total indicada en materia.");
            }
        }
    }

    private void validarHD() {
        double h = this.UFRMSCTR.getHoraSPN(this.FRM_GESTION.getSpnHdocencia());
        if (h >= 0.0 && h != this.unidadSelec.getHorasDocenciaUnidad()) {
            double nh = h + this.numHD - this.unidadSelec.getHorasDocenciaUnidad();
            if (nh <= (double)this.silabo.getMateria().getHorasDocencia()) {
                this.numHD = nh;
                this.unidadSelec.setHorasDocenciaUnidad(h);
                this.reescribirHoras();
            } else {
                this.FRM_GESTION.getSpnHdocencia().setValue(this.unidadSelec.getHorasDocenciaUnidad());
                this.UFRMSCTR.errorHoras("Las horas de docencia superan la hora total indicada en materia.");
            }
        }
    }

    private void validarHP() {
        double h = this.UFRMSCTR.getHoraSPN(this.FRM_GESTION.getSpnHpracticas());
        if (h >= 0.0 && h != this.unidadSelec.getHorasPracticaUnidad()) {
            double nh = h + this.numHP - this.unidadSelec.getHorasPracticaUnidad();
            if (nh <= (double)this.silabo.getMateria().getHorasPracticas()) {
                this.numHP = nh;
                this.unidadSelec.setHorasPracticaUnidad(h);
                this.reescribirHoras();
            } else {
                this.FRM_GESTION.getSpnHpracticas().setValue(this.unidadSelec.getHorasPracticaUnidad());
                this.UFRMSCTR.errorHoras("Las horas practicas superan la hora total indicada en materia.");
            }
        }
    }

    private void actualizarHoras() {
        this.unidades.forEach(u -> {
            this.numHD += u.getHorasDocenciaUnidad();
            this.numHA += u.getHorasAutonomoUnidad();
            this.numHP += u.getHorasPracticaUnidad();
        });
        this.reescribirHoras();
    }

    private void reescribirHoras() {
        this.FRM_GESTION.getLblTotalHdocencia().setText(this.numHD + "/" + this.silabo.getMateria().getHorasDocencia());
        this.FRM_GESTION.getLblTotalHmateria().setText(this.numHA + "/" + this.silabo.getMateria().getHorasAutoEstudio());
        this.FRM_GESTION.getLblTotalHpracticas().setText(this.numHP + "/" + this.silabo.getMateria().getHorasPracticas());
    }
}

