/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.frm;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import modelo.estilo.TblEstilo;
import modelo.referencias.NEWReferenciasBD;
import modelo.referencias.ReferenciasMD;
import modelo.referenciasSilabo.ReferenciaSilaboMD;
import modelo.silabo.NEWReferenciaSilaboBD;
import modelo.silabo.NEWSilaboBD;
import modelo.silabo.SilaboMD;
import vista.silabos.FrmReferencias;
import vista.silabos.NEWFrmSilabo;

public class FRMReferenciaSilaboCTR
extends DCTR {
    private final NEWFrmSilabo FRM_SILABO;
    private final FrmReferencias FRM_REF = new FrmReferencias();
    private final SilaboMD silabo;
    private final NEWReferenciasBD REBD = NEWReferenciasBD.single();
    private final NEWReferenciaSilaboBD RSBD = NEWReferenciaSilaboBD.single();
    private final NEWSilaboBD SBD = NEWSilaboBD.single();
    private List<ReferenciasMD> todasReferenciasBiblioteca;
    private List<ReferenciasMD> referenciasBuscadas;
    private List<ReferenciasMD> todasReferenciasVirtual;
    private final ReferenciasMD linkografia;
    private final ReferenciasMD complementaria;
    private List<ReferenciaSilaboMD> referenciasSilabo;
    private boolean existeReferencia = false;
    private boolean tieneComple = false;
    private boolean tieneLinko = false;
    private final DefaultListModel mdlRS = new DefaultListModel();
    private boolean cambioUnidad;
    private final DefaultTableModel mdTblBiblio = TblEstilo.modelTblSinEditar(new String[]{"C\u00f3digo", "Referencia"});

    public FRMReferenciaSilaboCTR(VtnPrincipalCTR ctrPrin, SilaboMD silabo, NEWFrmSilabo FRM_SILABO, boolean cambioUnidad) {
        super(ctrPrin);
        this.silabo = silabo;
        this.linkografia = new ReferenciasMD(silabo.getID() + "", "", "Linkografia");
        this.complementaria = new ReferenciasMD(silabo.getID() + "", "", "Complementaria");
        this.FRM_SILABO = FRM_SILABO;
        this.cambioUnidad = cambioUnidad;
    }

    public void iniciar() {
        this.cambioUnidad = true;
        this.FRM_SILABO.setVisible(false);
        this.iniciarVentana();
        this.cargarReferenciasSilabo();
        this.ctrPrin.agregarVtn(this.FRM_REF);
    }

    private void cargarReferenciasSilabo() {
        this.referenciasSilabo = this.RSBD.getBySilabo(this.silabo.getID());
        if (this.referenciasSilabo.size() > 0) {
            this.referenciasSilabo.forEach(r -> {
                if (r.getIdReferencia().getTipoReferencia().equals("Linkografia")) {
                    this.linkografia.setDescripcionReferencia(r.getIdReferencia().getDescripcionReferencia());
                    this.linkografia.setIdReferencia(r.getIdReferencia().getIdReferencia());
                    r.setIdReferencia(this.linkografia);
                    this.tieneLinko = true;
                }
                if (r.getIdReferencia().getTipoReferencia().equals("Complementaria")) {
                    this.complementaria.setDescripcionReferencia(r.getIdReferencia().getDescripcionReferencia());
                    this.complementaria.setIdReferencia(r.getIdReferencia().getIdReferencia());
                    r.setIdReferencia(this.complementaria);
                    this.tieneComple = true;
                }
                if (r.getIdReferencia().getTipoReferencia().equals("Base")) {
                    this.mdlRS.addElement("\u2022 " + r.getIdReferencia().getDescripcionReferencia());
                }
            });
        }
        if (!this.tieneLinko) {
            ReferenciaSilaboMD rl = new ReferenciaSilaboMD(this.linkografia, this.silabo);
            this.referenciasSilabo.add(rl);
            System.out.println("AGregamos linko");
        }
        if (!this.tieneComple) {
            ReferenciaSilaboMD rc = new ReferenciaSilaboMD(this.complementaria, this.silabo);
            this.referenciasSilabo.add(rc);
            System.out.println("Agregamos comple");
        }
        this.FRM_REF.getTxrLinkografia().setText(this.linkografia.getDescripcionReferencia());
        this.FRM_REF.getTxrBibliografiaComplementaria().setText(this.complementaria.getDescripcionReferencia());
        this.FRM_REF.getTxtSustentoBB().setText(this.silabo.getSustentobb());
        this.FRM_REF.getTxtSustentoCC().setText(this.silabo.getSustentobc());
    }

    private void iniciarVentana() {
        this.FRM_REF.setTitle(this.silabo.getMateria().getNombre() + " | " + this.silabo.getPeriodo().getNombre());
        this.iniciarAcciones();
        this.iniciarEventos();
        this.cargarBiblioteca();
        this.iniciarTbl();
        this.iniciarLista();
        this.FRM_REF.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                FRMReferenciaSilaboCTR.this.cambioUnidad = false;
                FRMReferenciaSilaboCTR.this.FRM_SILABO.setVisible(true);
            }
        });
    }

    private void iniciarAcciones() {
        this.FRM_REF.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String a = FRMReferenciaSilaboCTR.this.FRM_REF.getTxtBuscar().getText().trim().toLowerCase();
                if (FRMReferenciaSilaboCTR.this.FRM_REF.getCmbBiblioteca().getSelectedIndex() == 0) {
                    FRMReferenciaSilaboCTR.this.buscarBiblioteca(a);
                } else {
                    FRMReferenciaSilaboCTR.this.buscarVirtual(a);
                }
            }
        });
        this.FRM_REF.getCmbBiblioteca().addActionListener(e -> {
            if (this.FRM_REF.getCmbBiblioteca().getSelectedIndex() == 0) {
                this.cargarTodosBiblioteca();
            } else {
                this.cargarTodosVirtual();
            }
        });
        this.FRM_REF.getBtnAgregarBibliografiaBase().addActionListener(e -> this.agregarBiblioBase());
        this.FRM_REF.getBtnQuitarBibliografiaBase().addActionListener(e -> this.quitarBiblioBase());
        this.FRM_REF.getBtnAgregarBibliografiaBase1().addActionListener(e -> this.agregarBiblioConsulta());
        this.FRM_REF.getBtnAgregarBibliografiaBase1().setVisible(false);
        this.FRM_REF.getBtnQuitarBibliografiaBase1().setVisible(false);
        this.FRM_REF.getLstBibliografiaBase1().setVisible(false);
        this.FRM_REF.getBtnFinalizar().addActionListener(e -> this.guardar());
        this.FRM_REF.getBtnAtras().addActionListener(e -> this.FRM_SILABO.setVisible(true));
        this.FRM_REF.getBtnCancelar().addActionListener(e -> this.FRM_SILABO.setVisible(true));
    }

    private void iniciarEventos() {
        this.FRM_REF.getTxrBibliografiaComplementaria().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FRMReferenciaSilaboCTR.this.complementaria.setDescripcionReferencia(FRMReferenciaSilaboCTR.this.FRM_REF.getTxrBibliografiaComplementaria().getText().trim());
            }
        });
        this.FRM_REF.getTxrLinkografia().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FRMReferenciaSilaboCTR.this.linkografia.setDescripcionReferencia(FRMReferenciaSilaboCTR.this.FRM_REF.getTxrLinkografia().getText().trim());
            }
        });
    }

    private void cargarBiblioteca() {
        this.todasReferenciasBiblioteca = this.REBD.getAllBiblioteca();
        this.todasReferenciasVirtual = this.REBD.getAllVirtual();
    }

    private void iniciarLista() {
        this.FRM_REF.getLstBibliografiaBase().setModel(this.mdlRS);
    }

    private void iniciarTbl() {
        this.FRM_REF.getTblBiblioteca().setModel(this.mdTblBiblio);
        this.mdTblBiblio.setRowCount(0);
        int anchoCodigo = (int)((double)this.mdTblBiblio.getColumnCount() * 0.2 * (double)this.FRM_REF.getTblBiblioteca().getWidth());
        this.FRM_REF.getTblBiblioteca().getColumnModel().getColumn(0).setPreferredWidth(5);
        this.cargarTodosBiblioteca();
    }

    private void buscarBiblioteca(String aguja) {
        if (aguja.length() > 0) {
            this.mdTblBiblio.setRowCount(0);
            this.FRM_REF.getTblBiblioteca().getColumnModel().getColumn(0).setPreferredWidth(5);
            this.referenciasBuscadas = null;
            this.referenciasBuscadas = new ArrayList<ReferenciasMD>();
            this.todasReferenciasBiblioteca.forEach(r -> {
                if (r.getDescripcionReferencia().toLowerCase().contains(aguja) || r.getCodigoReferencia().toLowerCase().contains(aguja)) {
                    this.referenciasBuscadas.add((ReferenciasMD)r);
                    Object[] row = new Object[]{r.getCodigoReferencia(), r.getDescripcionReferencia()};
                    this.mdTblBiblio.addRow(row);
                }
            });
        } else {
            this.cargarTodosBiblioteca();
        }
    }

    private void buscarVirtual(String aguja) {
        if (aguja.length() > 0) {
            this.mdTblBiblio.setRowCount(0);
            this.FRM_REF.getTblBiblioteca().getColumnModel().getColumn(0).setPreferredWidth(5);
            this.referenciasBuscadas = null;
            this.referenciasBuscadas = new ArrayList<ReferenciasMD>();
            this.todasReferenciasVirtual.forEach(r -> {
                if (r.getDescripcionReferencia().toLowerCase().contains(aguja) || r.getCodigoReferencia().toLowerCase().contains(aguja)) {
                    this.referenciasBuscadas.add((ReferenciasMD)r);
                    Object[] row = new Object[]{r.getCodigoReferencia(), r.getDescripcionReferencia()};
                    this.mdTblBiblio.addRow(row);
                }
            });
        } else {
            this.cargarTodosVirtual();
        }
    }

    private void cargarTodosBiblioteca() {
        this.referenciasBuscadas = null;
        this.referenciasBuscadas = new ArrayList<ReferenciasMD>();
        this.mdTblBiblio.setRowCount(0);
        this.FRM_REF.getTblBiblioteca().getColumnModel().getColumn(0).setPreferredWidth(5);
        this.todasReferenciasBiblioteca.forEach(r -> {
            this.referenciasBuscadas.add((ReferenciasMD)r);
            Object[] row = new Object[]{r.getCodigoReferencia(), r.getDescripcionReferencia()};
            this.mdTblBiblio.addRow(row);
        });
    }

    private void cargarTodosVirtual() {
        this.mdTblBiblio.setRowCount(0);
        this.FRM_REF.getTblBiblioteca().getColumnModel().getColumn(0).setPreferredWidth(5);
        this.todasReferenciasVirtual.forEach(r -> {
            Object[] row = new Object[]{r.getCodigoReferencia(), r.getDescripcionReferencia()};
            this.mdTblBiblio.addRow(row);
        });
    }

    private void agregarBiblioBase() {
        int s = this.FRM_REF.getTblBiblioteca().getSelectedRow();
        if (s >= 0) {
            this.llenarListaReferencias(this.referenciasBuscadas.get(s));
        }
    }

    private void agregarBiblioConsulta() {
        int s = this.FRM_REF.getTblBiblioteca().getSelectedRow();
        if (s >= 0) {
            ReferenciasMD rf = this.referenciasBuscadas.get(s);
            this.FRM_REF.getTxrBibliografiaComplementaria().setText(this.FRM_REF.getTxrBibliografiaComplementaria().getText() + "\u2022 " + rf.getDescripcionReferencia() + "\n");
        }
    }

    private void llenarListaReferencias1(ReferenciasMD nuevaReferencia) {
        this.existeReferencia = false;
        this.mdlRS.removeAllElements();
        this.referenciasSilabo.forEach(r -> {
            if (r.getIdReferencia().getDescripcionReferencia().equals(nuevaReferencia.getDescripcionReferencia())) {
                this.existeReferencia = true;
            }
            if (r.getIdReferencia().getTipoReferencia().equals("Complementaria")) {
                this.mdlRS.addElement("\u2022 " + r.getIdReferencia().getDescripcionReferencia());
            }
        });
        if (!this.existeReferencia) {
            ReferenciaSilaboMD rs = new ReferenciaSilaboMD();
            rs.setIdSilabo(this.silabo);
            rs.setIdReferencia(nuevaReferencia);
            this.referenciasSilabo.add(rs);
            this.mdlRS.addElement("\u2022 " + rs.getIdReferencia().getDescripcionReferencia());
        } else {
            JOptionPane.showMessageDialog(null, "Ya agregamos esta referencia al silabo", "Error en referencias", 0);
        }
    }

    private void quitarBiblioBase() {
        int s = this.FRM_REF.getLstBibliografiaBase().getSelectedIndex();
        if (s >= 0) {
            if (this.referenciasSilabo.get(s).getIdReferenciaSilabo() > 0) {
                this.RSBD.eliminar(this.referenciasSilabo.get(s).getIdReferenciaSilabo());
            }
            this.referenciasSilabo.remove(s);
            this.llenarListaReferencias();
        }
    }

    private void llenarListaReferencias() {
        this.mdlRS.removeAllElements();
        this.referenciasSilabo.forEach(r -> {
            if (r.getIdReferencia().getTipoReferencia().equals("Base")) {
                this.mdlRS.addElement("\u2022 " + r.getIdReferencia().getDescripcionReferencia());
            }
        });
    }

    private void llenarListaReferencias(ReferenciasMD nuevaReferencia) {
        this.existeReferencia = false;
        this.mdlRS.removeAllElements();
        this.referenciasSilabo.forEach(r -> {
            if (r.getIdReferencia().getDescripcionReferencia().equals(nuevaReferencia.getDescripcionReferencia())) {
                this.existeReferencia = true;
            }
            if (r.getIdReferencia().getTipoReferencia().equals("Base")) {
                this.mdlRS.addElement("\u2022 " + r.getIdReferencia().getDescripcionReferencia());
            }
        });
        if (!this.existeReferencia) {
            ReferenciaSilaboMD rs = new ReferenciaSilaboMD();
            rs.setIdSilabo(this.silabo);
            rs.setIdReferencia(nuevaReferencia);
            this.referenciasSilabo.add(rs);
            this.mdlRS.addElement("\u2022 " + rs.getIdReferencia().getDescripcionReferencia());
        } else {
            JOptionPane.showMessageDialog(null, "Ya agregamos esta referencia al silabo", "Error en referencias", 0);
        }
    }

    private void guardar() {
        if (this.referenciasSilabo.size() > 2) {
            this.cambioUnidad = true;
            this.SBD.ediantoSilabo(this.silabo.getID(), false);
            this.SBD.setFechaEdicion(this.silabo.getID());
            this.referenciasSilabo.forEach(r -> {
                if (r.getIdReferenciaSilabo() == 0 && r.getIdReferencia().getTipoReferencia().equals("Base")) {
                    this.RSBD.guardar(this.silabo.getID(), r.getIdReferencia().getIdReferencia());
                }
                if (r.getIdReferencia().getTipoReferencia().equals("Linkografia") || r.getIdReferencia().getTipoReferencia().equals("Complementaria")) {
                    System.out.println("TENEMOS LINK Y COMPLEMENT");
                    if (r.getIdReferencia().getIdReferencia() > 0) {
                        this.REBD.editarNoBase(r.getIdReferencia());
                    } else {
                        int idGenerado = this.REBD.guardarNoBase(r.getIdReferencia());
                        this.RSBD.guardar(this.silabo.getID(), idGenerado);
                    }
                }
            });
            this.silabo.setSustentobb(this.FRM_REF.getTxtSustentoBB().getText());
            this.silabo.setSustentobc(this.FRM_REF.getTxtSustentoCC().getText());
            this.SBD.guardaSustentos(this.silabo.getID(), this.silabo.getSustentobb(), this.silabo.getSustentobc());
            JOptionPane.showConfirmDialog(this.FRM_REF, "Termino de crear su silabo.");
            this.FRM_REF.dispose();
            this.FRM_SILABO.dispose();
        } else {
            JOptionPane.showMessageDialog(null, "Por lo menos se debe agregar una referencia base a su silabo.", "Error en referencias", 0);
        }
    }
}

