/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.avance;

import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import modelo.AvanceSilabo.AvanzeUnidadesBDA;
import modelo.AvanceSilabo.AvanzeUnidadesMDA;
import modelo.AvanceSilabo.SeguimientoSilaboBD;
import modelo.AvanceSilabo.SeguimientoSilaboMD;
import modelo.curso.CursoMD;
import modelo.silabo.CursoMDS;
import modelo.silabo.CursosBDS;
import modelo.silabo.SilaboMD;
import modelo.unidadSilabo.UnidadSilaboBD;
import modelo.unidadSilabo.UnidadSilaboMD;
import vista.principal.VtnPrincipal;
import vista.silabos.frmAvanceSilabo;

public class controlador_avance_ingreso {
    private final VtnPrincipal vtnPrincipal;
    private CursoMD curso;
    private SilaboMD silabo;
    private List<CursoMDS> lista_curso;
    private frmAvanceSilabo avanceSi;
    private List<UnidadSilaboMD> unidadesSilabo;
    private List<AvanzeUnidadesMDA> lista_avanzeU;
    private SeguimientoSilaboMD seguimientoSilaboMD;
    private List<SeguimientoSilaboMD> count;
    private boolean accion = true;

    public controlador_avance_ingreso(VtnPrincipal vtnPrincipal, CursoMD curso, SilaboMD silabo) {
        this.vtnPrincipal = vtnPrincipal;
        this.curso = curso;
        this.silabo = silabo;
    }

    public void init() {
        this.avanceSi = new frmAvanceSilabo();
        this.vtnPrincipal.getDpnlPrincipal().add(this.avanceSi);
        this.avanceSi.setTitle("CREAR UN AVANCE DE SILABO");
        this.avanceSi.show();
        this.avanceSi.setLocation((this.vtnPrincipal.getDpnlPrincipal().getSize().width - this.avanceSi.getSize().width) / 2, (this.vtnPrincipal.getDpnlPrincipal().getSize().height - this.avanceSi.getSize().height) / 2);
        this.lista_curso = CursosBDS.ConsultarCursoCarreraDocente(this.curso.getId());
        this.lista_avanzeU = new ArrayList<AvanzeUnidadesMDA>();
        this.unidadesSilabo = UnidadSilaboBD.consultarUnidadesPlanClase(this.silabo.getID());
        this.cargarTemasUnidades();
        this.cargarCampos(this.lista_curso);
        this.avanceSi.getCbxTipoReporte().removeItemAt(2);
        this.avanceSi.getBntGuardar().addActionListener(e -> this.ejecutar(e));
        this.avanceSi.getBtnCancelar().addActionListener(a1 -> {
            this.avanceSi.dispose();
            this.vtnPrincipal.getMnCAvanceSilabo().doClick();
        });
        this.avanceSi.getCbxUnidad().addActionListener(e -> this.mostrarUnidad());
        this.avanceSi.getSpnCumplimiento().addChangeListener(e -> {
            AvanzeUnidadesMDA unidadSeleccionadaAvanz = this.seleccionarUnidadA();
            unidadSeleccionadaAvanz.setPortecentaje((Integer)this.avanceSi.getSpnCumplimiento().getValue());
        });
        this.avanceSi.getTxrObservaciones().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                AvanzeUnidadesMDA unidadSeleccionadaAvanz = controlador_avance_ingreso.this.seleccionarUnidadA();
                unidadSeleccionadaAvanz.setObservaciones(controlador_avance_ingreso.this.avanceSi.getTxrObservaciones().getText());
            }
        });
        this.avanceSi.getTxtConclusionGuia().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AvanzeUnidadesMDA unidadSeleccionadaAvanz = controlador_avance_ingreso.this.seleccionarUnidadA();
                unidadSeleccionadaAvanz.setConclusion(controlador_avance_ingreso.this.avanceSi.getTxtConclusionGuia().getText());
            }
        });
        this.avanceSi.getCbxUnidad().setSelectedIndex(0);
    }

    private void cargarTemasUnidades() {
        this.unidadesSilabo.forEach(umd -> this.avanceSi.getCbxUnidad().addItem(umd.getTituloUnidad()));
        for (UnidadSilaboMD us : this.unidadesSilabo) {
            this.lista_avanzeU.add(new AvanzeUnidadesMDA(us));
        }
    }

    public void cargarCampos(List<CursoMDS> lista) {
        for (CursoMDS cursoMDS : lista) {
            this.avanceSi.getTxtCarrera().setText(cursoMDS.getId_carrera().getNombre());
            this.avanceSi.getTxtCarrera().setEnabled(false);
            this.avanceSi.getTxtDocente().setText(cursoMDS.getId_persona().getPrimerNombre() + " " + cursoMDS.getId_persona().getPrimerApellido());
            this.avanceSi.getTxtDocente().setEnabled(false);
            this.avanceSi.getTxtAsignatura().setText(cursoMDS.getId_materia().getNombre());
            this.avanceSi.getTxtAsignatura().setEnabled(false);
            this.avanceSi.getTxtParalelo().setText(cursoMDS.getCurso_nombre());
            this.avanceSi.getTxtParalelo().setEnabled(false);
            int numeroAlm = CursosBDS.numero(this.curso.getId());
            this.avanceSi.getTxtNumeroAlumnos().setText(String.valueOf(numeroAlm));
        }
    }

    private void mostrarUnidad() {
        AvanzeUnidadesMDA unidadesMDA = this.seleccionarUnidadA();
        this.avanceSi.getTxrContenidos().setText(unidadesMDA.getUnidad().getContenidosUnidad());
        this.avanceSi.getTxrObservaciones().setText(unidadesMDA.getObservaciones());
        this.avanceSi.getSpnCumplimiento().setValue(unidadesMDA.getPortecentaje());
        this.avanceSi.getTxtConclusionGuia().setText(unidadesMDA.getConclusion());
    }

    private AvanzeUnidadesMDA seleccionarUnidadA() {
        Optional<AvanzeUnidadesMDA> unidadSeleccionadaA = this.lista_avanzeU.stream().filter(uas -> uas.getUnidad().getTituloUnidad().equals(this.avanceSi.getCbxUnidad().getSelectedItem().toString())).findFirst();
        return unidadSeleccionadaA.get();
    }

    private boolean guardar_SeguimientoSilabo() {
        boolean esInterciclo = true;
        try {
            this.seguimientoSilaboMD = new SeguimientoSilaboMD(this.curso);
            this.seguimientoSilaboMD.getCurso().setId(this.curso.getId());
            this.seguimientoSilaboMD.setFecha_entrega_informe(this.avanceSi.getDchFechaEntrega().getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            if (this.avanceSi.getCbxTipoReporte().getSelectedItem().equals("Interciclo")) {
                esInterciclo = true;
            }
            this.seguimientoSilaboMD.setEsInterciclo(esInterciclo);
            if (new SeguimientoSilaboBD().insertarSeguimiento(this.seguimientoSilaboMD)) {
                this.insertarAvanceUnidades();
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("Fallo al guardar ULTIMO");
        }
        return false;
    }

    private void insertarAvanceUnidades() {
        this.seguimientoSilaboMD = SeguimientoSilaboBD.consultarUltimoSegumiento(this.curso.getId(), this.seguimientoSilaboMD.isEsInterciclo());
        this.seguimientoSilaboMD.setId_seguimientoS(this.seguimientoSilaboMD.getId_seguimientoS());
        for (AvanzeUnidadesMDA avanceU : this.lista_avanzeU) {
            avanceU.getSeguimiento().setId_seguimientoS(this.seguimientoSilaboMD.getId_seguimientoS());
            AvanzeUnidadesBDA aus = new AvanzeUnidadesBDA();
            aus.insertarAvanzeUnidades(avanceU, avanceU.getSeguimiento().getId_seguimientoS());
        }
    }

    private void ejecutar(ActionEvent e) {
        if (this.accion) {
            new Thread(() -> {
                this.accion = false;
                if (this.validarCampos()) {
                    boolean aux = false;
                    this.avanceSi.getBtnCancelar().setEnabled(false);
                    this.avanceSi.getBntGuardar().setEnabled(false);
                    this.vtnPrincipal.getLblEstado().setText("                                  Guardando su Seguimiento de S\u00edlabo! Espere por favor...........");
                    try {
                        Thread.sleep(400L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(controlador_avance_ingreso.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    aux = this.guardar_SeguimientoSilabo();
                    if (aux) {
                        JOptionPane.showMessageDialog(this.avanceSi, "Se guard\u00f3 correctamente!");
                        this.avanceSi.dispose();
                        this.vtnPrincipal.getMnCAvanceSilabo().doClick();
                    } else {
                        JOptionPane.showMessageDialog(null, "Fall\u00f3 al guardar! Intente de nuevo! ", "Aviso", 0);
                        this.avanceSi.getBtnCancelar().setEnabled(true);
                        this.avanceSi.getBntGuardar().setEnabled(true);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "         REVISE INFORMACION INCOMPLETA\nY/O REPORTE DE CICLO O INTERCICLO YA EXISTENTE", "Aviso", 0);
                }
                this.vtnPrincipal.getLblEstado().setText("");
                this.accion = true;
            }).start();
        }
    }

    private boolean validarCampos() {
        boolean valid = true;
        if (this.avanceSi.getCbxTipoReporte().getSelectedItem().equals("Reporte Correspondiente a") || this.avanceSi.getDchFechaEntrega().getDate() == null) {
            valid = false;
        }
        for (int i = 0; i < this.lista_avanzeU.size(); ++i) {
            if (this.lista_avanzeU.get(i).getObservaciones() != null) continue;
            valid = false;
        }
        return valid;
    }
}

