/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.avance;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import modelo.AvanceSilabo.AvanzeUnidadesBDA;
import modelo.AvanceSilabo.AvanzeUnidadesMDA;
import modelo.AvanceSilabo.SeguimientoSilaboBD;
import modelo.AvanceSilabo.SeguimientoSilaboMD;
import modelo.curso.CursoMD;
import modelo.silabo.CursoMDS;
import modelo.silabo.CursosBDS;
import modelo.usuario.UsuarioBD;
import vista.principal.VtnPrincipal;
import vista.silabos.frmAvanceSilabo;

public class FrmEditarAvanceSilaboCTR {
    private UsuarioBD usuario;
    private SeguimientoSilaboMD seguimientoS;
    private final VtnPrincipal vtnPrincipal;
    private CursoMD curso;
    private frmAvanceSilabo avanceSi;
    private List<CursoMDS> lista_curso;
    private List<AvanzeUnidadesMDA> lista_avanUnidades;
    private SeguimientoSilaboMD seguimientoSilaboMD;
    private List<SeguimientoSilaboMD> count;
    private boolean accion = true;

    public FrmEditarAvanceSilaboCTR(UsuarioBD usuario, SeguimientoSilaboMD seguimientoS, VtnPrincipal vtnPrincipal, CursoMD curso) {
        this.usuario = usuario;
        this.seguimientoS = seguimientoS;
        this.vtnPrincipal = vtnPrincipal;
        this.curso = curso;
    }

    public void init() {
        this.avanceSi = new frmAvanceSilabo();
        this.vtnPrincipal.getDpnlPrincipal().add(this.avanceSi);
        this.avanceSi.setTitle("CREAR UN AVANCE DE SILABO");
        this.avanceSi.show();
        this.avanceSi.setLocation((this.vtnPrincipal.getDpnlPrincipal().getSize().width - this.avanceSi.getSize().width) / 2, (this.vtnPrincipal.getDpnlPrincipal().getSize().height - this.avanceSi.getSize().height) / 2);
        this.lista_curso = CursosBDS.ConsultarCursoCarreraDocente(this.curso.getId());
        this.lista_avanUnidades = AvanzeUnidadesBDA.consultarUnidadAvanze(this.curso.getId(), this.seguimientoS.getId_seguimientoS());
        this.cargarCampos(this.lista_curso);
        this.avanceSi.getBntGuardar().addActionListener(e -> this.ejecutar(e));
        this.lista_avanUnidades.forEach(uas -> this.avanceSi.getCbxUnidad().addItem(uas.getUnidad().getTituloUnidad()));
        this.avanceSi.getCbxUnidad().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmEditarAvanceSilaboCTR.this.MostrarUnidad();
            }
        });
        this.avanceSi.getTxrObservaciones().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                AvanzeUnidadesMDA unidadSeleccionadaAvanz = FrmEditarAvanceSilaboCTR.this.SeleccionarUnidadAvance();
                unidadSeleccionadaAvanz.setObservaciones(FrmEditarAvanceSilaboCTR.this.avanceSi.getTxrObservaciones().getText());
            }
        });
        this.avanceSi.getSpnCumplimiento().addChangeListener(e -> {
            AvanzeUnidadesMDA unidadSeleccionadaAvanz = this.SeleccionarUnidadAvance();
            unidadSeleccionadaAvanz.setPortecentaje((Integer)this.avanceSi.getSpnCumplimiento().getValue());
        });
        this.avanceSi.getTxrObservaciones().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                AvanzeUnidadesMDA unidadSeleccionadaAvanz = FrmEditarAvanceSilaboCTR.this.SeleccionarUnidadAvance();
                unidadSeleccionadaAvanz.setObservaciones(FrmEditarAvanceSilaboCTR.this.avanceSi.getTxrObservaciones().getText());
            }
        });
        this.avanceSi.getTxtConclusionGuia().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AvanzeUnidadesMDA unidadSeleccionadaAvanz = FrmEditarAvanceSilaboCTR.this.SeleccionarUnidadAvance();
                unidadSeleccionadaAvanz.setConclusion(FrmEditarAvanceSilaboCTR.this.avanceSi.getTxtConclusionGuia().getText());
            }
        });
        this.avanceSi.getCbxUnidad().setSelectedIndex(0);
        this.avanceSi.getBtnCancelar().addActionListener(e -> {
            this.avanceSi.dispose();
            this.vtnPrincipal.getMnCAvanceSilabo().doClick();
        });
    }

    public void cargarCampos(List<CursoMDS> lista) {
        for (CursoMDS cursoMDS : lista) {
            this.avanceSi.getTxtCarrera().setText(cursoMDS.getId_carrera().getNombre());
            this.avanceSi.getTxtCarrera().setEnabled(false);
            this.avanceSi.getTxtDocente().setText(cursoMDS.getId_persona().getPrimerNombre() + " " + cursoMDS.getId_persona().getPrimerApellido());
            this.avanceSi.getTxtDocente().setEnabled(false);
            this.avanceSi.getTxtAsignatura().setText(cursoMDS.getId_materia().getNombre());
            this.avanceSi.getTxtAsignatura().setEnabled(false);
            this.avanceSi.getTxtParalelo().setText(cursoMDS.getCurso_nombre());
            this.avanceSi.getTxtParalelo().setEnabled(false);
            int numeroAlm = CursosBDS.numero(this.curso.getId());
            this.avanceSi.getTxtNumeroAlumnos().setText(String.valueOf(numeroAlm));
            for (AvanzeUnidadesMDA aus : this.lista_avanUnidades) {
                this.avanceSi.getDchFechaEntrega().setDate(Date.from(aus.getSeguimiento().getFecha_entrega_informe().atStartOfDay(ZoneId.systemDefault()).toInstant()));
                if (aus.getSeguimiento().isEsInterciclo()) {
                    this.avanceSi.getCbxTipoReporte().setSelectedIndex(1);
                    continue;
                }
                this.avanceSi.getCbxTipoReporte().removeAllItems();
                this.avanceSi.getCbxTipoReporte().addItem("Fin de Ciclo");
                this.avanceSi.getCbxTipoReporte().setEnabled(false);
            }
        }
    }

    private void MostrarUnidad() {
        AvanzeUnidadesMDA unidadSeleccionada = this.SeleccionarUnidadAvance();
        this.avanceSi.getTxrContenidos().setText(unidadSeleccionada.getUnidad().getContenidosUnidad());
        this.avanceSi.getTxrObservaciones().setText(unidadSeleccionada.getObservaciones());
        this.avanceSi.getSpnCumplimiento().setValue(unidadSeleccionada.getPortecentaje());
        this.avanceSi.getTxtConclusionGuia().setText(unidadSeleccionada.getConclusion());
    }

    private AvanzeUnidadesMDA SeleccionarUnidadAvance() {
        Optional<AvanzeUnidadesMDA> unidad_avanSelecc = this.lista_avanUnidades.stream().filter(uas -> uas.getUnidad().getTituloUnidad().equals(this.avanceSi.getCbxUnidad().getSelectedItem().toString())).findFirst();
        return unidad_avanSelecc.get();
    }

    private boolean guardar_SeguimientoSilabo() {
        boolean valid = true;
        boolean esInterciclo = true;
        try {
            if (this.avanceSi.getCbxTipoReporte().getSelectedItem().equals("Fin de ciclo")) {
                this.seguimientoSilaboMD = new SeguimientoSilaboMD(this.curso);
                this.seguimientoSilaboMD.getCurso().setId(this.curso.getId());
                this.seguimientoSilaboMD.setFecha_entrega_informe(this.avanceSi.getDchFechaEntrega().getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                if (this.avanceSi.getCbxTipoReporte().getSelectedItem().equals("Fin de ciclo")) {
                    esInterciclo = false;
                }
                this.seguimientoSilaboMD.setEsInterciclo(esInterciclo);
                if (new SeguimientoSilaboBD().insertarSeguimiento(this.seguimientoSilaboMD)) {
                    this.insertarAvanceUnidades();
                    valid = true;
                }
            } else if (this.avanceSi.getCbxTipoReporte().getSelectedItem().equals("Fin de Ciclo")) {
                new SeguimientoSilaboBD().eliminarSeguimientoSilabo(this.seguimientoS);
                this.seguimientoSilaboMD = new SeguimientoSilaboMD(this.curso);
                this.seguimientoSilaboMD.getCurso().setId(this.curso.getId());
                this.seguimientoSilaboMD.setFecha_entrega_informe(this.avanceSi.getDchFechaEntrega().getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                if (this.avanceSi.getCbxTipoReporte().getSelectedItem().equals("Fin de Ciclo")) {
                    esInterciclo = false;
                }
                this.seguimientoSilaboMD.setEsInterciclo(esInterciclo);
                if (new SeguimientoSilaboBD().insertarSeguimiento(this.seguimientoSilaboMD)) {
                    this.insertarAvanceUnidades();
                    valid = true;
                }
            } else {
                new SeguimientoSilaboBD().eliminarSeguimientoSilabo(this.seguimientoS);
                this.seguimientoSilaboMD = new SeguimientoSilaboMD(this.curso);
                this.seguimientoSilaboMD.getCurso().setId(this.curso.getId());
                this.seguimientoSilaboMD.setFecha_entrega_informe(this.avanceSi.getDchFechaEntrega().getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                if (this.avanceSi.getCbxTipoReporte().getSelectedItem().equals("Interciclo")) {
                    esInterciclo = true;
                }
                this.seguimientoSilaboMD.setEsInterciclo(esInterciclo);
                if (new SeguimientoSilaboBD().insertarSeguimiento(this.seguimientoSilaboMD)) {
                    this.insertarAvanceUnidades();
                    valid = true;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Fallo al guardar ULTIMO");
        }
        return valid;
    }

    private void insertarAvanceUnidades() {
        this.seguimientoSilaboMD = SeguimientoSilaboBD.consultarUltimoSegumiento(this.curso.getId(), this.seguimientoSilaboMD.isEsInterciclo());
        this.seguimientoSilaboMD.setId_seguimientoS(this.seguimientoSilaboMD.getId_seguimientoS());
        for (AvanzeUnidadesMDA avanceU : this.lista_avanUnidades) {
            avanceU.getSeguimiento().setId_seguimientoS(this.seguimientoSilaboMD.getId_seguimientoS());
            AvanzeUnidadesBDA aus = new AvanzeUnidadesBDA();
            aus.insertarAvanzeUnidades(avanceU, avanceU.getSeguimiento().getId_seguimientoS());
        }
    }

    private void ejecutar(ActionEvent e) {
        if (this.accion) {
            new Thread(() -> {
                this.accion = false;
                if (this.validarCampos()) {
                    boolean aux = false;
                    this.avanceSi.getBtnCancelar().setEnabled(false);
                    this.avanceSi.getBntGuardar().setEnabled(false);
                    this.vtnPrincipal.getLblEstado().setText("                                  Guardando su Seguimiento de S\u00edlabo! Espere por favor...........");
                    try {
                        Thread.sleep(400L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FrmEditarAvanceSilaboCTR.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    aux = this.guardar_SeguimientoSilabo();
                    if (aux) {
                        JOptionPane.showMessageDialog(this.avanceSi, "Se guard\u00f3 correctamente!");
                        this.avanceSi.dispose();
                        this.vtnPrincipal.getMnCAvanceSilabo().doClick();
                    } else {
                        JOptionPane.showMessageDialog(null, "Fall\u00f3 al guardar! Intente de nuevo! ", "Aviso", 0);
                        this.avanceSi.getBtnCancelar().setEnabled(true);
                        this.avanceSi.getBntGuardar().setEnabled(true);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "     REVISE INFORMACION INCOMPLETA\nY/O REPORTE YA EXISTENTE O APROBADO", "Aviso", 0);
                }
                this.vtnPrincipal.getLblEstado().setText("");
                this.accion = true;
            }).start();
        }
    }

    private boolean validarCampos() {
        boolean valid = true;
        if (this.avanceSi.getCbxTipoReporte().getSelectedItem().equals("Reporte Correspondiente a") || this.avanceSi.getDchFechaEntrega().getDate() == null) {
            valid = false;
        }
        for (int i = 0; i < this.lista_avanUnidades.size(); ++i) {
            if (this.lista_avanUnidades.get(i).getObservaciones() != null) continue;
            valid = false;
        }
        if (this.avanceSi.getCbxTipoReporte().getSelectedIndex() == 2) {
            this.count = SeguimientoSilaboBD.consultarSeguimientoEsInterciclo(this.curso.getId());
            for (SeguimientoSilaboMD ss : this.count) {
                this.seguimientoSilaboMD = new SeguimientoSilaboMD();
                boolean esInterciclo = true;
                if (this.avanceSi.getCbxTipoReporte().getSelectedItem().equals("Fin de ciclo")) {
                    esInterciclo = false;
                }
                this.seguimientoSilaboMD.setEsInterciclo(esInterciclo);
                if (ss.isEsInterciclo() != this.seguimientoSilaboMD.isEsInterciclo()) continue;
                valid = false;
            }
        }
        if (this.avanceSi.getCbxTipoReporte().getSelectedIndex() == 1) {
            this.count = SeguimientoSilaboBD.consultarSeguimientoAprobacion(this.seguimientoS.getId_seguimientoS(), this.curso.getId());
            for (SeguimientoSilaboMD ss : this.count) {
                if (ss.getEstado_seguimiento() != 1) continue;
                valid = false;
            }
        }
        if (this.avanceSi.getCbxTipoReporte().getSelectedItem().equals("Fin de Ciclo")) {
            this.count = SeguimientoSilaboBD.consultarSeguimientoAprobacion(this.seguimientoS.getId_seguimientoS(), this.curso.getId());
            for (SeguimientoSilaboMD ss : this.count) {
                if (ss.getEstado_seguimiento() != 1) continue;
                valid = false;
            }
        }
        return valid;
    }
}

