/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.avance;

import controlador.silabo.avance.controlador_avance_ingreso;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import modelo.AvanceSilabo.SeguimientoSilaboBD;
import modelo.AvanceSilabo.SeguimientoSilaboMD;
import modelo.carrera.CarreraMD;
import modelo.curso.CursoMD;
import modelo.materia.MateriaMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.silabo.CarrerasBDS;
import modelo.silabo.CursosBDS;
import modelo.silabo.MateriasBDS;
import modelo.silabo.PeriodoLectivoBDS;
import modelo.silabo.SilaboBD;
import modelo.silabo.SilaboMD;
import modelo.usuario.UsuarioBD;
import vista.principal.VtnPrincipal;
import vista.silabos.frmConfiguracionSeguimientoSilabo;

public class ControladorConfiguracionAvanceSilabo {
    private int id_silabo = -1;
    private final UsuarioBD usuario;
    private List<CarreraMD> carreras_docente;
    private List<SilaboMD> silabosDocente;
    private frmConfiguracionSeguimientoSilabo avance;
    private List<CursoMD> cursoSilabo;
    private int id_periodo_lectivo = -1;
    private List<PeriodoLectivoMD> periodosCarrera;
    private final VtnPrincipal vtnPrincipal;
    private List<MateriaMD> materias_Silabos;
    private List<SeguimientoSilaboMD> count;

    public ControladorConfiguracionAvanceSilabo(UsuarioBD usuario, VtnPrincipal vtnPrincipal) {
        this.usuario = usuario;
        this.vtnPrincipal = vtnPrincipal;
    }

    public void init() {
        this.avance = new frmConfiguracionSeguimientoSilabo();
        this.vtnPrincipal.getDpnlPrincipal().add(this.avance);
        this.avance.setTitle("CREAR UN AVANCE DE SILABO");
        this.avance.show();
        this.avance.setLocation((this.vtnPrincipal.getDpnlPrincipal().getSize().width - this.avance.getSize().width) / 2, (this.vtnPrincipal.getDpnlPrincipal().getSize().height - this.avance.getSize().height) / 2);
        this.avance.getBtnCancelar().addActionListener(e -> {
            this.avance.dispose();
            this.vtnPrincipal.getMnCAvanceSilabo().doClick();
        });
        this.avance.getBtnSiguiente().addActionListener(a1 -> {
            if (this.validarSeguiSilaboExistente()) {
                this.avance.dispose();
                controlador_avance_ingreso cas = new controlador_avance_ingreso(this.vtnPrincipal, this.cursos_seleccionado(), this.silabo_seleccionado());
                cas.init();
                this.avance.dispose();
            } else {
                JOptionPane.showMessageDialog(null, "YA EXISTE EL SEGUIMIENTO DE SILABO DE ESTE CURSO", "Aviso", 0);
            }
        });
        this.avance.getCbxCarrera().addActionListener(a -> this.clickCmbCarreras());
        this.avance.getCbxSilabos().addActionListener(a -> this.clickCmbSilabos());
        this.avance.getCmb_perido().addActionListener(a -> this.clickComboPeriodos());
        this.estadoCmb_silbo(false);
        this.estadoCmb_cursoUnidDES(false);
        this.CARGAR_COMBO_CARRERAS();
    }

    private void CARGAR_COMBO_CARRERAS() {
        this.avance.getCbxCarrera().removeAllItems();
        this.carreras_docente = CarrerasBDS.consultar(this.usuario.getUsername());
        if (this.carreras_docente == null) {
            JOptionPane.showMessageDialog(null, "No tiene carreras asignadas");
        } else {
            this.avance.getCbxCarrera().addItem("SELECCIONE UNA CARRERA!");
            this.carreras_docente.forEach(cmd -> this.avance.getCbxCarrera().addItem(cmd.getNombre()));
        }
    }

    private void LLENAR_COMBO_SILABOS(List<MateriaMD> materias) {
        this.avance.getCbxSilabos().removeAllItems();
        if (materias != null) {
            this.avance.getCbxSilabos().addItem("SELECCIONE UN SILABO!");
            this.materias_Silabos.forEach(m -> this.avance.getCbxSilabos().addItem(m.getNombre()));
            this.avance.getCbxSilabos().setSelectedIndex(0);
        }
    }

    private void LLENA_COMBO_PERIODOS_CARRERA(List<PeriodoLectivoMD> periodos) {
        this.avance.getCmb_perido().removeAllItems();
        if (periodos != null) {
            this.avance.getCmb_perido().addItem("SELECCIONE SU PERIODO ACTUAL!");
            periodos.forEach(pl -> this.avance.getCmb_perido().addItem(pl.getNombre()));
            this.avance.getCmb_perido().setSelectedIndex(0);
        }
    }

    private void LLENAR_COMBO_CURSOS(List<CursoMD> cursos) {
        this.avance.getCbxCurso().removeAllItems();
        if (cursos != null) {
            cursos.forEach(cs -> this.avance.getCbxCurso().addItem(String.valueOf(cs.getNombre())));
        }
    }

    private void clickCmbCarreras() {
        int posC = this.avance.getCbxCarrera().getSelectedIndex();
        if (posC > 0) {
            this.estado_comboPeriodos(true);
            String carrera = this.carreras_docente.get(posC - 1).getNombre();
            this.periodosCarrera = PeriodoLectivoBDS.single().consultarPeriodos(carrera);
            this.LLENA_COMBO_PERIODOS_CARRERA(this.periodosCarrera);
        } else {
            this.estado_comboPeriodos(false);
        }
    }

    private void clickCmbSilabos() {
        int posC = this.avance.getCbxCarrera().getSelectedIndex();
        int posS = this.avance.getCbxSilabos().getSelectedIndex();
        if (posS > 0) {
            this.estadoCmb_cursoUnidDES(true);
            String materia_silabo = this.materias_Silabos.get(posS - 1).getNombre();
            this.cursoSilabo = CursosBDS.Consultarcursos(this.usuario.getPersona().getIdPersona(), this.getid_periodo(), materia_silabo);
            this.LLENAR_COMBO_CURSOS(this.cursoSilabo);
            if (this.avance.getCbxCurso().getItemCount() != 0) {
                this.avance.getBtnSiguiente().setEnabled(true);
            } else {
                JOptionPane.showMessageDialog(null, "NO PUEDE REALIZAR UN SEGUIMIENTO DE SILABO DE ESTA MATERIA", "Aviso", 0);
                this.avance.getBtnSiguiente().setEnabled(false);
            }
        } else {
            this.clickComboPeriodos();
            this.estadoCmb_cursoUnidDES(false);
            this.avance.getBtnSiguiente().setEnabled(false);
        }
    }

    private void clickComboPeriodos() {
        int posC = this.avance.getCbxCarrera().getSelectedIndex();
        int posP = this.avance.getCmb_perido().getSelectedIndex();
        if (posP > 0 && posC > 0) {
            this.estadoCmb_silbo(true);
            String carrera = this.carreras_docente.get(posC - 1).getNombre();
            String nombre_periodo = this.periodosCarrera.get(posP - 1).getNombre();
            this.materias_Silabos = MateriasBDS.consultarSilabo2(carrera, this.usuario.getPersona().getIdPersona(), nombre_periodo);
            this.LLENAR_COMBO_SILABOS(this.materias_Silabos);
        } else {
            this.clickCmbCarreras();
            this.estadoCmb_silbo(false);
        }
    }

    private void estadoCmb_silbo(boolean estado) {
        this.avance.getCbxSilabos().setEnabled(estado);
        this.avance.getCbxSilabos().removeAllItems();
    }

    private void estadoCmb_cursoUnidDES(boolean estado) {
        this.avance.getCbxCurso().setEnabled(estado);
        this.avance.getCbxCurso().removeAllItems();
        this.avance.getCbxCurso().setEnabled(estado);
        this.avance.getCbxCurso().removeAllItems();
    }

    private int getIdSilabo() {
        String silabo = this.avance.getCbxSilabos().getSelectedItem().toString();
        this.silabosDocente = this.cargar_silabo();
        this.silabosDocente.stream().filter(item -> item.getMateria().getNombre().equals(silabo)).collect(Collectors.toList()).forEach(obj -> {
            this.id_silabo = obj.getID();
        });
        return this.id_silabo;
    }

    public List<SilaboMD> cargar_silabo() {
        String[] parametros = new String[]{this.avance.getCbxCarrera().getSelectedItem().toString(), String.valueOf(this.usuario.getPersona().getIdPersona()), this.avance.getCmb_perido().getSelectedItem().toString()};
        List<SilaboMD> silabosdocente = SilaboBD.consultarSilabo1(parametros);
        return silabosdocente;
    }

    private void estado_comboPeriodos(boolean estado) {
        this.avance.getCmb_perido().setEnabled(estado);
        this.avance.getCmb_perido().removeAllItems();
    }

    private List<PeriodoLectivoMD> cargarPeriodos() {
        List<PeriodoLectivoMD> periodos = PeriodoLectivoBDS.single().consultarPeriodos(this.avance.getCbxCarrera().getSelectedItem().toString());
        return periodos;
    }

    private int getid_periodo() {
        String nombre_periodo = this.avance.getCmb_perido().getSelectedItem().toString();
        this.periodosCarrera = this.cargarPeriodos();
        this.periodosCarrera.stream().filter(item -> item.getNombre().equals(nombre_periodo)).collect(Collectors.toList()).forEach(obj -> {
            this.id_periodo_lectivo = obj.getID();
        });
        return this.id_periodo_lectivo;
    }

    private SilaboMD silabo_seleccionado() {
        this.silabosDocente = this.cargar_silabo();
        Optional<SilaboMD> silaboSeleccionado = this.silabosDocente.stream().filter(s -> s.getMateria().getNombre().equals(this.avance.getCbxSilabos().getSelectedItem().toString())).findFirst();
        return silaboSeleccionado.get();
    }

    private CursoMD cursos_seleccionado() {
        Optional<CursoMD> cursoSeleccionado = this.cursoSilabo.stream().filter(s -> s.getNombre().equals(this.avance.getCbxCurso().getSelectedItem().toString())).findFirst();
        return cursoSeleccionado.get();
    }

    private boolean validarSeguiSilaboExistente() {
        boolean valid = true;
        this.count = SeguimientoSilaboBD.consultarSeguimientoExistentes2(this.cursos_seleccionado().getId());
        for (SeguimientoSilaboMD ss : this.count) {
            if (ss.getCurso().getId() != this.cursos_seleccionado().getId()) continue;
            valid = false;
        }
        return valid;
    }
}

