/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo.avance;

import controlador.Libraries.Middlewares;
import controlador.silabo.avance.ControladorConfiguracionAvanceSilabo;
import controlador.silabo.avance.FrmEditarAvanceSilaboCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.AvanceSilabo.SeguimientoSilaboBD;
import modelo.AvanceSilabo.SeguimientoSilaboMD;
import modelo.PlanClases.JornadasDB;
import modelo.carrera.CarreraMD;
import modelo.curso.CursoMD;
import modelo.jornada.JornadaMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.silabo.CarrerasBDS;
import modelo.silabo.CursosBDS;
import modelo.silabo.PeriodoLectivoBDS;
import modelo.usuario.RolBD;
import modelo.usuario.UsuarioBD;
import vista.principal.VtnPrincipal;
import vista.silabos.frmCRUDAvanceSilabo;

public class ControladorCRUDAvanceSilabo {
    private final UsuarioBD usuario;
    private boolean esCordinador = false;
    private List<CarreraMD> carreras_docente;
    private frmCRUDAvanceSilabo seguimiento;
    private VtnPrincipal vtnPrincipal;
    private int id_periodo_lectivo = -1;
    private List<CursoMD> lista_curso;
    private RolBD rol;
    private List<SeguimientoSilaboMD> lista_seguimiento;
    private List<JornadaMD> lista_jornadas;
    private List<PeriodoLectivoMD> periodosCarrera;
    private SeguimientoSilaboMD segui;

    public ControladorCRUDAvanceSilabo(UsuarioBD usuario, RolBD rol, VtnPrincipal vtnPrincipal) {
        this.usuario = usuario;
        this.vtnPrincipal = vtnPrincipal;
        this.rol = rol;
    }

    public void initCrud() {
        this.seguimiento = new frmCRUDAvanceSilabo();
        if (this.rol.getNombre().equalsIgnoreCase("COORDINADOR")) {
            this.seguimiento.getTlbAvanceSilabo().removeColumn(this.seguimiento.getTlbAvanceSilabo().getColumnModel().getColumn(4));
        } else {
            this.seguimiento.getTlbAvanceSilabo().removeColumn(this.seguimiento.getTlbAvanceSilabo().getColumnModel().getColumn(5));
        }
        if (this.rol.getNombre().equalsIgnoreCase("COORDINADOR")) {
            this.esCordinador = true;
            this.seguimiento.getBtnEditar().setEnabled(false);
            this.seguimiento.getBtnNuevo().setEnabled(false);
            this.seguimiento.getBtnEliminar().setEnabled(false);
        }
        this.vtnPrincipal.getDpnlPrincipal().add(this.seguimiento);
        this.seguimiento.setTitle("Avances de S\u00edlabos");
        this.seguimiento.show();
        this.seguimiento.setLocation((this.vtnPrincipal.getDpnlPrincipal().getSize().width - this.seguimiento.getSize().width) / 2, (this.vtnPrincipal.getDpnlPrincipal().getSize().height - this.seguimiento.getSize().height) / 2);
        this.seguimiento.getBtnNuevo().addActionListener(e -> this.insertar());
        this.seguimiento.getBtnEditar().addActionListener(ae -> {
            int row = this.seguimiento.getTlbAvanceSilabo().getSelectedRow();
            if (row != -1) {
                this.seguimiento.dispose();
                FrmEditarAvanceSilaboCTR ce = new FrmEditarAvanceSilaboCTR(this.usuario, this.seguimientoSilabo(), this.vtnPrincipal, this.curso_selecc());
                ce.init();
            } else {
                JOptionPane.showMessageDialog(null, "Seleccione un avance de silabo", "Aviso", 0);
            }
        });
        this.seguimiento.getTlbAvanceSilabo().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int fila = ControladorCRUDAvanceSilabo.this.seguimiento.getTlbAvanceSilabo().getSelectedRow();
                int columna = ControladorCRUDAvanceSilabo.this.seguimiento.getTlbAvanceSilabo().getSelectedColumn();
                if (ControladorCRUDAvanceSilabo.this.esCordinador && columna == 4) {
                    if (ControladorCRUDAvanceSilabo.this.seguimiento.getTlbAvanceSilabo().getValueAt(fila, columna).equals(true)) {
                        new SeguimientoSilaboBD().aprobarSeguimientoSilabo(Integer.parseInt(ControladorCRUDAvanceSilabo.this.seguimiento.getTlbAvanceSilabo().getValueAt(fila, columna - 4).toString()), 1);
                    } else {
                        new SeguimientoSilaboBD().aprobarSeguimientoSilabo(Integer.parseInt(ControladorCRUDAvanceSilabo.this.seguimiento.getTlbAvanceSilabo().getValueAt(fila, columna - 4).toString()), 0);
                    }
                }
            }
        });
        this.seguimiento.getBtnEliminar().addActionListener(a -> {
            int row = this.seguimiento.getTlbAvanceSilabo().getSelectedRow();
            if (row != -1) {
                this.eliminarSeguimientos();
                this.cargarAvanceSilaboDocentes_Coordinador();
            } else {
                JOptionPane.showMessageDialog(null, "Seleccione un seguimiento de silabo", "Aviso", 0);
            }
        });
        this.CARGAR_COMBO_CARRERAS();
        this.CARGAR_COMBO_PERIODOS_CARRERA();
        this.CARGAR_JORNADAS();
        this.cargarAvanceSilaboDocentes_Coordinador();
        this.seguimiento.getCmb_Carreras().addActionListener(a -> this.cargarAvanceSilaboDocentes_Coordinador());
        this.seguimiento.getCmb_Carreras().addActionListener(a -> this.CARGAR_COMBO_PERIODOS_CARRERA());
        this.seguimiento.getCmbJornadas().addActionListener(a -> this.cargarAvanceSilaboDocentes_Coordinador());
        this.seguimiento.getCmb_periodos().addActionListener(a -> this.cargarAvanceSilaboDocentes_Coordinador());
        this.seguimiento.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ControladorCRUDAvanceSilabo.this.cargarAvanceSilaboDocentes_Coordinador();
                }
            }
        });
        this.seguimiento.getBtn_Imprimir().addActionListener(e -> this.imprimir());
    }

    public void insertar() {
        this.seguimiento.dispose();
        ControladorConfiguracionAvanceSilabo AS = new ControladorConfiguracionAvanceSilabo(this.usuario, this.vtnPrincipal);
        AS.init();
    }

    private void cargarAvanceSilaboDocentes_Coordinador() {
        try {
            DefaultTableModel modelotabla = (DefaultTableModel)this.seguimiento.getTlbAvanceSilabo().getModel();
            String[] parametros = new String[]{this.seguimiento.getCmb_Carreras().getSelectedItem().toString(), this.seguimiento.getCmbJornadas().getSelectedItem().toString(), this.seguimiento.getTxtBuscar().getText(), String.valueOf(this.usuario.getPersona().getIdPersona()), String.valueOf(this.getid_periodo())};
            if (this.esCordinador) {
                String[] parametros1 = new String[]{this.seguimiento.getCmb_Carreras().getSelectedItem().toString(), this.seguimiento.getCmbJornadas().getSelectedItem().toString(), this.seguimiento.getTxtBuscar().getText(), String.valueOf(this.getid_periodo())};
                this.lista_seguimiento = SeguimientoSilaboBD.consultarSeguimientoSilaboCoordinador(parametros1);
            } else {
                this.lista_seguimiento = SeguimientoSilaboBD.consultarSeguimientoSilaboDocentes(parametros);
            }
            for (int j = this.seguimiento.getTlbAvanceSilabo().getModel().getRowCount() - 1; j >= 0; --j) {
                modelotabla.removeRow(j);
            }
            for (SeguimientoSilaboMD ss : this.lista_seguimiento) {
                String estado = null;
                Boolean estadoB = null;
                String corresponde = null;
                if (ss.getEstado_seguimiento() == 0) {
                    estado = "Por Aprobar";
                    estadoB = false;
                } else {
                    estado = "Aprobado";
                    estadoB = true;
                }
                corresponde = ss.isEsInterciclo() ? "Interciclo" : "Fin de Ciclo";
                modelotabla.addRow(new Object[]{ss.getId_seguimientoS(), ss.getPersona().getPrimerApellido() + " " + ss.getPersona().getPrimerNombre(), ss.getMateria().getNombre(), ss.getCurso().getNombre(), estado, estadoB, ss.getFecha_entrega_informe(), corresponde});
            }
            this.seguimiento.getTlbAvanceSilabo().setModel(modelotabla);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void CARGAR_COMBO_CARRERAS() {
        this.seguimiento.getCmb_Carreras().removeAllItems();
        this.carreras_docente = new ArrayList<CarreraMD>();
        if (this.esCordinador) {
            this.carreras_docente.add(new CarrerasBDS().retornaCarreraCoordinador(this.usuario.getUsername()));
        } else {
            this.carreras_docente = CarrerasBDS.consultar(this.usuario.getUsername());
        }
        this.carreras_docente.forEach(cmd -> this.seguimiento.getCmb_Carreras().addItem(cmd.getNombre()));
        this.seguimiento.getCmb_Carreras().setSelectedIndex(0);
    }

    private void CARGAR_JORNADAS() {
        this.seguimiento.getCmbJornadas().removeAllItems();
        this.lista_jornadas = JornadasDB.consultarJornadas();
        this.lista_jornadas.forEach(lj -> this.seguimiento.getCmbJornadas().addItem(lj.getNombre()));
    }

    private void CARGAR_COMBO_PERIODOS_CARRERA() {
        this.seguimiento.getCmb_periodos().removeAllItems();
        List<PeriodoLectivoMD> periodos = PeriodoLectivoBDS.single().consultarPeriodos(this.seguimiento.getCmb_Carreras().getSelectedItem().toString());
        if (periodos == null) {
            JOptionPane.showMessageDialog(null, "No existen Periodos");
        } else {
            periodos.forEach(prd -> this.seguimiento.getCmb_periodos().addItem(prd.getNombre()));
        }
    }

    private List<PeriodoLectivoMD> cargarPeriodos() {
        List<PeriodoLectivoMD> periodos = PeriodoLectivoBDS.single().consultarPeriodos(this.seguimiento.getCmb_Carreras().getSelectedItem().toString());
        return periodos;
    }

    private int getid_periodo() {
        String nombre_periodo = this.seguimiento.getCmb_periodos().getSelectedItem().toString();
        this.periodosCarrera = this.cargarPeriodos();
        this.periodosCarrera.stream().filter(item -> item.getNombre().equals(nombre_periodo)).collect(Collectors.toList()).forEach(obj -> {
            this.id_periodo_lectivo = obj.getID();
        });
        return this.id_periodo_lectivo;
    }

    private SeguimientoSilaboMD seguimientoSilabo() {
        int seleccion = this.seguimiento.getTlbAvanceSilabo().getSelectedRow();
        this.segui = new SeguimientoSilaboMD();
        this.segui = SeguimientoSilaboBD.consultarIDsegui_IdCurso(Integer.parseInt(this.seguimiento.getTlbAvanceSilabo().getValueAt(seleccion, 0).toString()));
        return this.segui;
    }

    private CursoMD curso_selecc() {
        int seleccion = this.seguimiento.getTlbAvanceSilabo().getSelectedRow();
        this.lista_curso = CursosBDS.Consultarcursos(this.usuario.getPersona().getIdPersona(), this.getid_periodo(), this.seguimiento.getTlbAvanceSilabo().getValueAt(seleccion, 2).toString());
        Optional<CursoMD> curso_selecccionado = this.lista_curso.stream().filter(lc -> lc.getNombre().equals(this.seguimiento.getTlbAvanceSilabo().getValueAt(seleccion, 3).toString())).findFirst();
        return curso_selecccionado.get();
    }

    private void eliminarSeguimientos() {
        int reply = JOptionPane.showConfirmDialog(null, "\u00bfEst\u00e1 seguro que desea eliminar este seguimiento de silabo?", "Eliminar", 0);
        if (reply == 0) {
            new SeguimientoSilaboBD().eliminarSeguimientoSilabo(this.seguimientoSilabo());
            JOptionPane.showMessageDialog(null, "Seguimiento de silabo eliminado correctamente");
        }
    }

    public void imprimir() {
        int seleccion = this.seguimiento.getTlbAvanceSilabo().getSelectedRow();
        if (seleccion >= 0) {
            CarreraMD ca = new CarrerasBDS().retornaModalidad(this.seguimientoSilabo().getCurso().getId());
            String corresponde = !this.seguimientoSilabo().isEsInterciclo() ? "Final de ciclo" : "Interciclo";
            HashMap<String, String> parametro = new HashMap<String, String>();
            parametro.put("id_curso", String.valueOf(this.seguimientoSilabo().getCurso().getId()));
            parametro.put("id_seguimiento", String.valueOf(this.seguimientoSilabo().getId_seguimientoS()));
            parametro.put("corresponde", corresponde);
            Middlewares.generarReporte(this.getClass().getResource("/vista/silabos/reportes/avance_de_silabo_inter_2023/avance_principal.jasper"), "Avance de silabo " + corresponde, parametro);
        } else {
            JOptionPane.showMessageDialog(null, "DEBE SELECIONAR EL DOCUMENTO PARA IMPRIMIR");
        }
    }

    public void imprimir_anterior() {
        int seleccion = this.seguimiento.getTlbAvanceSilabo().getSelectedRow();
        if (seleccion >= 0) {
            CarreraMD ca = new CarrerasBDS().retornaModalidad(this.seguimientoSilabo().getCurso().getId());
            if (ca.getModalidad().equalsIgnoreCase("PRESENCIAL") || ca.getModalidad().equalsIgnoreCase("H\u00cdBRIDA")) {
                if (!this.seguimientoSilabo().isEsInterciclo()) {
                    HashMap<String, String> parametro = new HashMap<String, String>();
                    parametro.put("id_curso", String.valueOf(this.seguimientoSilabo().getCurso().getId()));
                    parametro.put("id_seguimiento", String.valueOf(this.seguimientoSilabo().getId_seguimientoS()));
                    Middlewares.generarReporte(this.getClass().getResource("/vista/silabos/reportes/avance_silabo_fin/avance_principal.jasper"), "Avance de silabo (fin de ciclo)", parametro);
                } else {
                    HashMap<String, String> parametro = new HashMap<String, String>();
                    parametro.put("id_curso", String.valueOf(this.seguimientoSilabo().getCurso().getId()));
                    parametro.put("id_seguimiento", String.valueOf(this.seguimientoSilabo().getId_seguimientoS()));
                    Middlewares.generarReporte(this.getClass().getResource("/vista/silabos/reportes/avance_de_silabo/avance_principal.jasper"), "Avance de silabo(interciclo)", parametro);
                }
            } else if (ca.getModalidad().equalsIgnoreCase("DUAL")) {
                if (!this.seguimientoSilabo().isEsInterciclo()) {
                    HashMap<String, String> parametro = new HashMap<String, String>();
                    parametro.put("id_curso", String.valueOf(this.seguimientoSilabo().getCurso().getId()));
                    parametro.put("id_seguimiento", String.valueOf(this.seguimientoSilabo().getId_seguimientoS()));
                    Middlewares.generarReporte(this.getClass().getResource("/vista/silabos/reportes/avance_silabo_fin/avance_principal.jasper"), "Avance de silabo (fin de ciclo)", parametro);
                } else {
                    HashMap<String, String> parametro = new HashMap<String, String>();
                    parametro.put("id_curso", String.valueOf(this.seguimientoSilabo().getCurso().getId()));
                    parametro.put("id_seguimiento", String.valueOf(this.seguimientoSilabo().getId_seguimientoS()));
                    Middlewares.generarReporte(this.getClass().getResource("/vista/silabos/reportes/avance_silabo_inter_dual/avance_principal.jasper"), "Avance de silabo(interciclo)", parametro);
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "DEBE SELECIONAR EL DOCUMENTO PARA IMPRIMIR");
        }
    }
}

