/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo;

import controlador.Libraries.Effects;
import controlador.Libraries.abstracts.AbstractVTN;
import controlador.Libraries.cellEditor.ComboBoxCellEditor;
import controlador.principal.VtnPrincipalCTR;
import controlador.silabo.VtnConfigSilaboCTR;
import controlador.silabo.frm.FRMSilaboCTR;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.silabo.NEWPeriodoLectivoBD;
import modelo.silabo.NEWSilaboBD;
import modelo.silabo.SilaboMD;
import modelo.validaciones.Validar;
import utils.CONS;
import vista.silabos.VtnSilabos;

public class VtnSilabosCTR
extends AbstractVTN<VtnSilabos, SilaboMD> {
    private final NEWSilaboBD SILABO_CONN = NEWSilaboBD.single();
    private List<PeriodoLectivoMD> periodos;

    public VtnSilabosCTR(VtnPrincipalCTR desktop) {
        super(desktop);
        this.vista = new VtnSilabos();
        this.modelo = new SilaboMD();
    }

    @Override
    public void Init() {
        this.setTable(((VtnSilabos)this.vista).getTbl());
        this.getPeriodos();
        CONS.refreshPermisos();
        ((VtnSilabos)this.vista).getChxPeriodos().setVisible(CONS.ROL.getNombre().equals("COORDINADOR"));
        try {
            this.cargarCmbPeriodo();
            this.setLista();
            this.cargarTabla(this.cargador());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.InitEventos();
        super.Init();
    }

    private void InitEventos() {
        ((VtnSilabos)this.vista).getBtnNuevo().addActionListener(this::btnNuevo);
        ((VtnSilabos)this.vista).getBtnEditar().addActionListener(this::btnEditar);
        ((VtnSilabos)this.vista).getBtnEliminar().addActionListener(this::btnEliminar);
        ((VtnSilabos)this.vista).getCmbPeriodo().addActionListener(this::cmbPeriodo);
        ((VtnSilabos)this.vista).getBtnImprimir().addActionListener(this::btnImprimir);
        ((VtnSilabos)this.vista).getTxtBuscar().addCaretListener(this::txtBuscar);
        ((VtnSilabos)this.vista).getBtnInformacion().addActionListener(this::btnInformacion);
        ((VtnSilabos)this.vista).getBtnRefresh().addActionListener(this::btnRefresh);
        ((VtnSilabos)this.vista).getChxPeriodos().addActionListener(this::chxPeriodos);
        this.tableM.addTableModelListener(new TableModelListener(){
            boolean active = false;

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!this.active && e.getType() == 0) {
                    this.active = true;
                    VtnSilabosCTR.this.cmbTblEstado();
                    this.active = false;
                }
            }
        });
        boolean estado = CONS.ROL.getNombre().equalsIgnoreCase("COORDINADOR") || CONS.ROL.getNombre().equalsIgnoreCase("DEV") || CONS.USUARIO.isIsSuperUser();
        ((VtnSilabos)this.vista).getTbl().getColumnModel().getColumn(5).setCellEditor(new ComboBoxCellEditor(estado, Arrays.asList("APROBADO", "PENDIENTE", "REVISAR")));
    }

    private void cargarCmbPeriodo() {
        ((VtnSilabos)this.vista).getCmbPeriodo().removeAllItems();
        this.periodos.stream().map(c -> c.getNombre()).forEach(((VtnSilabos)this.vista).getCmbPeriodo()::addItem);
    }

    private PeriodoLectivoMD getPeriodoCmb() {
        return this.periodos.stream().filter(item -> item.getNombre().equalsIgnoreCase(((VtnSilabos)this.vista).getCmbPeriodo().getSelectedItem().toString())).findFirst().get();
    }

    private void getPeriodos() {
        if (CONS.ROL.getNombre().equalsIgnoreCase("DOCENTE")) {
            this.periodos = NEWPeriodoLectivoBD.getMisPeriodosBy(CONS.USUARIO.getPersona().getIdPersona());
            ((VtnSilabos)this.vista).getBtnEliminar().setEnabled(false);
        } else if (CONS.ROL.getNombre().equalsIgnoreCase("COORDINADOR")) {
            this.periodos = NEWPeriodoLectivoBD.getPeriodosCoordinador(CONS.USUARIO.getPersona().getIdPersona());
        }
    }

    private Consumer<SilaboMD> cargador() {
        return obj -> {
            String fechaGeneracion = "SIN FECHA";
            if (obj.getFechaGeneracion() != null) {
                fechaGeneracion = obj.getFechaGeneracion().toString();
            }
            this.tableM.addRow(new Object[]{obj.getID(), this.tableM.getRowCount() + 1, obj.getMateria().getNombre(), obj.getPeriodo().getNombre(), fechaGeneracion, SilaboMD.getEstadoStr(obj.getEstado())});
        };
    }

    private SilaboMD getSilaboSeleccionadoTbl() {
        int row = this.getSelectedRow();
        if (row != -1) {
            int id = Integer.valueOf(this.table.getValueAt(row, 0).toString());
            return this.lista.stream().filter(item -> item.getID() == id).findFirst().get();
        }
        return null;
    }

    private void imprimirSilabosDuales(SilaboMD silabo) {
        Object[] opciones = new Object[]{"Silabo Dual", "Silabo Dual / Focalizada", "Silabo Dual /semanas"};
        int opcion = JOptionPane.showOptionDialog(this.vista, "GENERAR SILABO", "QUE TIPO DE SILABO DESEA GENERAR?", 1, 1, null, opciones, "Cancelar");
        switch (opcion) {
            case 0: {
                NEWSilaboBD.imprimirProgramaAnalitico(silabo);
                break;
            }
            case 1: {
                NEWSilaboBD.imprimirProgramaFocalizada(silabo);
                break;
            }
            case 2: {
                String semanas = JOptionPane.showInputDialog("Escriba el numero de semanas");
                if (semanas == null) break;
                if (Validar.esNumeros(semanas)) {
                    int numSemanas = Integer.parseInt(semanas);
                    if (numSemanas >= 6) {
                        NEWSilaboBD.imprimirProgramaAnaliticoConSemanas(silabo, numSemanas);
                        break;
                    }
                    JOptionPane.showMessageDialog(this.vista, "Debe indicar mas de seis semanas de clases por periodo ");
                    break;
                }
                JOptionPane.showMessageDialog(this.vista, "Solo puede ingresar numeros.");
            }
        }
    }

    private void setLista() {
        try {
            PeriodoLectivoMD periodo = this.periodos.get(((VtnSilabos)this.vista).getCmbPeriodo().getSelectedIndex());
            this.lista = CONS.ROL.getNombre().equalsIgnoreCase("DOCENTE") && !((VtnSilabos)this.vista).getChxPeriodos().isSelected() ? NEWSilaboBD.findBy(this.user.getPersona().getIdentificacion(), periodo.getID()) : (CONS.ROL.getNombre().equalsIgnoreCase("COORDINADOR") ? NEWSilaboBD.getSilabosPeriodo(this.getPeriodoCmb().getID()) : (CONS.USUARIO.isIsSuperUser() ? NEWSilaboBD.getSilabosPeriodo(periodo.getID()) : NEWSilaboBD.getSilabosPeriodo(this.getPeriodoCmb().getID())));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void mensajeEditando() {
        JOptionPane.showMessageDialog(this.vista, "EL SILABO NO ESTA DISPOBIBLE ACTUALMENTE\n\n" + ((SilaboMD)this.modelo).getEditadoPor().getIdentificacion() + " " + ((SilaboMD)this.modelo).getEditadoPor().getPrimerApellido() + " " + ((SilaboMD)this.modelo).getEditadoPor().getPrimerNombre() + " \n\nESTA TRABAJANDO EN EL SILABO", "ALERTA!!", 2);
    }

    private void validarEstadoParaEditar(SilaboMD silabo) {
        if (silabo.getEstado() == SilaboMD.APROBADO) {
            JOptionPane.showMessageDialog(this.vista, "NO PUEDE EDITAR UN SILABO APROBADO", "ALERTA!!", 1);
        } else {
            FRMSilaboCTR ctr = new FRMSilaboCTR(this.desktop, silabo);
            ctr.editar();
        }
    }

    private void btnImprimir(ActionEvent e) {
        new Thread(() -> {
            Effects.setLoadCursor(this.vista);
            ((VtnSilabos)this.vista).getLblEstado().setVisible(true);
            ((VtnSilabos)this.vista).getLblEstado().setText("SE ESTA IMPRIMIENTO EL SILABO ESPERE POR FAVOR");
            ((VtnSilabos)this.vista).getBtnImprimir().setEnabled(false);
            int row = ((VtnSilabos)this.vista).getTbl().getSelectedRow();
            if (row == -1) {
                JOptionPane.showMessageDialog(this.vista, "DEBE SELECCIONAR UN SILABO PRIMERO!!", "Aviso", 0);
            } else {
                SilaboMD silabo = this.getSilaboSeleccionadoTbl();
                if (silabo != null) {
                    String modalidad = silabo.getPeriodo().getCarrera().getModalidad();
                    String codigoCarrera = silabo.getPeriodo().getCarrera().getCodigo();
                    boolean verificacion = NEWSilaboBD.validarHorasSilaboMateria(silabo.getID());
                    if (!verificacion) {
                        JOptionPane.showMessageDialog(null, "SU SILABO NO CUMPLE CON LA HORAS NECESARIAS ESTABLECIDAS EN LA MATERIA\n POR FAVOR REVISELO");
                    } else if (modalidad.equalsIgnoreCase("PRESENCIAL") || modalidad.equalsIgnoreCase("TRADICIONAL") || modalidad.equalsIgnoreCase("H\u00cdBRIDA")) {
                        NEWSilaboBD.imprimirSilabo(silabo, modalidad, silabo.getPeriodo().getCarrera().getNumSemanas(), codigoCarrera);
                    } else {
                        String semanas = JOptionPane.showInputDialog("Escriba el numero de semanas");
                        NEWSilaboBD.imprimirSilabo(silabo, modalidad, Integer.parseInt(semanas), codigoCarrera);
                    }
                }
            }
            ((VtnSilabos)this.vista).getBtnImprimir().setEnabled(true);
            ((VtnSilabos)this.vista).getLblEstado().setText("");
            Effects.setDefaultCursor(this.vista);
        }).start();
    }

    private void btnNuevo(ActionEvent e) {
        VtnConfigSilaboCTR vtn = new VtnConfigSilaboCTR(this.desktop);
        vtn.Init();
        vtn.setVtnSilabos(this);
    }

    private void btnEditar(ActionEvent e) {
        SilaboMD silabo = this.getSilaboSeleccionadoTbl();
        if (silabo != null) {
            silabo = this.SILABO_CONN.getSilaboById(Integer.valueOf(this.table.getValueAt(this.table.getSelectedRow(), 0).toString()));
            this.validarEstadoParaEditar(silabo);
        }
    }

    private void btnEliminar(ActionEvent e) {
        String MENSAJE_ELIMINAR;
        int opcionEliminado;
        SilaboMD silabo = this.getSilaboSeleccionadoTbl();
        if (silabo != null && (opcionEliminado = JOptionPane.showConfirmDialog(this.vista, MENSAJE_ELIMINAR = String.format("ESTA SEGURO DE ELIMINAR EL SILABO:\nPERIODO LECTIVO:\nMATERIA:%s\nRECUERDE QUE SI ELIMINA EL SILABO SE LE BORRARA:\nSUS AVANCES DE SILABO Y PLANES DE CLASE", silabo.getPeriodo().getNombre(), silabo.getMateria().getNombre()), "ESTA SEGURO?", 0)) == 0) {
            boolean estado = NEWSilaboBD.eliminar(silabo);
            if (estado) {
                JOptionPane.showMessageDialog(this.vista, "SE HA ELIMINADO CORRECTAMENTE");
            } else {
                JOptionPane.showMessageDialog(this.vista, "HA HABIDO UN PROBLEMA");
            }
        }
        this.btnRefresh(e);
    }

    private void cmbPeriodo(ActionEvent e) {
        this.setLista();
        this.cargarTabla(this.cargador());
    }

    private void txtBuscar(CaretEvent e) {
        this.tableM.setRowCount(0);
        String buscar = ((VtnSilabos)this.vista).getTxtBuscar().getText().toLowerCase();
        this.lista.stream().filter(item -> item.getMateria().getNombre().toLowerCase().contains(buscar)).forEach(this.cargador());
    }

    private void cmbTblEstado() {
        int colum = this.table.getSelectedColumn();
        int row = this.getSelectedRow();
        SilaboMD silabo = this.getSilaboSeleccionadoTbl();
        if (silabo != null) {
            String estado = this.table.getValueAt(row, colum).toString();
            if (silabo.getEstado() != SilaboMD.getEstadoInt(estado).intValue()) {
                silabo.setEstado(SilaboMD.getEstadoInt(estado));
                this.cargarTabla(this.cargador());
                NEWSilaboBD.editarEstado(silabo);
            }
        }
    }

    private void btnInformacion(ActionEvent e) {
        SilaboMD silabo = this.getSilaboSeleccionadoTbl();
        if (silabo != null) {
            String informacion = NEWSilaboBD.getInformacion(silabo);
            JOptionPane.showMessageDialog(this.vista, informacion, "INFORMACION DEL SILABO", -1);
        }
    }

    private void btnRefresh(ActionEvent e) {
        this.setLista();
        this.cargarTabla(this.cargador());
    }

    private void chxPeriodos(ActionEvent e) {
        this.tableM.setRowCount(0);
        ((VtnSilabos)this.vista).getCmbPeriodo().removeAllItems();
        if (((VtnSilabos)this.vista).getChxPeriodos().isSelected()) {
            this.periodos = NEWPeriodoLectivoBD.selectAllDEV();
        } else {
            this.getPeriodos();
        }
        this.cargarCmbPeriodo();
    }
}

