/*
 * Decompiled with CFR 0.152.
 */
package controlador.silabo;

import controlador.Libraries.abstracts.AbstractVTN;
import controlador.principal.VtnPrincipalCTR;
import controlador.silabo.VtnSilabosCTR;
import controlador.silabo.frm.FRMSilaboCTR;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import javax.swing.JOptionPane;
import modelo.materia.MateriaMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.silabo.NEWMateriaBD;
import modelo.silabo.NEWPeriodoLectivoBD;
import modelo.silabo.NEWSilaboBD;
import modelo.silabo.SilaboMD;
import utils.CONS;
import vista.silabos.VtnConfigSilabo;
import vista.silabos.VtnSilabos;

public class VtnConfigSilaboCTR
extends AbstractVTN<VtnConfigSilabo, SilaboMD> {
    private final NEWPeriodoLectivoBD PERIODO_BD = NEWPeriodoLectivoBD.single();
    private final NEWSilaboBD SILABO_CON = NEWSilaboBD.single();
    private List<MateriaMD> materias;
    private List<SilaboMD> silabosRef;
    private final List<PeriodoLectivoMD> misPeriodos = NEWPeriodoLectivoBD.getMisPeriodosBy(CONS.USUARIO.getPersona().getIdPersona());
    private final String MENSAJE_SIN_SILABO_PENDIENTE = "NO TIENE SILABOS PENDIENTES PARA ESTA CARRERA";
    private VtnSilabosCTR vtnSilabos;

    public VtnConfigSilaboCTR(VtnPrincipalCTR desktop) {
        super(desktop);
        this.vista = new VtnConfigSilabo();
    }

    public VtnSilabosCTR getVtnSilabos() {
        return this.vtnSilabos;
    }

    public void setVtnSilabos(VtnSilabosCTR vtnSilabos) {
        this.vtnSilabos = vtnSilabos;
    }

    @Override
    public void Init() {
        super.Init();
        this.cargarCmbMisPeriodos();
        this.cargaAsignaturas();
        this.InitEventos();
    }

    private void InitEventos() {
        ((VtnConfigSilabo)this.vista).getCmbPeriodos().addActionListener(this::cmbAsignatura);
        ((VtnConfigSilabo)this.vista).getCmbAsignatura().addActionListener(this::cmbPeriodoRef);
        ((VtnConfigSilabo)this.vista).getCmbPeriodoRef().addActionListener(this::validarPeriodoRef);
        ((VtnConfigSilabo)this.vista).getBtnSiguiente().addActionListener(this::btnSiguiente);
        ((VtnConfigSilabo)this.vista).getBtnCancelar().addActionListener(e -> ((VtnConfigSilabo)this.vista).dispose());
    }

    private int getIdPeriodo() {
        return this.misPeriodos.stream().filter(periodos -> periodos.getNombre().equals(((VtnConfigSilabo)this.vista).getCmbPeriodos().getSelectedItem().toString())).findFirst().map(c -> c.getID()).orElse(0);
    }

    private PeriodoLectivoMD getPeriodo() {
        return this.misPeriodos.stream().filter(item -> item.getID() == this.getIdPeriodo()).findFirst().orElse(null);
    }

    private int getIdMateria() throws NullPointerException {
        return this.getMateria().map(c -> c.getId()).orElse(0);
    }

    private Optional<MateriaMD> getMateria() throws NullPointerException {
        return this.materias.stream().filter(mat -> mat.getNombre().equals(((VtnConfigSilabo)this.vista).getCmbAsignatura().getSelectedItem().toString())).findFirst();
    }

    private void cargarCmbMisPeriodos() {
        this.misPeriodos.stream().map(c -> c.getNombre()).forEach(((VtnConfigSilabo)this.vista).getCmbPeriodos()::addItem);
    }

    private void validarPeriodoRef(ActionEvent e) {
        if (((VtnConfigSilabo)this.vista).getCmbPeriodoRef().getSelectedIndex() != 0) {
            ((VtnConfigSilabo)this.vista).getSpnUnidades().setEnabled(false);
        } else {
            ((VtnConfigSilabo)this.vista).getSpnUnidades().setEnabled(true);
        }
    }

    private boolean migrarEvaluaciones() {
        String mensaje = "DESEA MIGRAR LAS EVALUCACIONES DEL SILABO ANTERIOR?";
        int resuesta = JOptionPane.showConfirmDialog(this.vista, mensaje, "IMPORTANTE!!!", 0);
        return resuesta == 0;
    }

    private void cmbAsignatura(ActionEvent e) {
        this.cargaAsignaturas();
    }

    private void cargaAsignaturas() {
        ((VtnConfigSilabo)this.vista).getCmbAsignatura().removeAllItems();
        this.materias = NEWMateriaBD.single().getMateriasSinSilabo(CONS.USUARIO.getPersona().getIdentificacion(), this.getIdPeriodo());
        this.materias.stream().map(c -> c.getNombre()).forEach(((VtnConfigSilabo)this.vista).getCmbAsignatura()::addItem);
        if (this.materias.size() > 0) {
            ((VtnConfigSilabo)this.vista).getCmbAsignatura().setEnabled(true);
            ((VtnConfigSilabo)this.vista).getBtnSiguiente().setEnabled(true);
            ((VtnConfigSilabo)this.vista).getSpnUnidades().setEnabled(true);
        } else {
            ((VtnConfigSilabo)this.vista).getCmbAsignatura().setEnabled(false);
            ((VtnConfigSilabo)this.vista).getCmbAsignatura().addItem("NO TIENE SILABOS PENDIENTES PARA ESTA CARRERA");
            ((VtnConfigSilabo)this.vista).getBtnSiguiente().setEnabled(false);
            ((VtnConfigSilabo)this.vista).getSpnUnidades().setEnabled(false);
            ((VtnConfigSilabo)this.vista).getCmbPeriodoRef().addItem("NO TIENE SILABOS PENDIENTES PARA ESTA CARRERA");
            ((VtnConfigSilabo)this.vista).getCmbPeriodoRef().setEnabled(false);
        }
    }

    private void cmbPeriodoRef(ActionEvent e) {
        try {
            ((VtnConfigSilabo)this.vista).getCmbPeriodoRef().removeAllItems();
            this.silabosRef = NEWSilaboBD.single().getSilaboRef(this.getIdPeriodo(), this.getIdMateria());
            if (this.silabosRef.size() > 0) {
                ((VtnConfigSilabo)this.vista).getCmbPeriodoRef().setEnabled(true);
                ((VtnConfigSilabo)this.vista).getCmbPeriodoRef().addItem("SI TIENE PERIODOS DE REFERENCIA PARA COPIAR EL SILABO");
                this.silabosRef.stream().map(c -> c.getPeriodo().getNombre()).forEach(((VtnConfigSilabo)this.vista).getCmbPeriodoRef()::addItem);
            } else {
                ((VtnConfigSilabo)this.vista).getCmbPeriodoRef().setEnabled(false);
                ((VtnConfigSilabo)this.vista).getCmbPeriodoRef().addItem("NO TIENE PERIODOS DE REFERENCIA PARA COPIAR");
            }
        }
        catch (NullPointerException ex) {
            ((VtnConfigSilabo)this.vista).getCmbPeriodoRef().addItem("NO TIENE SILABOS PENDIENTES PARA ESTA CARRERA");
            ((VtnConfigSilabo)this.vista).getCmbPeriodoRef().setEnabled(false);
        }
    }

    private void btnSiguiente(ActionEvent e) {
        int indexCmbRef = ((VtnConfigSilabo)this.vista).getCmbPeriodoRef().getSelectedIndex();
        this.desktop.getVtnPrin().setCursor(new Cursor(3));
        if (indexCmbRef > 0) {
            MateriaMD materia = this.materias.stream().filter(item -> item.getNombre().equals(((VtnConfigSilabo)this.vista).getCmbAsignatura().getSelectedItem().toString())).findFirst().get();
            PeriodoLectivoMD periodo = this.silabosRef.stream().filter(item -> item.getPeriodo().getNombre().equalsIgnoreCase(((VtnConfigSilabo)this.vista).getCmbPeriodoRef().getSelectedItem().toString())).map(c -> c.getPeriodo()).findFirst().get();
            this.modelo = new SilaboMD();
            this.modelo = this.SILABO_CON.getSilaboBy(materia, periodo);
            FRMSilaboCTR ctr = new FRMSilaboCTR(this.desktop, (SilaboMD)this.modelo);
            ctr.referenciado(this.migrarEvaluaciones());
        } else {
            this.modelo = new SilaboMD();
            ((SilaboMD)this.modelo).setPeriodo(this.PERIODO_BD.getUltimoPeriodoBy(this.getPeriodo().getCarrera().getId()));
            ((SilaboMD)this.modelo).setMateria(this.getMateria().get());
            FRMSilaboCTR ctr = new FRMSilaboCTR(this.desktop, (SilaboMD)this.modelo);
            ctr.nuevo(Integer.parseInt(((VtnConfigSilabo)this.vista).getSpnUnidades().getValue().toString()));
        }
        ((VtnConfigSilabo)this.vista).dispose();
        ((VtnSilabos)this.vtnSilabos.getVista()).dispose();
    }
}

