/*
 * Decompiled with CFR 0.152.
 */
package controlador.prdlectivo;

import controlador.prdlectivo.FrmPrdLectivoCTR;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.estilo.TblEstilo;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import vista.prdlectivo.FrmPrdLectivo;
import vista.prdlectivo.VtnPrdLectivo;

public class VtnPrdLectivoCTR
extends DCTR {
    private final VtnPrdLectivo vtnPrdLectivo;
    private final PeriodoLectivoBD PLBD = PeriodoLectivoBD.single();
    private FrmPrdLectivo frmPerLectivo;
    private List<PeriodoLectivoMD> periodos;
    private List<CarreraMD> carreras;

    public VtnPrdLectivoCTR(VtnPrdLectivo vtnPrdLectivo, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnPrdLectivo = vtnPrdLectivo;
    }

    public void iniciar() {
        this.ctrPrin.agregarVtn(this.vtnPrdLectivo);
        this.vtnPrdLectivo.getTxt_Buscar().addKeyListener(new TxtVBuscador(this.vtnPrdLectivo.getTxt_Buscar()));
        this.ocultarAtributo();
        this.vtnPrdLectivo.getTxt_Buscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String b = VtnPrdLectivoCTR.this.vtnPrdLectivo.getTxt_Buscar().getText().toUpperCase();
                if (e.getKeyCode() == 10) {
                    VtnPrdLectivoCTR.this.buscaIncremental(b);
                } else if (b.length() == 0) {
                    VtnPrdLectivoCTR.this.cargarPeriodos();
                }
            }
        });
        this.vtnPrdLectivo.getBtnEditar().addActionListener(e -> this.editarPeriodo());
        this.vtnPrdLectivo.getBtnIngresar().addActionListener(e -> this.abrirFrmPrdLectivo());
        this.vtnPrdLectivo.getBtnBuscar().addActionListener(e -> this.buscaIncremental(this.vtnPrdLectivo.getTxt_Buscar().getText()));
        this.vtnPrdLectivo.getBtnCerrarPeriodo().addActionListener(e -> this.cerrarPeriodo());
        this.vtnPrdLectivo.getBtnListaDocentesPeriodos().addActionListener(e -> this.ListaDocentesPeriodos());
        this.vtnPrdLectivo.getTxt_Buscar().addKeyListener(new TxtVBuscador(this.vtnPrdLectivo.getTxt_Buscar(), this.vtnPrdLectivo.getBtnBuscar()));
        this.vtnPrdLectivo.getCmbx_Filtrar().addActionListener(e -> this.filtrarCarreras());
        TblEstilo.formatoTbl(this.vtnPrdLectivo.getTblPrdLectivo());
        TblEstilo.columnaMedida(this.vtnPrdLectivo.getTblPrdLectivo(), 3, 120);
        TblEstilo.columnaMedida(this.vtnPrdLectivo.getTblPrdLectivo(), 4, 120);
        TblEstilo.columnaMedida(this.vtnPrdLectivo.getTblPrdLectivo(), 5, 100);
        this.cargarPeriodos();
        this.cargarCarreras();
        this.InitPermisos();
    }

    public void abrirFrmPrdLectivo() {
        this.ctrPrin.abrirFrmPrdLectivo();
        this.vtnPrdLectivo.dispose();
    }

    public void cargarCarreras() {
        CarreraBD bdCarrera = CarreraBD.single();
        this.carreras = bdCarrera.cargarCarreras();
        for (int i = 0; i < this.carreras.size(); ++i) {
            this.vtnPrdLectivo.getCmbx_Filtrar().addItem(this.carreras.get(i).getNombre());
        }
    }

    public void filtrarCarreras() {
        int idCarrera = 0;
        if (this.vtnPrdLectivo.getCmbx_Filtrar().getSelectedIndex() > 0) {
            String nombre = this.vtnPrdLectivo.getCmbx_Filtrar().getSelectedItem().toString();
            for (int i = 0; i < this.carreras.size(); ++i) {
                if (!this.carreras.get(i).getNombre().equals(nombre)) continue;
                idCarrera = this.carreras.get(i).getId();
            }
            this.periodos = this.PLBD.llenarPeriodosxCarreras(idCarrera);
            this.llenarTabla(this.periodos);
        } else {
            this.llenarTabla(this.periodos);
        }
    }

    public void ocultarAtributo() {
        TblEstilo.ocualtarID(this.vtnPrdLectivo.getTblPrdLectivo());
    }

    private void cargarPeriodos() {
        this.periodos = this.PLBD.cargarPeriodos();
        this.llenarTabla(this.periodos);
    }

    public void llenarTabla(List<PeriodoLectivoMD> periodos) {
        DefaultTableModel modelo_Tabla = (DefaultTableModel)this.vtnPrdLectivo.getTblPrdLectivo().getModel();
        for (int i = this.vtnPrdLectivo.getTblPrdLectivo().getRowCount() - 1; i >= 0; --i) {
            modelo_Tabla.removeRow(i);
        }
        int columnas = modelo_Tabla.getColumnCount();
        for (int i = 0; i < periodos.size(); ++i) {
            modelo_Tabla.addRow(new Object[columnas]);
            String dia_Inicio = String.valueOf(periodos.get(i).getFechaInicio().getDayOfMonth());
            String mes_Inicio = String.valueOf(periodos.get(i).getFechaInicio().getMonthValue());
            String anio_Inicio = String.valueOf(periodos.get(i).getFechaInicio().getYear());
            String dia_Fin = String.valueOf(periodos.get(i).getFechaFin().getDayOfMonth());
            String mes_Fin = String.valueOf(periodos.get(i).getFechaFin().getMonthValue());
            String anio_Fin = String.valueOf(periodos.get(i).getFechaFin().getYear());
            this.vtnPrdLectivo.getTblPrdLectivo().setValueAt(periodos.get(i).getID(), i, 0);
            this.vtnPrdLectivo.getTblPrdLectivo().setValueAt(periodos.get(i).getCarrera().getNombre(), i, 1);
            this.vtnPrdLectivo.getTblPrdLectivo().setValueAt(periodos.get(i).getNombre(), i, 2);
            this.vtnPrdLectivo.getTblPrdLectivo().setValueAt(periodos.get(i).getDocente().getNombreCorto(), i, 3);
            this.vtnPrdLectivo.getTblPrdLectivo().setValueAt(anio_Inicio + "/" + mes_Inicio + "/" + dia_Inicio, i, 4);
            this.vtnPrdLectivo.getTblPrdLectivo().setValueAt(anio_Fin + "/" + mes_Fin + "/" + dia_Fin, i, 5);
            if (periodos.get(i).isEstado()) {
                this.vtnPrdLectivo.getTblPrdLectivo().setValueAt("ABIERTO", i, 6);
                continue;
            }
            this.vtnPrdLectivo.getTblPrdLectivo().setValueAt("CERRADO", i, 6);
        }
        if (periodos.isEmpty()) {
            this.vtnPrdLectivo.getLblResultados().setText("0 Resultados obtenidos.");
        } else {
            this.vtnPrdLectivo.getLblResultados().setText(String.valueOf(periodos.size()) + " Resultados obtenidos.");
        }
    }

    public void buscaIncremental(String aguja) {
        if (Validar.esLetrasYNumeros(aguja)) {
            this.periodos = this.PLBD.capturarPeriodos(aguja);
            this.llenarTabla(this.periodos);
        }
    }

    public PeriodoLectivoMD capturarFila() {
        int i = this.vtnPrdLectivo.getTblPrdLectivo().getSelectedRow();
        if (i >= 0) {
            PeriodoLectivoMD periodo = this.PLBD.capturarPerLectivo(Integer.valueOf(this.vtnPrdLectivo.getTblPrdLectivo().getValueAt(i, 0).toString()));
            return periodo;
        }
        return null;
    }

    public void editarPeriodo() {
        PeriodoLectivoMD periodo = this.capturarFila();
        CarreraMD carrera = new CarreraMD();
        if (periodo != null) {
            this.frmPerLectivo = new FrmPrdLectivo();
            FrmPrdLectivoCTR ctrFrm = new FrmPrdLectivoCTR(this.frmPerLectivo, this.ctrPrin);
            ctrFrm.iniciar();
            carrera.setNombre(periodo.getCarrera().getNombre());
            ctrFrm.editar(periodo, carrera);
            this.vtnPrdLectivo.dispose();
        } else {
            JOptionPane.showMessageDialog(null, "Advertencia!! Seleccione una fila");
        }
    }

    public void eliminarPeriodo() {
        if (this.capturarFila() == null) {
            JOptionPane.showMessageDialog(null, "No se puede Eliminar si no selecciona un Per\u00edodo Lectivo");
        } else {
            int dialog = 1;
            int result = JOptionPane.showConfirmDialog(null, "\u00bfEsta seguro que desea eliminar este Per\u00edodo Lectivo? ", " Eliminar Per\u00edodo Lectivo ", dialog);
            if (result == 0) {
                PeriodoLectivoMD periodo = this.capturarFila();
                if (this.PLBD.eliminarPeriodo(periodo)) {
                    JOptionPane.showMessageDialog(null, "Datos Eliminados Satisfactoriamente");
                    this.cargarPeriodos();
                } else {
                    JOptionPane.showMessageDialog(null, "NO SE PUDO ELIMINAR AL PER\u00cdODO LECTIVO");
                }
            }
        }
    }

    public void cerrarPeriodo() {
        if (this.capturarFila() == null) {
            JOptionPane.showMessageDialog(null, "Seleccione un Per\u00edodo Lectivo");
        } else {
            PeriodoLectivoMD periodo = this.capturarFila();
            if (!periodo.isEstado()) {
                int dialog = 1;
                int result = JOptionPane.showConfirmDialog(null, "El Per\u00edodo Lectivo que seleccion\u00f3 esta Cerrado\n \u00bfDesea Abrir este Per\u00edodo Lectivo? ", " Abrir Per\u00edodo Lectivo ", dialog);
                if (result == 0) {
                    if (this.PLBD.abrirPeriodo(periodo.getID())) {
                        JOptionPane.showMessageDialog(null, "Per\u00edodo Lectivo Abierto Satisfactoriamente");
                    } else {
                        JOptionPane.showMessageDialog(null, "No se pudo abrir este Per\u00edodo Lectivo");
                    }
                }
            } else {
                String num = this.PLBD.alumnosMatriculados(periodo.getCarrera().getId());
                int dialog = 1;
                int result = JOptionPane.showConfirmDialog(null, "ADVERTENCIA!!\nEst\u00e1 a punto de Cerrar un Per\u00edodo Lectivo\nAl hacer esto se pasaran las notas de todos los estudiantes matriculados en la carrera de " + periodo.getCarrera().getNombre() + "\nA la Malla General, esto quiere decir que las notas de " + num + " Alumnos ser\u00e1n cambiadas de lugar, esta acci\u00f3n es irreversible\nSi est\u00e1 de acuerdo con realizar esta acci\u00f3n deber\u00e1 disponer de una excelente conexi\u00f3n a Internet\nEste proceso se tardar\u00e1 algunos minutos\n\u00bfEsta seguro que desea cerrar este Per\u00edodo Lectivo? ", " Cerrar Per\u00edodo Lectivo ", dialog);
                if (result == 0) {
                    if (!periodo.isEstado()) {
                        JOptionPane.showMessageDialog(null, "Este Per\u00edodo Lectivo ya fue cerrado");
                    } else if (this.PLBD.cerrarPeriodo(periodo)) {
                        JOptionPane.showMessageDialog(null, "Per\u00edodo Lectivo Cerrado Satisfactoriamente");
                        this.cargarPeriodos();
                    } else {
                        JOptionPane.showMessageDialog(null, "NO SE PUDO CERRAR ESTE PER\u00cdODO LECTIVO");
                    }
                }
            }
        }
    }

    public void ListaDocentesPeriodos() {
        String path = "/vista/reportes/repListaDocentesPeriodos.jasper";
        int posFila = this.vtnPrdLectivo.getTblPrdLectivo().getSelectedRow();
        if (posFila >= 0) {
            try {
                HashMap<String, Integer> parametro = new HashMap<String, Integer>();
                parametro.put("periodo", this.periodos.get(posFila).getID());
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Lista de Docente por Periodo Lectivo");
                System.out.println(parametro);
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
            }
        } else {
            JOptionPane.showMessageDialog(null, "Seleccione primero una fila de la tabla");
        }
    }

    private void InitPermisos() {
        this.vtnPrdLectivo.getBtnCerrarPeriodo().getAccessibleContext().setAccessibleName("Periodo-Lectivo-Cerrar Periodo");
        this.vtnPrdLectivo.getBtnEditar().getAccessibleContext().setAccessibleName("Periodo-Lectivo-Editar");
        this.vtnPrdLectivo.getBtnIngresar().getAccessibleContext().setAccessibleName("Periodo-Lectivo-Ingresar");
        CONS.activarBtns(this.vtnPrdLectivo.getBtnCerrarPeriodo(), this.vtnPrdLectivo.getBtnEditar(), this.vtnPrdLectivo.getBtnIngresar());
    }
}

