/*
 * Decompiled with CFR 0.152.
 */
package controlador.prdlectivo;

import controlador.periodoLectivoNotas.tipoDeNotas.VtnTipoNotasCTR;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.carrera.CarreraMD;
import modelo.estilo.TblEstilo;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.DocenteBD;
import modelo.persona.DocenteMD;
import modelo.validaciones.CmbValidar;
import modelo.validaciones.Validar;
import vista.prdlectivo.FrmPrdLectivo;

public class FrmPrdLectivoCTR
extends DCTR {
    private final FrmPrdLectivo frmPrdLectivo;
    private final PeriodoLectivoBD PLBD = PeriodoLectivoBD.single();
    private boolean editar = false;
    private int id_PeriodoLectivo;
    private List<CarreraMD> carreras;
    private final DocenteBD DBD = DocenteBD.single();
    private ArrayList<DocenteMD> docentes;
    private DefaultTableModel mdTbl;

    public FrmPrdLectivoCTR(FrmPrdLectivo frmPrdLectivo, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.frmPrdLectivo = frmPrdLectivo;
    }

    public void iniciar() {
        this.ctrPrin.agregarVtn(this.frmPrdLectivo);
        CmbValidar combo_Carreras = new CmbValidar(this.frmPrdLectivo.getCbx_Carreras(), this.frmPrdLectivo.getLbl_ErrCarrera());
        ActionListener Cancelar = e -> {
            this.frmPrdLectivo.dispose();
            this.ctrPrin.cerradoJIF();
        };
        ActionListener rellenarNombre = e -> {
            if (!this.frmPrdLectivo.getCbx_Carreras().getSelectedItem().toString().equals("|SELECCIONE|")) {
                for (int i = 0; i < this.carreras.size(); ++i) {
                    if (!this.frmPrdLectivo.getCbx_Carreras().getSelectedItem().toString().equals(this.carreras.get(i).getNombre().toUpperCase())) continue;
                    Font negrita = new Font("Tahoma", 1, 13);
                    this.frmPrdLectivo.getTxt_Nombre().setFont(negrita);
                    this.frmPrdLectivo.getTxt_Nombre().setText(this.carreras.get(i).getCodigo());
                }
            }
        };
        this.iniciarDatos();
        this.iniciarCarreras();
        this.iniciarComponentes();
        this.iniciarFechas();
        this.habilitarGuardar();
        this.frmPrdLectivo.getCbx_Carreras().addActionListener(rellenarNombre);
        this.frmPrdLectivo.getJdc_FechaInicio().addMouseListener((MouseListener)new MouseAdapter(){

            public void MouseClicked() {
                FrmPrdLectivoCTR.this.habilitarGuardar();
            }
        });
        this.frmPrdLectivo.getJdc_FechaFin().addMouseListener((MouseListener)new MouseAdapter(){

            public void MouseClicked() {
                FrmPrdLectivoCTR.this.habilitarGuardar();
            }
        });
        this.frmPrdLectivo.getBtn_Guardar().addActionListener(e -> this.guardarPeriodo());
        this.frmPrdLectivo.getBtn_Cancelar().addActionListener(Cancelar);
        this.frmPrdLectivo.getCbx_Carreras().addActionListener(combo_Carreras);
        this.frmPrdLectivo.getTxtObservacion().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!Validar.esLetras(FrmPrdLectivoCTR.this.frmPrdLectivo.getTxtObservacion().getText()) && !FrmPrdLectivoCTR.this.frmPrdLectivo.getTxtObservacion().getText().equals("")) {
                    FrmPrdLectivoCTR.this.frmPrdLectivo.getLbl_ErrObservacion().setText("Ingrese solo letras");
                    FrmPrdLectivoCTR.this.frmPrdLectivo.getLbl_ErrObservacion().setVisible(true);
                } else {
                    FrmPrdLectivoCTR.this.frmPrdLectivo.getLbl_ErrObservacion().setVisible(false);
                }
                FrmPrdLectivoCTR.this.habilitarGuardar();
            }
        });
        this.iniciarTblDocentes();
    }

    private void iniciarTblDocentes() {
        String[] titulo = new String[]{"C\u00e9dula", "Nombre"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.frmPrdLectivo.getTblDocentes().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.frmPrdLectivo.getTblDocentes());
        this.frmPrdLectivo.getBtnBuscar().addActionListener(e -> this.buscarDocentes(this.frmPrdLectivo.getTxtBuscar().getText().trim()));
        this.frmPrdLectivo.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String a = FrmPrdLectivoCTR.this.frmPrdLectivo.getTxtBuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    FrmPrdLectivoCTR.this.buscarDocentes(a);
                }
            }
        });
    }

    public void iniciarDatos() {
        this.carreras = this.PLBD.capturarCarrera();
    }

    public void iniciarCarreras() {
        for (int i = 0; i < this.carreras.size(); ++i) {
            this.frmPrdLectivo.getCbx_Carreras().addItem(this.carreras.get(i).getNombre());
        }
    }

    public void habilitarGuardar() {
        String carrera = this.frmPrdLectivo.getCbx_Carreras().getSelectedItem().toString();
        String nombre = this.frmPrdLectivo.getTxt_Nombre().getText();
        String observacion = this.frmPrdLectivo.getTxtObservacion().getText();
        if (!(carrera.equals("|SELECCIONE|") && nombre.equals("") && observacion.equals(""))) {
            this.frmPrdLectivo.getBtn_Guardar().setEnabled(true);
        } else {
            this.frmPrdLectivo.getBtn_Guardar().setEnabled(false);
        }
    }

    public void iniciarFechas() {
        LocalDate fechaActual = LocalDate.now();
        Date fechaHoy = Date.from(fechaActual.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        this.frmPrdLectivo.getJdc_FechaInicio().setDateFormatString("dd/MM/yyyy");
        this.frmPrdLectivo.getJdc_FechaFin().setDateFormatString("dd/MM/yyyy");
        this.frmPrdLectivo.getJdcFechaFinClases().setDateFormatString("dd/MM/yyyy");
        this.frmPrdLectivo.getJdc_FechaInicio().setDate(fechaHoy);
        this.frmPrdLectivo.getJdc_FechaFin().setDate(fechaHoy);
        this.frmPrdLectivo.getJdcFechaFinClases().setDate(fechaHoy);
    }

    public void iniciarComponentes() {
        this.frmPrdLectivo.getCbx_Carreras().setToolTipText("Seleccione una Carrera para generar el Nombre del Per\u00edodo");
        this.frmPrdLectivo.getTxt_Nombre().setToolTipText("El nombre se genera si selecciona una Carrera");
        this.frmPrdLectivo.getJdc_FechaInicio().setToolTipText("Seleccione la Fecha de Inicio del Per\u00edodo Lectivo");
        this.frmPrdLectivo.getJdc_FechaFin().setToolTipText("Seleccione la Fecha de Terminaci\u00f3n del Per\u00edodo Lectivo");
        this.frmPrdLectivo.getTxtObservacion().setToolTipText("Ingrese una Observaci\u00f3n de este Per\u00edodo Lectivo");
        this.frmPrdLectivo.getBtn_Guardar().setToolTipText("Se habilitar\u00e1 despu\u00e9s que los campos con \"*\" esten llenos");
        this.frmPrdLectivo.getLbl_ErrCarrera().setVisible(false);
        this.frmPrdLectivo.getLbl_ErrNombre().setVisible(false);
        this.frmPrdLectivo.getLbl_ErrFecInicio().setVisible(false);
        this.frmPrdLectivo.getLbl_ErrFecFin().setVisible(false);
        this.frmPrdLectivo.getLbl_ErrObservacion().setVisible(false);
        this.frmPrdLectivo.getTxt_Nombre().setEnabled(false);
        this.frmPrdLectivo.getBtn_Guardar().setEnabled(false);
    }

    public LocalDate convertirDate(Date fecha) {
        if (fecha != null) {
            return Instant.ofEpochMilli(fecha.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        }
        return null;
    }

    public void guardarPeriodo() {
        int posCoord;
        boolean error = false;
        LocalDate dia_Inicio = this.convertirDate(this.frmPrdLectivo.getJdc_FechaInicio().getDate());
        LocalDate dia_Fin = this.convertirDate(this.frmPrdLectivo.getJdc_FechaFin().getDate());
        LocalDate fechaFinClases = this.convertirDate(this.frmPrdLectivo.getJdcFechaFinClases().getDate());
        if (dia_Inicio.isAfter(dia_Fin) || dia_Inicio.isEqual(dia_Fin)) {
            error = true;
            this.frmPrdLectivo.getLbl_ErrFecFin().setText("Fecha Incorrecta");
            this.frmPrdLectivo.getLbl_ErrFecFin().setVisible(true);
        } else {
            this.frmPrdLectivo.getLbl_ErrFecFin().setVisible(false);
        }
        if (fechaFinClases == null) {
            error = true;
            JOptionPane.showMessageDialog(this.frmPrdLectivo, "Debe ingresar la fecha de fin de clases.", "Error", 0);
        }
        if ((posCoord = this.frmPrdLectivo.getTblDocentes().getSelectedRow()) < 0) {
            error = true;
            JOptionPane.showMessageDialog(this.frmPrdLectivo, "Debe seleccionar un coordinador.", "Error", 0);
        }
        if (error) {
            this.habilitarGuardar();
        } else if (!this.editar) {
            PeriodoLectivoMD periodo = new PeriodoLectivoMD();
            CarreraMD carrera = new CarreraMD();
            carrera.setId(this.PLBD.capturarIdCarrera(this.frmPrdLectivo.getCbx_Carreras().getSelectedItem().toString()).getId());
            periodo = this.pasarDatos(periodo, carrera);
            periodo.setDocente(this.docentes.get(posCoord));
            if (this.PLBD.guardarPeriodo(periodo, carrera)) {
                JOptionPane.showMessageDialog(null, "Datos guardados correctamente");
                this.frmPrdLectivo.dispose();
                this.ctrPrin.cerradoJIF();
                VtnTipoNotasCTR controlador = new VtnTipoNotasCTR(this.ctrPrin.getVtnPrin());
                controlador.Init();
            } else {
                JOptionPane.showMessageDialog(null, "Error en guardar los datos");
            }
        } else {
            PeriodoLectivoMD periodo = new PeriodoLectivoMD();
            CarreraMD carrera = new CarreraMD();
            carrera.setId(this.PLBD.capturarIdCarrera(this.frmPrdLectivo.getCbx_Carreras().getSelectedItem().toString()).getId());
            periodo = this.pasarDatos(periodo, carrera);
            periodo.setID(this.id_PeriodoLectivo);
            periodo.setDocente(this.docentes.get(posCoord));
            if (this.PLBD.editarPeriodo(periodo, carrera)) {
                JOptionPane.showMessageDialog(null, "Datos editados correctamente");
                this.frmPrdLectivo.dispose();
                this.ctrPrin.cerradoJIF();
                this.editar = false;
            } else {
                JOptionPane.showMessageDialog(null, "Error en editar los datos");
            }
        }
    }

    public PeriodoLectivoMD pasarDatos(PeriodoLectivoMD periodo, CarreraMD carrera) {
        LocalDate dia_Inicio = this.convertirDate(this.frmPrdLectivo.getJdc_FechaInicio().getDate());
        LocalDate dia_Fin = this.convertirDate(this.frmPrdLectivo.getJdc_FechaFin().getDate());
        LocalDate finClases = this.convertirDate(this.frmPrdLectivo.getJdcFechaFinClases().getDate());
        periodo.setNombre(this.frmPrdLectivo.getTxt_Nombre().getText() + " ");
        periodo.setNumPeriodo((String)this.frmPrdLectivo.getJspPeriodo().getValue());
        if (dia_Inicio != null) {
            periodo.setFechaInicio(dia_Inicio);
        }
        if (dia_Fin != null) {
            periodo.setFechaFin(dia_Fin);
        }
        if (finClases != null) {
            periodo.setFechaFinClases(finClases);
        }
        periodo.setObservacion(this.frmPrdLectivo.getTxtObservacion().getText());
        return periodo;
    }

    public void reiniciarComponentes(FrmPrdLectivo vista) {
        vista.getCbx_Carreras().setSelectedItem("|SELECCIONE|");
        vista.getTxt_Nombre().setText("");
        vista.getTxtObservacion().setText("");
    }

    public String sacarIniciales(String palabra) {
        String[] palabras;
        String nombre = "";
        for (String p : palabras = palabra.split(" ")) {
            if (p.length() <= 3) continue;
            nombre = nombre + p.charAt(0);
        }
        return nombre;
    }

    public void editar(PeriodoLectivoMD mdPerLectivo, CarreraMD mdCarrera) {
        this.id_PeriodoLectivo = mdPerLectivo.getID();
        this.editar = true;
        Calendar fechaIni = Calendar.getInstance();
        fechaIni.clear();
        fechaIni.set(mdPerLectivo.getFechaInicio().getYear(), mdPerLectivo.getFechaInicio().getMonthValue() - 1, mdPerLectivo.getFechaInicio().getDayOfMonth());
        Calendar fechaFin = Calendar.getInstance();
        fechaFin.clear();
        fechaFin.set(mdPerLectivo.getFechaFin().getYear(), mdPerLectivo.getFechaFin().getMonthValue() - 1, mdPerLectivo.getFechaFin().getDayOfMonth());
        Calendar fechaClasesFin = Calendar.getInstance();
        fechaClasesFin.clear();
        if (mdPerLectivo.getFechaFinClases() != null) {
            fechaClasesFin.set(mdPerLectivo.getFechaFinClases().getYear(), mdPerLectivo.getFechaFinClases().getMonthValue() - 1, mdPerLectivo.getFechaFinClases().getDayOfMonth());
        }
        this.frmPrdLectivo.getCbx_Carreras().setSelectedItem(mdCarrera.getNombre());
        this.frmPrdLectivo.getCbx_Carreras().setEnabled(false);
        this.frmPrdLectivo.getTxt_Nombre().setText(mdPerLectivo.getNombre());
        this.frmPrdLectivo.getJdc_FechaInicio().setCalendar(fechaIni);
        this.frmPrdLectivo.getJdc_FechaFin().setCalendar(fechaFin);
        this.frmPrdLectivo.getTxtObservacion().setText(mdPerLectivo.getObservacion());
        this.frmPrdLectivo.getJdcFechaFinClases().setCalendar(fechaClasesFin);
        this.frmPrdLectivo.getTxtBuscar().setText(mdPerLectivo.getDocente().getIdentificacion());
        this.frmPrdLectivo.getBtnBuscar().doClick();
        this.habilitarGuardar();
    }

    private void buscarDocentes(String aguja) {
        if (Validar.esLetrasYNumeros(aguja)) {
            this.docentes = this.DBD.buscar(aguja);
            this.llenarTblDocentes(this.docentes);
        }
    }

    private void llenarTblDocentes(ArrayList<DocenteMD> docentes) {
        this.mdTbl.setRowCount(0);
        if (docentes != null) {
            docentes.forEach(d -> {
                Object[] valores = new Object[]{d.getIdentificacion(), d.getPrimerApellido() + " " + d.getSegundoApellido() + " " + d.getPrimerNombre() + "  " + d.getSegundoNombre()};
                this.mdTbl.addRow(valores);
            });
        }
    }
}

