/*
 * Decompiled with CFR 0.152.
 */
package controlador.persona;

import controlador.persona.FrmPersonaCTR;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import vista.persona.FrmPersona;
import vista.persona.VtnWebCam;

public class WebCamCTR
extends DCTR {
    private final VtnWebCam vtnWebCam;
    private final FrmPersona frmPersona;
    private final FrmPersonaCTR ctrFrmPersona;
    private InputStream is;
    private FileInputStream fis;
    private Image foto = null;
    private boolean camaraActiva = false;

    public WebCamCTR(FrmPersona frmPersona, FrmPersonaCTR ctrFrmPersona, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.frmPersona = frmPersona;
        this.ctrFrmPersona = ctrFrmPersona;
        this.vtnWebCam = new VtnWebCam((Frame)ctrPrin.getVtnPrin(), false);
        this.vtnWebCam.setLocationRelativeTo(ctrPrin.getVtnPrin());
        this.vtnWebCam.setVisible(true);
    }

    public void iniciarCamara() {
        this.vtnWebCam.getBtnCapturarFoto().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                for (MouseListener ml : WebCamCTR.this.vtnWebCam.getPanelCam().getMouseListeners()) {
                    ml.mouseClicked(e);
                }
            }
        });
        this.vtnWebCam.getBtnGuardarFoto().addActionListener(e -> this.guardarFoto());
        this.vtnWebCam.getBtnCancelar().addActionListener(e -> this.cancelarFoto());
        this.vtnWebCam.getPanelCam().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!WebCamCTR.this.camaraActiva) {
                    WebCamCTR.this.camaraActiva = true;
                } else {
                    WebCamCTR.this.capturarFoto();
                    WebCamCTR.this.camaraActiva = false;
                }
            }
        });
    }

    public void capturarFoto() {
        System.out.println("Se dio click en capturar foto");
        try {
            byte[] imagen = this.vtnWebCam.getPanelCam().getBytes();
            if (imagen != null) {
                this.is = new ByteArrayInputStream(imagen);
                BufferedImage bi = ImageIO.read(this.is);
                if (bi != null) {
                    ImageIcon icono = new ImageIcon(bi);
                    this.foto = icono.getImage().getScaledInstance(this.vtnWebCam.getLbl_Imagen().getWidth(), this.vtnWebCam.getLbl_Imagen().getHeight(), 4);
                    this.vtnWebCam.getLbl_Imagen().setIcon(new ImageIcon(this.foto));
                    ImageIO.write((RenderedImage)bi, "png", new File("./foto.png"));
                    this.vtnWebCam.getPanelCam().setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
                } else {
                    JOptionPane.showMessageDialog(this.vtnWebCam, "Primero debe actiavar la camara, \ndandole click al recuado idicado.");
                    this.vtnWebCam.getPanelCam().setBorder(BorderFactory.createLineBorder(new Color(47, 76, 113), 2));
                }
            }
        }
        catch (IOException ex) {
            System.out.println("Este es un error al tomar una foto " + ex.getMessage());
        }
    }

    private void guardarFoto() {
        if (this.foto != null && this.is != null) {
            Image foto_Nueva = this.foto.getScaledInstance(this.frmPersona.getLblFoto().getWidth(), this.frmPersona.getLblFoto().getHeight(), 4);
            this.frmPersona.getLblFoto().setIcon(new ImageIcon(foto_Nueva));
            this.cancelarFoto();
            this.ctrFrmPersona.pasarFoto(this.is);
        } else {
            JOptionPane.showMessageDialog(this.vtnWebCam, "Aun no se a tomado una foto.");
        }
    }

    private void cancelarFoto() {
        this.vtnWebCam.dispose();
        System.out.println("Se dio click en cancelar");
    }
}

