/*
 * Decompiled with CFR 0.152.
 */
package controlador.persona;

import controlador.persona.FrmPersonaCTR;
import controlador.persona.JDEditarIdentificacionCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.estilo.TblEstilo;
import modelo.persona.PersonaBD;
import modelo.persona.PersonaMD;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import vista.persona.FrmPersona;
import vista.persona.VtnPersona;

public class VtnPersonaCTR
extends DVtnCTR {
    private final PersonaBD PBD = PersonaBD.single();
    private final VtnPersona vtnPersona;
    private ArrayList<PersonaMD> personas;
    private final String[] tipoPersonas = new String[]{"Docente", "Alumno"};
    String[] accesos = new String[]{"Personas-Ingresar", "Personas-Editar", "Personas-Eliminar", "Personas-Estado"};

    public VtnPersonaCTR(VtnPersona vtnPersona, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnPersona = vtnPersona;
    }

    public void iniciar() {
        this.ctrPrin.agregarVtn(this.vtnPersona);
        this.vtnPersona.getChBx_PerEliminada().addActionListener(e -> {
            if (this.vtnPersona.getChBx_PerEliminada().isSelected()) {
                this.filtrarEliminados();
                this.vtnPersona.getBtnEditar().setEnabled(false);
                this.vtnPersona.getBtnEliminar().setEnabled(false);
            } else {
                this.cargarTipoPersona();
                this.vtnPersona.getBtnEditar().setEnabled(true);
                this.vtnPersona.getBtnEliminar().setEnabled(true);
            }
        });
        this.vtnPersona.getBtnReportePersona().setEnabled(false);
        this.cargarCmbTipoPersonas();
        this.vtnPersona.getLblError().setVisible(false);
        this.vtnPersona.getBtnIngresar().addActionListener(e -> this.ingresar());
        this.vtnPersona.getBtnEditar().addActionListener(e -> this.editar());
        this.vtnPersona.getBtnEliminar().addActionListener(e -> this.eliminar());
        String[] titulo = new String[]{"ID", "Identificacion", "Nombre Completo", "Fecha Nacimiento", "Celular", "Tel\u00e9fono", "Correo"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.vtnPersona.getTblPersona().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.vtnPersona.getTblPersona());
        TblEstilo.ocualtarID(this.vtnPersona.getTblPersona());
        TblEstilo.columnaMedida(this.vtnPersona.getTblPersona(), 1, 100);
        TblEstilo.columnaMedida(this.vtnPersona.getTblPersona(), 3, 120);
        this.cargarTipoPersona();
        this.vtnPersona.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    VtnPersonaCTR.this.buscar();
                }
            }
        });
        this.vtnPersona.getTxtBuscar().addKeyListener(new TxtVBuscador(this.vtnPersona.getTxtBuscar(), this.vtnPersona.getBtnBuscar()));
        this.vtnPersona.getTblPersona().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VtnPersonaCTR.this.validarBotonesReportes();
            }
        });
        this.vtnPersona.getBtnReportePersona().addActionListener(e -> this.llamaReportePersona());
        this.vtnPersona.getCmbTipoPersona().addActionListener(e -> this.cargarTipoPersona());
        this.vtnPersona.getBtnEditarIdentificacion().addActionListener(e -> this.editarIdentificacion());
        this.InitPermisos();
    }

    private void cargarCmbTipoPersonas() {
        this.vtnPersona.getCmbTipoPersona().removeAllItems();
        this.vtnPersona.getCmbTipoPersona().addItem("Todos");
        for (String t : this.tipoPersonas) {
            this.vtnPersona.getCmbTipoPersona().addItem(t);
        }
    }

    private void cargarTipoPersona() {
        String tipo;
        switch (tipo = this.vtnPersona.getCmbTipoPersona().getSelectedItem().toString()) {
            case "Docente": {
                this.personas = this.PBD.cargarDocentes();
                this.cargarLista();
                break;
            }
            case "Alumno": {
                this.personas = this.PBD.cargarAlumnos();
                this.cargarLista();
                break;
            }
            default: {
                this.personas = this.PBD.cargarPersonas();
                this.cargarLista();
            }
        }
    }

    public void filtrarEliminados() {
        List<PersonaMD> peliminados = this.PBD.filtrarEliminados();
        this.mdTbl.setRowCount(0);
        this.ctrPrin.getVtnPrin().getDpnlPrincipal().setCursor(new Cursor(3));
        if (peliminados != null) {
            peliminados.forEach(p -> {
                Object[] valores = new Object[]{p.getIdPersona(), p.getIdentificacion(), p.getPrimerNombre() + " " + p.getSegundoNombre() + " " + p.getPrimerApellido() + " " + p.getSegundoApellido(), p.getFechaNacimiento()};
                this.mdTbl.addRow(valores);
            });
            this.vtnPersona.getLblResultados().setText(peliminados.size() + " resultados obtenidos.");
        } else {
            this.vtnPersona.getLblResultados().setText("0 resultados obtenidos.");
        }
    }

    public void cargarLista() {
        this.mdTbl.setRowCount(0);
        this.ctrPrin.getVtnPrin().getDpnlPrincipal().setCursor(new Cursor(3));
        if (this.personas != null) {
            this.personas.forEach(p -> {
                Object[] valores = new Object[]{p.getIdPersona(), p.getIdentificacion(), p.getPrimerNombre() + " " + p.getSegundoNombre() + " " + p.getPrimerApellido() + " " + p.getSegundoApellido(), p.getFechaNacimiento(), p.getCelular(), p.getTelefono(), p.getCorreo()};
                this.mdTbl.addRow(valores);
            });
            this.vtnPersona.getLblResultados().setText(this.personas.size() + " resultados obtenidos.");
        }
        this.ctrPrin.getVtnPrin().getDpnlPrincipal().setCursor(new Cursor(0));
    }

    public void buscar() {
        String busqueda = this.vtnPersona.getTxtBuscar().getText();
        if (Validar.esLetrasYNumeros(busqueda = busqueda.trim())) {
            if (busqueda.length() > 2) {
                this.personas = this.PBD.buscar(busqueda);
            } else if (busqueda.length() == 0) {
                this.personas = this.PBD.cargarPersonas();
            }
            this.cargarLista();
        }
    }

    public void ingresar() {
        this.ctrPrin.abrirFrmPersona();
        this.vtnPersona.dispose();
        this.ctrPrin.cerradoJIF();
    }

    public void editar() {
        this.posFila = this.vtnPersona.getTblPersona().getSelectedRow();
        if (this.posFila >= 0) {
            this.vtnPersona.getLblError().setVisible(false);
            FrmPersona frmPersona = new FrmPersona();
            FrmPersonaCTR ctrFrm = new FrmPersonaCTR(frmPersona, this.ctrPrin);
            ctrFrm.iniciar();
            PersonaMD perEditar = this.PBD.buscarPersona(Integer.parseInt(this.vtnPersona.getTblPersona().getValueAt(this.posFila, 0).toString()));
            ctrFrm.editar(perEditar);
            this.cargarTipoPersona();
        } else {
            this.vtnPersona.getLblError().setVisible(true);
        }
    }

    private void editarIdentificacion() {
        this.posFila = this.vtnPersona.getTblPersona().getSelectedRow();
        if (this.posFila >= 0) {
            System.out.println("Este es el ID Persona: " + this.personas.get(this.posFila).getIdPersona());
            System.out.println("Nombre Persona " + this.personas.get(this.posFila).getNombreCompleto());
            this.vtnPersona.getLblError().setVisible(false);
            JDEditarIdentificacionCTR ctr = new JDEditarIdentificacionCTR(this.ctrPrin, this.vtnPersona.getTblPersona().getValueAt(this.posFila, 0).toString(), this.vtnPersona.getTblPersona().getValueAt(this.posFila, 2).toString());
            ctr.iniciar();
            PersonaMD perEditar = this.PBD.buscarPersona(Integer.parseInt(this.vtnPersona.getTblPersona().getValueAt(this.posFila, 0).toString()));
            ctr.editarIdentificacion(perEditar);
            this.cargarTipoPersona();
        } else {
            JOptionPane.showMessageDialog(null, "Debe seleccionar una fila ");
        }
    }

    private void eliminar() {
        this.posFila = this.vtnPersona.getTblPersona().getSelectedRow();
        if (this.posFila >= 0) {
            System.out.println(Integer.valueOf(this.vtnPersona.getTblPersona().getValueAt(this.posFila, 0).toString()));
            PersonaMD persona = this.PBD.buscarPersona(Integer.valueOf(this.vtnPersona.getTblPersona().getValueAt(this.posFila, 0).toString()));
            int dialog = 1;
            int result = JOptionPane.showConfirmDialog(null, "\u00bfEsta seguro que desea eliminar a \n" + this.vtnPersona.getTblPersona().getValueAt(this.posFila, 2) + "?", " Eliminar Persona", dialog);
            if (result == 0) {
                if (this.PBD.eliminarPersonaId(persona.getIdPersona())) {
                    JOptionPane.showMessageDialog(null, "Datos Eliminados Satisfactoriamente");
                    this.cargarTipoPersona();
                    this.vtnPersona.getTxtBuscar().setText("");
                } else {
                    JOptionPane.showMessageDialog(null, "NO SE PUDO ELIMINAR A LA PERSONA");
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "SELECCIONE UNA FILA PARA ELIMINAR A LA PERSONA");
        }
    }

    public void llamaReportePersona() {
        this.posFila = this.vtnPersona.getTblPersona().getSelectedRow();
        if (this.posFila >= 0) {
            try {
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/reportes/repPersona.jasper"));
                HashMap<String, String> parametro = new HashMap<String, String>();
                parametro.put("cedula", String.valueOf(this.mdTbl.getValueAt(this.posFila, 1)));
                CON.mostrarReporte(jr, parametro, "Reporte de Persona");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
            }
        } else {
            JOptionPane.showMessageDialog(null, "Selecione una fila para ver el reporte.");
        }
    }

    private void InitPermisos() {
        this.vtnPersona.getBtnEditarIdentificacion().getAccessibleContext().setAccessibleName("Personas-Editar Identificacion");
        this.vtnPersona.getBtnEliminar().getAccessibleContext().setAccessibleName("Personas-Eliminar");
        this.vtnPersona.getBtnEditar().getAccessibleContext().setAccessibleName("Personas-Editar");
        this.vtnPersona.getBtnIngresar().getAccessibleContext().setAccessibleName("Personas-Ingresar");
        this.vtnPersona.getChBx_PerEliminada().getAccessibleContext().setAccessibleName("Personas-Ver Personas Eliminadas");
        this.vtnPersona.getBtnReportePersona().getAccessibleContext().setAccessibleName("Personas-Reporte-Persona");
        CONS.activarBtns(this.vtnPersona.getBtnEditarIdentificacion(), this.vtnPersona.getBtnEliminar(), this.vtnPersona.getBtnEditar(), this.vtnPersona.getBtnIngresar(), this.vtnPersona.getChBx_PerEliminada(), this.vtnPersona.getBtnReportePersona());
    }

    public void validarBotonesReportes() {
        if (CONS.getPermisos().contains("Personas-Reporte-Persona")) {
            int selecTabl = this.vtnPersona.getTblPersona().getSelectedRow();
            if (selecTabl >= 0) {
                this.vtnPersona.getBtnReportePersona().setEnabled(true);
            } else {
                this.vtnPersona.getBtnReportePersona().setEnabled(false);
            }
        }
    }
}

