/*
 * Decompiled with CFR 0.152.
 */
package controlador.persona;

import controlador.persona.VtnAlumnoCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.MallaAlumnoMD;
import modelo.persona.AlumnoBD;
import modelo.persona.AlumnoMD;
import vista.persona.VtnAlumno;
import vista.persona.VtnMatRetiradas;

public class VtnMatReprobadasCTR
extends DVtnCTR {
    private final VtnMatRetiradas vtnMaterias;
    private final VtnAlumnoCTR vtnAlumnoCtr;
    private final VtnAlumno vtnAlumno;
    private AlumnoBD ALBD;
    private int idPersona;

    public VtnMatReprobadasCTR(VtnAlumnoCTR vtnAlumnoCtr, VtnAlumno vtnAlumno, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnMaterias = new VtnMatRetiradas((Frame)ctrPrin.getVtnPrin(), false);
        this.vtnAlumnoCtr = vtnAlumnoCtr;
        this.vtnAlumno = vtnAlumno;
        this.vtnMaterias.setTitle("Materias Ausentes");
        this.vtnMaterias.setLocationRelativeTo(null);
        this.vtnMaterias.setVisible(true);
    }

    public void iniciarVentana() {
        AlumnoMD alumno = VtnAlumnoCTR.mdAlumno;
        Font negrita = new Font("Tahoma", 1, 13);
        this.vtnMaterias.getTxt_Cedula().setFont(negrita);
        this.vtnMaterias.getTxt_Nombre().setFont(negrita);
        this.vtnMaterias.getTxt_Cedula().setText(alumno.getIdentificacion());
        this.vtnMaterias.getTxt_Nombre().setText(alumno.getPrimerNombre() + " " + alumno.getSegundoNombre() + " " + alumno.getPrimerApellido() + " " + alumno.getSegundoApellido());
        this.vtnMaterias.getBtn_Salir().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VtnMatReprobadasCTR.this.vtnMaterias.dispose();
            }
        });
        this.llenarMaterias(alumno.getIdPersona());
        this.iniciarComponentes();
    }

    public void iniciarComponentes() {
        this.vtnMaterias.getTxt_Cedula().setEnabled(false);
        this.vtnMaterias.getTxt_Nombre().setEnabled(false);
    }

    public void llenarMaterias(int idPersona) {
        DefaultTableModel modelo_Tabla = (DefaultTableModel)this.vtnMaterias.getTbl_Materias().getModel();
        for (int i = this.vtnMaterias.getTbl_Materias().getRowCount() - 1; i >= 0; --i) {
            modelo_Tabla.removeRow(i);
        }
        this.ALBD = AlumnoBD.single();
        List<MallaAlumnoMD> malla = this.ALBD.consultarMaterias(idPersona);
        int columnas = modelo_Tabla.getColumnCount();
        for (int i = 0; i < malla.size(); ++i) {
            modelo_Tabla.addRow(new Object[columnas]);
            this.vtnMaterias.getTbl_Materias().setValueAt(malla.get(i).getMateria().getNombre(), i, 0);
            if (!malla.get(i).getEstado().equals("A")) continue;
            this.vtnMaterias.getTbl_Materias().setValueAt("AUSENTE", i, 1);
        }
    }
}

