/*
 * Decompiled with CFR 0.152.
 */
package controlador.persona;

import controlador.docente.JDFinContratacionCTR;
import controlador.persona.FrmDocenteCTR;
import controlador.persona.FrmPersonaCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import modelo.docente.RolDocenteBD;
import modelo.docente.RolDocenteMD;
import modelo.docente.RolPeriodoBD;
import modelo.docente.RolPeriodoMD;
import modelo.estilo.TblEstilo;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.DocenteBD;
import modelo.persona.DocenteMD;
import modelo.persona.PersonaBD;
import modelo.persona.PersonaMD;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import vista.persona.FrmDocente;
import vista.persona.FrmPersona;
import vista.persona.VtnDocente;

public class VtnDocenteCTR
extends DVtnCTR {
    private final VtnDocente vtnDocente;
    private final DocenteBD DBD = DocenteBD.single();
    private final RolPeriodoBD RPBD = RolPeriodoBD.single();
    private final RolDocenteBD RDBD = RolDocenteBD.single();
    private final PeriodoLectivoBD PLBD = PeriodoLectivoBD.single();
    private DocenteMD d;
    private ArrayList<PeriodoLectivoMD> periodos;
    private ArrayList<RolPeriodoMD> roles;
    private ArrayList<DocenteMD> docentesMD;
    private FrmDocente frmDocente;
    private PersonaMD perEditar;
    private final PersonaBD PBD = PersonaBD.single();
    private final String[] tipoDocntes = new String[]{"Finalizado Contrato"};

    public VtnDocenteCTR(VtnDocente vtnDocente, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnDocente = vtnDocente;
    }

    public void iniciar() {
        this.vtnDocente.getBtnReporteDocente().setEnabled(false);
        this.vtnDocente.getBtnReporteDocenteMateria().setEnabled(false);
        this.cargarCmbTipoDocentes();
        String[] titulo = new String[]{"Cedula", "Nombres Completos", "Celular", "Correo", "Tipo Contrato"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.vtnDocente.getTblDocente().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.vtnDocente.getTblDocente());
        TblEstilo.columnaMedida(this.vtnDocente.getTblDocente(), 0, 100);
        TblEstilo.columnaMedida(this.vtnDocente.getTblDocente(), 2, 100);
        TblEstilo.columnaMedida(this.vtnDocente.getTblDocente(), 4, 130);
        this.cargarDocentes();
        this.vtnDocente.getBtnEditar().addActionListener(e -> this.editar());
        this.vtnDocente.getBtnIngresar().addActionListener(e -> this.abrirFrmDocente());
        this.vtnDocente.getBtnEliminar().addActionListener(e -> this.eliminarDocente());
        this.vtnDocente.getBtnFinContratacion().addActionListener(e -> this.finContratacion());
        this.vtnDocente.getCbxDocentesEliminados().addActionListener(e -> this.cargarDocentes());
        this.cargarTipoDocentes();
        this.vtnDocente.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String b = VtnDocenteCTR.this.vtnDocente.getTxtBuscar().getText().toUpperCase().trim();
                if (e.getKeyCode() == 10) {
                    VtnDocenteCTR.this.buscaIncremental(b);
                } else if (b.length() == 0) {
                    VtnDocenteCTR.this.cargarDocentes();
                }
            }
        });
        this.vtnDocente.getTxtBuscar().addKeyListener(new TxtVBuscador(this.vtnDocente.getTxtBuscar(), this.vtnDocente.getBtnBuscar()));
        this.vtnDocente.getBtnhorasAsignadas().addActionListener(e -> this.botonReporteHorasAsignadas());
        this.vtnDocente.getBtnReporteDocente().addActionListener(e -> this.llamaReporteDocente());
        this.vtnDocente.getBtnListaDocente().addActionListener(e -> this.ListaDeDocentes());
        this.vtnDocente.getBtnAsignarRol().addActionListener(e -> this.asignarRolDocente());
        this.vtnDocente.getBtnReporteDocenteMateria().addActionListener(e -> this.botonReporteMateria());
        this.vtnDocente.getTblDocente().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VtnDocenteCTR.this.validarBotonesReportes();
            }
        });
        this.ctrPrin.agregarVtn(this.vtnDocente);
        this.vtnDocente.getCmbTipoDocente().addActionListener(e -> this.cargarTipoDocentes());
        this.InitPermisos();
    }

    private void cargarCmbTipoDocentes() {
        this.vtnDocente.getCmbTipoDocente().removeAllItems();
        this.vtnDocente.getCmbTipoDocente().addItem("Todos");
        for (String t : this.tipoDocntes) {
            this.vtnDocente.getCmbTipoDocente().addItem(t);
        }
    }

    public void cargarTipoDocentes() {
        String tipo;
        switch (tipo = this.vtnDocente.getCmbTipoDocente().getSelectedItem().toString()) {
            case "Finalizado Contrato": {
                this.docentesMD = this.DBD.cargarDocentesFinContrato();
                this.llenarTabla(this.docentesMD);
                break;
            }
            default: {
                this.docentesMD = this.DBD.cargarDocentes();
                this.llenarTabla(this.docentesMD);
            }
        }
        System.out.println(" Tipo Docentes " + tipo);
    }

    private void cargarDocentes() {
        if (this.vtnDocente.getCbxDocentesEliminados().isSelected()) {
            this.docentesMD = this.DBD.cargarDocentesEliminados();
            this.llenarTabla(this.docentesMD);
            this.vtnDocente.getBtnEditar().setText("Habilitar");
            this.inhabilitarBotones();
        } else {
            this.docentesMD = this.DBD.cargarDocentes();
            this.llenarTabla(this.docentesMD);
            this.vtnDocente.getBtnEditar().setText("Editar");
            this.habilitarBotones();
        }
    }

    public void llenarTabla(ArrayList<DocenteMD> docentesM) {
        this.mdTbl.setRowCount(0);
        if (docentesM != null) {
            docentesM.forEach(dc -> {
                Object[] valores = new Object[]{dc.getCodigo(), dc.getPrimerApellido() + " " + dc.getSegundoApellido() + " " + dc.getPrimerNombre() + " " + dc.getSegundoNombre(), dc.getCelular(), dc.getCorreo(), dc.getDocenteTipoTiempo()};
                this.mdTbl.addRow(valores);
            });
            this.vtnDocente.getLblResultados().setText(String.valueOf(docentesM.size()) + " Resultados obtenidos.");
        } else {
            this.vtnDocente.getLblResultados().setText("0 Resultados obtenidos.");
        }
    }

    public void abrirFrmDocente() {
        this.frmDocente = new FrmDocente();
        FrmDocenteCTR ctrFrmDocente = new FrmDocenteCTR(this.frmDocente, this.ctrPrin);
        ctrFrmDocente.iniciar();
        this.vtnDocente.dispose();
        this.ctrPrin.cerradoJIF();
    }

    public void buscaIncremental(String aguja) {
        if (Validar.esLetrasYNumeros(aguja)) {
            if (this.vtnDocente.getCbxDocentesEliminados().isSelected()) {
                this.docentesMD = this.DBD.buscarEliminados(aguja);
                this.llenarTabla(this.docentesMD);
            } else {
                this.docentesMD = this.DBD.buscar(aguja);
                this.llenarTabla(this.docentesMD);
            }
        }
    }

    public void editar() {
        this.posFila = this.vtnDocente.getTblDocente().getSelectedRow();
        if (!this.vtnDocente.getCbxDocentesEliminados().isSelected()) {
            if (this.posFila >= 0) {
                int seleccion = JOptionPane.showOptionDialog(null, "Seleccione una Opcion", "Selector de Opciones", 1, 3, null, new Object[]{"Editar Datos Personales", "Editar Datos de Docente"}, "Editar Datos de Docente");
                if (seleccion == 0) {
                    FrmPersona frmPersona = new FrmPersona();
                    FrmPersonaCTR ctrFrmPersona = new FrmPersonaCTR(frmPersona, this.ctrPrin);
                    ctrFrmPersona.iniciar();
                    this.perEditar = this.PBD.buscarPersona(this.docentesMD.get(this.posFila).getIdPersona());
                    ctrFrmPersona.editar(this.perEditar);
                    this.ctrPrin.cerradoJIF();
                } else if (seleccion == 1) {
                    FrmDocente frmDoc = new FrmDocente();
                    FrmDocenteCTR ctrFrm = new FrmDocenteCTR(frmDoc, this.ctrPrin);
                    ctrFrm.iniciar();
                    frmDoc.getBtnRegistrarPersona().setVisible(false);
                    if (this.docentesMD.get(this.posFila).getCodigo().length() == 10) {
                        frmDoc.getCmbTipoIdentificacion().setSelectedItem("CEDULA");
                        ctrFrm.habilitarComponentesDocente();
                        frmDoc.getTxtIdentificacion().setEnabled(false);
                    } else {
                        frmDoc.getCmbTipoIdentificacion().setSelectedItem("PASAPORTE");
                        ctrFrm.habilitarComponentesDocente();
                        frmDoc.getTxtIdentificacion().setEnabled(false);
                    }
                    frmDoc.getCmbTipoIdentificacion().setEnabled(false);
                    frmDoc.getBtnGuardar().setEnabled(true);
                    ctrFrm.editar(this.DBD.buscarDocente(this.docentesMD.get(this.posFila).getIdDocente()));
                    this.ctrPrin.cerradoJIF();
                }
            } else {
                JOptionPane.showMessageDialog(null, "SELECCIONE UNA FILA !");
            }
        } else if (this.posFila >= 0) {
            this.d = this.DBD.buscarDocenteInactivo(this.docentesMD.get(this.posFila).getCodigo());
            if (this.d != null) {
                int seleccion = JOptionPane.showOptionDialog(null, "Seleccione una Opcion", "Selector de Opciones", 1, 3, null, new Object[]{"Activar Docente", "No Activar"}, "Cancelar");
                if (seleccion == 1) {
                    this.cargarDocentes();
                    System.out.println("opcion 2");
                } else if (seleccion == 0) {
                    this.DBD.activarDocente(this.docentesMD.get(this.posFila).getIdDocente());
                    System.out.println(this.DBD.activarDocente(this.docentesMD.get(this.posFila).getIdDocente()) + "METODO ACTIVAR");
                    JOptionPane.showMessageDialog(null, "SE ACTIVO EL DOCENTE !");
                    this.cargarDocentes();
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "SELECCIONE UNA FILA !");
        }
    }

    private void InitPermisos() {
        this.vtnDocente.getBtnAsignarRol().getAccessibleContext().setAccessibleName("Docente-Asignar Rol");
        this.vtnDocente.getBtnFinContratacion().getAccessibleContext().setAccessibleName("Docente-Fin de Contratacion");
        this.vtnDocente.getBtnEliminar().getAccessibleContext().setAccessibleName("Docente-Eliminar");
        this.vtnDocente.getBtnEditar().getAccessibleContext().setAccessibleName("Docente-Editar");
        this.vtnDocente.getBtnIngresar().getAccessibleContext().setAccessibleName("Docente-Ingresar");
        this.vtnDocente.getCbxDocentesEliminados().getAccessibleContext().setAccessibleName("Docente-Ver Docentes Eliminados");
        this.vtnDocente.getBtnhorasAsignadas().getAccessibleContext().setAccessibleName("Docente-Reporte-Horas Asignacion");
        this.vtnDocente.getBtnReporteDocente().getAccessibleContext().setAccessibleName("Docente-Reporte-Docente");
        this.vtnDocente.getBtnReporteDocenteMateria().getAccessibleContext().setAccessibleName("Docente-Reporte-Materia Docente");
        CONS.activarBtns(this.vtnDocente.getBtnAsignarRol(), this.vtnDocente.getBtnFinContratacion(), this.vtnDocente.getBtnEliminar(), this.vtnDocente.getBtnEditar(), this.vtnDocente.getBtnIngresar(), this.vtnDocente.getCbxDocentesEliminados(), this.vtnDocente.getBtnhorasAsignadas(), this.vtnDocente.getBtnReporteDocente(), this.vtnDocente.getBtnReporteDocenteMateria());
    }

    public void eliminarDocente() {
        DocenteMD docentemd = new DocenteMD();
        this.posFila = this.vtnDocente.getTblDocente().getSelectedRow();
        if (this.posFila >= 0) {
            String observacion;
            int dialog = 1;
            int result = JOptionPane.showConfirmDialog(null, "\u00bfEsta seguro que desea eliminar un Docente? ", " Eliminar Docente ", dialog);
            if (result == 0 && (observacion = JOptionPane.showInputDialog("\u00bfPor que motivo elimina este Docente?")) != null) {
                docentemd.setEstado(observacion.toUpperCase());
                if (this.DBD.eliminarDocente(docentemd, this.docentesMD.get(this.posFila).getIdDocente())) {
                    System.out.println(this.docentesMD.get(this.posFila).getIdDocente() + " " + this.docentesMD.get(this.posFila).getNombreCompleto());
                    JOptionPane.showMessageDialog(null, "Datos Eliminados Satisfactoriamente");
                    this.cargarDocentes();
                } else {
                    JOptionPane.showMessageDialog(null, "NO SE PUDO ELIMINAR AL DOCENTE !");
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "SELECCIONE UNA FILA !");
        }
    }

    public void llamaReporteDocente() {
        String path = "/vista/reportes/repDocentes.jasper";
        this.posFila = this.vtnDocente.getTblDocente().getSelectedRow();
        if (this.posFila >= 0) {
            try {
                HashMap<String, Integer> parametro = new HashMap<String, Integer>();
                parametro.put("cedula", this.docentesMD.get(this.posFila).getIdDocente());
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Reporte de Docente");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
            }
        } else {
            JOptionPane.showMessageDialog(this.frmDocente, "Seleecione una fila primero.");
        }
    }

    public void ListaDeDocentes() {
        String path = "/vista/reportes/repListaDocentes.jasper";
        try {
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
            CON.mostrarReporte(jr, null, "Lista de Docentes");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
        }
    }

    public void llamaReporteDocenteMateria() {
        String path = "/vista/reportes/repDocentesCarrera.jasper";
        this.posFila = this.vtnDocente.getTblDocente().getSelectedRow();
        if (this.posFila >= 0) {
            try {
                HashMap<String, Integer> parametro = new HashMap<String, Integer>();
                parametro.put("id", this.docentesMD.get(this.posFila).getIdDocente());
                System.out.println(parametro);
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Reporte de Materias del Docente");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
            }
        } else {
            JOptionPane.showMessageDialog(this.frmDocente, "Seleecione una fila primero.");
        }
    }

    public void botonReporteMateria() {
        int s = JOptionPane.showOptionDialog(this.vtnDocente, "Reporte de Materias del Docente\n\u00bfElegir el tipo de Reporte?", "REPORTE MATERIAS", 1, 1, null, new Object[]{"Materias por Periodo", "Historial de Materias", "Cancelar"}, "Historial de Materias");
        switch (s) {
            case 0: {
                this.seleccionarPeriodo();
                break;
            }
            case 1: {
                this.llamaReporteDocenteMateria();
                break;
            }
        }
    }

    public void seleccionarPeriodo() {
        this.periodos = this.PLBD.cargarPeriodos();
        ArrayList<String> nmPrd = new ArrayList<String>();
        nmPrd.add("Seleccione");
        this.periodos.forEach(p -> nmPrd.add(p.getNombre()));
        Object np = JOptionPane.showInputDialog(null, "Lista de periodos lectivos", "Periodos lectivos", 3, null, nmPrd.toArray(), "Seleccione");
        if (np == null) {
            this.botonReporteMateria();
        } else if (np.equals("Seleccione")) {
            JOptionPane.showMessageDialog(null, "Debe seleccionar un periodo lectivo.");
            this.seleccionarPeriodo();
        } else {
            int posPrd = nmPrd.indexOf(np);
            String path = "/vista/reportes/repDocenteCarreraPeriodo.jasper";
            this.posFila = this.vtnDocente.getTblDocente().getSelectedRow();
            try {
                HashMap<String, Object> parametro = new HashMap<String, Object>();
                parametro.put("idDocente", this.docentesMD.get(this.posFila).getIdDocente());
                parametro.put("periodo", np);
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Reporte de Materias del Docente por Periodos Lectivos");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "Error: " + (Object)((Object)ex));
            }
        }
    }

    public void validarBotonesReportes() {
        int selecTabl = this.vtnDocente.getTblDocente().getSelectedRow();
        if (selecTabl >= 0) {
            this.vtnDocente.getBtnReporteDocente().setEnabled(true);
            this.vtnDocente.getBtnReporteDocenteMateria().setEnabled(true);
        } else {
            this.vtnDocente.getBtnReporteDocente().setEnabled(false);
            this.vtnDocente.getBtnReporteDocenteMateria().setEnabled(false);
        }
    }

    private void finContratacion() {
        this.posFila = this.vtnDocente.getTblDocente().getSelectedRow();
        if (this.posFila >= 0) {
            JDFinContratacionCTR ctr = new JDFinContratacionCTR(this.ctrPrin, this.vtnDocente.getTblDocente().getValueAt(this.posFila, 0).toString(), this.DBD.capturarIdDocente(this.vtnDocente.getTblDocente().getValueAt(this.posFila, 0).toString(), 0).getIdDocente());
            ctr.iniciar();
        } else {
            JOptionPane.showMessageDialog(null, "Debe seleccionar una fila ");
        }
    }

    private void habilitarBotones() {
        this.vtnDocente.getBtnEliminar().setEnabled(true);
        this.vtnDocente.getBtnEditar().setEnabled(true);
        this.vtnDocente.getBtnIngresar().setEnabled(true);
        this.vtnDocente.getBtnFinContratacion().setEnabled(true);
    }

    private void inhabilitarBotones() {
        this.vtnDocente.getBtnEliminar().setEnabled(false);
        this.vtnDocente.getBtnIngresar().setEnabled(false);
        this.vtnDocente.getBtnFinContratacion().setEnabled(false);
    }

    public void botonReporteHorasAsignadas() {
        int s = JOptionPane.showOptionDialog(this.vtnDocente, "Reporte de Materias del Docente\n\u00bfdesea obtener reporte de horas semanales?", "REPORTE hORAS DOCENCIA SEMANAL", 1, 1, null, new Object[]{"Horas por Docente", "Horas por periodo", "Cancelar"}, "Historial de Materias");
        switch (s) {
            case 0: {
                this.seleccionarPeriodohoras();
                break;
            }
            case 1: {
                this.seleccionarPeriodohorasCARRERA();
                break;
            }
        }
    }

    public void asignarRolDocente() {
        this.posFila = this.vtnDocente.getTblDocente().getSelectedRow();
        if (this.posFila >= 0) {
            this.periodos = this.PLBD.cargarPeriodos();
            ArrayList<String> nmPrd = new ArrayList<String>();
            nmPrd.add("Seleccione");
            this.periodos.forEach(p -> nmPrd.add(p.getNombre()));
            Object np = JOptionPane.showInputDialog(null, "Lista de periodos lectivos", "Periodos lectivos", 3, null, nmPrd.toArray(), 0);
            System.out.println("Posicion: ");
            if (np == null) {
                JOptionPane.showMessageDialog(null, "Seleccione un periodo");
            } else {
                System.out.println("Este es el periodo: " + np.toString());
                int posPrd = nmPrd.indexOf(np);
                System.out.println("La posicion es: " + posPrd + " El nombre es: " + this.periodos.get(posPrd - 1).getNombre());
                this.selecionarRol(this.periodos.get(posPrd - 1).getID());
            }
        } else {
            JOptionPane.showMessageDialog(null, "Seleccione una fila de la tabla");
        }
    }

    private void selecionarRol(int idPrd) {
        ArrayList<String> nmRol = new ArrayList<String>();
        this.roles = this.RPBD.cargarRolesPorPeriodo(idPrd);
        nmRol.add("Seleccione");
        this.roles.forEach(r -> nmRol.add(r.getNombre_rol()));
        Object nr = JOptionPane.showInputDialog(null, "Lista de roles por periodos", "Roles de Docente", 3, null, nmRol.toArray(), 0);
        if (nr != null) {
            if (!nr.equals("Seleccione")) {
                int posRol = nmRol.indexOf(nr);
                this.insertarRolDocente(this.roles.get(posRol - 1));
            } else {
                JOptionPane.showMessageDialog(null, "Selleccione un rol");
                this.selecionarRol(idPrd);
            }
        }
    }

    public void insertarRolDocente(RolPeriodoMD rol) {
        this.posFila = this.vtnDocente.getTblDocente().getSelectedRow();
        RolDocenteMD rd = new RolDocenteMD();
        rd.setIdDocente(this.docentesMD.get(this.posFila));
        rd.setIdRolPeriodo(rol);
        if (this.RDBD.InsertarRol(rd)) {
            JOptionPane.showMessageDialog(null, "Datos grabados correctamente");
        } else {
            JOptionPane.showMessageDialog(null, "Error en grabar los datos");
        }
    }

    public void seleccionarPeriodohoras() {
        this.periodos = this.PLBD.cargarPeriodos();
        ArrayList<String> nmPrd = new ArrayList<String>();
        nmPrd.add("Seleccione");
        this.periodos.forEach(p -> nmPrd.add(p.getNombre()));
        Object np = JOptionPane.showInputDialog(null, "Lista de periodos lectivos", "Periodos lectivos", 3, null, nmPrd.toArray(), "Seleccione");
        if (np == null) {
            this.botonReporteHorasAsignadas();
        } else if (np.equals("Seleccione")) {
            JOptionPane.showMessageDialog(null, "Debe seleccionar un periodo lectivo.");
            this.seleccionarPeriodohoras();
        } else {
            int posPrd = nmPrd.indexOf(np);
            String path = "/vista/reportes/repSesionClase.jasper";
            try {
                this.posFila = this.vtnDocente.getTblDocente().getSelectedRow();
                HashMap<String, Object> parametro = new HashMap<String, Object>();
                parametro.put("iddocente", this.docentesMD.get(this.posFila).getIdDocente());
                parametro.put("idperiodolectivo", np.toString());
                System.out.println(parametro);
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Reporte de Horas de docencia Semanal");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "Error: " + (Object)((Object)ex));
            }
        }
    }

    public void seleccionarPeriodohorasCARRERA() {
        this.periodos = this.PLBD.cargarPeriodos();
        ArrayList<String> nmPrd = new ArrayList<String>();
        nmPrd.add("Seleccione");
        this.periodos.forEach(p -> nmPrd.add(p.getNombre()));
        Object np = JOptionPane.showInputDialog(null, "Lista de periodos lectivos", "Periodos lectivos", 3, null, nmPrd.toArray(), "Seleccione");
        if (np == null) {
            this.botonReporteHorasAsignadas();
        } else if (np.equals("Seleccione")) {
            JOptionPane.showMessageDialog(null, "Debe seleccionar un periodo lectivo.");
            this.seleccionarPeriodohorasCARRERA();
        } else {
            int posPrd = nmPrd.indexOf(np);
            String path = "/vista/reportes/repHorasClaseCarrera.jasper";
            try {
                this.posFila = this.vtnDocente.getTblDocente().getSelectedRow();
                HashMap<String, String> parametro = new HashMap<String, String>();
                parametro.put("periodo_nombre", np.toString());
                System.out.println(parametro);
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Reporte de Horas de docencia Semanal");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "Error: " + (Object)((Object)ex));
            }
        }
    }
}

