/*
 * Decompiled with CFR 0.152.
 */
package controlador.persona;

import controlador.persona.FrmAlumnoCTR;
import controlador.persona.FrmPersonaCTR;
import controlador.persona.VtnMatReprobadasCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.swing.JOptionPane;
import modelo.estilo.TblEstilo;
import modelo.persona.AlumnoBD;
import modelo.persona.AlumnoMD;
import modelo.persona.PersonaBD;
import modelo.persona.PersonaMD;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import vista.persona.FrmAlumno;
import vista.persona.FrmPersona;
import vista.persona.VtnAlumno;
import vista.persona.VtnMatRetiradas;

public class VtnAlumnoCTR
extends DVtnCTR {
    private final VtnAlumno vtnAlumno;
    private FrmAlumno frmAlumno;
    private final AlumnoBD ABD = AlumnoBD.single();
    public static AlumnoMD mdAlumno;
    private List<List<String>> alumnos;
    private List<List<String>> todosAlumnos;

    public VtnAlumnoCTR(VtnAlumno vtnAlumno, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnAlumno = vtnAlumno;
    }

    public void iniciar() {
        this.ctrPrin.agregarVtn(this.vtnAlumno);
        this.iniciarComponentes();
        this.vtnAlumno.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    VtnAlumnoCTR.this.buscaIncremental(VtnAlumnoCTR.this.vtnAlumno.getTxtBuscar().getText().toUpperCase());
                }
            }
        });
        this.vtnAlumno.getBtnEliminar().addActionListener(e -> this.eliminarAlumno());
        this.vtnAlumno.getBtnEditar().addActionListener(e -> this.editarAlumno());
        this.vtnAlumno.getBtnIngresar().addActionListener(e -> this.abrirFrmAlumno());
        this.vtnAlumno.getBtn_Materias().addActionListener(e -> this.abrirVtnMaterias());
        this.vtnAlumno.getCbx_Filtrar().addActionListener(e -> {
            String palabra;
            switch (palabra = this.vtnAlumno.getCbx_Filtrar().getSelectedItem().toString()) {
                case "ALUMNOS ELMINADOS": {
                    this.llenarElimanados();
                    this.vtnAlumno.getBtn_Materias().setVisible(false);
                    this.vtnAlumno.getBtnEliminar().setEnabled(false);
                    this.vtnAlumno.getBtnEditar().setEnabled(false);
                    break;
                }
                case "ALUMNOS RETIRADOS": {
                    this.llenarRetirados();
                    this.vtnAlumno.getBtn_Materias().setVisible(true);
                    this.vtnAlumno.getBtnEliminar().setEnabled(true);
                    this.vtnAlumno.getBtnEditar().setEnabled(true);
                    break;
                }
                default: {
                    this.alumnos = this.todosAlumnos;
                    this.llenarTbl(this.alumnos);
                    this.vtnAlumno.getBtn_Materias().setVisible(false);
                    this.vtnAlumno.getBtnEliminar().setEnabled(true);
                    this.vtnAlumno.getBtnEditar().setEnabled(true);
                }
            }
        });
        this.vtnAlumno.getTxtBuscar().addKeyListener(new TxtVBuscador(this.vtnAlumno.getTxtBuscar(), this.vtnAlumno.getBtnBuscar()));
        this.InitPermisos();
        this.vtnAlumno.getBtnReporteAlumnos().addActionListener(e -> this.ListaDeAlumnos());
        this.iniciarTbl();
    }

    private void iniciarTbl() {
        String[] titulo = new String[]{"ID", "Identificacion", "Nombres", "Apellidos", "Correo", "Celular", "Carrera", "Curso"};
        this.mdTbl = this.iniciarTbl(this.vtnAlumno.getTblAlumno(), titulo);
        this.alumnos = this.ABD.getAllTable();
        this.todosAlumnos = this.alumnos;
        TblEstilo.ocualtarID(this.vtnAlumno.getTblAlumno());
        this.llenarTbl(this.alumnos);
        this.listenerTxtBuscarLocal(this.vtnAlumno.getTxtBuscar(), this.vtnAlumno.getBtnBuscar(), this.buscarFun());
    }

    public void abrirFrmAlumno() {
        this.frmAlumno = new FrmAlumno();
        this.ctrPrin.abrirFrmAlumno();
        this.vtnAlumno.dispose();
        this.ctrPrin.cerradoJIF();
    }

    public void abrirVtnMaterias() {
        mdAlumno = this.capturarFila();
        if (mdAlumno == null) {
            JOptionPane.showMessageDialog(null, "Advertencia!! Seleccione a un Alumno");
        } else {
            VtnMatRetiradas m = new VtnMatRetiradas((Frame)this.ctrPrin.getVtnPrin(), false);
            VtnMatReprobadasCTR materias = new VtnMatReprobadasCTR(this, this.vtnAlumno, this.ctrPrin);
            materias.iniciarVentana();
        }
    }

    public void iniciarComponentes() {
        this.vtnAlumno.getBtn_Materias().setVisible(false);
    }

    public void llenarElimanados() {
        this.mdTbl.setRowCount(0);
        List<PersonaMD> lista = this.ABD.llenarEliminados();
        int columnas = this.mdTbl.getColumnCount();
        for (int i = 0; i < lista.size(); ++i) {
            this.mdTbl.addRow(new Object[columnas]);
            this.vtnAlumno.getTblAlumno().setValueAt(String.valueOf(lista.get(i).getIdPersona()), i, 0);
            this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getIdentificacion(), i, 1);
            this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getPrimerNombre() + " " + lista.get(i).getSegundoNombre(), i, 2);
            this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getPrimerApellido() + " " + lista.get(i).getSegundoApellido(), i, 3);
            this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getCorreo(), i, 4);
        }
        this.vtnAlumno.getLblResultados().setText(String.valueOf(lista.size()) + " Resultados obtenidos.");
    }

    public void llenarRetirados() {
        this.mdTbl.setRowCount(0);
        List<AlumnoMD> lista = this.ABD.filtrarRetirados();
        int columnas = this.mdTbl.getColumnCount();
        for (int i = 0; i < lista.size(); ++i) {
            this.mdTbl.addRow(new Object[columnas]);
            this.vtnAlumno.getTblAlumno().setValueAt(String.valueOf(lista.get(i).getIdPersona()), i, 0);
            this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getIdentificacion(), i, 1);
            this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getPrimerNombre() + " " + lista.get(i).getSegundoNombre(), i, 2);
            this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getPrimerApellido() + " " + lista.get(i).getSegundoApellido(), i, 3);
            this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getCorreo(), i, 4);
        }
        this.vtnAlumno.getLblResultados().setText(String.valueOf(lista.size()) + " Resultados obtenidos.");
    }

    public void buscaIncremental(String aguja) {
        if (Validar.esLetrasYNumeros(aguja)) {
            this.mdTbl.setRowCount(0);
            List<PersonaMD> lista = this.ABD.capturarPersona(aguja);
            int columnas = this.mdTbl.getColumnCount();
            for (int i = 0; i < lista.size(); ++i) {
                this.mdTbl.addRow(new Object[columnas]);
                this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getIdPersona(), i, 0);
                this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getIdentificacion(), i, 1);
                this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getPrimerNombre() + " " + lista.get(i).getSegundoNombre(), i, 2);
                this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getPrimerApellido() + " " + lista.get(i).getSegundoApellido(), i, 3);
                this.vtnAlumno.getTblAlumno().setValueAt(lista.get(i).getCorreo(), i, 4);
            }
            this.vtnAlumno.getLblResultados().setText(String.valueOf(lista.size()) + " Resultados obtenidos.");
        } else if (!aguja.equals("")) {
            JOptionPane.showMessageDialog(null, "Ingrese un caracter v\u00e1lido para la B\u00fasqueda");
        } else {
            this.alumnos = this.todosAlumnos;
            this.llenarTbl(this.alumnos);
        }
    }

    private void llenarTbl(List<List<String>> alumnos) {
        this.mdTbl.setRowCount(0);
        alumnos.forEach(a -> this.mdTbl.addRow(a.toArray()));
        this.vtnAlumno.getLblResultados().setText(alumnos.size() + " Resultados obtenidos.");
    }

    public AlumnoMD capturarFila() {
        int i = this.vtnAlumno.getTblAlumno().getSelectedRow();
        if (i >= 0) {
            AlumnoMD alumno = this.ABD.buscarPersona(Integer.valueOf(this.vtnAlumno.getTblAlumno().getValueAt(i, 0).toString()));
            System.out.println("ID: " + this.vtnAlumno.getTblAlumno().getValueAt(i, 0).toString());
            return alumno;
        }
        return null;
    }

    public void editarAlumno() {
        AlumnoMD al = this.capturarFila();
        if (al != null) {
            int seleccion = JOptionPane.showOptionDialog(null, "Seleccione una Opcion", "Selector de Opciones", 1, 3, null, new Object[]{"Editar Datos Personales", "Editar Datos de Alumno"}, "Editar Datos de Alumno");
            if (seleccion == 1) {
                this.frmAlumno = new FrmAlumno();
                FrmAlumnoCTR ctrFrm = new FrmAlumnoCTR(this.frmAlumno, this.ctrPrin);
                ctrFrm.iniciar();
                ctrFrm.editar(al);
                this.vtnAlumno.dispose();
                this.ctrPrin.cerradoJIF();
            } else if (seleccion == 0) {
                PersonaBD PBD = PersonaBD.single();
                FrmPersona frmPersona = new FrmPersona();
                PersonaMD persona = PBD.buscarPersona(al.getIdPersona());
                FrmPersonaCTR ctrPers = new FrmPersonaCTR(frmPersona, this.ctrPrin);
                ctrPers.iniciar();
                ctrPers.editar(persona);
                if (Validar.esNumeros(persona.getIdentificacion())) {
                    frmPersona.getCmbTipoId().setSelectedItem("CEDULA");
                } else {
                    frmPersona.getCmbTipoId().setSelectedItem("PASAPORTE");
                }
                frmPersona.getTxtIdentificacion().setText(persona.getIdentificacion());
                this.vtnAlumno.dispose();
                this.ctrPrin.cerradoJIF();
            }
        } else {
            JOptionPane.showMessageDialog(null, "Advertencia!! Seleccione una fila");
        }
    }

    public void eliminarAlumno() {
        if (this.capturarFila() == null) {
            JOptionPane.showMessageDialog(null, "No se puede Eliminar si no selecciona a un Alumno");
        } else {
            int dialog = 1;
            int result = JOptionPane.showConfirmDialog(null, "\u00bfEsta seguro que desea eliminar a este Estudiante? ", " Eliminar Estudiante ", dialog);
            if (result == 0) {
                AlumnoMD alumno = this.capturarFila();
                String observacion = JOptionPane.showInputDialog("\u00bfPor que motivo elimina este alumno?");
                if (observacion != null) {
                    alumno.setObservacion(observacion.toUpperCase());
                    if (this.ABD.eliminarAlumno(alumno, alumno.getIdPersona())) {
                        JOptionPane.showMessageDialog(null, "Datos Eliminados Satisfactoriamente");
                        this.buscaIncremental("");
                    } else {
                        JOptionPane.showMessageDialog(null, "NO SE PUDO ELIMINAR AL ALUMNO");
                    }
                }
            }
        }
    }

    public void ListaDeAlumnos() {
        String path = "/vista/reportes/repListaAlumnos.jasper";
        try {
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
            CON.mostrarReporte(jr, null, "Lista de Docentes");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
        }
    }

    private void InitPermisos() {
        this.vtnAlumno.getBtnEliminar().getAccessibleContext().setAccessibleName("Alumnos-Eliminar");
        this.vtnAlumno.getBtnEditar().getAccessibleContext().setAccessibleName("Alumnos-Editar");
        this.vtnAlumno.getBtnIngresar().getAccessibleContext().setAccessibleName("Alumnos-Ingresar");
        this.vtnAlumno.getBtnReporteAlumnos().getAccessibleContext().setAccessibleName("Alumnos-Reporte-Alumnos");
        CONS.activarBtns(this.vtnAlumno.getBtnEliminar(), this.vtnAlumno.getBtnEditar(), this.vtnAlumno.getBtnIngresar(), this.vtnAlumno.getBtnReporteAlumnos());
    }

    private Function<String, Void> buscarFun() {
        return t -> {
            this.buscar(t.toUpperCase().trim());
            return null;
        };
    }

    private void buscar(String aguja) {
        this.alumnos = new ArrayList<List<String>>();
        this.todosAlumnos.forEach(ta -> {
            if (((String)ta.get(1)).contains(aguja) || ((String)ta.get(2)).contains(aguja) || ((String)ta.get(3)).contains(aguja) || ((String)ta.get(4)).contains(aguja) || ((String)ta.get(5)).contains(aguja) || ((String)ta.get(2) + " " + (String)ta.get(3)).contains(aguja)) {
                this.alumnos.add((List<String>)ta);
            }
        });
        this.llenarTbl(this.alumnos);
    }
}

