/*
 * Decompiled with CFR 0.152.
 */
package controlador.persona;

import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import modelo.persona.PersonaBD;
import modelo.persona.PersonaMD;
import modelo.validaciones.CmbValidar;
import modelo.validaciones.TxtVCedula;
import modelo.validaciones.Validar;
import vista.persona.JDEditarIdentificacion;

public class JDEditarIdentificacionCTR
extends DVtnCTR {
    private final PersonaBD PBD = PersonaBD.single();
    private final JDEditarIdentificacion jdEditarIdentificacion;
    private final String identificacion;
    private final String nombrePersona;
    private int idPersona = 0;
    private boolean editar = false;
    private int numAccion = 2;
    private TxtVCedula valCe;

    public JDEditarIdentificacionCTR(VtnPrincipalCTR ctrPrin, String identificacion, String nombrePersona) {
        super(ctrPrin);
        this.identificacion = identificacion;
        this.nombrePersona = nombrePersona;
        this.jdEditarIdentificacion = new JDEditarIdentificacion((Frame)ctrPrin.getVtnPrin(), false);
        this.jdEditarIdentificacion.setLocationRelativeTo(ctrPrin.getVtnPrin());
        this.jdEditarIdentificacion.setVisible(true);
        this.jdEditarIdentificacion.setTitle("Editar Identificacion");
    }

    public void iniciar() {
        Font negrita = new Font("Tahoma", 1, 13);
        this.jdEditarIdentificacion.getLblNombrePersona().setFont(negrita);
        this.jdEditarIdentificacion.getLblNombrePersona().setText(this.nombrePersona);
        this.jdEditarIdentificacion.getTxtIdentificacion().setEnabled(false);
        this.iniciarComponentes();
        this.iniciarValidaciones();
        this.jdEditarIdentificacion.getBtnCancelar().addActionListener(e -> this.cancelar());
        this.jdEditarIdentificacion.getBtnGuardar().addActionListener(e -> this.guardarIdentificacion());
        this.valCe = new TxtVCedula(this.jdEditarIdentificacion.getTxtIdentificacion(), this.jdEditarIdentificacion.getLblErrorIdentificacion());
        this.jdEditarIdentificacion.getTxtIdentificacion().addKeyListener(this.valCe);
        this.jdEditarIdentificacion.getCbx_Identificacion().addActionListener(e -> this.tipoID());
    }

    public void iniciarComponentes() {
        this.jdEditarIdentificacion.getCbx_Identificacion().setToolTipText("Seleccione un Tipo de Identificaci\u00f3n");
        this.jdEditarIdentificacion.getTxtIdentificacion().setToolTipText("Ingrese una Identificaci\u00f3n v\u00e1lida");
        this.jdEditarIdentificacion.getLblErrorIdentificacion().setVisible(false);
    }

    private void tipoID() {
        int pos = this.jdEditarIdentificacion.getCbx_Identificacion().getSelectedIndex();
        this.jdEditarIdentificacion.getTxtIdentificacion().setEnabled(false);
        switch (pos) {
            case 1: {
                this.valCe.activarValidacion();
                this.jdEditarIdentificacion.getTxtIdentificacion().setEnabled(true);
                break;
            }
            case 2: {
                this.valCe.desactivarValidacion();
                this.jdEditarIdentificacion.getTxtIdentificacion().setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
                this.jdEditarIdentificacion.getLblErrorIdentificacion().setVisible(false);
                this.jdEditarIdentificacion.getTxtIdentificacion().setEnabled(true);
                break;
            }
            default: {
                this.jdEditarIdentificacion.getTxtIdentificacion().setEnabled(false);
            }
        }
    }

    private void cancelar() {
        this.jdEditarIdentificacion.dispose();
    }

    public void guardarIdentificacion() {
        boolean guardar = true;
        String identifi = this.jdEditarIdentificacion.getTxtIdentificacion().getText().trim().toUpperCase();
        int tipoIdentifi = this.jdEditarIdentificacion.getCbx_Identificacion().getSelectedIndex();
        if (tipoIdentifi == 1) {
            if (!Validar.esCedula(identifi)) {
                guardar = false;
                this.jdEditarIdentificacion.getLblErrorIdentificacion().setVisible(true);
            } else {
                this.jdEditarIdentificacion.getLblErrorIdentificacion().setVisible(false);
            }
        }
        if (guardar) {
            if (this.editar && this.idPersona > 0) {
                if (this.PBD.editarIdentificacion(identifi, this.idPersona)) {
                    JOptionPane.showMessageDialog(null, "Datos Editados Correctamente.");
                    this.iniciarComponentes();
                } else {
                    JOptionPane.showMessageDialog(null, "No se pudo editar,\nRevise su conexion a internet. ");
                }
                this.editar = false;
            }
            this.jdEditarIdentificacion.dispose();
            this.ctrPrin.cerradoJIF();
        } else {
            JOptionPane.showMessageDialog(null, "Existen errores en los campos\nRevise su informaci\u00f3n!!");
        }
    }

    public void editarIdentificacion(PersonaMD perEditar) {
        this.idPersona = perEditar.getIdPersona();
        System.out.println("id" + this.idPersona);
        this.editar = true;
        String cedula = perEditar.getIdentificacion();
        if (Validar.esCedula(cedula)) {
            this.jdEditarIdentificacion.getCbx_Identificacion().setSelectedItem("CEDULA");
        } else {
            this.jdEditarIdentificacion.getCbx_Identificacion().setSelectedItem("PASAPORTE");
        }
        this.jdEditarIdentificacion.getTxtIdentificacion().setEnabled(true);
        this.jdEditarIdentificacion.getTxtIdentificacion().setText(perEditar.getIdentificacion());
        this.iniciarValidaciones();
    }

    public void habilitarBtnGuardar() {
        String TipoId = this.jdEditarIdentificacion.getCbx_Identificacion().getSelectedItem().toString();
        String Identificacion = this.jdEditarIdentificacion.getTxtIdentificacion().getText();
        if (!this.jdEditarIdentificacion.getLblErrorIdentificacion().isVisible()) {
            if (!TipoId.equals("SELECCIONE") && !Identificacion.equals("")) {
                this.jdEditarIdentificacion.getBtnGuardar().setEnabled(true);
            } else {
                this.jdEditarIdentificacion.getBtnGuardar().setEnabled(false);
            }
        } else {
            this.jdEditarIdentificacion.getBtnGuardar().setEnabled(false);
        }
    }

    private void iniciarValidaciones() {
        PropertyChangeListener habilitar_Guardar = evt -> this.habilitarBtnGuardar();
        if (this.numAccion > 1) {
            this.jdEditarIdentificacion.getCbx_Identificacion().addActionListener(new CmbValidar(this.jdEditarIdentificacion.getCbx_Identificacion()));
            this.jdEditarIdentificacion.getCbx_Identificacion().addPropertyChangeListener(habilitar_Guardar);
        }
    }
}

