/*
 * Decompiled with CFR 0.152.
 */
package controlador.persona;

import com.toedter.calendar.JDateChooser;
import controlador.persona.WebCamCTR;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Color;
import java.awt.Image;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import modelo.COMBOS;
import modelo.lugar.LugarBD;
import modelo.lugar.LugarMD;
import modelo.persona.PersonaBD;
import modelo.persona.PersonaMD;
import modelo.validaciones.CmbValidar;
import modelo.validaciones.TxtVCedula;
import modelo.validaciones.TxtVCelular;
import modelo.validaciones.TxtVCorreo;
import modelo.validaciones.TxtVDireccion;
import modelo.validaciones.TxtVLetras;
import modelo.validaciones.TxtVNumCasa;
import modelo.validaciones.TxtVNumeros;
import modelo.validaciones.TxtVTelefono;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import vista.persona.FrmPersona;

public class FrmPersonaCTR
extends DCTR {
    private final FrmPersona frmPersona;
    private final PersonaBD PBD = PersonaBD.single();
    private TxtVCedula valCe;
    private int numAccion = 2;
    private final String[] idiomas = COMBOS.IDIOMAS;
    private ArrayList<LugarMD> paises;
    private ArrayList<LugarMD> distritos;
    private ArrayList<LugarMD> ciudades;
    private ArrayList<LugarMD> provincias;
    private ArrayList<LugarMD> cantones;
    private ArrayList<LugarMD> parroquias;
    private final LugarBD LBD = LugarBD.single();
    private FileInputStream fis = null;
    private int lonBytes = 0;
    private boolean editar = false;
    private int idPersona = 0;
    private boolean errorCedula = false;
    JDateChooser dateChooser = new JDateChooser("yyyy/MM/dd", "####/##/##", '_');

    public FrmPersonaCTR(FrmPersona frmPersona, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.frmPersona = frmPersona;
        this.cargarPaises();
    }

    public void iniciar() {
        this.ctrPrin.agregarVtn(this.frmPersona);
        this.frmPersona.getTxtIdentificacion().setEnabled(false);
        this.iniciarComponentes();
        this.cargarIdiomas();
        this.desactivarDiscapacidad(false);
        this.desactivarCategoriaMigratoria(false);
        this.iniciarValidaciones();
        this.frmPersona.getCmbNacionalidad().addActionListener(e -> this.cargarDistritosPais());
        this.frmPersona.getCmbProvincia().addActionListener(e -> this.cargarCiudadesDistrito());
        this.frmPersona.getCmbPaisReside().addActionListener(e -> this.cargarProvinciasResidencia());
        this.frmPersona.getCmbProvinciaReside().addActionListener(e -> this.cargarCantonesProvincia());
        this.frmPersona.getCmbCantonReside().addActionListener(e -> this.cargarParroquiaCanton());
        this.frmPersona.getCmbParroquiaReside().addActionListener(e -> this.cargarCodigoPostal());
        this.frmPersona.getCbxDiscapacidad().addActionListener(e -> this.activarDiscapacidad());
        this.frmPersona.getCbxCategoriaMigratoria().addActionListener(e -> this.activarCategoriaMigratoria());
        this.frmPersona.getBtnBuscarFoto().addActionListener(e -> this.buscarFoto());
        this.frmPersona.getBtnCapturarFoto().addActionListener(e -> this.capturarFotoWebCam());
        this.frmPersona.getBtnGuardarPersona().addActionListener(e -> this.guardarPersona());
        this.frmPersona.getBtnCancelar().addActionListener(e -> this.salirBoton());
        this.frmPersona.getBtnBuscarPersona().addActionListener(e -> this.consultar());
        this.frmPersona.getTxtIdentificacion().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FrmPersonaCTR.this.buscarIdentificacion();
            }
        });
        this.valCe = new TxtVCedula(this.frmPersona.getTxtIdentificacion(), this.frmPersona.getLblErrorIdentificacion());
        this.frmPersona.getTxtIdentificacion().addKeyListener(this.valCe);
        this.frmPersona.getCmbTipoId().addActionListener(e -> this.tipoID());
        this.cerrarVtn();
    }

    private void cerrarVtn() {
        this.frmPersona.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                FrmPersonaCTR.this.frmPersona.getTxtIdentificacion().setText("");
            }
        });
    }

    public boolean confirmaError() {
        return this.frmPersona.getLblErrorCallePrin().isVisible() || this.frmPersona.getLblErrorCalleSec().isVisible() || this.frmPersona.getLblErrorCanton().isVisible() || this.frmPersona.getLblErrorCantonReside().isVisible() || this.frmPersona.getLblErrorCarnetConadis().isVisible() || this.frmPersona.getLblErrorCelular().isVisible() || this.frmPersona.getLblErrorCodigoPostal().isVisible() || this.frmPersona.getLblErrorCorreo().isVisible() || this.frmPersona.getLblErrorEstadoCivil().isVisible() || this.frmPersona.getLblErrorEtnia().isVisible() || this.frmPersona.getLblErrorGenero().isVisible() || this.frmPersona.getLblErrorIdentificacion().isVisible() || this.frmPersona.getLblErrorIdioma().isVisible() || this.frmPersona.getLblErrorNacionalidad().isVisible() || this.frmPersona.getLblErrorPaisReside().isVisible() || this.frmPersona.getLblErrorPaisReside().isVisible() || this.frmPersona.getLblErrorCategoriaMigratoria().isVisible() || this.frmPersona.getLblErrorPorcentaje().isVisible() || this.frmPersona.getLblErrorPriApellido().isVisible() || this.frmPersona.getLblErrorPriNombre().isVisible() || this.frmPersona.getLblErrorProvincia().isVisible() || this.frmPersona.getLblErrorProvinciaReside().isVisible() || this.frmPersona.getLblErrorReferencia().isVisible() || this.frmPersona.getLblErrorSector().isVisible() || this.frmPersona.getLblErrorSegApellido().isVisible() || this.frmPersona.getLblErrorSegNombre().isVisible() || this.frmPersona.getLblErrorSexo().isVisible() || this.frmPersona.getLblErrorTelefono().isVisible() || this.frmPersona.getLblErrorTipoResidencia().isVisible() || this.frmPersona.getLblErrorTipoSangre().isVisible();
    }

    public void buscarIdentificacion() {
        this.errorCedula = false;
        String cedula = this.frmPersona.getTxtIdentificacion().getText();
        if (!cedula.equals("")) {
            if (this.valCe.isValidarCedula()) {
                if (!Validar.esCedula(cedula)) {
                    this.errorCedula = true;
                    this.frmPersona.getLblErrorIdentificacion().setText("C\u00e9dula incorrecta.");
                    this.frmPersona.getLblErrorIdentificacion().setVisible(true);
                } else {
                    this.frmPersona.getLblErrorIdentificacion().setVisible(false);
                }
            }
            if (!this.errorCedula) {
                PersonaMD per = this.PBD.existePersona(cedula);
                this.editar = true;
                if (per != null) {
                    if (!per.isPersonaActiva()) {
                        int dialog = 1;
                        int result = JOptionPane.showConfirmDialog(null, "Esta persona se encuentra eliminada.\n \u00bfDesea Activarla ? ", " Activar Persona", dialog);
                        if (result == 0) {
                            if (this.PBD.activarPersonaIdentificacion(per.getIdentificacion())) {
                                JOptionPane.showMessageDialog(null, "Persona activada correctamente");
                                this.editar(per);
                            } else {
                                JOptionPane.showMessageDialog(null, "NO SE PUDO ACTUALIZAR A LA PERSONA");
                            }
                        }
                    } else if (per.isPersonaActiva()) {
                        this.editar(per);
                        this.numAccion = 2;
                        this.iniciarValidaciones();
                    }
                } else {
                    this.numAccion = 0;
                    this.borrarCampos();
                    this.iniciarComponentes();
                    this.editar = false;
                    this.iniciarValidaciones();
                }
            }
        } else {
            this.borrarCampos();
            this.iniciarComponentes();
        }
    }

    private void tipoID() {
        int pos = this.frmPersona.getCmbTipoId().getSelectedIndex();
        this.frmPersona.getTxtIdentificacion().setEnabled(false);
        switch (pos) {
            case 1: {
                this.valCe.activarValidacion();
                this.frmPersona.getTxtIdentificacion().setEnabled(true);
                break;
            }
            case 2: {
                this.valCe.desactivarValidacion();
                this.frmPersona.getTxtIdentificacion().setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
                this.frmPersona.getLblErrorIdentificacion().setVisible(false);
                this.frmPersona.getTxtIdentificacion().setEnabled(true);
                break;
            }
            default: {
                this.frmPersona.getTxtIdentificacion().setEnabled(false);
            }
        }
    }

    private void desactivarDiscapacidad(boolean estado) {
        if (estado) {
            this.frmPersona.getLblTipoDiscapacidad().setVisible(estado);
            this.frmPersona.getCmbTipoDiscapacidad().setVisible(estado);
            this.frmPersona.getLblCarnetConadis().setVisible(estado);
            this.frmPersona.getTxtCarnetConadis().setVisible(estado);
            this.frmPersona.getLblPorcentaje().setVisible(estado);
            this.frmPersona.getTxtPorcentaje().setVisible(estado);
            if (estado) {
                this.frmPersona.getCmbTipoDiscapacidad().addActionListener(new CmbValidar(this.frmPersona.getCmbTipoDiscapacidad(), this.frmPersona.getLblErrorTipoDiscapacidad()));
            }
        } else {
            this.frmPersona.getLblTipoDiscapacidad().setVisible(estado);
            this.frmPersona.getCmbTipoDiscapacidad().setVisible(estado);
            this.frmPersona.getLblErrorTipoDiscapacidad().setVisible(estado);
            this.frmPersona.getLblCarnetConadis().setVisible(estado);
            this.frmPersona.getTxtCarnetConadis().setVisible(estado);
            this.frmPersona.getLblErrorCarnetConadis().setVisible(estado);
            this.frmPersona.getLblPorcentaje().setVisible(estado);
            this.frmPersona.getTxtPorcentaje().setVisible(estado);
            this.frmPersona.getLblErrorPorcentaje().setVisible(estado);
        }
    }

    public void desactivarCategoriaMigratoria(boolean estado) {
        if (estado) {
            this.frmPersona.getCmbCategoriaMigratoria().setVisible(estado);
            if (estado) {
                this.frmPersona.getCmbCategoriaMigratoria().addActionListener(new CmbValidar(this.frmPersona.getCmbCategoriaMigratoria(), this.frmPersona.getLblErrorCategoriaMigratoria()));
            }
        } else {
            this.frmPersona.getCmbCategoriaMigratoria().setVisible(estado);
            this.frmPersona.getLblErrorCategoriaMigratoria().setVisible(estado);
        }
    }

    private void activarCategoriaMigratoria() {
        boolean categoriaM = this.frmPersona.getCbxCategoriaMigratoria().isSelected();
        this.desactivarCategoriaMigratoria(categoriaM);
    }

    private void activarDiscapacidad() {
        boolean discapacidad = this.frmPersona.getCbxDiscapacidad().isSelected();
        this.desactivarDiscapacidad(discapacidad);
    }

    private void iniciarValidaciones() {
        PropertyChangeListener habilitar_Guardar = evt -> this.habilitarBtnGuardar();
        if (this.numAccion > 1) {
            this.frmPersona.getCmbIdiomas().addActionListener(new CmbValidar(this.frmPersona.getCmbIdiomas(), this.frmPersona.getLblErrorIdioma()));
            this.frmPersona.getCmbIdiomas().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbCanton().addActionListener(new CmbValidar(this.frmPersona.getCmbCanton(), this.frmPersona.getLblErrorCanton()));
            this.frmPersona.getCmbCanton().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbCantonReside().addActionListener(new CmbValidar(this.frmPersona.getCmbCantonReside(), this.frmPersona.getLblErrorCantonReside()));
            this.frmPersona.getCmbCantonReside().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbEstadoCivil().addActionListener(new CmbValidar(this.frmPersona.getCmbEstadoCivil(), this.frmPersona.getLblErrorEstadoCivil()));
            this.frmPersona.getCmbEstadoCivil().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbEtnia().addActionListener(new CmbValidar(this.frmPersona.getCmbEtnia(), this.frmPersona.getLblErrorEtnia()));
            this.frmPersona.getCmbEtnia().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbGenero().addActionListener(new CmbValidar(this.frmPersona.getCmbGenero(), this.frmPersona.getLblErrorGenero()));
            this.frmPersona.getCmbGenero().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbNacionalidad().addActionListener(new CmbValidar(this.frmPersona.getCmbNacionalidad(), this.frmPersona.getLblErrorNacionalidad()));
            this.frmPersona.getCmbNacionalidad().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbPaisReside().addActionListener(new CmbValidar(this.frmPersona.getCmbPaisReside(), this.frmPersona.getLblErrorPaisReside()));
            this.frmPersona.getCmbPaisReside().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbParroquiaReside().addActionListener(new CmbValidar(this.frmPersona.getCmbParroquiaReside(), this.frmPersona.getLblErrorParroquiaReside()));
            this.frmPersona.getCmbParroquiaReside().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbProvincia().addActionListener(new CmbValidar(this.frmPersona.getCmbProvincia(), this.frmPersona.getLblErrorProvincia()));
            this.frmPersona.getCmbProvincia().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbProvinciaReside().addActionListener(new CmbValidar(this.frmPersona.getCmbProvinciaReside(), this.frmPersona.getLblErrorProvinciaReside()));
            this.frmPersona.getCmbProvinciaReside().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbSexo().addActionListener(new CmbValidar(this.frmPersona.getCmbSexo(), this.frmPersona.getLblErrorSexo()));
            this.frmPersona.getCmbSexo().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbTipoDiscapacidad().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbTipoId().addActionListener(new CmbValidar(this.frmPersona.getCmbTipoId()));
            this.frmPersona.getCmbTipoId().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbTipoResidencia().addActionListener(new CmbValidar(this.frmPersona.getCmbTipoResidencia(), this.frmPersona.getLblErrorTipoResidencia()));
            this.frmPersona.getCmbTipoResidencia().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbTipoSangre().addActionListener(new CmbValidar(this.frmPersona.getCmbTipoSangre(), this.frmPersona.getLblErrorTipoSangre()));
            this.frmPersona.getCmbTipoSangre().addPropertyChangeListener(habilitar_Guardar);
            this.frmPersona.getCmbCategoriaMigratoria().addPropertyChangeListener(habilitar_Guardar);
        }
        this.frmPersona.getTxtCallePrincipal().addKeyListener(new TxtVDireccion(this.frmPersona.getTxtCallePrincipal(), this.frmPersona.getLblErrorCallePrin()));
        this.frmPersona.getTxtCallePrincipal().addPropertyChangeListener(habilitar_Guardar);
        this.frmPersona.getTxtCalleSecundaria().addKeyListener(new TxtVDireccion(this.frmPersona.getTxtCalleSecundaria(), this.frmPersona.getLblErrorCalleSec()));
        this.frmPersona.getTxtCelular().addKeyListener(new TxtVCelular(this.frmPersona.getTxtCelular(), this.frmPersona.getLblErrorCelular()));
        this.frmPersona.getTxtCodigoPostal().addKeyListener(new TxtVNumeros(this.frmPersona.getTxtCodigoPostal(), this.frmPersona.getLblErrorCodigoPostal()));
        this.frmPersona.getTxtCodigoPostal().addPropertyChangeListener(habilitar_Guardar);
        this.frmPersona.getTxtPorcentaje().addKeyListener(new TxtVNumeros(this.frmPersona.getTxtPorcentaje(), this.frmPersona.getLblErrorPorcentaje()));
        this.frmPersona.getTxtPorcentaje().addPropertyChangeListener(habilitar_Guardar);
        this.frmPersona.getTxtPrimerApellido().addKeyListener(new TxtVLetras(this.frmPersona.getTxtPrimerApellido(), this.frmPersona.getLblErrorPriApellido()));
        this.frmPersona.getTxtPrimerApellido().addPropertyChangeListener(habilitar_Guardar);
        this.frmPersona.getTxtPrimerNombre().addKeyListener(new TxtVLetras(this.frmPersona.getTxtPrimerNombre(), this.frmPersona.getLblErrorPriNombre()));
        this.frmPersona.getTxtPrimerNombre().addPropertyChangeListener(habilitar_Guardar);
        this.frmPersona.getTxtReferencia().addKeyListener(new TxtVLetras(this.frmPersona.getTxtReferencia(), this.frmPersona.getLblErrorReferencia()));
        this.frmPersona.getTxtSector().addKeyListener(new TxtVLetras(this.frmPersona.getTxtSector(), this.frmPersona.getLblErrorSector()));
        this.frmPersona.getTxtSegundoApellido().addKeyListener(new TxtVLetras(this.frmPersona.getTxtSegundoApellido(), this.frmPersona.getLblErrorSegApellido()));
        this.frmPersona.getTxtSegundoApellido().addPropertyChangeListener(habilitar_Guardar);
        this.frmPersona.getTxtSegundoNombre().addKeyListener(new TxtVLetras(this.frmPersona.getTxtSegundoNombre(), this.frmPersona.getLblErrorSegNombre()));
        this.frmPersona.getTxtSegundoNombre().addPropertyChangeListener(habilitar_Guardar);
        this.frmPersona.getTxtTelefono().addKeyListener(new TxtVTelefono(this.frmPersona.getTxtTelefono(), this.frmPersona.getLblErrorTelefono()));
        this.frmPersona.getTxtCorreo().addKeyListener(new TxtVCorreo(this.frmPersona.getTxtCorreo(), this.frmPersona.getLblErrorCorreo()));
        this.frmPersona.getTxtNumeroCasa().addKeyListener(new TxtVNumCasa(this.frmPersona.getTxtNumeroCasa(), this.frmPersona.getLblErrorNumeroCasa()));
        this.frmPersona.getTxtNumeroCasa().addPropertyChangeListener(habilitar_Guardar);
    }

    public void buscarFoto() {
        this.frmPersona.getLblFoto().setIcon(null);
        JFileChooser j = new JFileChooser();
        j.setFileSelectionMode(0);
        int estado = j.showOpenDialog(null);
        if (estado == 0) {
            try {
                this.fis = new FileInputStream(j.getSelectedFile());
                this.lonBytes = (int)j.getSelectedFile().length();
                System.out.println("Longitud de foto buscada " + this.lonBytes);
                System.out.println("FIle input stream " + this.fis);
                Image icono = ImageIO.read(j.getSelectedFile()).getScaledInstance(this.frmPersona.getLblFoto().getWidth(), this.frmPersona.getLblFoto().getHeight(), 4);
                this.frmPersona.getLblFoto().setIcon(new ImageIcon(icono));
                this.frmPersona.getLblFoto().updateUI();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "No se puedo cargar la imagen");
                System.out.println("Nose puedo cargar la imagen" + e.getMessage());
            }
        }
    }

    private void capturarFotoWebCam() {
        WebCamCTR ctrCam = new WebCamCTR(this.frmPersona, this, this.ctrPrin);
        ctrCam.iniciarCamara();
        this.habilitarBtnGuardar();
    }

    public void habilitarBtnGuardar() {
        String TipoId = this.frmPersona.getCmbTipoId().getSelectedItem().toString();
        String Identificacion = this.frmPersona.getTxtIdentificacion().getText();
        String PriNombre = this.frmPersona.getTxtPrimerNombre().getText();
        String PriApellido = this.frmPersona.getTxtPrimerApellido().getText();
        String EstadoCivil = this.frmPersona.getCmbEstadoCivil().getSelectedItem().toString();
        String IdiomaRaiz = this.frmPersona.getCmbIdiomas().getSelectedItem().toString();
        String Sexo = this.frmPersona.getCmbSexo().getSelectedItem().toString();
        String Genero = this.frmPersona.getCmbGenero().getSelectedItem().toString();
        String TipoSangre = this.frmPersona.getCmbTipoSangre().getSelectedItem().toString();
        String Etnia = this.frmPersona.getCmbEtnia().getSelectedItem().toString();
        String CallePrin = this.frmPersona.getTxtCallePrincipal().getText();
        if (!this.confirmaError()) {
            if (!(TipoId.equals("SELECCIONE") || Identificacion.equals("") || PriNombre.equals("") || PriApellido.equals("") || EstadoCivil.equals("SELECCIONE") || IdiomaRaiz.equals("SELECCIONE") || Sexo.equals("SELECCIONE") || Genero.equals("SELECCIONE") || TipoSangre.equals("SELECCIONE") || Etnia.equals("SELECCIONE") || CallePrin.equals(""))) {
                this.frmPersona.getBtnGuardarPersona().setEnabled(true);
            } else {
                this.frmPersona.getBtnGuardarPersona().setEnabled(false);
            }
        } else {
            this.frmPersona.getBtnGuardarPersona().setEnabled(false);
        }
    }

    public void guardarPersona() {
        boolean discapacidad;
        String priNombre;
        LocalDate fechaActual;
        LocalDate fechaNacimiento = fechaActual = LocalDate.now();
        boolean guardar = true;
        String estadoCivil = "a";
        String tipoSangre = "a";
        String genero = "a";
        String sexo = "a";
        String etnia = "a";
        String carnetConadis = "a";
        String tipoDiscapacidad = "a";
        String porcentajeDiscapacidad = "a";
        String idiomaRaiz = "a";
        String comboCategoriaMigra = "a";
        String identificacion = this.frmPersona.getTxtIdentificacion().getText().trim().toUpperCase();
        int tipoIdentifi = this.frmPersona.getCmbTipoId().getSelectedIndex();
        if (tipoIdentifi == 1) {
            if (!Validar.esCedula(identificacion)) {
                guardar = false;
                this.frmPersona.getLblErrorIdentificacion().setVisible(true);
            } else {
                this.frmPersona.getLblErrorIdentificacion().setVisible(false);
            }
        }
        if (!Validar.esLetras(priNombre = this.frmPersona.getTxtPrimerNombre().getText().trim().toUpperCase())) {
            guardar = false;
            this.frmPersona.getLblErrorPriNombre().setVisible(true);
        } else {
            this.frmPersona.getLblErrorPriNombre().setVisible(false);
        }
        String segNombre = this.frmPersona.getTxtSegundoNombre().getText().trim().toUpperCase();
        String priApellido = this.frmPersona.getTxtPrimerApellido().getText().trim().toUpperCase();
        if (!Validar.esLetras(priApellido)) {
            guardar = false;
            this.frmPersona.getLblErrorPriApellido().setVisible(true);
        } else {
            this.frmPersona.getLblErrorPriApellido().setVisible(false);
        }
        String segApellido = this.frmPersona.getTxtSegundoApellido().getText().trim().toUpperCase();
        if (this.frmPersona.getJdfechaNacimiento().isValid()) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            Date fecha = this.frmPersona.getJdfechaNacimiento().getDate();
            String fechaNac = sdf.format(fecha);
            String[] fec = fechaNac.split("/");
            if (Integer.parseInt(fec[2]) > fechaActual.getYear() || Integer.parseInt(fec[2]) > fechaActual.getYear() - 16) {
                guardar = false;
                this.frmPersona.getLblErrorFecNac().setVisible(true);
            } else {
                fechaNacimiento = LocalDate.of(Integer.parseInt(fec[2]), Integer.parseInt(fec[1]), Integer.parseInt(fec[0]));
                this.frmPersona.getLblErrorFecNac().setVisible(false);
            }
        } else {
            this.frmPersona.getLblErrorFecNac().setVisible(false);
        }
        if (this.frmPersona.getCmbEstadoCivil().getSelectedIndex() < 1) {
            guardar = false;
            this.frmPersona.getLblErrorEstadoCivil().setVisible(true);
        } else {
            estadoCivil = this.frmPersona.getCmbEstadoCivil().getSelectedItem().toString();
            this.frmPersona.getLblErrorEstadoCivil().setVisible(false);
        }
        if (this.frmPersona.getCmbGenero().getSelectedIndex() < 1) {
            guardar = false;
            this.frmPersona.getLblErrorGenero().setVisible(true);
        } else {
            genero = this.frmPersona.getCmbGenero().getSelectedItem().toString();
            this.frmPersona.getLblErrorGenero().setVisible(false);
        }
        if (this.frmPersona.getCmbSexo().getSelectedIndex() < 1) {
            guardar = false;
            this.frmPersona.getLblErrorSexo().setVisible(true);
        } else {
            sexo = this.frmPersona.getCmbSexo().getSelectedItem().toString();
            this.frmPersona.getLblErrorSexo().setVisible(false);
        }
        if (this.frmPersona.getCmbEtnia().getSelectedIndex() < 1) {
            guardar = false;
            this.frmPersona.getLblErrorEtnia().setVisible(true);
        } else {
            etnia = this.frmPersona.getCmbEtnia().getSelectedItem().toString();
            this.frmPersona.getLblErrorEtnia().setVisible(false);
        }
        if (this.frmPersona.getCmbTipoResidencia().getSelectedIndex() < 1) {
            guardar = false;
            this.frmPersona.getLblTipoDiscapacidad().setVisible(true);
        } else {
            this.frmPersona.getLblErrorTipoResidencia().setVisible(false);
        }
        if (this.frmPersona.getCmbTipoSangre().getSelectedIndex() < 1) {
            guardar = false;
            this.frmPersona.getLblErrorTipoSangre().setVisible(true);
        } else {
            tipoSangre = this.frmPersona.getCmbTipoSangre().getSelectedItem().toString();
            this.frmPersona.getLblErrorTipoSangre().setVisible(false);
        }
        boolean categoriaMigra = this.frmPersona.getCbxCategoriaMigratoria().isSelected();
        if (categoriaMigra) {
            if (this.frmPersona.getCmbCategoriaMigratoria().getSelectedIndex() < 1) {
                this.frmPersona.getLblErrorCategoriaMigratoria().setVisible(true);
            } else {
                comboCategoriaMigra = this.frmPersona.getCmbCategoriaMigratoria().getSelectedItem().toString();
                this.frmPersona.getLblErrorCategoriaMigratoria().setVisible(false);
            }
        }
        if (discapacidad = this.frmPersona.getCbxDiscapacidad().isSelected()) {
            if (this.frmPersona.getCmbTipoDiscapacidad().getSelectedIndex() < 1) {
                this.frmPersona.getLblErrorTipoDiscapacidad().setVisible(true);
            } else {
                tipoDiscapacidad = this.frmPersona.getCmbTipoDiscapacidad().getSelectedItem().toString();
                this.frmPersona.getLblErrorTipoDiscapacidad().setVisible(false);
            }
            porcentajeDiscapacidad = this.frmPersona.getTxtPorcentaje().getText().trim().toUpperCase();
            if (!Validar.esNumeros(porcentajeDiscapacidad)) {
                guardar = false;
                this.frmPersona.getLblErrorPorcentaje().setVisible(true);
            } else {
                porcentajeDiscapacidad = this.frmPersona.getTxtPorcentaje().getText();
                this.frmPersona.getLblErrorPorcentaje().setVisible(false);
            }
            carnetConadis = this.frmPersona.getTxtCarnetConadis().getText();
        }
        if (this.frmPersona.getCmbIdiomas().getSelectedIndex() < 1) {
            guardar = false;
            this.frmPersona.getLblErrorIdioma().setVisible(true);
        } else {
            idiomaRaiz = this.frmPersona.getCmbIdiomas().getSelectedItem().toString();
            this.frmPersona.getLblErrorIdioma().setVisible(false);
        }
        String telefono = this.frmPersona.getTxtTelefono().getText().trim().toUpperCase();
        String callePrin = this.frmPersona.getTxtCallePrincipal().getText().trim().toUpperCase();
        if (!Validar.esDireccion(callePrin)) {
            this.frmPersona.getLblErrorCallePrin().setVisible(true);
            guardar = false;
        } else {
            this.frmPersona.getLblErrorCallePrin().setVisible(false);
        }
        String calleSec = this.frmPersona.getTxtCalleSecundaria().getText().trim().toUpperCase().toUpperCase();
        String referencia = this.frmPersona.getTxtReferencia().getText().trim().toUpperCase();
        String celular = this.frmPersona.getTxtCelular().getText().trim().toUpperCase();
        LugarMD lugarNac = null;
        LugarMD lugarRes = null;
        int posNac = this.frmPersona.getCmbNacionalidad().getSelectedIndex();
        if (posNac > 0 && posNac <= this.paises.size()) {
            this.frmPersona.getLblErrorNacionalidad().setVisible(false);
            lugarNac = this.paises.get(posNac - 1);
            int posDis = this.frmPersona.getCmbProvincia().getSelectedIndex();
            if (posDis > 0 && posDis <= this.distritos.size()) {
                this.frmPersona.getLblErrorProvincia().setVisible(false);
                lugarNac = this.distritos.get(posDis - 1);
                int posCi = this.frmPersona.getCmbCanton().getSelectedIndex();
                if (posCi > 0 && posCi <= this.ciudades.size()) {
                    this.frmPersona.getLblErrorCanton().setVisible(false);
                    lugarNac = this.ciudades.get(posCi - 1);
                } else {
                    this.frmPersona.getLblErrorCanton().setVisible(true);
                }
            } else {
                this.frmPersona.getLblErrorProvincia().setVisible(true);
            }
        } else {
            this.frmPersona.getLblErrorNacionalidad().setVisible(true);
        }
        int posPro = this.frmPersona.getCmbProvinciaReside().getSelectedIndex();
        if (posPro > 0 && posPro <= this.provincias.size()) {
            this.frmPersona.getLblErrorProvinciaReside().setVisible(false);
            lugarRes = this.provincias.get(posPro - 1);
            int posCa = this.frmPersona.getCmbCantonReside().getSelectedIndex();
            if (posCa > 0 && posCa <= this.cantones.size()) {
                this.frmPersona.getLblErrorCantonReside().setVisible(false);
                lugarRes = this.cantones.get(posCa - 1);
                int posPr = this.frmPersona.getCmbParroquiaReside().getSelectedIndex();
                if (posPr > 0 && posPr <= this.parroquias.size()) {
                    this.frmPersona.getLblErrorParroquiaReside().setVisible(false);
                    lugarRes = this.parroquias.get(posPr - 1);
                }
            } else {
                this.frmPersona.getLblErrorCantonReside().setVisible(true);
            }
        } else {
            this.frmPersona.getLblErrorProvinciaReside().setVisible(true);
        }
        String numCasa = this.frmPersona.getTxtNumeroCasa().getText().trim().toUpperCase();
        String sector = this.frmPersona.getTxtSector().getText().trim().toUpperCase();
        String zonaResidencia = this.frmPersona.getCmbTipoResidencia().getSelectedItem().toString().trim().toUpperCase();
        String correo = this.frmPersona.getTxtCorreo().getText().trim();
        if (guardar) {
            PersonaMD per = new PersonaMD();
            per.setFile(this.fis);
            per.setLogBytes(this.lonBytes);
            per.setIdentificacion(identificacion);
            per.setPrimerNombre(priNombre);
            per.setSegundoNombre(segNombre);
            per.setPrimerApellido(priApellido);
            per.setSegundoApellido(segApellido);
            per.setFechaNacimiento(fechaNacimiento);
            per.setEstadoCivil(estadoCivil);
            per.setCelular(celular);
            per.setTelefono(telefono);
            per.setIdiomaRaiz(idiomaRaiz);
            per.setIdioma(idiomaRaiz);
            per.setTipoSangre(tipoSangre);
            per.setGenero(genero);
            per.setSexo(sexo.charAt(0));
            per.setEtnia(etnia);
            per.setCorreo(correo);
            if (discapacidad) {
                per.setDiscapacidad(discapacidad);
                per.setCarnetConadis(carnetConadis);
                per.setTipoDiscapacidad(tipoDiscapacidad);
                per.setPorcentajeDiscapacidad(Integer.parseInt(porcentajeDiscapacidad));
            }
            if (categoriaMigra) {
                per.setCategoriaMigratoria(comboCategoriaMigra);
            }
            per.setLugarNatal(lugarNac);
            per.setLugarResidencia(lugarRes);
            per.setTipoResidencia(zonaResidencia);
            per.setCallePrincipal(callePrin);
            per.setCalleSecundaria(calleSec);
            per.setReferencia(referencia);
            per.setSector(sector);
            per.setNumeroCasa(numCasa);
            per.setFechaRegistro(fechaActual);
            if (this.editar) {
                if (this.idPersona > 0) {
                    per.setIdPersona(this.idPersona);
                    if (this.fis != null) {
                        if (this.PBD.editarPersonaConFoto(per)) {
                            JOptionPane.showMessageDialog(null, "Datos Editados Correctamente.");
                            this.botonreportepersona();
                            this.borrarCamposConId();
                            this.iniciarComponentes();
                        } else {
                            JOptionPane.showMessageDialog(null, "No se pudo editar,\nRevise su conexion a internet. ");
                        }
                    } else if (this.PBD.editarPersona(per)) {
                        JOptionPane.showMessageDialog(null, "Datos Editados Correctamente.");
                        this.botonreportepersona();
                        this.borrarCamposConId();
                        this.iniciarComponentes();
                    } else {
                        JOptionPane.showMessageDialog(null, "No se pudo editar,\nRevise su conexion a internet. ");
                    }
                    this.editar = false;
                }
            } else if (this.fis != null) {
                this.PBD.insertarPersonaConFoto(per);
                JOptionPane.showMessageDialog(null, "Datos guardados correctamente.");
                this.botonreportepersona();
                this.borrarCampos();
                this.iniciarComponentes();
            } else {
                this.PBD.insertarPersona(per);
                JOptionPane.showMessageDialog(null, "Datos guardados correctamente.");
                this.botonreportepersona();
                this.borrarCampos();
                this.iniciarComponentes();
            }
            this.frmPersona.dispose();
            this.ctrPrin.cerradoJIF();
        } else {
            JOptionPane.showMessageDialog(null, "Existen errores en los campos\nRevise su informaci\u00f3n!!");
        }
    }

    public void salirBoton() {
        this.frmPersona.dispose();
    }

    private void consultar() {
        String identificacion = this.frmPersona.getTxtIdentificacion().getText();
        PersonaMD per = this.PBD.buscarPersona(identificacion);
        if (per != null) {
            this.editar(per);
        }
    }

    public void editar(PersonaMD per) {
        this.idPersona = per.getIdPersona();
        System.out.println("id" + this.idPersona);
        this.editar = true;
        String cedula = per.getIdentificacion();
        Date fecha = new Date();
        Calendar fecha_Nacimiento = Calendar.getInstance();
        fecha_Nacimiento.clear();
        fecha_Nacimiento.set(per.getFechaNacimiento().getYear(), per.getFechaNacimiento().getMonthValue() - 1, per.getFechaNacimiento().getDayOfMonth());
        if (Validar.esCedula(cedula)) {
            this.frmPersona.getCmbTipoId().setSelectedItem("CEDULA");
        } else {
            this.frmPersona.getCmbTipoId().setSelectedItem("PASAPORTE");
        }
        this.frmPersona.getTxtIdentificacion().setEnabled(true);
        this.frmPersona.getTxtIdentificacion().setText(per.getIdentificacion());
        this.frmPersona.getTxtCallePrincipal().setText(per.getCallePrincipal());
        this.frmPersona.getTxtCalleSecundaria().setText(per.getCalleSecundaria());
        this.frmPersona.getTxtCelular().setText(per.getCelular());
        this.frmPersona.getTxtCorreo().setText(per.getCorreo());
        this.frmPersona.getTxtNumeroCasa().setText(per.getNumeroCasa());
        this.frmPersona.getTxtPrimerApellido().setText(per.getPrimerApellido());
        this.frmPersona.getTxtPrimerNombre().setText(per.getPrimerNombre());
        this.frmPersona.getTxtReferencia().setText(per.getReferencia());
        this.frmPersona.getTxtSector().setText(per.getSector());
        this.frmPersona.getTxtSegundoApellido().setText(per.getSegundoApellido());
        this.frmPersona.getTxtSegundoNombre().setText(per.getSegundoNombre());
        this.frmPersona.getTxtTelefono().setText(per.getTelefono());
        if (per.getEstadoCivil() == null) {
            this.frmPersona.getCmbEstadoCivil().setSelectedItem("SELECCIONE");
        } else {
            this.frmPersona.getCmbEstadoCivil().setSelectedItem(per.getEstadoCivil());
        }
        if (!per.isDiscapacidad()) {
            this.activarDiscapacidad();
            this.frmPersona.getCbxDiscapacidad().setSelected(false);
            this.frmPersona.getCmbTipoDiscapacidad().setSelectedItem("SELECCIONE");
            this.frmPersona.getTxtCarnetConadis().setText("");
            this.frmPersona.getTxtPorcentaje().setText("");
        } else {
            this.frmPersona.getCbxDiscapacidad().setSelected(per.isDiscapacidad());
            this.activarDiscapacidad();
            this.frmPersona.getCmbTipoDiscapacidad().setSelectedItem(per.getTipoDiscapacidad());
            this.frmPersona.getTxtCarnetConadis().setText(per.getCarnetConadis());
            this.frmPersona.getTxtPorcentaje().setText(per.getPorcentajeDiscapacidad() + "");
        }
        if (per.getIdiomaRaiz() == null) {
            this.frmPersona.getCmbIdiomas().setSelectedItem("SELECCIONE");
        } else {
            this.frmPersona.getCmbIdiomas().setSelectedItem(per.getIdiomaRaiz());
        }
        if (per.getCategoriaMigratoria() == null) {
            this.frmPersona.getCmbCategoriaMigratoria().setSelectedItem("SELECCIONE");
        } else {
            this.frmPersona.getCbxCategoriaMigratoria().isSelected();
            this.activarCategoriaMigratoria();
            this.frmPersona.getCmbCategoriaMigratoria().setSelectedItem(per.getCategoriaMigratoria());
        }
        this.frmPersona.getJdfechaNacimiento().setCalendar(fecha_Nacimiento);
        String sexo = per.getSexo() + "";
        sexo = "H".equals(sexo) ? "HOMBRE" : "MUJER";
        this.frmPersona.getCmbSexo().setSelectedItem(sexo);
        this.frmPersona.getCmbTipoSangre().setSelectedItem(per.getTipoSangre().trim());
        this.frmPersona.getCmbGenero().setSelectedItem(per.getGenero());
        this.frmPersona.getCmbEtnia().setSelectedItem(per.getEtnia());
        this.frmPersona.getCmbTipoResidencia().setSelectedItem(per.getTipoResidencia());
        this.frmPersona.getCmbNacionalidad().setSelectedItem(per.getLugarNatal());
        this.frmPersona.getCmbProvincia().setSelectedItem(per.getLugarNatal());
        this.frmPersona.getCmbCanton().setSelectedItem(per.getLugarNatal());
        this.frmPersona.getCmbProvinciaReside().setSelectedItem(per.getLugarResidencia());
        this.frmPersona.getCmbParroquiaReside().setSelectedItem(per.getLugarResidencia());
        this.frmPersona.getCmbPaisReside().setSelectedItem(per.getLugarResidencia());
        this.frmPersona.getCmbCantonReside().setSelectedItem(per.getLugarResidencia());
        if (per.getFoto() != null) {
            Image icono = per.getFoto().getScaledInstance(this.frmPersona.getLblFoto().getWidth(), this.frmPersona.getLblFoto().getHeight(), 4);
            this.frmPersona.getLblFoto().setIcon(new ImageIcon(icono));
            this.frmPersona.getLblFoto().updateUI();
        } else {
            this.frmPersona.getLblFoto().setIcon(null);
            this.frmPersona.getLblFoto().updateUI();
        }
        int nvlLugarNac = 0;
        if (per.getLugarNatal() != null) {
            nvlLugarNac = Integer.parseInt(per.getLugarNatal().getNivel());
        }
        String ciudad = null;
        String distrito = null;
        if (nvlLugarNac == 3) {
            ciudad = per.getLugarNatal().getNombre();
            per.setLugarNatal(this.LBD.buscar(per.getLugarNatal().getIdReferencia()));
        }
        if ((nvlLugarNac = Integer.parseInt(per.getLugarNatal().getNivel())) == 2) {
            distrito = per.getLugarNatal().getNombre();
            per.setLugarNatal(this.LBD.buscar(per.getLugarNatal().getIdReferencia()));
        }
        if ((nvlLugarNac = Integer.parseInt(per.getLugarNatal().getNivel())) == 1) {
            this.cargarPaises();
            this.frmPersona.getCmbNacionalidad().setSelectedItem(per.getLugarNatal().getNombre());
            if (distrito != null) {
                this.frmPersona.getCmbProvincia().setSelectedItem(distrito);
            }
            if (ciudad != null) {
                this.frmPersona.getCmbCanton().setSelectedItem(ciudad);
            }
        }
        System.out.println("Nivel de lugar residencia  " + per.getLugarResidencia().getNivel());
        int nvlLugarRes = per.getLugarResidencia().getNivel() == null ? 0 : Integer.parseInt(per.getLugarResidencia().getNivel());
        String parroquia = null;
        String canton = null;
        String provincia = null;
        if (nvlLugarRes == 4) {
            parroquia = per.getLugarResidencia().getNombre();
            per.setLugarResidencia(this.LBD.buscar(per.getLugarResidencia().getIdReferencia()));
        }
        if ((nvlLugarRes = per.getLugarResidencia().getNivel() == null ? 0 : Integer.parseInt(per.getLugarResidencia().getNivel())) == 3) {
            canton = per.getLugarResidencia().getNombre();
            per.setLugarResidencia(this.LBD.buscar(per.getLugarResidencia().getIdReferencia()));
        }
        if ((nvlLugarRes = per.getLugarResidencia().getNivel() == null ? 0 : Integer.parseInt(per.getLugarResidencia().getNivel())) == 2) {
            provincia = per.getLugarResidencia().getNombre();
            per.setLugarResidencia(this.LBD.buscar(per.getLugarResidencia().getIdReferencia()));
        }
        nvlLugarRes = per.getLugarResidencia().getNivel() == null ? 0 : Integer.parseInt(per.getLugarResidencia().getNivel());
        System.out.println("Pais reside " + per.getLugarResidencia().getNombre());
        if (nvlLugarRes == 1) {
            this.frmPersona.getCmbPaisReside().setSelectedItem(per.getLugarResidencia().getNombre());
            if (provincia != null) {
                this.frmPersona.getCmbProvinciaReside().setSelectedItem(provincia);
            }
            if (canton != null) {
                this.frmPersona.getCmbCantonReside().setSelectedItem(canton);
            }
            if (parroquia != null) {
                this.frmPersona.getCmbParroquiaReside().setSelectedItem(parroquia);
            }
        }
        this.iniciarValidaciones();
    }

    public void iniciarComponentes() {
        this.frmPersona.getCmbTipoId().setToolTipText("Seleccione un Tipo de Identificaci\u00f3n");
        this.frmPersona.getTxtIdentificacion().setToolTipText("Ingrese una Identificaci\u00f3n v\u00e1lida y espere la respuesta del Sistema");
        this.frmPersona.getTxtPrimerNombre().setToolTipText("Ingrese su primer nombre");
        this.frmPersona.getTxtSegundoNombre().setToolTipText("Ingrese su segundo nombre");
        this.frmPersona.getTxtPrimerApellido().setToolTipText("Ingrese su primer apellido");
        this.frmPersona.getTxtSegundoApellido().setToolTipText("Ingrese su segundo apellido");
        this.frmPersona.getTxtCallePrincipal().setToolTipText("Ingrese su calle principal");
        this.frmPersona.getTxtCalleSecundaria().setToolTipText("Ingrese su calle secundaria");
        this.frmPersona.getTxtCarnetConadis().setToolTipText("Ingrese un carnet de conadis valido");
        this.frmPersona.getTxtCelular().setToolTipText("Ingrese su numero de celular");
        this.frmPersona.getTxtCodigoPostal().setToolTipText("Ingrese su codigo postal");
        this.frmPersona.getTxtCorreo().setToolTipText("Ingrese su correo");
        this.frmPersona.getTxtNumeroCasa().setToolTipText("Ingrese el numero de casa");
        this.frmPersona.getTxtPorcentaje().setToolTipText("Ingrese el porcentaje de discapacidad");
        this.frmPersona.getTxtReferencia().setToolTipText("Ingrese una referencia de su direccion");
        this.frmPersona.getTxtSector().setToolTipText("Ingrese el sector donde vive");
        this.frmPersona.getTxtTelefono().setToolTipText("Ingrese su numero convencional");
        this.frmPersona.getLblErrorCategoriaMigratoria().setVisible(false);
        this.frmPersona.getLblErrorCallePrin().setVisible(false);
        this.frmPersona.getLblErrorCalleSec().setVisible(false);
        this.frmPersona.getLblErrorCanton().setVisible(false);
        this.frmPersona.getLblErrorCantonReside().setVisible(false);
        this.frmPersona.getLblErrorCarnetConadis().setVisible(false);
        this.frmPersona.getLblErrorCelular().setVisible(false);
        this.frmPersona.getLblErrorCodigoPostal().setVisible(false);
        this.frmPersona.getLblErrorCorreo().setVisible(false);
        this.frmPersona.getLblErrorEstadoCivil().setVisible(false);
        this.frmPersona.getLblErrorEtnia().setVisible(false);
        this.frmPersona.getLblErrorFecNac().setVisible(false);
        this.frmPersona.getLblErrorGenero().setVisible(false);
        this.frmPersona.getLblErrorIdentificacion().setVisible(false);
        this.frmPersona.getLblErrorIdioma().setVisible(false);
        this.frmPersona.getLblErrorNacionalidad().setVisible(false);
        this.frmPersona.getLblErrorNumeroCasa().setVisible(false);
        this.frmPersona.getLblErrorParroquiaReside().setVisible(false);
        this.frmPersona.getLblErrorPorcentaje().setVisible(false);
        this.frmPersona.getLblErrorPriApellido().setVisible(false);
        this.frmPersona.getLblErrorPriNombre().setVisible(false);
        this.frmPersona.getLblErrorProvincia().setVisible(false);
        this.frmPersona.getLblErrorProvinciaReside().setVisible(false);
        this.frmPersona.getLblErrorReferencia().setVisible(false);
        this.frmPersona.getLblErrorSector().setVisible(false);
        this.frmPersona.getLblErrorSegApellido().setVisible(false);
        this.frmPersona.getLblErrorSegNombre().setVisible(false);
        this.frmPersona.getLblErrorSexo().setVisible(false);
        this.frmPersona.getLblErrorTelefono().setVisible(false);
        this.frmPersona.getLblErrorTipoDiscapacidad().setVisible(false);
        this.frmPersona.getLblErrorTipoResidencia().setVisible(false);
        this.frmPersona.getLblErrorTipoSangre().setVisible(false);
        this.frmPersona.getLblErrorPaisReside().setVisible(false);
    }

    private void cargarIdiomas() {
        this.frmPersona.getCmbIdiomas().removeAllItems();
        this.frmPersona.getCmbIdiomas().addItem("SELECCIONE");
        for (String i : this.idiomas) {
            this.frmPersona.getCmbIdiomas().addItem(i.toUpperCase());
        }
    }

    private void cargarPaises() {
        this.paises = this.LBD.buscarPaises();
        this.paises = this.reordenarArray(this.paises, "ECUADOR");
        this.frmPersona.getCmbNacionalidad().removeAllItems();
        this.frmPersona.getCmbNacionalidad().addItem("SELECCIONE");
        this.frmPersona.getCmbPaisReside().removeAllItems();
        this.frmPersona.getCmbPaisReside().addItem("SELECCIONE");
        this.paises.forEach(l -> {
            this.frmPersona.getCmbNacionalidad().addItem(l.getNombre());
            this.frmPersona.getCmbPaisReside().addItem(l.getNombre());
        });
    }

    private ArrayList<LugarMD> reordenarArray(ArrayList<LugarMD> lugares, String primerItem) {
        ArrayList<LugarMD> lugaresOrdenados = new ArrayList<LugarMD>();
        lugares.forEach(l -> {
            if (l.getNombre().equalsIgnoreCase(primerItem)) {
                lugaresOrdenados.add((LugarMD)l);
            }
        });
        lugares.forEach(l -> {
            if (!l.getNombre().equalsIgnoreCase(primerItem)) {
                lugaresOrdenados.add((LugarMD)l);
            }
        });
        return lugaresOrdenados;
    }

    public void cargarDistritosPais() {
        int posNac = this.frmPersona.getCmbNacionalidad().getSelectedIndex();
        if (posNac > 0) {
            this.frmPersona.getLblErrorProvincia().setVisible(false);
            this.distritos = this.LBD.buscarPorReferencia(this.paises.get(posNac - 1).getId());
            this.distritos = this.reordenarArray(this.distritos, "PROVINCIA DEL AZUAY");
            this.cargarCmbLugares(this.frmPersona.getCmbProvincia(), this.distritos);
        } else {
            this.frmPersona.getLblErrorProvincia().setVisible(true);
        }
    }

    public void cargarCiudadesDistrito() {
        int posDis = this.frmPersona.getCmbProvincia().getSelectedIndex();
        if (posDis > 0) {
            this.frmPersona.getLblErrorCanton().setVisible(false);
            this.ciudades = this.LBD.buscarPorReferencia(this.distritos.get(posDis - 1).getId());
            this.cargarCmbLugares(this.frmPersona.getCmbCanton(), this.ciudades);
        } else {
            this.frmPersona.getLblErrorCanton().setVisible(true);
        }
    }

    private void cargarProvinciasResidencia() {
        int posPaisRe = this.frmPersona.getCmbPaisReside().getSelectedIndex();
        if (posPaisRe > 0) {
            this.frmPersona.getLblErrorPaisReside().setVisible(false);
            this.provincias = this.LBD.buscarPorReferencia(this.paises.get(posPaisRe - 1).getId());
            this.provincias = this.reordenarArray(this.provincias, "PROVINCIA DEL AZUAY");
            this.cargarCmbLugares(this.frmPersona.getCmbProvinciaReside(), this.provincias);
        } else {
            this.frmPersona.getLblErrorPaisReside().setVisible(true);
        }
    }

    public void cargarCantonesProvincia() {
        int posPr = this.frmPersona.getCmbProvinciaReside().getSelectedIndex();
        if (posPr > 0) {
            this.frmPersona.getLblErrorCantonReside().setVisible(false);
            this.cantones = this.LBD.buscarPorReferencia(this.provincias.get(posPr - 1).getId());
            this.cargarCmbLugares(this.frmPersona.getCmbCantonReside(), this.cantones);
        } else {
            this.frmPersona.getLblErrorCantonReside().setVisible(true);
        }
    }

    public void cargarParroquiaCanton() {
        int posCt = this.frmPersona.getCmbCantonReside().getSelectedIndex();
        if (posCt > 0) {
            this.frmPersona.getLblErrorParroquiaReside().setVisible(false);
            this.parroquias = this.LBD.buscarPorReferencia(this.cantones.get(posCt - 1).getId());
            this.cargarCmbLugares(this.frmPersona.getCmbParroquiaReside(), this.parroquias);
            System.out.println("Cantones " + this.cantones.get(posCt - 1).getId());
        } else {
            this.frmPersona.getLblErrorParroquiaReside().setVisible(true);
        }
    }

    public void cargarCmbLugares(JComboBox cmb, ArrayList<LugarMD> lug) {
        cmb.removeAllItems();
        cmb.addItem("SELECCIONE");
        lug.forEach(l -> cmb.addItem(l.getNombre()));
        cmb.addItem("OTRO");
    }

    public void cargarCodigoPostal() {
        int posPr = this.frmPersona.getCmbProvinciaReside().getSelectedIndex();
        int posPa = this.frmPersona.getCmbParroquiaReside().getSelectedIndex();
        if (posPa > 0 && posPa < this.parroquias.size()) {
            this.frmPersona.getTxtCodigoPostal().setText(this.parroquias.get(posPa - 1).getCodigo());
        } else {
            this.frmPersona.getTxtCodigoPostal().setText("");
        }
    }

    private void borrarCampos() {
        this.frmPersona.getTxtCallePrincipal().setText("");
        this.frmPersona.getTxtCalleSecundaria().setText("");
        this.frmPersona.getTxtCelular().setText("");
        this.frmPersona.getTxtCorreo().setText("");
        this.frmPersona.getTxtNumeroCasa().setText("");
        this.frmPersona.getTxtPrimerApellido().setText("");
        this.frmPersona.getTxtPrimerNombre().setText("");
        this.frmPersona.getTxtReferencia().setText("");
        this.frmPersona.getTxtSector().setText("");
        this.frmPersona.getTxtSegundoApellido().setText("");
        this.frmPersona.getTxtSegundoNombre().setText("");
        this.frmPersona.getTxtTelefono().setText("");
        this.frmPersona.getCmbEstadoCivil().setSelectedIndex(0);
        this.frmPersona.getCmbTipoResidencia().setSelectedIndex(0);
        this.frmPersona.getCmbIdiomas().setSelectedIndex(0);
        this.frmPersona.getCmbSexo().setSelectedIndex(0);
        this.frmPersona.getCmbTipoSangre().setSelectedIndex(0);
        this.frmPersona.getCmbGenero().setSelectedIndex(0);
        this.frmPersona.getCmbEtnia().setSelectedIndex(0);
        this.frmPersona.getCmbNacionalidad().setSelectedIndex(0);
        this.frmPersona.getCmbProvincia().setSelectedIndex(0);
        this.frmPersona.getCmbCanton().setSelectedIndex(0);
        this.frmPersona.getCmbProvinciaReside().setSelectedIndex(0);
        this.frmPersona.getCmbParroquiaReside().setSelectedIndex(0);
        this.frmPersona.getCmbPaisReside().setSelectedIndex(0);
        this.frmPersona.getCmbCantonReside().setSelectedIndex(0);
        this.frmPersona.getCbxDiscapacidad().setSelected(false);
        this.frmPersona.getCmbTipoDiscapacidad().setSelectedIndex(0);
        this.frmPersona.getTxtCarnetConadis().setText("");
        this.frmPersona.getTxtPorcentaje().setText("");
        this.frmPersona.getLblFoto().setIcon(null);
        this.frmPersona.getLblFoto().updateUI();
        this.frmPersona.getCmbNacionalidad().setSelectedIndex(0);
        this.frmPersona.getCmbPaisReside().setSelectedIndex(0);
        this.frmPersona.getCmbProvinciaReside().setSelectedIndex(0);
        this.frmPersona.getCmbCantonReside().setSelectedIndex(0);
        this.frmPersona.getCmbParroquiaReside().setSelectedIndex(0);
        this.frmPersona.getCbxCategoriaMigratoria().setSelected(false);
        this.frmPersona.getCmbCategoriaMigratoria().setSelectedIndex(0);
    }

    public void borrarCamposConId() {
        this.borrarCampos();
        this.frmPersona.getCmbTipoId().setSelectedIndex(0);
        this.frmPersona.getTxtIdentificacion().setText("");
    }

    public void pasarFoto(InputStream is) {
        try {
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            File salida = new File("./foto.png");
            this.fis = new FileInputStream(salida);
            this.lonBytes = (int)salida.length();
            System.out.println("Tomada la foto " + this.fis);
            System.out.println("Longitud " + this.lonBytes);
        }
        catch (IOException ex) {
            System.out.println("No se pudo tranformar");
            System.out.println(ex.getMessage());
        }
    }

    public void llamaReportePersona() {
        String path = "/vista/reportes/repPersona.jasper";
        try {
            HashMap<String, String> parametro = new HashMap<String, String>();
            parametro.put("cedula", this.frmPersona.getTxtIdentificacion().getText());
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
            CON.mostrarReporte(jr, parametro, "Reporte de Persona");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "Error: " + (Object)((Object)ex));
        }
    }

    public void botonreportepersona() {
        int s = JOptionPane.showOptionDialog(null, "Registro de persona \n\u00bfDessea Imprimir el Registro realizado ?", "REPORTE PERSONAS", 1, 1, null, new Object[]{"SI", "NO"}, "NO");
        switch (s) {
            case 0: {
                this.llamaReportePersona();
                break;
            }
            case 1: {
                break;
            }
        }
    }
}

