/*
 * Decompiled with CFR 0.152.
 */
package controlador.persona;

import controlador.persona.FrmPersonaCTR;
import controlador.persona.VtnDocenteCTR;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import modelo.persona.DocenteBD;
import modelo.persona.DocenteMD;
import modelo.persona.PersonaBD;
import modelo.persona.PersonaMD;
import modelo.validaciones.TxtVCedula;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import vista.persona.FrmDocente;
import vista.persona.FrmPersona;

public class FrmDocenteCTR
extends DCTR {
    private boolean editar = false;
    private int idDocente = 0;
    private VtnDocenteCTR docenteVtn;
    private final FrmDocente frmDocente;
    private final DocenteBD DBD = DocenteBD.single();
    private boolean guardar = false;
    private static int cont = 0;
    private static int validar = 0;
    private final PersonaBD PBD = PersonaBD.single();
    private DocenteMD d;
    private TxtVCedula valCe;
    private String cedula;
    private final FrmPersona persona = new FrmPersona();

    public FrmDocenteCTR(FrmDocente frmDocente, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.frmDocente = frmDocente;
    }

    private void abrirFrmPersona() {
        FrmPersona frmPersona = new FrmPersona();
        FrmPersonaCTR ctrFrmPersona = new FrmPersonaCTR(frmPersona, this.ctrPrin);
        ctrFrmPersona.iniciar();
        frmPersona.getCmbTipoId().setSelectedItem(this.frmDocente.getCmbTipoIdentificacion().getSelectedItem());
        frmPersona.getTxtIdentificacion().setText(this.cedula);
        this.frmDocente.dispose();
    }

    public void iniciar() {
        this.ctrPrin.agregarVtn(this.frmDocente);
        this.frmDocente.getBtnCancelar().addActionListener(e -> this.salirBoton());
        FocusListener Buscar = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                cont++;
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        FocusListener titulo = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                cont++;
            }

            @Override
            public void focusLost(FocusEvent e) {
                FrmDocenteCTR.this.campoTitulo();
            }
        };
        FocusListener abreviatura = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                cont++;
            }

            @Override
            public void focusLost(FocusEvent e) {
                FrmDocenteCTR.this.camposNulos();
            }
        };
        KeyListener TITULO = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                FrmDocenteCTR.this.campoTitulo();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                validar = 5;
            }
        };
        KeyListener ABREVIATURA = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                FrmDocenteCTR.this.camposNulos();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
        this.inhabilitarComponentesDocente();
        this.iniciarComponentes();
        this.iniciarFechas();
        this.frmDocente.getTxtIdentificacion().addFocusListener(Buscar);
        this.frmDocente.getBtnBuscarPersona().addActionListener(e -> this.buscarCedula(this.frmDocente.getTxtIdentificacion().getText()));
        this.frmDocente.getBtnGuardar().addActionListener(e -> this.guardarDocente());
        this.frmDocente.getBtnRegistrarPersona().addActionListener(e -> this.abrirFrmPersona());
        this.frmDocente.getTxtAbreviaturaDocente().addActionListener(e -> this.camposNulos());
        this.frmDocente.getTxtTituloDocente().addActionListener(e -> this.campoTitulo());
        this.frmDocente.getTxtTituloDocente().addKeyListener(TITULO);
        this.frmDocente.getTxtAbreviaturaDocente().addKeyListener(ABREVIATURA);
        this.frmDocente.getTxtTituloDocente().addFocusListener(titulo);
        this.frmDocente.getTxtAbreviaturaDocente().addFocusListener(abreviatura);
        this.frmDocente.getTxtIdentificacion().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.frmDocente.getTxtTituloDocente().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FrmDocenteCTR.this.campoTitulo();
            }
        });
        this.frmDocente.getTxtAbreviaturaDocente().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FrmDocenteCTR.this.camposNulos();
            }
        });
        this.valCe = new TxtVCedula(this.frmDocente.getTxtIdentificacion(), this.frmDocente.getLblError());
        this.frmDocente.getCmbTipoIdentificacion().addActionListener(e -> this.tipoID());
        this.ctrPrin.estadoCargaFrmFin("FORMULARIO DE REGISTRO DOCENTE");
    }

    private void tipoID() {
        int pos = this.frmDocente.getCmbTipoIdentificacion().getSelectedIndex();
        this.frmDocente.getTxtIdentificacion().setEnabled(false);
        if (pos == 1) {
            this.frmDocente.getTxtIdentificacion().addKeyListener(this.valCe);
            this.frmDocente.getTxtIdentificacion().setEnabled(true);
            this.inhabilitarComponentesDocente();
            this.reiniciarComponentes(this.frmDocente);
            this.frmDocente.getBtnRegistrarPersona().setVisible(false);
        } else if (pos == 2) {
            this.frmDocente.getTxtIdentificacion().removeKeyListener(this.valCe);
            this.frmDocente.getTxtIdentificacion().setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
            this.frmDocente.getLblError().setVisible(false);
            this.frmDocente.getTxtIdentificacion().setEnabled(true);
            this.inhabilitarComponentesDocente();
            this.reiniciarComponentes(this.frmDocente);
            this.frmDocente.getBtnRegistrarPersona().setVisible(false);
        } else if (pos == 0) {
            this.reiniciarComponentes(this.frmDocente);
            this.inhabilitarComponentesDocente();
        }
    }

    private void camposNulos() {
        if (this.frmDocente.getTxtAbreviaturaDocente().getText().equals("")) {
            this.frmDocente.getBtnGuardar().setEnabled(false);
            this.frmDocente.getLblAbreviaturaDocente().setVisible(true);
            this.frmDocente.getLblAbreviaturaDocente().setBackground(Color.red);
            this.frmDocente.getLblDatoAbreviatura().setForeground(Color.red);
            this.frmDocente.getLblDatoAbreviatura().setText("Llennar, campo obligatorio");
        } else {
            this.frmDocente.getLblDatoAbreviatura().setVisible(false);
            this.frmDocente.getBtnGuardar().setEnabled(true);
        }
    }

    public void campoTitulo() {
        if (this.frmDocente.getTxtTituloDocente().getText().equals("")) {
            this.frmDocente.getBtnGuardar().setEnabled(false);
            this.frmDocente.getLblTituloDocente().setVisible(true);
            this.frmDocente.getLblDatoTitulo().setForeground(Color.red);
            this.frmDocente.getLblDatoTitulo().setText("Llennar, campo obligatorio");
        } else {
            this.frmDocente.getLblDatoTitulo().setVisible(false);
            this.frmDocente.getBtnGuardar().setEnabled(true);
        }
    }

    public void buscarCedula(String cedula) {
        boolean buscar = true;
        this.frmDocente.getTxtIdentificacion().setVisible(true);
        if (this.frmDocente.getCmbTipoIdentificacion().getSelectedItem().toString().equals("CEDULA")) {
            if (!Validar.esCedula(cedula)) {
                this.guardar = false;
                this.frmDocente.getLblError().setVisible(true);
                this.frmDocente.getLblError().setForeground(Color.red);
                this.frmDocente.getLblError().setText("Error! Cedula invalida");
            } else {
                this.frmDocente.getLblError().setVisible(false);
                if (buscar) {
                    this.d = this.DBD.buscarDocenteInactivo(cedula);
                    if (this.d != null) {
                        int seleccion = JOptionPane.showOptionDialog(null, "Seleccione una Opcion", "Selector de Opciones", 1, 3, null, new Object[]{"Activar Docente", "No Activar"}, "Cancelar");
                        if (seleccion == 1) {
                            this.inhabilitarComponentesDocente();
                            this.frmDocente.getBtnRegistrarPersona().setVisible(false);
                        } else if (seleccion == 0) {
                            this.DBD.activarDocente(this.d.getIdPersona());
                            this.habilitarComponentesDocente();
                            this.editar(this.d);
                        }
                    } else {
                        this.d = this.DBD.buscarDocente(cedula);
                        if (this.d == null) {
                            System.out.println("No existe el docente");
                            PersonaMD p = this.PBD.buscarPersona(cedula);
                            if (p == null) {
                                JOptionPane.showMessageDialog(null, "No existe la persona");
                                this.frmDocente.getBtnRegistrarPersona().setVisible(true);
                                this.cedula = this.frmDocente.getTxtIdentificacion().getText();
                                this.inhabilitarComponentesDocente();
                                this.reiniciarComponentes(this.frmDocente);
                            } else {
                                System.out.println("Existe persona");
                                this.habilitarComponentesDocente();
                                this.idDocente = p.getIdPersona();
                                this.frmDocente.getLblDatosPersona().setText("Nuevo registro: [ " + p.getIdentificacion() + " ] " + p.getNombreCompleto());
                            }
                        } else {
                            System.out.println("Si existe el docente");
                            this.habilitarComponentesDocente();
                            this.frmDocente.getBtnRegistrarPersona().setVisible(false);
                            this.editar(this.d);
                            this.frmDocente.getLblDatosPersona().setText("[ " + this.d.getCodigo() + " ] " + this.d.getNombreCompleto());
                        }
                    }
                }
            }
        } else if (buscar) {
            this.d = this.DBD.buscarDocenteInactivo(cedula);
            if (this.d != null) {
                int seleccion = JOptionPane.showOptionDialog(null, "Seleccione una Opcion", "Selector de Opciones", 1, 3, null, new Object[]{"Activar Docente", "No Activar"}, "Cancelar");
                if (seleccion == 1) {
                    this.inhabilitarComponentesDocente();
                    this.frmDocente.getBtnRegistrarPersona().setVisible(false);
                } else if (seleccion == 0) {
                    this.DBD.activarDocente(this.d.getIdPersona());
                    this.habilitarComponentesDocente();
                    this.editar(this.d);
                }
            } else {
                this.d = this.DBD.buscarDocente(cedula);
                if (this.d == null) {
                    System.out.println("No existe el docente");
                    PersonaMD p = this.PBD.buscarPersona(cedula);
                    if (p == null) {
                        JOptionPane.showMessageDialog(null, "No existe la persona");
                        this.frmDocente.getBtnRegistrarPersona().setVisible(true);
                        this.inhabilitarComponentesDocente();
                        this.reiniciarComponentes(this.frmDocente);
                        this.frmDocente.getLblDatosPersona().setText("");
                    } else {
                        System.out.println("Existe persona");
                        this.habilitarComponentesDocente();
                        this.idDocente = p.getIdPersona();
                    }
                } else {
                    System.out.println("Si existe el docente");
                    this.habilitarComponentesDocente();
                    this.frmDocente.getBtnRegistrarPersona().setVisible(false);
                    this.editar(this.d);
                    this.frmDocente.getLblDatosPersona().setText("[ " + this.d.getIdDocente() + " ] " + this.d.getPrimerApellido() + " " + this.d.getSegundoApellido() + " " + this.d.getPrimerNombre());
                }
            }
        }
    }

    public void iniciarComponentes() {
        this.frmDocente.getLblError().setVisible(false);
        this.frmDocente.getJdcFechaFinContratacion().setDate(null);
    }

    public void guardarDocente() {
        LocalDate fechaFinContratacion;
        LocalDate fechaIni;
        this.guardar = true;
        int idPer = this.idDocente;
        System.out.println(idPer);
        String codigo = this.frmDocente.getTxtIdentificacion().getText();
        int docenteCategoria = Integer.parseInt(this.frmDocente.getSpnCategoria().getValue().toString());
        String docenteTipoTiempo = this.frmDocente.getCmbTipoTiempo().getSelectedItem().toString();
        System.out.println("docente tipo tiempo guardar docente " + docenteTipoTiempo);
        boolean docenteCapacitador = this.frmDocente.getCbxDocenteCapacitador().isSelected();
        boolean docenteOtroTrabajo = this.frmDocente.getCbxOtroTrabajo().isSelected();
        this.frmDocente.getJdcFechaInicioContratacion().setDateFormatString("dd/MM/yyyy");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd", Locale.getDefault());
        String d = sdf.format(this.frmDocente.getJdcFechaInicioContratacion().getDate());
        String[] fecIniC = d.split("/");
        LocalDate fechaInicioContratacion = fechaIni = LocalDate.of(Integer.parseInt(fecIniC[0]), Integer.parseInt(fecIniC[1]), Integer.parseInt(fecIniC[2]));
        try {
            LocalDate fechaFin1;
            this.frmDocente.getJdcFechaFinContratacion().setDateFormatString("dd/MM/yyyy");
            SimpleDateFormat fecFin = new SimpleDateFormat("yyyy/MM/dd", Locale.getDefault());
            String fechaFin = fecFin.format(this.frmDocente.getJdcFechaFinContratacion().getDate());
            String[] fecFinC = fechaFin.split("/");
            fechaFinContratacion = fechaFin1 = LocalDate.of(Integer.parseInt(fecFinC[0]), Integer.parseInt(fecFinC[1]), Integer.parseInt(fecFinC[2]));
        }
        catch (NullPointerException e) {
            fechaFinContratacion = null;
        }
        String docenteTitulo = this.frmDocente.getTxtTituloDocente().getText();
        String docenteAbreviatura = this.frmDocente.getTxtAbreviaturaDocente().getText();
        String estado = null;
        System.out.println("Se dio click en guardar");
        System.out.println("Guardar = " + this.guardar);
        System.out.println("Editar = " + this.editar);
        if (this.guardar) {
            DocenteMD docente = new DocenteMD();
            docente.setCodigo(codigo);
            docente.setIdPersona(idPer);
            docente.setFechaInicioContratacion(fechaInicioContratacion);
            docente.setFechaFinContratacion(fechaFinContratacion);
            docente.setEstado(estado);
            docente.setDocenteCapacitador(docenteCapacitador);
            docente.setDocenteCategoria(docenteCategoria);
            docente.setDocenteOtroTrabajo(docenteOtroTrabajo);
            docente.setTituloDocente(docenteTitulo);
            docente.setAbreviaturaDocente(docenteAbreviatura);
            docente.setDocenteCapacitador(this.frmDocente.getCbxDocenteCapacitador().isSelected());
            if (!docenteTipoTiempo.equalsIgnoreCase("Seleccione")) {
                docente.setDocenteTipoTiempo(docenteTipoTiempo);
                if (this.editar) {
                    if (this.idDocente > 0) {
                        docente.setIdDocente(this.idDocente);
                        this.DBD.editarDocente(docente);
                        JOptionPane.showMessageDialog(null, "Los Datos se han editado exitosamente");
                        this.botonreporteDocente();
                        this.frmDocente.dispose();
                    }
                } else {
                    this.DBD.InsertarDocente(docente);
                    JOptionPane.showMessageDialog(null, "Se han insertado los datos de forma correcta!");
                    this.botonreporteDocente();
                    this.frmDocente.dispose();
                }
            } else {
                JOptionPane.showMessageDialog(null, "Seleccione una opcion");
            }
        }
    }

    public void editar(DocenteMD doc) {
        this.editar = true;
        this.idDocente = doc.getIdDocente();
        this.frmDocente.getLblDatosPersona().setText("[ " + doc.getCodigo() + " ] " + doc.getNombreCompleto());
        if (doc.getFechaInicioContratacion() != null) {
            Calendar calendar_Inicio = Calendar.getInstance();
            calendar_Inicio.clear();
            calendar_Inicio.set(doc.getFechaInicioContratacion().getYear(), doc.getFechaInicioContratacion().getMonthValue() - 1, doc.getFechaInicioContratacion().getDayOfMonth());
            this.frmDocente.getJdcFechaInicioContratacion().setCalendar(calendar_Inicio);
        } else {
            this.frmDocente.getJdcFechaInicioContratacion().setCalendar(null);
        }
        if (doc.getFechaFinContratacion() != null) {
            Calendar calendar_Fin = Calendar.getInstance();
            calendar_Fin.clear();
            calendar_Fin.set(doc.getFechaFinContratacion().getYear(), doc.getFechaFinContratacion().getMonthValue() - 1, doc.getFechaFinContratacion().getDayOfMonth());
            this.frmDocente.getJdcFechaFinContratacion().setCalendar(calendar_Fin);
        } else {
            this.frmDocente.getJdcFechaFinContratacion().setCalendar(null);
        }
        this.frmDocente.getTxtIdentificacion().setText(doc.getCodigo());
        this.frmDocente.getSpnCategoria().setValue(doc.getDocenteCategoria());
        this.frmDocente.getCmbTipoTiempo().setSelectedItem(doc.getDocenteTipoTiempo());
        System.out.println("docente tipo tiempo guardar docente " + doc.getDocenteTipoTiempo());
        this.frmDocente.getCbxDocenteCapacitador().setSelected(doc.isDocenteCapacitador());
        this.frmDocente.getCbxOtroTrabajo().setSelected(doc.isDocenteOtroTrabajo());
        this.frmDocente.getTxtTituloDocente().setText(doc.getTituloDocente());
        this.frmDocente.getTxtAbreviaturaDocente().setText(doc.getAbreviaturaDocente());
    }

    public void reiniciarComponentes(FrmDocente frmDocente) {
        frmDocente.getTxtIdentificacion().setText("");
        frmDocente.getCmbTipoTiempo().setSelectedItem("SELECCIONE");
        frmDocente.getCbxDocenteCapacitador().setSelected(false);
        frmDocente.getCbxOtroTrabajo().setSelected(false);
        frmDocente.getSpnCategoria().setValue(3);
        this.iniciarFechas();
        frmDocente.getJdcFechaFinContratacion().setCalendar(null);
        frmDocente.getLblDatosPersona().setText("");
        frmDocente.getTxtTituloDocente().setText("");
        frmDocente.getTxtAbreviaturaDocente().setText("");
    }

    public void salirBoton() {
        try {
            this.frmDocente.setClosed(true);
        }
        catch (PropertyVetoException ex) {
            System.out.println(ex);
        }
    }

    public void habilitarComponentesDocente() {
        this.frmDocente.getJdcFechaInicioContratacion().setEnabled(true);
        this.frmDocente.getCbxDocenteCapacitador().setEnabled(true);
        this.frmDocente.getCmbTipoTiempo().setEnabled(true);
        this.frmDocente.getSpnCategoria().setEnabled(true);
        this.frmDocente.getJdcFechaFinContratacion().setEnabled(true);
        this.frmDocente.getCbxOtroTrabajo().setEnabled(true);
        this.frmDocente.getTxtTituloDocente().setEnabled(true);
        this.frmDocente.getTxtAbreviaturaDocente().setEnabled(true);
    }

    public void inhabilitarComponentesDocente() {
        this.frmDocente.getBtnGuardar().setEnabled(false);
        this.frmDocente.getCbxDocenteCapacitador().setEnabled(false);
        this.frmDocente.getCmbTipoTiempo().setEnabled(false);
        this.frmDocente.getSpnCategoria().setEnabled(false);
        this.frmDocente.getJdcFechaFinContratacion().setEnabled(false);
        this.frmDocente.getJdcFechaInicioContratacion().setEnabled(false);
        this.frmDocente.getCbxOtroTrabajo().setEnabled(false);
        this.frmDocente.getTxtTituloDocente().setEnabled(false);
        this.frmDocente.getTxtAbreviaturaDocente().setEnabled(false);
    }

    public void iniciarFechas() {
        LocalDate fechaActual = LocalDate.now();
        Date fechaHoy = Date.from(fechaActual.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        this.frmDocente.getJdcFechaInicioContratacion().setDate(fechaHoy);
    }

    public void llamaReporteDocente() {
        String path = "/vista/reportes/repDocentes.jasper";
        try {
            HashMap<String, String> parametro = new HashMap<String, String>();
            parametro.put("cedulaverificacion", this.frmDocente.getTxtIdentificacion().getText());
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
            CON.mostrarReporte(jr, parametro, "Reporte de Docente");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(this.frmDocente, "Error: " + (Object)((Object)ex));
        }
    }

    public void botonreporteDocente() {
        int s = JOptionPane.showOptionDialog(null, "Registro de persona \n\u00bfDessea Imprimir el Registro realizado ?", "REPORTE DOCENTES", 1, 1, null, new Object[]{"SI", "NO"}, "NO");
        switch (s) {
            case 0: {
                this.llamaReporteDocente();
                break;
            }
            case 1: {
                break;
            }
        }
    }
}

