/*
 * Decompiled with CFR 0.152.
 */
package controlador.persona;

import controlador.carrera.VtnCarreraCTR;
import controlador.persona.FrmPersonaCTR;
import controlador.persona.VtnAlumnoCTR;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import modelo.persona.AlumnoBD;
import modelo.persona.AlumnoMD;
import modelo.persona.PersonaMD;
import modelo.persona.ProfesionMD;
import modelo.persona.SectorEconomicoBD;
import modelo.persona.SectorEconomicoMD;
import modelo.validaciones.CmbValidar;
import modelo.validaciones.TxtVNumeros;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import vista.persona.FrmAlumno;
import vista.persona.FrmPersona;
import vista.persona.VtnAlumno;

public class FrmAlumnoCTR
extends DCTR {
    private final FrmAlumno frmAlumno;
    private final AlumnoBD ALBD = AlumnoBD.single();
    private static int cont = 0;
    private boolean editar = false;
    private boolean editar_2 = false;
    private static int validar = 0;
    private boolean identificacion = false;
    private List<AlumnoMD> Alumnos = new ArrayList<AlumnoMD>();
    private List<SectorEconomicoMD> Sectores = new ArrayList<SectorEconomicoMD>();
    private final SectorEconomicoBD SEBD = SectorEconomicoBD.single();

    public FrmAlumnoCTR(FrmAlumno frmAlumno, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.frmAlumno = frmAlumno;
    }

    public void iniciar() {
        this.ctrPrin.agregarVtn(this.frmAlumno);
        CmbValidar combo_TipoColegio = new CmbValidar(this.frmAlumno.getCmBx_TipoColegio(), this.frmAlumno.getLbl_ErrTipColegio());
        CmbValidar combo_TipoBachi = new CmbValidar(this.frmAlumno.getCmBx_TipoBachillerato(), this.frmAlumno.getLbl_ErrTipBachillerato());
        CmbValidar combo_SectEcono = new CmbValidar(this.frmAlumno.getCmBx_SecEconomico(), this.frmAlumno.getLbl_ErrSecEconomico());
        CmbValidar combo_ForPadre = new CmbValidar(this.frmAlumno.getCmBx_ForPadre(), this.frmAlumno.getLbl_ErrForPadre());
        CmbValidar combo_ForMadre = new CmbValidar(this.frmAlumno.getCmBx_ForMadre(), this.frmAlumno.getLbl_ErrForMadre());
        CmbValidar combo_Parentesco = new CmbValidar(this.frmAlumno.getCmBx_Parentesco(), this.frmAlumno.getLbl_ErrParentesco());
        ActionListener Cancelar = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmAlumnoCTR.this.frmAlumno.dispose();
            }
        };
        FocusListener Buscar = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                cont++;
            }

            @Override
            public void focusLost(FocusEvent e) {
                String cedula = FrmAlumnoCTR.this.frmAlumno.getTxt_Cedula().getText();
                if (FrmAlumnoCTR.this.identificacion) {
                    if (!cedula.equals("")) {
                        if (cedula.length() == 10) {
                            if (!Validar.esCedula(cedula)) {
                                FrmAlumnoCTR.this.frmAlumno.getLbl_ErrCedula().setText("Ingrese una c\u00e9dula v\u00e1lida");
                                FrmAlumnoCTR.this.frmAlumno.getLbl_ErrCedula().setVisible(true);
                                FrmAlumnoCTR.this.reiniciarComponentes(FrmAlumnoCTR.this.frmAlumno);
                                cont = 0;
                            } else {
                                FrmAlumnoCTR.this.frmAlumno.getLbl_ErrCedula().setVisible(false);
                                FrmAlumnoCTR.this.buscarCedula();
                            }
                        } else if (cedula.length() < 10) {
                            FrmAlumnoCTR.this.frmAlumno.getLbl_ErrCedula().setText("La c\u00e9dula lleva 10 n\u00fameros");
                            FrmAlumnoCTR.this.frmAlumno.getLbl_ErrCedula().setVisible(true);
                            FrmAlumnoCTR.this.reiniciarComponentes(FrmAlumnoCTR.this.frmAlumno);
                            cont = 0;
                        }
                    } else {
                        FrmAlumnoCTR.this.frmAlumno.getLbl_ErrCedula().setVisible(false);
                        cont = 0;
                    }
                } else if (!cedula.equals("")) {
                    if (Validar.esLetrasYNumeros(cedula)) {
                        FrmAlumnoCTR.this.frmAlumno.getLbl_ErrCedula().setVisible(false);
                        FrmAlumnoCTR.this.buscarCedula();
                    }
                } else {
                    FrmAlumnoCTR.this.frmAlumno.getLbl_ErrCedula().setText("El pasaporte contiene solo letras y n\u00fameros");
                    FrmAlumnoCTR.this.frmAlumno.getLbl_ErrCedula().setVisible(true);
                    cont = 0;
                }
            }
        };
        PropertyChangeListener habilitar_Guardar = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FrmAlumnoCTR.this.habilitarGuardar();
            }
        };
        KeyAdapter titulo_Superior = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                validar = 1;
                FrmAlumnoCTR.this.validarComponentes(FrmAlumnoCTR.this.frmAlumno.getTxt_TlSuperior().getText());
                FrmAlumnoCTR.this.habilitarGuardar();
            }
        };
        KeyAdapter ocupacion = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                validar = 2;
                String nombre = FrmAlumnoCTR.this.frmAlumno.getTxt_Ocupacion().getText();
                if (nombre.equalsIgnoreCase("Est")) {
                    FrmAlumnoCTR.this.frmAlumno.getTxt_Ocupacion().setText("Estudiante");
                } else if (nombre.equalsIgnoreCase("Tra")) {
                    FrmAlumnoCTR.this.frmAlumno.getTxt_Ocupacion().setText("Estudiante y Empleado");
                }
                FrmAlumnoCTR.this.validarComponentes(nombre);
                FrmAlumnoCTR.this.habilitarGuardar();
            }
        };
        KeyAdapter nombre_Contacto = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                validar = 3;
                FrmAlumnoCTR.this.validarComponentes(FrmAlumnoCTR.this.frmAlumno.getTxt_NomContacto().getText());
                FrmAlumnoCTR.this.habilitarGuardar();
            }
        };
        KeyAdapter num_Contacto = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                validar = 4;
                FrmAlumnoCTR.this.validarComponentes(FrmAlumnoCTR.this.frmAlumno.getTxt_ConEmergency().getText());
                FrmAlumnoCTR.this.habilitarGuardar();
            }
        };
        KeyAdapter cedula = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (FrmAlumnoCTR.this.identificacion) {
                    String cedula = FrmAlumnoCTR.this.frmAlumno.getTxt_Cedula().getText();
                    char car = e.getKeyChar();
                    if (car < '0' || car > '9') {
                        e.consume();
                    }
                    if (cedula.length() >= 10) {
                        e.consume();
                    }
                    FrmAlumnoCTR.this.habilitarGuardar();
                } else {
                    String cedula = FrmAlumnoCTR.this.frmAlumno.getTxt_Cedula().getText();
                    char car = e.getKeyChar();
                    if (!Validar.esLetrasYNumeros(car + "")) {
                        e.consume();
                    }
                    FrmAlumnoCTR.this.habilitarGuardar();
                }
            }
        };
        KeyAdapter validarPalabras = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char car = e.getKeyChar();
                if (!Validar.esLetras(car + "")) {
                    e.consume();
                }
                FrmAlumnoCTR.this.habilitarGuardar();
            }
        };
        this.frmAlumno.getCbx_Identificacion().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FrmAlumnoCTR.this.frmAlumno.getCbx_Identificacion().getSelectedItem().toString().equals("C\u00c9DULA")) {
                    FrmAlumnoCTR.this.identificacion = true;
                    FrmAlumnoCTR.this.frmAlumno.getTxt_Cedula().setEnabled(true);
                    FrmAlumnoCTR.this.frmAlumno.getCbx_Identificacion().setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
                } else if (FrmAlumnoCTR.this.frmAlumno.getCbx_Identificacion().getSelectedItem().toString().equals("PASAPORTE")) {
                    FrmAlumnoCTR.this.identificacion = false;
                    FrmAlumnoCTR.this.frmAlumno.getTxt_Cedula().setEnabled(true);
                    FrmAlumnoCTR.this.frmAlumno.getCbx_Identificacion().setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
                } else {
                    FrmAlumnoCTR.this.frmAlumno.getCbx_Identificacion().setBorder(BorderFactory.createLineBorder(new Color(204, 0, 0)));
                    FrmAlumnoCTR.this.frmAlumno.getTxt_Cedula().setEnabled(false);
                }
            }
        });
        KeyAdapter anios = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String numero = FrmAlumnoCTR.this.frmAlumno.getTxt_Anios().getText().trim();
                if (numero.equals("")) {
                    FrmAlumnoCTR.this.frmAlumno.getLbl_ErrAnio().setVisible(false);
                } else if (Integer.valueOf(numero) < 1980 || Integer.valueOf(numero) > 2039) {
                    FrmAlumnoCTR.this.frmAlumno.getLbl_ErrAnio().setVisible(true);
                } else {
                    FrmAlumnoCTR.this.frmAlumno.getLbl_ErrAnio().setVisible(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                String palabra = FrmAlumnoCTR.this.frmAlumno.getTxt_Anios().getText().trim();
                char car = e.getKeyChar();
                if (!Validar.esNumeros(car + "")) {
                    e.consume();
                }
                if (palabra != null && palabra.length() >= 4) {
                    e.consume();
                }
            }
        };
        KeyAdapter abreviatura = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char car = e.getKeyChar();
                if (!Validar.esLetras3(car + "")) {
                    e.consume();
                }
                FrmAlumnoCTR.this.habilitarGuardar();
            }
        };
        this.iniciaDatos();
        this.habilitarGuardar();
        this.iniciarSectores();
        this.iniciarComponentes();
        this.frmAlumno.getCmBx_TipoColegio().addActionListener(combo_TipoColegio);
        this.frmAlumno.getCmBx_TipoColegio().addPropertyChangeListener(habilitar_Guardar);
        this.frmAlumno.getCmBx_TipoBachillerato().addActionListener(combo_TipoBachi);
        this.frmAlumno.getCmBx_TipoBachillerato().addPropertyChangeListener(habilitar_Guardar);
        this.frmAlumno.getCmBx_SecEconomico().addActionListener(combo_SectEcono);
        this.frmAlumno.getCmBx_SecEconomico().addPropertyChangeListener(habilitar_Guardar);
        this.frmAlumno.getCmBx_ForPadre().addActionListener(combo_ForPadre);
        this.frmAlumno.getCmBx_ForPadre().addPropertyChangeListener(habilitar_Guardar);
        this.frmAlumno.getCmBx_ForMadre().addActionListener(combo_ForMadre);
        this.frmAlumno.getCmBx_ForMadre().addPropertyChangeListener(habilitar_Guardar);
        this.frmAlumno.getCmBx_Parentesco().addActionListener(combo_Parentesco);
        this.frmAlumno.getCmBx_Parentesco().addPropertyChangeListener(habilitar_Guardar);
        this.frmAlumno.getTxt_Cedula().addFocusListener(Buscar);
        this.frmAlumno.getTxt_Cedula().addKeyListener(cedula);
        this.frmAlumno.getTxt_TlSuperior().addKeyListener(titulo_Superior);
        this.frmAlumno.getTxt_Ocupacion().addKeyListener(ocupacion);
        this.frmAlumno.getTxt_NomContacto().addKeyListener(nombre_Contacto);
        this.frmAlumno.getTxt_ConEmergency().addKeyListener(new TxtVNumeros(this.frmAlumno.getTxt_ConEmergency(), this.frmAlumno.getLbl_ErrConEmergencia()));
        this.frmAlumno.getTxt_ConEmergency().addPropertyChangeListener(habilitar_Guardar);
        this.frmAlumno.getTxt_TituloSuperior().addKeyListener(validarPalabras);
        this.frmAlumno.getTxt_TituloSuperior().addPropertyChangeListener(habilitar_Guardar);
        this.frmAlumno.getChkBx_EdcSuperior().addActionListener(e -> this.activarSuperior());
        this.frmAlumno.getChkBx_Trabaja().addActionListener(e -> this.activarSectores());
        this.frmAlumno.getTxt_Anios().addKeyListener(anios);
        this.frmAlumno.getTxt_Anios().addPropertyChangeListener(habilitar_Guardar);
        this.frmAlumno.getTxt_Abreviatura().addKeyListener(abreviatura);
        this.frmAlumno.getChkBx_EdcSuperior().addPropertyChangeListener(habilitar_Guardar);
        this.frmAlumno.getChkBx_Trabaja().addPropertyChangeListener(habilitar_Guardar);
        this.frmAlumno.getBtn_Buscar().addActionListener(e -> this.buscarPersona());
        this.frmAlumno.getBtn_Guardar().addActionListener(e -> this.guardarAlumno());
        this.frmAlumno.getBtn_Cancelar().addActionListener(Cancelar);
    }

    public void buscarPersona() {
        VtnAlumno alumno = new VtnAlumno();
        VtnAlumnoCTR c = new VtnAlumnoCTR(alumno, this.ctrPrin);
        c.iniciar();
    }

    public void iniciaDatos() {
        this.Sectores = this.SEBD.capturarSectores();
    }

    public boolean confirmarErrores() {
        boolean error = false;
        error = this.frmAlumno.getChkBx_EdcSuperior().isSelected() ? (this.frmAlumno.getChkBx_Trabaja().isSelected() ? this.frmAlumno.getLbl_ErrCedula().isVisible() || this.frmAlumno.getLbl_ErrTipoIdenti().isVisible() || this.frmAlumno.getLbl_ErrConEmergencia().isVisible() || this.frmAlumno.getLbl_ErrForMadre().isVisible() || this.frmAlumno.getLbl_ErrForPadre().isVisible() || this.frmAlumno.getLbl_ErrNomContacto().isVisible() || this.frmAlumno.getLbl_ErrOcupacion().isVisible() || this.frmAlumno.getLbl_ErrParentesco().isVisible() || this.frmAlumno.getLbl_ErrSecEconomico().isVisible() || this.frmAlumno.getLbl_ErrTiSuperior().isVisible() || this.frmAlumno.getLbl_ErrTipBachillerato().isVisible() || this.frmAlumno.getLbl_ErrTipColegio().isVisible() || this.frmAlumno.getLbl_ErrorTSuperior().isVisible() || this.frmAlumno.getLbl_ErrAnio().isVisible() : this.frmAlumno.getLbl_ErrCedula().isVisible() || this.frmAlumno.getLbl_ErrTipoIdenti().isVisible() || this.frmAlumno.getLbl_ErrConEmergencia().isVisible() || this.frmAlumno.getLbl_ErrForMadre().isVisible() || this.frmAlumno.getLbl_ErrForPadre().isVisible() || this.frmAlumno.getLbl_ErrNomContacto().isVisible() || this.frmAlumno.getLbl_ErrOcupacion().isVisible() || this.frmAlumno.getLbl_ErrParentesco().isVisible() || this.frmAlumno.getLbl_ErrTiSuperior().isVisible() || this.frmAlumno.getLbl_ErrTipBachillerato().isVisible() || this.frmAlumno.getLbl_ErrTipColegio().isVisible() || this.frmAlumno.getLbl_ErrorTSuperior().isVisible() || this.frmAlumno.getLbl_ErrAnio().isVisible()) : (this.frmAlumno.getChkBx_Trabaja().isSelected() ? this.frmAlumno.getLbl_ErrCedula().isVisible() || this.frmAlumno.getLbl_ErrTipoIdenti().isVisible() || this.frmAlumno.getLbl_ErrConEmergencia().isVisible() || this.frmAlumno.getLbl_ErrForMadre().isVisible() || this.frmAlumno.getLbl_ErrForPadre().isVisible() || this.frmAlumno.getLbl_ErrNomContacto().isVisible() || this.frmAlumno.getLbl_ErrOcupacion().isVisible() || this.frmAlumno.getLbl_ErrParentesco().isVisible() || this.frmAlumno.getLbl_ErrSecEconomico().isVisible() || this.frmAlumno.getLbl_ErrTiSuperior().isVisible() || this.frmAlumno.getLbl_ErrTipBachillerato().isVisible() || this.frmAlumno.getLbl_ErrTipColegio().isVisible() || this.frmAlumno.getLbl_ErrorTSuperior().isVisible() || this.frmAlumno.getLbl_ErrAnio().isVisible() : this.frmAlumno.getLbl_ErrCedula().isVisible() || this.frmAlumno.getLbl_ErrTipoIdenti().isVisible() || this.frmAlumno.getLbl_ErrConEmergencia().isVisible() || this.frmAlumno.getLbl_ErrForMadre().isVisible() || this.frmAlumno.getLbl_ErrForPadre().isVisible() || this.frmAlumno.getLbl_ErrNomContacto().isVisible() || this.frmAlumno.getLbl_ErrOcupacion().isVisible() || this.frmAlumno.getLbl_ErrParentesco().isVisible() || this.frmAlumno.getLbl_ErrTiSuperior().isVisible() || this.frmAlumno.getLbl_ErrTipBachillerato().isVisible() || this.frmAlumno.getLbl_ErrTipColegio().isVisible() || this.frmAlumno.getLbl_ErrorTSuperior().isVisible() || this.frmAlumno.getLbl_ErrAnio().isVisible());
        return error;
    }

    public void buscarCedula() {
        if (cont == 1) {
            boolean error = false;
            String cedula = this.frmAlumno.getTxt_Cedula().getText();
            if (!cedula.equals("")) {
                if (!error) {
                    PersonaMD p = this.ALBD.filtrarPersona(this.frmAlumno.getTxt_Cedula().getText());
                    if (p.getIdentificacion() == null) {
                        this.reiniciarComponentes(this.frmAlumno);
                        this.iniciarComponentes();
                        int dialog = 1;
                        int result = JOptionPane.showConfirmDialog(null, "Usted no esta registrado en el Sistema \u00bfDESEA HACERLO? ", " Registrar Persona ", dialog);
                        if (result == 0) {
                            FrmPersona frmPersona = new FrmPersona();
                            FrmPersonaCTR ctrPers = new FrmPersonaCTR(frmPersona, this.ctrPrin);
                            ctrPers.iniciar();
                            frmPersona.getTxtIdentificacion().setText(cedula);
                            if (Validar.esNumeros(cedula)) {
                                frmPersona.getCmbTipoId().setSelectedItem("CEDULA");
                            } else {
                                frmPersona.getCmbTipoId().setSelectedItem("PASAPORTE");
                            }
                            this.frmAlumno.dispose();
                            this.ctrPrin.cerradoJIF();
                        }
                        cont = 0;
                    } else {
                        AlumnoMD alumno = this.ALBD.buscarPersona(p.getIdPersona());
                        Integer idAlumno = alumno.getId_Alumno();
                        Font negrita = new Font("Tahoma", 1, 13);
                        this.frmAlumno.getTxt_Nombre().setFont(negrita);
                        this.frmAlumno.getTxt_Nombre().setText(p.getPrimerNombre() + " " + p.getSegundoNombre() + " " + p.getPrimerApellido() + " " + p.getSegundoApellido());
                        this.habilitarGuardar();
                        if (alumno.getId_Alumno() == 0) {
                            this.reiniciarComponentes(this.frmAlumno);
                            this.iniciarComponentes();
                            cont = 0;
                            JOptionPane.showMessageDialog(null, "Esta persona no esta registrada como alumno");
                        } else {
                            ProfesionMD profesion = new ProfesionMD();
                            this.frmAlumno.getCmBx_TipoColegio().setSelectedItem(alumno.getTipo_Colegio());
                            this.frmAlumno.getCmBx_TipoBachillerato().setSelectedItem(alumno.getTipo_Bachillerato());
                            this.frmAlumno.getTxt_Anios().setText(alumno.getAnio_graduacion());
                            this.frmAlumno.getTxt_TlSuperior().setText(alumno.getTitulo_Superior());
                            this.frmAlumno.getTxt_Ocupacion().setText(alumno.getOcupacion());
                            String sector = this.SEBD.capturarSector(alumno.getSectorEconomico().getId_SecEconomico()).getDescrip_SecEconomico();
                            if (alumno.isTrabaja()) {
                                this.frmAlumno.getCmBx_SecEconomico().setEnabled(true);
                            } else {
                                this.frmAlumno.getCmBx_SecEconomico().setEnabled(false);
                            }
                            this.frmAlumno.getChkBx_Trabaja().setSelected(alumno.isTrabaja());
                            if (sector.equals("NINGUNO")) {
                                this.frmAlumno.getCmBx_SecEconomico().setSelectedIndex(0);
                                this.frmAlumno.getLbl_ErrSecEconomico().setVisible(false);
                                this.frmAlumno.getChkBx_Trabaja().setSelected(false);
                            } else {
                                this.frmAlumno.getCmBx_SecEconomico().setSelectedItem(sector);
                            }
                            this.frmAlumno.getCmBx_ForPadre().setSelectedItem(alumno.getFormacion_Padre());
                            this.frmAlumno.getCmBx_ForMadre().setSelectedItem(alumno.getFormacion_Madre());
                            this.frmAlumno.getTxt_NomContacto().setText(alumno.getNom_Contacto());
                            this.frmAlumno.getCmBx_Parentesco().setSelectedItem(alumno.getParentesco_Contacto());
                            this.frmAlumno.getTxt_ConEmergency().setText(alumno.getContacto_Emergencia());
                            this.frmAlumno.getChkBx_EdcSuperior().setSelected(alumno.isEducacion_Superior());
                            this.frmAlumno.getChkBx_Pension().setSelected(alumno.isPension());
                            this.frmAlumno.getChkBx_Trabaja().setSelected(alumno.isTrabaja());
                            if (profesion.getTitulo_nombre() != null) {
                                this.frmAlumno.getTxt_TituloSuperior().setText(profesion.getTitulo_nombre());
                                this.frmAlumno.getTxt_Abreviatura().setText(profesion.getTitulo_abreviatura());
                                this.frmAlumno.getTxt_TituloSuperior().setVisible(true);
                                this.frmAlumno.getTxt_Abreviatura().setVisible(true);
                                this.frmAlumno.getLbl_AbvTitulo().setVisible(true);
                                this.frmAlumno.getLbl_TSuperior().setVisible(true);
                            }
                            cont = 0;
                            this.editar_2 = true;
                            this.habilitarGuardar();
                        }
                    }
                } else {
                    cont = 0;
                }
            } else {
                cont = 0;
            }
        }
    }

    public void validarComponentes(String texto) {
        if (validar == 1) {
            if (!Validar.esLetras(texto) && !texto.equals("")) {
                this.frmAlumno.getLbl_ErrTiSuperior().setVisible(true);
            } else {
                this.frmAlumno.getLbl_ErrTiSuperior().setVisible(false);
            }
            validar = 0;
        } else if (validar == 2) {
            if (!Validar.esLetras(texto) && !texto.equals("")) {
                this.frmAlumno.getLbl_ErrOcupacion().setVisible(true);
            } else {
                this.frmAlumno.getLbl_ErrOcupacion().setVisible(false);
            }
            validar = 0;
        } else if (validar == 3) {
            if (!Validar.esLetras(texto) && !texto.equals("")) {
                this.frmAlumno.getLbl_ErrNomContacto().setVisible(true);
            } else {
                this.frmAlumno.getLbl_ErrNomContacto().setVisible(false);
            }
            validar = 0;
        } else if (validar == 4) {
            if (!Validar.esNumeros(texto) && !texto.equals("")) {
                this.frmAlumno.getLbl_ErrConEmergencia().setVisible(true);
            } else {
                this.frmAlumno.getLbl_ErrConEmergencia().setVisible(false);
            }
            validar = 0;
        } else if (validar == 5) {
            if (!Validar.esNumeros(texto) && !texto.equals("")) {
                this.frmAlumno.getLbl_ErrCedula().setText("Ingrese solo n\u00fameros");
                this.frmAlumno.getLbl_ErrCedula().setVisible(true);
            } else {
                this.frmAlumno.getLbl_ErrCedula().setVisible(false);
            }
            validar = 0;
        }
    }

    public void habilitarGuardar() {
        String cedula = this.frmAlumno.getTxt_Cedula().getText();
        String nombre = this.frmAlumno.getTxt_Nombre().getText();
        String titulo_Bachiller = this.frmAlumno.getTxt_TlSuperior().getText();
        String nombre_Contacto = this.frmAlumno.getTxt_NomContacto().getText();
        String contacto_Emergencia = this.frmAlumno.getTxt_ConEmergency().getText();
        String tipo_Colegio = this.frmAlumno.getCmBx_TipoColegio().getSelectedItem().toString();
        String tipo_Bachillerato = this.frmAlumno.getCmBx_TipoBachillerato().getSelectedItem().toString();
        String sector_Economico = this.frmAlumno.getCmBx_SecEconomico().getSelectedItem().toString();
        String parentesco = this.frmAlumno.getCmBx_Parentesco().getSelectedItem().toString();
        String titulo_Superior = this.frmAlumno.getTxt_TituloSuperior().getText();
        String abreviatura = this.frmAlumno.getTxt_Abreviatura().getText();
        String formacion_Padre = this.frmAlumno.getCmBx_ForMadre().getSelectedItem().toString();
        String formacion_Madre = this.frmAlumno.getCmBx_ForPadre().getSelectedItem().toString();
        String ocupacion = this.frmAlumno.getTxt_Ocupacion().getText();
        String anio = this.frmAlumno.getTxt_Anios().getText();
        if (this.frmAlumno.getChkBx_EdcSuperior().isSelected()) {
            if (this.frmAlumno.getChkBx_Trabaja().isSelected()) {
                if (!(cedula.equals("") || nombre.equals("") || titulo_Bachiller.equals("") || nombre_Contacto.equals("") || contacto_Emergencia.equals("") || tipo_Colegio.equals("|SELECCIONE|") || tipo_Bachillerato.equals("|SELECCIONE|") || sector_Economico.equals("|SELECCIONE|") || parentesco.equals("|SELECCIONE|") || titulo_Superior.equals("") || abreviatura.equals("") || formacion_Madre.equals("|SELECCIONE|") || formacion_Padre.equals("|SELECCIONE|") || ocupacion.equals("") || anio.equals(""))) {
                    if (!this.confirmarErrores()) {
                        this.frmAlumno.getBtn_Guardar().setEnabled(true);
                    } else {
                        this.frmAlumno.getBtn_Guardar().setEnabled(false);
                    }
                } else {
                    this.frmAlumno.getBtn_Guardar().setEnabled(false);
                }
            } else if (!(cedula.equals("") || nombre.equals("") || titulo_Bachiller.equals("") || nombre_Contacto.equals("") || contacto_Emergencia.equals("") || tipo_Colegio.equals("|SELECCIONE|") || ocupacion.equals("") || anio.equals("") || tipo_Bachillerato.equals("|SELECCIONE|") || parentesco.equals("|SELECCIONE|") || titulo_Superior.equals("") || abreviatura.equals("") || formacion_Madre.equals("|SELECCIONE|") || formacion_Padre.equals("|SELECCIONE|"))) {
                if (!this.confirmarErrores()) {
                    this.frmAlumno.getBtn_Guardar().setEnabled(true);
                } else {
                    this.frmAlumno.getBtn_Guardar().setEnabled(false);
                }
            } else {
                this.frmAlumno.getBtn_Guardar().setEnabled(false);
            }
        } else if (this.frmAlumno.getChkBx_Trabaja().isSelected()) {
            if (!(cedula.equals("") || nombre.equals("") || titulo_Bachiller.equals("") || nombre_Contacto.equals("") || contacto_Emergencia.equals("") || tipo_Colegio.equals("|SELECCIONE|") || tipo_Bachillerato.equals("|SELECCIONE|") || sector_Economico.equals("|SELECCIONE|") || parentesco.equals("|SELECCIONE|") || ocupacion.equals("") || anio.equals("") || formacion_Madre.equals("|SELECCIONE|") || formacion_Padre.equals("|SELECCIONE|"))) {
                if (!this.confirmarErrores()) {
                    this.frmAlumno.getBtn_Guardar().setEnabled(true);
                } else {
                    this.frmAlumno.getBtn_Guardar().setEnabled(false);
                }
            } else {
                this.frmAlumno.getBtn_Guardar().setEnabled(false);
            }
        } else if (!(cedula.equals("") || nombre.equals("") || titulo_Bachiller.equals("") || nombre_Contacto.equals("") || contacto_Emergencia.equals("") || tipo_Colegio.equals("|SELECCIONE|") || ocupacion.equals("") || anio.equals("") || tipo_Bachillerato.equals("|SELECCIONE|") || parentesco.equals("|SELECCIONE|") || formacion_Madre.equals("|SELECCIONE|") || formacion_Padre.equals("|SELECCIONE|"))) {
            if (!this.confirmarErrores()) {
                this.frmAlumno.getBtn_Guardar().setEnabled(true);
            } else {
                this.frmAlumno.getBtn_Guardar().setEnabled(false);
            }
        } else {
            this.frmAlumno.getBtn_Guardar().setEnabled(false);
        }
    }

    public void iniciarComponentes() {
        this.frmAlumno.getCbx_Identificacion().setToolTipText("Seleccione un Tipo de Identificaci\u00f3n");
        this.frmAlumno.getTxt_Cedula().setToolTipText("Ingrese una Identificaci\u00f3n v\u00e1lida y espere la respuesta del Sistema");
        this.frmAlumno.getTxt_Nombre().setToolTipText("El nombre se filtrar\u00e1 autom\u00e1ticamente");
        this.frmAlumno.getCmBx_TipoColegio().setToolTipText("Seleccione el Tipo de la Instituci\u00f3n a la que curs\u00f3");
        this.frmAlumno.getCmBx_TipoBachillerato().setToolTipText("Seleccione el Tipo de Bachillerato que curs\u00f3");
        this.frmAlumno.getTxt_TlSuperior().setToolTipText("Ingrese el T\u00edtulo de Bachiller");
        this.frmAlumno.getTxt_Ocupacion().setToolTipText("Ingrese si tiene una Ocupaci\u00f3n");
        this.frmAlumno.getTxt_Anios().setToolTipText("Ingrese el A\u00f1o en el consigui\u00f3 el T\u00edtulo de Bachiller");
        this.frmAlumno.getCmBx_SecEconomico().setToolTipText("Seleccione un Sector si trabaja, sino seleccione \"Ninguno\"");
        this.frmAlumno.getCmBx_ForPadre().setToolTipText("Seleccione el Nivel de Formaci\u00f3n del Padre");
        this.frmAlumno.getCmBx_ForMadre().setToolTipText("Seleccione el Nivel de Formaci\u00f3n de la Madre");
        this.frmAlumno.getTxt_NomContacto().setToolTipText("Ingrese el Nombre de un Contacto confiable y a disposici\u00f3n");
        this.frmAlumno.getCmBx_Parentesco().setToolTipText("Seleccione el Parentesco con respecto al usuario ingresado");
        this.frmAlumno.getTxt_ConEmergency().setToolTipText("Ingrese el N\u00famero telef\u00f3nico del Contacto");
        this.frmAlumno.getBtn_Guardar().setToolTipText("Se habilitar\u00e1 despu\u00e9s que los campos con \"*\" esten llenos");
        this.frmAlumno.getBtn_Buscar().setToolTipText("Se abrir\u00e1 una Ventana con todos los Estudiantes");
        this.frmAlumno.getLbl_ErrCedula().setVisible(false);
        this.frmAlumno.getLbl_ErrTipColegio().setVisible(false);
        this.frmAlumno.getLbl_ErrTipBachillerato().setVisible(false);
        this.frmAlumno.getLbl_ErrTiSuperior().setVisible(false);
        this.frmAlumno.getLbl_ErrOcupacion().setVisible(false);
        this.frmAlumno.getLbl_ErrSecEconomico().setVisible(false);
        this.frmAlumno.getLbl_ErrForPadre().setVisible(false);
        this.frmAlumno.getLbl_ErrForMadre().setVisible(false);
        this.frmAlumno.getLbl_ErrNomContacto().setVisible(false);
        this.frmAlumno.getLbl_ErrParentesco().setVisible(false);
        this.frmAlumno.getLbl_ErrConEmergencia().setVisible(false);
        this.frmAlumno.getLbl_ErrTipoIdenti().setVisible(false);
        this.frmAlumno.getTxt_Nombre().setEnabled(false);
        this.frmAlumno.getTxt_Cedula().setEnabled(false);
        this.frmAlumno.getLbl_TSuperior().setVisible(false);
        this.frmAlumno.getLbl_ErrorTSuperior().setVisible(false);
        this.frmAlumno.getTxt_TituloSuperior().setVisible(false);
        this.frmAlumno.getCmBx_SecEconomico().setEnabled(false);
        this.frmAlumno.getLbl_AbvTitulo().setVisible(false);
        this.frmAlumno.getTxt_Abreviatura().setVisible(false);
        this.frmAlumno.getLbl_ErrAnio().setVisible(false);
    }

    private void activarSuperior() {
        boolean superior = this.frmAlumno.getChkBx_EdcSuperior().isSelected();
        this.desactivarSuperior(superior);
    }

    private void desactivarSuperior(boolean estado) {
        this.frmAlumno.getLbl_TSuperior().setVisible(estado);
        this.frmAlumno.getTxt_TituloSuperior().setVisible(estado);
        this.frmAlumno.getLbl_AbvTitulo().setVisible(estado);
        this.frmAlumno.getTxt_Abreviatura().setVisible(estado);
    }

    private void activarSectores() {
        boolean esSector = this.frmAlumno.getChkBx_Trabaja().isSelected();
        this.desactivarSectores(esSector);
    }

    private void desactivarSectores(boolean estado) {
        this.frmAlumno.getCmBx_SecEconomico().setEnabled(estado);
        this.frmAlumno.getLbl_ErrSecEconomico().setVisible(false);
    }

    public void iniciarSectores() {
        for (int i = 0; i < this.Sectores.size(); ++i) {
            this.frmAlumno.getCmBx_SecEconomico().addItem(this.Sectores.get(i).getDescrip_SecEconomico().toUpperCase());
        }
    }

    public void guardarAlumno() {
        if (!this.editar && !this.editar_2) {
            AlumnoMD persona = new AlumnoMD();
            ProfesionMD profesion = new ProfesionMD();
            persona = this.pasarDatos(persona);
            profesion.setTitulo_nombre(persona.getProfesion().getTitulo_nombre());
            profesion.setTitulo_abreviatura(persona.getProfesion().getTitulo_abreviatura());
            if (this.ALBD.guardarAlumno(persona, this.SEBD.capturarIdSector(this.frmAlumno.getCmBx_SecEconomico().getSelectedItem().toString()))) {
                if (!persona.getProfesion().getTitulo_nombre().equals("")) {
                    if (this.ALBD.guardarTitulo(profesion)) {
                        profesion.setId_Titulo(this.ALBD.idProfesion(profesion.getTitulo_nombre()).getId_Titulo());
                        if (this.ALBD.guardarTituloAuxiliar(profesion, persona.getIdPersona())) {
                            JOptionPane.showMessageDialog(null, "Datos grabados correctamente");
                            this.botonreporteAlumno();
                            this.frmAlumno.dispose();
                            this.ctrPrin.cerradoJIF();
                        } else {
                            this.reiniciarComponentes(this.frmAlumno);
                            JOptionPane.showMessageDialog(null, "Error en grabar los datos del T\u00edtulo Superior");
                        }
                    } else {
                        this.reiniciarComponentes(this.frmAlumno);
                        JOptionPane.showMessageDialog(null, "Error en grabar los datos del T\u00edtulo Superior");
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Datos grabados correctamente");
                    this.botonreporteAlumno();
                    this.frmAlumno.dispose();
                    this.ctrPrin.cerradoJIF();
                }
            } else {
                JOptionPane.showMessageDialog(null, "Error en grabar los datos");
            }
        } else if (this.editar) {
            AlumnoMD persona = new AlumnoMD();
            if (this.ALBD.editarAlumno(persona = this.pasarDatos(persona), this.ALBD.capturarPersona(this.frmAlumno.getTxt_Cedula().getText()).get(0).getIdPersona())) {
                JOptionPane.showMessageDialog(null, "Datos editados correctamente");
                this.botonreporteAlumno();
                this.frmAlumno.dispose();
                this.ctrPrin.cerradoJIF();
                this.editar = false;
            } else {
                JOptionPane.showMessageDialog(null, "Error en editar los datos");
            }
        } else if (this.editar_2) {
            AlumnoMD persona = new AlumnoMD();
            if (this.ALBD.editarAlumno(persona = this.pasarDatos(persona), this.ALBD.capturarPersona(this.frmAlumno.getTxt_Cedula().getText()).get(0).getIdPersona())) {
                JOptionPane.showMessageDialog(null, "Datos editados correctamente");
                this.botonreporteAlumno();
                this.frmAlumno.dispose();
                this.ctrPrin.cerradoJIF();
                this.editar_2 = false;
            } else {
                JOptionPane.showMessageDialog(null, "Error en editar los datos");
            }
        }
    }

    public void editar(AlumnoMD persona) {
        this.editar = true;
        Font negrita = new Font("Tahoma", 1, 13);
        this.frmAlumno.getTxt_Nombre().setFont(negrita);
        String sector = this.SEBD.capturarSector(persona.getSectorEconomico().getId_SecEconomico()).getDescrip_SecEconomico().toUpperCase();
        ProfesionMD profesion = new ProfesionMD();
        if (Validar.esNumeros(persona.getIdentificacion())) {
            this.frmAlumno.getCbx_Identificacion().setSelectedItem("C\u00c9DULA");
        } else {
            this.frmAlumno.getCbx_Identificacion().setSelectedItem("PASAPORTE");
        }
        this.frmAlumno.getTxt_Cedula().setText(persona.getIdentificacion());
        this.frmAlumno.getTxt_Nombre().setText(persona.getPrimerNombre() + " " + persona.getSegundoNombre() + " " + persona.getPrimerApellido() + " " + persona.getSegundoApellido());
        this.frmAlumno.getCmBx_TipoColegio().setSelectedItem(persona.getTipo_Colegio());
        this.frmAlumno.getCmBx_TipoBachillerato().setSelectedItem(persona.getTipo_Bachillerato());
        this.frmAlumno.getTxt_TlSuperior().setText(persona.getTitulo_Superior());
        this.frmAlumno.getChkBx_EdcSuperior().setSelected(persona.isEducacion_Superior());
        this.frmAlumno.getTxt_Ocupacion().setText(persona.getOcupacion());
        this.frmAlumno.getTxt_Anios().setText(persona.getAnio_graduacion());
        this.frmAlumno.getChkBx_Pension().setSelected(persona.isPension());
        if (persona.isTrabaja()) {
            this.frmAlumno.getCmBx_SecEconomico().setEnabled(true);
        } else {
            this.frmAlumno.getCmBx_SecEconomico().setEnabled(false);
        }
        this.frmAlumno.getChkBx_Trabaja().setSelected(persona.isTrabaja());
        if (sector.equals("NINGUNO")) {
            this.frmAlumno.getCmBx_SecEconomico().setSelectedIndex(0);
            this.frmAlumno.getLbl_ErrSecEconomico().setVisible(false);
        } else {
            this.frmAlumno.getCmBx_SecEconomico().setSelectedItem(sector);
        }
        this.frmAlumno.getCmBx_ForPadre().setSelectedItem(persona.getFormacion_Padre());
        this.frmAlumno.getCmBx_ForMadre().setSelectedItem(persona.getFormacion_Madre());
        this.frmAlumno.getTxt_NomContacto().setText(persona.getNom_Contacto());
        this.frmAlumno.getCmBx_Parentesco().setSelectedItem(persona.getParentesco_Contacto());
        this.frmAlumno.getTxt_ConEmergency().setText(persona.getContacto_Emergencia());
        if (profesion.getTitulo_nombre() != null) {
            this.frmAlumno.getTxt_TituloSuperior().setText(profesion.getTitulo_nombre());
            this.frmAlumno.getTxt_Abreviatura().setText(profesion.getTitulo_abreviatura());
            this.frmAlumno.getTxt_TituloSuperior().setVisible(true);
            this.frmAlumno.getTxt_Abreviatura().setVisible(true);
            this.frmAlumno.getLbl_AbvTitulo().setVisible(true);
            this.frmAlumno.getLbl_TSuperior().setVisible(true);
        }
        this.habilitarGuardar();
    }

    public void reiniciarComponentes(FrmAlumno frmAlumno) {
        frmAlumno.getCmBx_TipoColegio().setSelectedItem("|SELECCIONE|");
        frmAlumno.getCmBx_TipoBachillerato().setSelectedItem("|SELECCIONE|");
        frmAlumno.getTxt_TlSuperior().setText("");
        frmAlumno.getChkBx_EdcSuperior().setSelected(false);
        frmAlumno.getTxt_Ocupacion().setText("");
        frmAlumno.getChkBx_Pension().setSelected(false);
        frmAlumno.getTxt_Anios().setText("");
        frmAlumno.getChkBx_Trabaja().setSelected(false);
        frmAlumno.getCmBx_ForPadre().setSelectedItem("|SELECCIONE|");
        frmAlumno.getCmBx_ForMadre().setSelectedItem("|SELECCIONE|");
        frmAlumno.getTxt_NomContacto().setText("");
        frmAlumno.getCmBx_Parentesco().setSelectedItem("|SELECCIONE|");
        frmAlumno.getTxt_ConEmergency().setText("");
    }

    public AlumnoMD pasarDatos(AlumnoMD persona) {
        ProfesionMD profesion = new ProfesionMD();
        Integer sectorEco = this.SEBD.capturarIdSector(this.frmAlumno.getCmBx_SecEconomico().getSelectedItem().toString()).getId_SecEconomico();
        PersonaMD user = this.ALBD.filtrarPersona(this.frmAlumno.getTxt_Cedula().getText());
        SectorEconomicoMD sector = new SectorEconomicoMD();
        persona.setIdPersona(user.getIdPersona());
        persona.setIdentificacion(user.getIdentificacion());
        if (0 == sectorEco) {
            sector.setId_SecEconomico(0);
        } else {
            sector.setId_SecEconomico(sectorEco);
        }
        persona.setSectorEconomico(sector);
        persona.setTipo_Colegio(this.frmAlumno.getCmBx_TipoColegio().getSelectedItem().toString());
        persona.setTipo_Bachillerato(this.frmAlumno.getCmBx_TipoBachillerato().getSelectedItem().toString());
        persona.setAnio_graduacion(this.frmAlumno.getTxt_Anios().getText());
        persona.setEducacion_Superior(this.frmAlumno.getChkBx_EdcSuperior().isSelected());
        persona.setTitulo_Superior(this.frmAlumno.getTxt_TlSuperior().getText().toUpperCase());
        persona.setPension(this.frmAlumno.getChkBx_Pension().isSelected());
        persona.setOcupacion(this.frmAlumno.getTxt_Ocupacion().getText().toUpperCase());
        persona.setTrabaja(this.frmAlumno.getChkBx_Trabaja().isSelected());
        if (this.frmAlumno.getCmBx_ForPadre().getSelectedItem().toString().equals("|SELECCIONE|") || this.frmAlumno.getCmBx_ForPadre().getSelectedItem().equals("NINGUNO")) {
            persona.setFormacion_Padre(null);
        } else {
            persona.setFormacion_Padre(this.frmAlumno.getCmBx_ForPadre().getSelectedItem().toString());
        }
        if (this.frmAlumno.getCmBx_ForMadre().getSelectedItem().toString().equals("|SELECCIONE|") || this.frmAlumno.getCmBx_ForMadre().getSelectedItem().equals("NINGUNO")) {
            persona.setFormacion_Madre(null);
        } else {
            persona.setFormacion_Madre(this.frmAlumno.getCmBx_ForMadre().getSelectedItem().toString());
        }
        persona.setNom_Contacto(this.frmAlumno.getTxt_NomContacto().getText().toUpperCase());
        persona.setParentesco_Contacto(this.frmAlumno.getCmBx_Parentesco().getSelectedItem().toString());
        persona.setContacto_Emergencia(this.frmAlumno.getTxt_ConEmergency().getText());
        profesion.setTitulo_nombre(this.frmAlumno.getTxt_TituloSuperior().getText().toUpperCase());
        profesion.setTitulo_abreviatura(this.frmAlumno.getTxt_Abreviatura().getText());
        persona.setProfesion(profesion);
        return persona;
    }

    public void llamaReporteAlumno() {
        String path = "/vista/reportes/repAlumno.jasper";
        try {
            HashMap<String, String> parametro = new HashMap<String, String>();
            parametro.put("cedula_alumno", this.frmAlumno.getTxt_Cedula().getText());
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
            CON.mostrarReporte(jr, parametro, "Reporte de Alumno");
        }
        catch (JRException ex) {
            Logger.getLogger(VtnCarreraCTR.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void botonreporteAlumno() {
        int s = JOptionPane.showOptionDialog(null, "Registro de persona \n\u00bfDessea Imprimir el Registro realizado ?", "REPORTE ALUMNO", 1, 1, null, new Object[]{"SI", "NO"}, "NO");
        switch (s) {
            case 0: {
                this.llamaReporteAlumno();
                break;
            }
            case 1: {
                break;
            }
        }
    }
}

