/*
 * Decompiled with CFR 0.152.
 */
package controlador.periodoLectivoNotas.tipoDeNotas.forms;

import controlador.Libraries.Middlewares;
import controlador.Libraries.Validaciones;
import controlador.Libraries.cellEditor.TextFieldCellEditor;
import controlador.periodoLectivoNotas.tipoDeNotas.VtnTipoNotasCTR;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.tipoDeNota.TipoDeNotaBD;
import vista.principal.VtnPrincipal;
import vista.tipoDeNotas.FrmTipoNota;

public abstract class AbstracForm {
    protected VtnPrincipal desktop;
    protected FrmTipoNota vista;
    protected TipoDeNotaBD modelo;
    protected VtnTipoNotasCTR vtnPadre;
    protected Map<String, PeriodoLectivoMD> listaPeriodos;
    protected List<String> listaDuales;
    protected List<String> listaTradicionales;
    protected List<TipoDeNotaBD> listaTipos;
    protected List<String> listaNombres;
    protected DefaultTableModel tabla;
    protected PeriodoLectivoBD periodoBD = new PeriodoLectivoBD();

    public AbstracForm(VtnPrincipal desktop, FrmTipoNota vista, TipoDeNotaBD modelo2, VtnTipoNotasCTR vtnPadre) {
        this.desktop = desktop;
        this.vista = vista;
        this.modelo = modelo2;
        this.vtnPadre = vtnPadre;
    }

    public abstract void Init();

    protected void InitEventos() {
        this.vista.getBtnCancelar().addActionListener(e -> this.vista.dispose());
        this.vista.getBtnGuardar().addActionListener(e -> this.btnGuardar(e));
        this.vista.getCmbPeriodoLectivo().addItemListener(e -> {
            this.InitListas();
            this.listaNombres = this.modelo.selectNombreWhere(this.getIdPeriodo());
            this.cargarTabla();
            this.setlblCarrera();
        });
        this.tabla.addTableModelListener(new TableModelListener(){
            boolean active = false;

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!this.active && e.getType() == 0) {
                    this.active = true;
                    AbstracForm.this.validarNotas();
                    this.active = false;
                }
            }
        });
    }

    protected void InitListas() {
        this.listaDuales = new ArrayList<String>();
        this.listaDuales.add("G. DE AULA 1");
        this.listaDuales.add("G. DE AULA 2");
        this.listaDuales.add("TOTAL GESTION");
        this.listaDuales.add("EXAMEN FINAL");
        this.listaDuales.add("EXAMEN DE RECUPERACION");
        this.listaDuales.add("NOTA FINAL");
        this.listaDuales.add("PTI");
        this.listaDuales.add("N. TUTOR EMPRESARIAL");
        this.listaDuales.add("N. TUTOR ACADEMICO");
        this.listaDuales.add("DESEMPE\u00d1O GENERAL EN LA INSTITUCION FORMADORA");
        this.listaDuales.add("SUBTOTAL FASE PRACTICA");
        this.listaDuales.add("NOTA FINAL TOTAL");
        this.listaTradicionales = new ArrayList<String>();
        this.listaTradicionales.add("APORTE 1");
        this.listaTradicionales.add("EXAMEN INTERCICLO");
        this.listaTradicionales.add("NOTA INTERCICLO");
        this.listaTradicionales.add("APORTE 2");
        this.listaTradicionales.add("EXAMEN FINAL");
        this.listaTradicionales.add("EXAMEN DE RECUPERACION");
        this.listaTradicionales.add("NOTA FINAL");
    }

    protected void InitTablas() {
        this.vista.getTblTipoNota().getColumnModel().getColumn(1).setCellEditor(new TextFieldCellEditor(true));
        this.vista.getTblTipoNota().getColumnModel().getColumn(2).setCellEditor(new TextFieldCellEditor(true));
    }

    protected int getRow() {
        return this.vista.getTblTipoNota().getSelectedRow();
    }

    protected int getColum() {
        return this.vista.getTblTipoNota().getSelectedColumn();
    }

    protected void cargarComboCarreras() {
        this.listaPeriodos.entrySet().stream().forEach(entry -> this.vista.getCmbPeriodoLectivo().addItem((String)entry.getKey()));
    }

    protected void setlblCarrera() {
        this.vista.getLblNombreCarrera().setText(this.listaPeriodos.entrySet().stream().filter(item -> ((String)item.getKey()).equals(this.vista.getCmbPeriodoLectivo().getSelectedItem().toString())).map(c -> ((PeriodoLectivoMD)c.getValue()).getCarrera().getNombre()).findFirst().orElse(""));
    }

    protected String getModalidad() {
        return this.listaPeriodos.entrySet().stream().filter(item -> ((String)item.getKey()).equalsIgnoreCase(this.vista.getCmbPeriodoLectivo().getSelectedItem().toString())).map(c -> ((PeriodoLectivoMD)c.getValue()).getCarrera().getModalidad()).findFirst().orElse("");
    }

    protected int getIdPeriodo() {
        return this.listaPeriodos.entrySet().stream().filter(item -> ((String)item.getKey()).equalsIgnoreCase(this.vista.getCmbPeriodoLectivo().getSelectedItem().toString())).map(c -> ((PeriodoLectivoMD)c.getValue()).getID()).findFirst().get();
    }

    protected void cargarTabla() {
        this.tabla.setRowCount(0);
        if (this.getModalidad().toLowerCase().contains("dual")) {
            this.listaDuales.removeAll(this.listaNombres);
            this.listaDuales.forEach(obj -> this.tabla.addRow(new Object[]{obj, 0, 100}));
        } else if (this.getModalidad().toLowerCase().contains("tradicional") || this.getModalidad().toLowerCase().contains("presencial")) {
            this.listaTradicionales.removeAll(this.listaNombres);
            this.listaTradicionales.forEach(obj -> this.tabla.addRow(new Object[]{obj, 0, 100}));
        }
    }

    protected void setObjs() {
        this.listaTipos = new ArrayList<TipoDeNotaBD>();
        if (this.getModalidad().equalsIgnoreCase("presencial") || this.getModalidad().equalsIgnoreCase("tradicional")) {
            this.setObjLista(this.listaTradicionales);
        } else {
            this.setObjLista(this.listaDuales);
        }
    }

    private void setObjLista(List<String> lista) {
        lista.stream().forEach(new Consumer<String>(){
            int index = 0;

            @Override
            public void accept(String obj) {
                TipoDeNotaBD tipo = new TipoDeNotaBD();
                tipo.setNombre(obj);
                tipo.setValorMinimo(new Double(AbstracForm.this.vista.getTblTipoNota().getValueAt(this.index, 1).toString()));
                tipo.setValorMaximo(new Double(AbstracForm.this.vista.getTblTipoNota().getValueAt(this.index, 2).toString()));
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(AbstracForm.this.getIdPeriodo());
                tipo.setPeriodoLectivo(periodo);
                AbstracForm.this.listaTipos.add(tipo);
                ++this.index;
            }
        });
    }

    protected void validacion() {
        String v1 = "0";
        String v2 = "0";
        try {
            v1 = this.tabla.getValueAt(this.getRow(), 1).toString();
            v2 = this.tabla.getValueAt(this.getRow(), 2).toString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (Validaciones.isDecimal(v1)) {
            if (!v2.isEmpty()) {
                if (Validaciones.isDecimal(v2)) {
                    double valor2;
                    double valor1 = Middlewares.conversor(v1);
                    if (valor1 > (valor2 = Middlewares.conversor(v2)) || valor1 == valor2 || valor2 == 0.0 || valor1 < 0.0) {
                        JOptionPane.showMessageDialog(this.vista, "EL VALOR MINIMO NO PUEDE SER MENOR AL MAXIMO\nEL VALOR MAXIMO NO PUEDE SER 0\nEL VALOR MINIMO Y MAXIMO NO PUEDEN SER IGUALES");
                        this.tabla.setValueAt(0, this.getRow(), 1);
                        this.tabla.setValueAt(100, this.getRow(), 2);
                    }
                } else {
                    this.tabla.setValueAt(100, this.getRow(), 2);
                }
            }
        } else {
            this.cargarTabla();
        }
    }

    protected abstract void btnGuardar(ActionEvent var1);

    private void validarNotas() {
        switch (this.getColum()) {
            case 1: {
                this.validacion();
                break;
            }
            case 2: {
                this.validacion();
                break;
            }
        }
    }
}

