/*
 * Decompiled with CFR 0.152.
 */
package controlador.periodoLectivoNotas.tipoDeNotas;

import controlador.Libraries.Effects;
import controlador.periodoLectivoNotas.tipoDeNotas.forms.FrmTipoNotaAgregar;
import controlador.periodoLectivoNotas.tipoDeNotas.forms.FrmTipoNotaEditar;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.tipoDeNota.TipoDeNotaBD;
import modelo.tipoDeNota.TipoDeNotaMD;
import utils.CONS;
import vista.principal.VtnPrincipal;
import vista.tipoDeNotas.FrmTipoNota;
import vista.tipoDeNotas.VtnTipoNotas;

public class VtnTipoNotasCTR {
    private final VtnPrincipal desktop;
    private VtnTipoNotas vista;
    private TipoDeNotaBD modelo;
    private List<TipoDeNotaBD> listaTiposNotas;
    private List<PeriodoLectivoMD> listaPeriodos;
    private DefaultTableModel tablaTiposNotas;
    private final PeriodoLectivoBD periodo = new PeriodoLectivoBD();

    public VtnTipoNotasCTR(VtnPrincipal desktop) {
        this.desktop = desktop;
        this.vista = new VtnTipoNotas();
        this.modelo = new TipoDeNotaBD();
    }

    public VtnTipoNotas getVista() {
        return this.vista;
    }

    public void Init() {
        Effects.addInDesktopPane(this.vista, this.desktop.getDpnlPrincipal());
        Effects.centerFrame(this.vista, this.desktop.getDpnlPrincipal());
        this.tablaTiposNotas = (DefaultTableModel)this.vista.getTblTipoNotas().getModel();
        this.InitEventos();
        this.listaTiposNotas = this.modelo.selectAllWhereEstadoIs(true);
        this.cargarTabla(this.listaTiposNotas);
        this.cargarCmbPeriodos();
        this.InitPermisos();
    }

    private void InitEventos() {
        this.vista.getBtnEditar().addActionListener(e -> this.btnEditar(e));
        this.vista.getBtnEliminar().addActionListener(e -> this.btnEliminar(e));
        this.vista.getBtnIngresar().addActionListener(e -> new FrmTipoNotaAgregar(this.desktop, new FrmTipoNota(), new TipoDeNotaBD(), this).Init());
        this.vista.getBtnActualizar().addActionListener(e -> {
            this.listaTiposNotas = this.modelo.selectAllWhereEstadoIs(true);
            this.cargarTabla(this.listaTiposNotas);
        });
        this.vista.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VtnTipoNotasCTR.this.cargarTablaFilter(VtnTipoNotasCTR.this.vista.getTxtBuscar().getText().toUpperCase());
            }
        });
        this.vista.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                VtnTipoNotasCTR.this.vista = null;
                VtnTipoNotasCTR.this.listaTiposNotas = null;
                VtnTipoNotasCTR.this.modelo = null;
                VtnTipoNotasCTR.this.tablaTiposNotas = null;
                System.gc();
                System.out.println(".VTN Tipos de notas closed!");
            }
        });
        this.vista.getCmbPeriodos().addActionListener(e -> {
            if (this.vista.getCmbPeriodos().getSelectedIndex() != 0) {
                this.cargarTabla(this.listaTiposNotas.stream().filter(item -> item.getPeriodoLectivo().getNombre().equalsIgnoreCase(this.vista.getCmbPeriodos().getSelectedItem().toString())).collect(Collectors.toList()));
            } else {
                this.cargarTabla(this.listaTiposNotas);
            }
        });
    }

    public void cargarTabla(List<TipoDeNotaBD> lista) {
        this.tablaTiposNotas.setRowCount(0);
        lista.forEach(this.agregarFilas());
    }

    private void cargarCmbPeriodos() {
        this.listaPeriodos = this.periodo.selectIdNombreAll();
        this.vista.getCmbPeriodos().addItem("---------------------------------------------------");
        this.listaPeriodos.stream().map(c -> c.getNombre()).forEachOrdered(this.vista.getCmbPeriodos()::addItem);
    }

    private void cargarTablaFilter(String Aguja) {
        this.tablaTiposNotas.setRowCount(0);
        this.listaTiposNotas.stream().filter(item -> item.getNombre().toUpperCase().contains(Aguja) || item.getFechaCreacion().toString().toUpperCase().contains(Aguja) || String.valueOf(item.getValorMaximo()).toUpperCase().contains(Aguja) || String.valueOf(item.getValorMinimo()).toUpperCase().contains(Aguja) || item.getPeriodoLectivo().getNombre().toUpperCase().contains(Aguja)).collect(Collectors.toList()).forEach(this.agregarFilas());
    }

    private Consumer<TipoDeNotaMD> agregarFilas() {
        return obj -> {
            this.tablaTiposNotas.addRow(new Object[]{this.tablaTiposNotas.getDataVector().size() + 1, obj.getId(), obj.getNombre(), obj.getPeriodoLectivo().getNombre(), obj.getPeriodoLectivo().getCarrera().getNombre(), obj.getPeriodoLectivo().getCarrera().getModalidad(), obj.getValorMinimo(), obj.getValorMaximo(), obj.getFechaCreacion()});
            this.vista.getLblResultados().setText(this.tablaTiposNotas.getDataVector().size() + " Resultados Obtenidos");
        };
    }

    private void btnEditar(ActionEvent e) {
        int fila = this.vista.getTblTipoNotas().getSelectedRow();
        if (fila != -1) {
            int ID = Integer.valueOf(this.vista.getTblTipoNotas().getValueAt(fila, 1).toString());
            this.modelo = this.listaTiposNotas.stream().filter(item -> item.getId() == ID).findFirst().get();
            FrmTipoNotaEditar form = new FrmTipoNotaEditar(this.desktop, new FrmTipoNota(), this.modelo, this);
            form.Init();
        } else {
            JOptionPane.showMessageDialog(this.vista, "SELECCIONE UNA FILA");
        }
    }

    private void btnEliminar(ActionEvent e) {
    }

    private void InitPermisos() {
        this.vista.getBtnIngresar().getAccessibleContext().setAccessibleName("Notas-Tipos-de-Notas-Ingresar");
        this.vista.getBtnActualizar().getAccessibleContext().setAccessibleName("Notas-Tipos-de-Notas-Actualizar");
        this.vista.getBtnEditar().getAccessibleContext().setAccessibleName("Notas-Tipos-de-Notas-Editar");
        this.vista.getBtnEliminar().getAccessibleContext().setAccessibleName("Notas-Tipos-de-Notas-Eliminar");
        CONS.activarBtns(this.vista.getBtnIngresar(), this.vista.getBtnActualizar(), this.vista.getBtnEditar(), this.vista.getBtnEliminar());
    }
}

