/*
 * Decompiled with CFR 0.152.
 */
package controlador.pagos;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.CMBAlumnoBD;
import modelo.alumno.MallaAlumnoMD;
import modelo.estilo.TblEstilo;
import modelo.pagos.ComprobantePagoBD;
import modelo.pagos.ComprobantePagoMD;
import modelo.pagos.PagoMateriaBD;
import modelo.pagos.PagoMateriaMD;
import modelo.pagos.UtilComprobanteBD;
import modelo.periodolectivo.CMBPeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.AlumnoMD;
import modelo.validaciones.Validar;
import vista.pagos.FrmComprobantes;

public class FRMComprobanteCTR
extends DCTR {
    private final FrmComprobantes FRM = new FrmComprobantes();
    private ComprobantePagoMD cp;
    private List<PagoMateriaMD> pms;
    private List<PeriodoLectivoMD> pls;
    private List<AlumnoMD> as;
    private List<MallaAlumnoMD> ms;
    private final CMBPeriodoLectivoBD PLBD = CMBPeriodoLectivoBD.single();
    private final CMBAlumnoBD CABD = CMBAlumnoBD.single();
    private final UtilComprobanteBD UCBD = UtilComprobanteBD.single();
    private final ComprobantePagoBD CPBD = ComprobantePagoBD.single();
    private final PagoMateriaBD PMBD = PagoMateriaBD.single();
    private DefaultTableModel mdTblAlum;
    private DefaultTableModel mdTblMate;
    private FileInputStream fis = null;
    private int lonBytes = 0;

    public FRMComprobanteCTR(VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
    }

    public void iniciar() {
        this.iniciarCmbPeriodo();
        this.inicarTbls();
        this.iniciarBuscarAlumno();
        this.iniciarAcciones();
        this.iniciarEventos();
        this.ctrPrin.agregarVtn(this.FRM);
    }

    private void iniciarAcciones() {
        this.FRM.getBtnBuscarImagen().addActionListener(e -> this.buscarImagen());
        this.FRM.getBtnGuardar().addActionListener(e -> this.guardar());
        this.FRM.getBtnAdd().addActionListener(e -> this.agregarMateria());
    }

    private void inicarTbls() {
        String[] T_TBLALUM = new String[]{"Nombre"};
        this.mdTblAlum = TblEstilo.modelTblSinEditar(T_TBLALUM);
        this.FRM.getTblAlumnos().setModel(this.mdTblAlum);
        String[] T_TBLMATERIA = new String[]{"Materia", "# Matricula", "Monto"};
        this.mdTblMate = TblEstilo.modelTblSinEditar(T_TBLMATERIA);
        this.FRM.getTblMaterias().setModel(this.mdTblMate);
    }

    private void iniciarCmbPeriodo() {
        this.pls = this.PLBD.getForCmbSoloAbiertos();
        this.FRM.getCmbPeriodo().removeAllItems();
        this.FRM.getCmbPeriodo().addItem("Seleccione");
        this.pls.forEach(pl -> this.FRM.getCmbPeriodo().addItem(pl.getNombre()));
        this.cp = new ComprobantePagoMD();
    }

    private void iniciarBuscarAlumno() {
        this.FRM.getBtnBuscarAlumno().addActionListener(e -> this.buscarAlumno(this.FRM.getTxtAlumno().getText().trim()));
        this.FRM.getTxtAlumno().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FRMComprobanteCTR.this.buscarAlumno(FRMComprobanteCTR.this.FRM.getTxtAlumno().getText().trim());
                }
            }
        });
    }

    private void buscarAlumno(String aguja) {
        int posPeriodo = this.FRM.getCmbPeriodo().getSelectedIndex();
        if (posPeriodo > 0) {
            this.cursorCarga(this.FRM);
            this.as = this.CABD.getForBusquedaPeriodo(aguja, this.pls.get(posPeriodo - 1).getID());
            this.mdTblAlum.setRowCount(0);
            this.as.forEach(a -> this.mdTblAlum.addRow(new Object[]{a.getApellidosNombres()}));
            this.cursorNormal(this.FRM);
        } else {
            JOptionPane.showMessageDialog(this.FRM, "Debe seleccionar un periodo antes de buscar.");
        }
    }

    private void buscarImagen() {
        JFileChooser j = new JFileChooser();
        j.setFileSelectionMode(0);
        int estado = j.showOpenDialog(null);
        if (estado == 0) {
            this.FRM.getLblImagen().setIcon(null);
            try {
                this.fis = new FileInputStream(j.getSelectedFile());
                this.lonBytes = (int)j.getSelectedFile().length();
                Image icono = ImageIO.read(j.getSelectedFile()).getScaledInstance(this.FRM.getLblImagen().getWidth(), this.FRM.getLblImagen().getHeight(), 4);
                this.FRM.getLblImagen().setIcon(new ImageIcon(icono));
                this.FRM.getLblImagen().updateUI();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "No se puede cargar la imagen.\n" + e.getMessage());
            }
        }
    }

    private void iniciarEventos() {
        this.FRM.getTblAlumnos().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FRMComprobanteCTR.this.cargarMateriasAlumno();
                FRMComprobanteCTR.this.existeComprobantePago();
            }
        });
        this.FRM.getCmbMaterias().addActionListener(e -> {
            if (this.vtnCargada) {
                this.selectMateria();
            }
        });
    }

    private void cargarMateriasAlumno() {
        int posAlmn = this.FRM.getTblAlumnos().getSelectedRow();
        if (posAlmn >= 0) {
            this.FRM.getLblAlumno().setText(this.as.get(posAlmn).getApellidosNombres());
            this.cursorCarga(this.FRM);
            this.ms = this.UCBD.getByAlumno(this.as.get(posAlmn).getId_Alumno());
            this.llenarCmbMateria(this.ms);
            this.cursorNormal(this.FRM);
            this.selectMateria();
        } else {
            JOptionPane.showMessageDialog(null, "No selecciono un alumno.");
        }
    }

    private void existeComprobantePago() {
        int posAlmn = this.FRM.getTblAlumnos().getSelectedRow();
        int posPeriodo = this.FRM.getCmbPeriodo().getSelectedIndex();
        if (posAlmn >= 0 && posPeriodo > 0) {
            this.cp = this.CPBD.getByAlumnoPeriodo(this.as.get(posAlmn).getId_Alumno(), this.pls.get(posPeriodo - 1).getID());
            if (this.cp.getComprobante() != null) {
                Image icono = this.cp.getComprobante().getScaledInstance(this.FRM.getLblImagen().getWidth(), this.FRM.getLblImagen().getHeight(), 4);
                this.FRM.getLblImagen().setIcon(new ImageIcon(icono));
                this.FRM.getLblImagen().updateUI();
            }
            this.FRM.getTxtCodigo().setText(this.cp.getCodigo());
            this.FRM.getTxtObservaciones().setText(this.cp.getObservaciones());
            this.FRM.getTxtMontoTotal().setText(this.cp.getTotal() + "");
            this.fis = null;
            this.lonBytes = 0;
            if (this.cp.getId() != 0) {
                this.pms = this.PMBD.getByComprobante(this.cp.getId());
                this.llenarTblMateria(this.pms);
            } else {
                this.pms = null;
                this.pms = new ArrayList<PagoMateriaMD>();
                this.mdTblMate.setRowCount(0);
            }
        }
    }

    private void selectMateria() {
        int posMateria = this.FRM.getCmbMaterias().getSelectedIndex();
        if (posMateria >= 0 && this.ms.size() > 0) {
            this.FRM.getTxtNoMatricula().setText(this.ms.get(posMateria).getMallaNumMatricula() + "");
        }
    }

    private void guardar() {
        int posAlmn = this.FRM.getTblAlumnos().getSelectedRow();
        int posPeriodo = this.FRM.getCmbPeriodo().getSelectedIndex();
        if (posAlmn >= 0 && posPeriodo > 0 && this.frmValido()) {
            this.cp.setPeriodo(this.pls.get(posPeriodo - 1));
            this.cp.setAlumno(this.as.get(posAlmn));
            this.cp.setTotal(Double.parseDouble(this.FRM.getTxtMontoTotal().getText()));
            this.cp.setObservaciones(this.FRM.getTxtObservaciones().getText());
            this.cp.setFile(this.fis);
            this.cp.setLongBytes(this.lonBytes);
            this.cp.setCodigo(this.FRM.getTxtCodigo().getText());
            this.cursorCarga(this.FRM);
            if (this.cp.getId() == 0) {
                int idGenerado = this.CPBD.guardar(this.cp);
                if (idGenerado > 0) {
                    this.cp.setId(idGenerado);
                    this.guardarPagos();
                    JOptionPane.showMessageDialog(this.FRM, "Guardamos correctamente el comprobante.");
                }
            } else {
                if (this.CPBD.editar(this.cp) > 0) {
                    this.guardarPagos();
                    JOptionPane.showMessageDialog(this.FRM, "Editamos correctamente el comprobante.");
                }
                if (this.fis != null && this.lonBytes != 0) {
                    this.CPBD.editarFoto(this.cp);
                }
            }
            this.cursorNormal(this.FRM);
        } else {
            JOptionPane.showMessageDialog(this.FRM, "No tenemos datos que guardar, debe llenar el formulario.");
        }
    }

    private void guardarPagos() {
        this.pms.forEach(p -> {
            if (p.getId() != 0) {
                this.PMBD.editar((PagoMateriaMD)p);
            } else {
                this.PMBD.guardar((PagoMateriaMD)p);
            }
        });
    }

    private boolean frmValido() {
        boolean valido;
        boolean bl = valido = !this.FRM.getTxtCodigo().getText().equals("");
        if (!Validar.esNumerosDecimales(this.FRM.getTxtMontoTotal().getText())) {
            this.FRM.getLblEstado().setText("Debe ingresar un monto valido");
            valido = false;
        }
        return valido;
    }

    private void agregarMateria() {
        PagoMateriaMD pm = new PagoMateriaMD();
        int posMateria = this.FRM.getCmbMaterias().getSelectedIndex();
        if (posMateria >= 0 && !this.FRM.getCmbMaterias().getSelectedItem().toString().equals("No tiene materias pendientes.") && this.frmMateriaValida()) {
            pm.setComprobante(this.cp);
            pm.setMallaAlumno(this.ms.get(posMateria));
            pm.setNumMatricula(Integer.parseInt(this.FRM.getTxtNoMatricula().getText()));
            pm.setPago(Double.parseDouble(this.FRM.getTxtMonto().getText()));
            this.pms.add(pm);
            this.ms.remove(posMateria);
            this.FRM.getTxtMonto().setText("");
            this.FRM.getTxtNoMatricula().setText("");
            this.llenarCmbMateria(this.ms);
            this.llenarTblMateria(this.pms);
        } else {
            JOptionPane.showMessageDialog(this.FRM, "No tenemos todos los datos necesarios para agregar la materia.");
        }
    }

    private boolean frmMateriaValida() {
        return Validar.esNumeros(this.FRM.getTxtNoMatricula().getText()) && Validar.esNumerosDecimales(this.FRM.getTxtMonto().getText());
    }

    private void llenarCmbMateria(List<MallaAlumnoMD> ms) {
        this.FRM.getCmbMaterias().removeAllItems();
        ms.forEach(m -> this.FRM.getCmbMaterias().addItem(m.getMateria().getCodigo() + " | " + m.getMateria().getNombre()));
        if (ms.isEmpty()) {
            this.FRM.getCmbMaterias().addItem("No tiene materias pendientes.");
        }
    }

    private void llenarTblMateria(List<PagoMateriaMD> pms) {
        this.mdTblMate.setRowCount(0);
        pms.forEach(pm -> {
            Object[] r = new Object[]{pm.getMallaAlumno().getMateria().getNombre(), pm.getNumMatricula(), pm.getPago()};
            this.mdTblMate.addRow(r);
        });
    }
}

