/*
 * Decompiled with CFR 0.152.
 */
package controlador.notas.ux;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class RowStyle
extends DefaultTableCellRenderer {
    private final int columna;
    private Map<String, Color> estados;
    private Color bgColor;

    public RowStyle(int columna) {
        this.columna = columna;
    }

    public Color getBgColor() {
        if (this.bgColor == null) {
            return Color.WHITE;
        }
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void setEstados(Map<String, Color> estados) {
        this.estados = estados;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(this.bgColor);
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        try {
            String valor = table.getValueAt(row, this.columna).toString();
            Color color = this.estados.entrySet().stream().filter(item -> ((String)item.getKey()).toLowerCase().contains(valor.toLowerCase())).map(c -> (Color)c.getValue()).findFirst().orElse(null);
            this.setForeground(color);
            this.setHorizontalAlignment(0);
            this.setFont(new Font("Arial", 0, 11));
            table.setSelectionBackground(Color.lightGray);
            this.setHorizontalAlignment(0);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return this;
    }
}

