/*
 * Decompiled with CFR 0.152.
 */
package controlador.notas;

import controlador.Libraries.Effects;
import controlador.Libraries.Middlewares;
import controlador.Libraries.Validaciones;
import controlador.Libraries.cellEditor.ComboBoxCellEditor;
import controlador.Libraries.cellEditor.TextFieldCellEditor;
import controlador.notas.AbstractVtn;
import controlador.notas.ReportesCTR;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import modelo.alumno.AlumnoCursoMD;
import modelo.notas.NotasBD;
import modelo.persona.DocenteMD;
import modelo.tipoDeNota.TipoDeNotaMD;
import utils.CONS;
import vista.notas.VtnNotas;
import vista.principal.VtnPrincipal;

public class VtnNotasCTR
extends AbstractVtn {
    private final BiFunction<JTable, String, Integer> getIndex = (tabla, nombre) -> tabla.getColumnModel().getColumnIndex(nombre);

    public VtnNotasCTR(VtnPrincipal desktop, VtnNotas vista) {
        super(desktop, vista);
    }

    public void Init() {
        this.tablaTrad = (DefaultTableModel)this.vista.getTblTrad().getModel();
        this.tablaDuales = (DefaultTableModel)this.vista.getTblDual().getModel();
        this.jTblTrad = this.vista.getTblTrad();
        this.jTblDual = this.vista.getTblDual();
        this.listaDocentes = CONS.ROL.getNombre().toLowerCase().contains("docente") ? this.docenteBD.selectAll(CONS.USUARIO.getUsername()) : this.docenteBD.selectAll();
        Effects.addInDesktopPane(this.vista, this.desktop.getDpnlPrincipal());
        this.activarForm(false);
        this.cargarComboDocente();
        this.cargarComboPeriodos();
        this.setLblCarrera();
        this.cargarComboCiclo();
        this.cargarComboMaterias();
        this.InitEventos();
        this.activarForm(true);
    }

    private void InitEventos() {
        this.vista.getCmbDocente().addActionListener(e -> this.cargarComboPeriodos());
        this.vista.getCmbPeriodoLectivo().addActionListener(e -> this.cargarComboCiclo());
        this.vista.getCmbPeriodoLectivo().addItemListener(e -> this.setLblCarrera());
        this.vista.getCmbCiclo().addActionListener(e -> this.cargarComboMaterias());
        this.vista.getBtnVerNotas().addActionListener(e -> this.btnVerNotas(e));
        this.vista.getBtnImprimir().addActionListener(e -> this.btnImprimir(e));
        this.vista.getBtnBuscar().addActionListener(e -> this.buscarDocente());
        this.vista.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String texto;
                if (e.getKeyCode() == 10 && (texto = VtnNotasCTR.this.vista.getTxtBuscar().getText()).length() >= 10) {
                    VtnNotasCTR.this.buscarDocente();
                }
            }
        });
        this.tablaTrad.addTableModelListener(new TableModelListener(){
            boolean active = false;

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!this.active && e.getType() == 0) {
                    this.active = true;
                    VtnNotasCTR.this.carlcularNotasTradicionales(VtnNotasCTR.this.jTblTrad);
                    this.active = false;
                }
            }
        });
        this.tablaDuales.addTableModelListener(new TableModelListener(){
            boolean active = false;

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!this.active && e.getType() == 0) {
                    this.active = true;
                    VtnNotasCTR.this.cacularNotasDuales(VtnNotasCTR.this.jTblDual);
                    this.active = false;
                }
            }
        });
        this.vista.getTxtBuscar().addKeyListener(Validaciones.validarNumeros());
        this.InitPermisos();
    }

    private void InitTablas() {
        ArrayList<String> items = new ArrayList<String>();
        items.add("Asiste");
        items.add("No asiste");
        items.add("Retirado");
        items.add("Desertor");
        if (this.getModalidad().equalsIgnoreCase("tradicional") || this.getModalidad().equalsIgnoreCase("presencial") || this.getModalidad().equalsIgnoreCase("h\u00edbrida") || this.getModalidad().equalsIgnoreCase("especial")) {
            if (!this.getEstado()) {
                this.jTblTrad.getColumnModel().getColumn(6).setCellEditor(new TextFieldCellEditor(false));
                this.jTblTrad.getColumnModel().getColumn(7).setCellEditor(new TextFieldCellEditor(false));
                this.jTblTrad.getColumnModel().getColumn(9).setCellEditor(new TextFieldCellEditor(false));
                this.jTblTrad.getColumnModel().getColumn(10).setCellEditor(new TextFieldCellEditor(false));
                this.jTblTrad.getColumnModel().getColumn(11).setCellEditor(new TextFieldCellEditor(false));
                this.jTblTrad.getColumnModel().getColumn(14).setCellEditor(new TextFieldCellEditor(false));
                this.jTblTrad.getColumnModel().getColumn(16).setCellEditor(new ComboBoxCellEditor(false, items));
            } else {
                this.jTblTrad.getColumnModel().getColumn(6).setCellEditor(new TextFieldCellEditor(true));
                this.jTblTrad.getColumnModel().getColumn(7).setCellEditor(new TextFieldCellEditor(true));
                this.jTblTrad.getColumnModel().getColumn(9).setCellEditor(new TextFieldCellEditor(true));
                this.jTblTrad.getColumnModel().getColumn(10).setCellEditor(new TextFieldCellEditor(true));
                this.jTblTrad.getColumnModel().getColumn(11).setCellEditor(new TextFieldCellEditor(true));
                this.jTblTrad.getColumnModel().getColumn(14).setCellEditor(new TextFieldCellEditor(true));
                this.jTblTrad.getColumnModel().getColumn(16).setCellEditor(new ComboBoxCellEditor(true, items));
            }
        } else if (!this.getEstado()) {
            this.jTblDual.getColumnModel().getColumn(6).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(7).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(9).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(10).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(13).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(15).setCellEditor(new ComboBoxCellEditor(true, items));
        } else {
            this.jTblDual.getColumnModel().getColumn(6).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(7).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(9).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(10).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(13).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(15).setCellEditor(new ComboBoxCellEditor(true, items));
        }
        String nombrePeriodo = this.vista.getCmbPeriodoLectivo().getSelectedItem().toString();
        if (nombrePeriodo.equals("SCOP 3/2019 - 7/2019")) {
            this.jTblDual.getColumnModel().getColumn(6).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(7).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(9).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(10).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(13).setCellEditor(new TextFieldCellEditor(true));
            this.jTblDual.getColumnModel().getColumn(15).setCellEditor(new ComboBoxCellEditor(true, items));
        }
    }

    private void InitPermisos() {
        this.vista.getBtnImprimir().getAccessibleContext().setAccessibleName("Notas-Consultar-Notas-Imprimir");
        this.vista.getBtnVerNotas().getAccessibleContext().setAccessibleName("Notas-Consultar-Notas-Ver Notas");
        CONS.activarBtns(this.vista.getBtnImprimir(), this.vista.getBtnVerNotas());
    }

    private void mensajeDeError() {
        Effects.setTextInLabel(this.vista.getLblEstado(), "INGRESE UN NUMERO CORRECTO EJEMPLO (15.6)", CONS.ERROR_COLOR, 2);
    }

    private void errorDeNota(TipoDeNotaMD rango) {
        Effects.setTextInLabel(this.vista.getLblEstado(), "EL RANGO DE LA NOTA DEBE ESTAR ENTRE: 0 Y " + rango.getValorMaximo(), CONS.ERROR_COLOR, 2);
    }

    private void refreshTabla(Consumer<AlumnoCursoMD> loader, DefaultTableModel tabla) {
        this.activarForm(false);
        tabla.setRowCount(0);
        this.listaNotas.stream().forEach(loader);
        this.activarForm(true);
    }

    private int getSelectedRowTrad() {
        return this.vista.getTblTrad().getSelectedRow();
    }

    private int getSelectedColumTrad() {
        return this.vista.getTblTrad().getSelectedColumn();
    }

    private int getSelectedRowDuales() {
        return this.vista.getTblDual().getSelectedRow();
    }

    private int getSelectedColumDuales() {
        return this.vista.getTblDual().getSelectedColumn();
    }

    private String getModalidad() {
        return this.listaPeriodos.stream().filter(item -> item.getID() == this.getIdPeriodoLectivo()).map(c -> c.getCarrera().getModalidad()).findFirst().orElse("");
    }

    private int getHoras() {
        return this.listaMaterias.stream().filter(item -> item.getNombre().equals(this.vista.getCmbAsignatura().getSelectedItem().toString())).map(c -> c.getHorasPresenciales()).findFirst().orElse(1);
    }

    private TipoDeNotaMD getRango(String nombreNota) {
        return this.listaValidaciones.stream().filter(item -> item.getNombre().equals(nombreNota)).findFirst().get();
    }

    private Predicate<NotasBD> buscar(String busqueda) {
        return item -> item.getTipoDeNota().getNombre().equals(busqueda);
    }

    private Consumer<NotasBD> editarNota(int fila, int columna, TableModel tabla) {
        return obj -> {
            String text = tabla.getValueAt(fila, columna).toString();
            obj.setNotaValor(Middlewares.conversor(text));
            obj.editar();
        };
    }

    private void activarForm(boolean estado) {
        if (CONS.ROL.getNombre().toLowerCase().contains("docente")) {
            this.vista.getTxtBuscar().setVisible(false);
            this.vista.getBtnBuscar().setVisible(false);
            this.vista.getCmbDocente().setEnabled(false);
        } else {
            this.vista.getTxtBuscar().setEnabled(estado);
            this.vista.getBtnBuscar().setEnabled(estado);
            this.vista.getCmbDocente().setEnabled(estado);
        }
        this.vista.getCmbPeriodoLectivo().setEnabled(estado);
        this.vista.getCmbCiclo().setEnabled(estado);
        this.vista.getCmbAsignatura().setEnabled(estado);
        this.vista.getTblTrad().setEnabled(estado);
    }

    private int calcularPorcentaje(int faltas, int horas) {
        if (horas == 0) {
            horas = 1;
        }
        return faltas * 100 / horas;
    }

    private void editarFaltas(int fila, JTable tabla, Consumer<AlumnoCursoMD> loader, Function<String, Void> editar, Function<Void, Void> sumar) {
        block10: {
            int colFaltas = this.getIndex.apply(tabla, "Faltas");
            int colEstado = this.getIndex.apply(tabla, "Estado");
            int conPorcentaje = this.getIndex.apply(tabla, "% Faltas");
            int colAsistencia = this.getIndex.apply(tabla, "Asistencia");
            String faltasText = tabla.getValueAt(fila, colFaltas).toString();
            if (faltasText.isEmpty()) {
                faltasText = "2.2";
            }
            if (Validaciones.isInt(faltasText)) {
                try {
                    int faltas = new Integer(faltasText);
                    int oldFaltas = ((AlumnoCursoMD)this.listaNotas.get(fila)).getNumFalta();
                    if (faltas == oldFaltas) break block10;
                    if (faltas <= this.getHoras()) {
                        int horas = this.getHoras();
                        int porcentaje = 0;
                        if (horas <= 0) {
                            horas = 1;
                        }
                        porcentaje = faltas * 100 / horas;
                        tabla.setValueAt(porcentaje, fila, conPorcentaje);
                        String estado = tabla.getValueAt(fila, colEstado).toString();
                        String asistencia = tabla.getValueAt(fila, colAsistencia).toString();
                        if (!estado.equalsIgnoreCase("RETIRADO") && !asistencia.equalsIgnoreCase("RETIRADO")) {
                            if (porcentaje >= 25) {
                                tabla.setValueAt("REPROBADO", fila, colEstado);
                            } else {
                                sumar.apply(null);
                            }
                        }
                        tabla.setValueAt(faltas, fila, colFaltas);
                        editar.apply("");
                        break block10;
                    }
                    Effects.setTextInLabel(this.vista.getLblEstado(), "LAS FALTAS NO PUEDEN SER MAYORES AL NUMERO DE HORAS", CONS.ERROR_COLOR, 2);
                    this.refreshTabla(loader, (DefaultTableModel)tabla.getModel());
                }
                catch (NumberFormatException e) {
                    Effects.setTextInLabel(this.vista.getLblEstado(), "INGRESE UN NUMERO VALIDO!!", CONS.ERROR_COLOR, 2);
                    this.refreshTabla(loader, (DefaultTableModel)tabla.getModel());
                }
            } else {
                Effects.setTextInLabel(this.vista.getLblEstado(), "INGRESE SOLO NUMERO ENTEROS!!", CONS.ERROR_COLOR, 2);
                this.refreshTabla(loader, (DefaultTableModel)tabla.getModel());
            }
        }
    }

    private void cargarTabla(Consumer<AlumnoCursoMD> loader) {
        new Thread(() -> {
            this.cargarTabla = false;
            String cursoNombre = this.vista.getCmbCiclo().getSelectedItem().toString();
            String nombreMateria = this.vista.getCmbAsignatura().getSelectedItem().toString();
            this.listaNotas = this.almnCursoBD.selectWhere(cursoNombre, nombreMateria, this.getIdDocente(), this.getIdPeriodoLectivo());
            this.InitTablas();
            this.listaNotas.stream().forEach(loader);
            this.cargarTabla = true;
            this.vista.getLblResultados().setText(this.listaNotas.size() + " Resultados");
        }).start();
    }

    private double getValorNota(int index, String tipoNota) {
        return ((AlumnoCursoMD)this.listaNotas.get(index)).getNotas().stream().filter(item -> item.getTipoDeNota().getNombre().equals(tipoNota)).findFirst().map(c -> c.getNotaValor()).orElse(((AlumnoCursoMD)this.listaNotas.get(index)).getNotaFinal());
    }

    private void carlcularNotasTradicionales(JTable tabla) {
        int fila = tabla.getSelectedRow();
        int columna = tabla.getSelectedColumn();
        switch (columna) {
            case 6: {
                String valueText = tabla.getValueAt(fila, columna).toString();
                String tipoNota = "APORTE 1";
                this.guardarTRAD(fila, valueText, tipoNota);
                break;
            }
            case 7: {
                String valueText = tabla.getValueAt(fila, columna).toString();
                String tipoNota = "EXAMEN INTERCICLO";
                this.guardarTRAD(fila, valueText, tipoNota);
                break;
            }
            case 9: {
                String valueText = tabla.getValueAt(fila, columna).toString();
                String tipoNota = "APORTE 2";
                this.guardarTRAD(fila, valueText, tipoNota);
                break;
            }
            case 10: {
                String valueText = tabla.getValueAt(fila, columna).toString();
                String tipoNota = "EXAMEN FINAL";
                this.guardarTRAD(fila, valueText, tipoNota);
                break;
            }
            case 11: {
                String valueText = tabla.getValueAt(fila, columna).toString();
                String tipoNota = "EXAMEN DE RECUPERACION";
                this.guardarTRAD(fila, valueText, tipoNota);
                break;
            }
            case 14: {
                this.editarFaltas(fila, tabla, this.agregarFilasTrad(), this.editarTrad(), this.sumarTrad());
                break;
            }
            case 16: {
                String asistencia = tabla.getValueAt(fila, columna).toString().toLowerCase();
                int colEstado = this.getIndex.apply(tabla, "Estado");
                if (asistencia.equalsIgnoreCase("retirado")) {
                    tabla.setValueAt("RETIRADO", fila, colEstado);
                    this.editarTrad().apply(null);
                    break;
                }
                if (asistencia.equalsIgnoreCase("asiste")) {
                    tabla.setValueAt("REPROBADO", fila, colEstado);
                    this.sumarTrad().apply(null);
                    this.editarTrad().apply("");
                    break;
                }
                tabla.setValueAt("REPROBADO", fila, colEstado);
                this.editarTrad().apply("");
            }
        }
    }

    private Consumer<AlumnoCursoMD> agregarFilasTrad() {
        return obj -> this.tablaTrad.addRow(new Object[]{this.tablaTrad.getDataVector().size() + 1, obj.getAlumno().getIdentificacion(), obj.getAlumno().getPrimerApellido(), obj.getAlumno().getSegundoApellido(), obj.getAlumno().getPrimerNombre(), obj.getAlumno().getSegundoNombre(), obj.getNotas().stream().filter(this.buscar("APORTE 1")).findAny().get().getNotaValor(), obj.getNotas().stream().filter(this.buscar("EXAMEN INTERCICLO")).findAny().get().getNotaValor(), obj.getNotas().stream().filter(this.buscar("NOTA INTERCICLO")).findAny().get().getNotaValor(), obj.getNotas().stream().filter(this.buscar("APORTE 2")).findAny().get().getNotaValor(), obj.getNotas().stream().filter(this.buscar("EXAMEN FINAL")).findAny().get().getNotaValor(), obj.getNotas().stream().filter(this.buscar("EXAMEN DE RECUPERACION")).findAny().get().getNotaValor(), (int)Middlewares.conversor("" + obj.getNotaFinal()), obj.getEstado(), obj.getNumFalta(), this.calcularPorcentaje(obj.getNumFalta(), this.getHoras()), obj.getAsistencia()});
    }

    private Consumer<AlumnoCursoMD> agregarFilasDuales() {
        return obj -> this.tablaDuales.addRow(new Object[]{this.tablaDuales.getDataVector().size() + 1, obj.getAlumno().getIdentificacion(), obj.getAlumno().getPrimerApellido(), obj.getAlumno().getSegundoApellido(), obj.getAlumno().getPrimerNombre(), obj.getAlumno().getSegundoNombre(), obj.getNotas().stream().filter(this.buscar("G. DE AULA 1")).findAny().get().getNotaValor(), obj.getNotas().stream().filter(this.buscar("G. DE AULA 2")).findAny().get().getNotaValor(), obj.getNotas().stream().filter(this.buscar("TOTAL GESTION")).findAny().get().getNotaValor(), obj.getNotas().stream().filter(this.buscar("EXAMEN FINAL")).findAny().get().getNotaValor(), obj.getNotas().stream().filter(this.buscar("EXAMEN DE RECUPERACION")).findAny().get().getNotaValor(), (int)Middlewares.conversor("" + obj.getNotaFinal()), obj.getEstado(), obj.getNumFalta(), this.carcularPorcentaje(obj.getNumFalta(), this.getHoras()), obj.getAsistencia()});
    }

    private void guardarTRAD(int fila, String valueText, String tipoNota) {
        if (Validaciones.isDecimal(valueText)) {
            double value = Middlewares.conversor(valueText);
            if (value != this.getValorNota(fila, tipoNota)) {
                TipoDeNotaMD rango = this.getRango(tipoNota);
                if (value > rango.getValorMaximo()) {
                    this.errorDeNota(rango);
                    this.refreshTabla(this.agregarFilasTrad(), this.tablaTrad);
                } else {
                    this.sumarTrad().apply(null);
                    this.editarTrad().apply(tipoNota);
                    this.refreshTabla(this.agregarFilasTrad(), this.tablaTrad);
                }
            }
        } else {
            this.mensajeDeError();
            this.refreshTabla(this.agregarFilasTrad(), this.tablaTrad);
        }
    }

    private Function<Void, Void> sumarTrad() {
        return t -> {
            int fila = this.getSelectedRowTrad();
            double aporte1 = Middlewares.conversor(this.tablaTrad.getValueAt(fila, 6).toString());
            double examenInterCiclo = Middlewares.conversor(this.tablaTrad.getValueAt(fila, 7).toString());
            double totalInterciclo = aporte1 + examenInterCiclo;
            this.tablaTrad.setValueAt(totalInterciclo, fila, 8);
            double aporte2 = Middlewares.conversor(this.tablaTrad.getValueAt(fila, 9).toString());
            double examenFinal = Middlewares.conversor(this.tablaTrad.getValueAt(fila, 10).toString());
            double examenRecuperacion = Middlewares.conversor(this.tablaTrad.getValueAt(fila, 11).toString());
            double notaFinal = examenRecuperacion != 0.0 ? totalInterciclo + aporte2 + examenRecuperacion : totalInterciclo + aporte2 + examenFinal;
            this.validarAprobado(examenFinal, examenRecuperacion, Math.round(notaFinal), this.jTblTrad);
            this.tablaTrad.setValueAt(Math.round(notaFinal), fila, 12);
            return null;
        };
    }

    private void validarAprobado(double examenFinal, double examenRecuperacion, double notaFinal, JTable tabla) {
        int fila = tabla.getSelectedRow();
        int colEstado = this.getIndex.apply(tabla, "Estado");
        int colFaltas = this.getIndex.apply(tabla, "% Faltas");
        TipoDeNotaMD rango = null;
        String estado = tabla.getValueAt(fila, colEstado).toString();
        int faltas = (int)Math.round(Middlewares.conversor(tabla.getValueAt(fila, colFaltas).toString()));
        if (!estado.equalsIgnoreCase("RETIRADO") && faltas < 25) {
            if (examenRecuperacion > 0.0) {
                rango = this.getRango("EXAMEN DE RECUPERACION");
                if (examenRecuperacion < rango.getValorMinimo()) {
                    tabla.setValueAt("REPROBADO", fila, colEstado);
                } else {
                    this.validarNotaFinal(notaFinal, tabla, fila, colEstado);
                }
            } else {
                rango = this.getRango("EXAMEN FINAL");
                if (examenFinal < rango.getValorMinimo()) {
                    tabla.setValueAt("REPROBADO", fila, colEstado);
                } else {
                    this.validarNotaFinal(notaFinal, tabla, fila, colEstado);
                }
            }
        }
    }

    private void validarNotaFinal(double notaFinal, JTable tabla, int fila, int colEstado) {
        if (notaFinal >= this.getRango("NOTA FINAL").getValorMinimo()) {
            tabla.setValueAt("APROBADO", fila, colEstado);
        } else {
            tabla.setValueAt("REPROBADO", fila, colEstado);
        }
    }

    private Function<String, Void> editarTrad() {
        return tipoNota -> {
            this.jTblTrad.setEnabled(false);
            int fila = this.getSelectedRowTrad();
            int columa = this.getSelectedColumTrad();
            String estado = this.vista.getTblTrad().getValueAt(fila, 13).toString();
            String asistencia = Middlewares.capitalize(this.vista.getTblTrad().getValueAt(fila, 16).toString());
            AlumnoCursoMD alumno = (AlumnoCursoMD)this.listaNotas.get(fila);
            if (tipoNota != null) {
                List<NotasBD> notas = alumno.getNotas();
                notas.stream().filter(this.buscar((String)tipoNota)).collect(Collectors.toList()).forEach(this.editarNota(fila, columa, this.tablaTrad));
                notas.stream().filter(this.buscar("NOTA INTERCICLO")).collect(Collectors.toList()).forEach(this.editarNota(fila, 8, this.tablaTrad));
                if (asistencia.equalsIgnoreCase("retirado")) {
                    estado = "RETIRADO";
                }
                alumno.setNotaFinal(Middlewares.conversor(this.tablaTrad.getValueAt(fila, 12).toString()));
            }
            alumno.setAsistencia(asistencia);
            alumno.setEstado(estado);
            alumno.setNumFalta(Integer.valueOf(this.tablaTrad.getValueAt(fila, 14).toString()));
            this.almnCursoBD.editar(alumno);
            this.jTblTrad.setEnabled(true);
            return null;
        };
    }

    private void guardarDUAL(int fila, String valueText, String tipoNota) {
        if (Validaciones.isDecimal(valueText)) {
            double value = Middlewares.conversor(valueText);
            if (value != this.getValorNota(fila, tipoNota)) {
                TipoDeNotaMD rango = this.getRango(tipoNota);
                if (value > rango.getValorMaximo()) {
                    this.errorDeNota(rango);
                    this.refreshTabla(this.agregarFilasDuales(), this.tablaDuales);
                } else {
                    this.sumarDual().apply(null);
                    this.editarDuales().apply(tipoNota);
                    this.refreshTabla(this.agregarFilasDuales(), this.tablaDuales);
                }
            }
        } else {
            this.mensajeDeError();
            this.refreshTabla(this.agregarFilasDuales(), this.tablaDuales);
        }
    }

    private Function<Void, Void> sumarDual() {
        return t -> {
            int fila = this.getSelectedRowDuales();
            double gestion1 = Middlewares.conversor(this.jTblDual.getValueAt(fila, 6).toString());
            double gestion2 = Middlewares.conversor(this.jTblDual.getValueAt(fila, 7).toString());
            double totalGestion = gestion1 + gestion2;
            this.jTblDual.setValueAt(totalGestion, fila, 8);
            double examenFinal = Middlewares.conversor(this.jTblDual.getValueAt(fila, 9).toString());
            double examenRecuperacion = Middlewares.conversor(this.jTblDual.getValueAt(fila, 10).toString());
            double notaFinal = examenRecuperacion != 0.0 ? totalGestion + examenRecuperacion : totalGestion + examenFinal;
            this.validarAprobado(examenFinal, examenRecuperacion, Math.round(notaFinal), this.jTblDual);
            this.jTblDual.setValueAt(Math.round(notaFinal), fila, 11);
            return null;
        };
    }

    private void cacularNotasDuales(JTable tabla) {
        int fila = tabla.getSelectedRow();
        int columna = tabla.getSelectedColumn();
        switch (columna) {
            case 6: {
                String valueText = tabla.getValueAt(fila, columna).toString();
                String tipoNota = "G. DE AULA 1";
                this.guardarDUAL(fila, valueText, tipoNota);
                break;
            }
            case 7: {
                String tipoNota = "G. DE AULA 2";
                String valueText = tabla.getValueAt(fila, columna).toString();
                this.guardarDUAL(fila, valueText, tipoNota);
                break;
            }
            case 9: {
                String tipoNota = "EXAMEN FINAL";
                String valueText = tabla.getValueAt(fila, columna).toString();
                this.guardarDUAL(fila, valueText, tipoNota);
                break;
            }
            case 10: {
                String tipoNota = "EXAMEN DE RECUPERACION";
                String valueText = tabla.getValueAt(fila, columna).toString();
                this.guardarDUAL(fila, valueText, tipoNota);
                break;
            }
            case 13: {
                this.editarFaltas(fila, tabla, this.agregarFilasDuales(), this.editarDuales(), this.sumarDual());
                break;
            }
            case 15: {
                String asistencia = tabla.getValueAt(fila, columna).toString().toLowerCase();
                int colEstado = this.getIndex.apply(tabla, "Estado");
                if (asistencia.equalsIgnoreCase("retirado")) {
                    tabla.setValueAt("RETIRADO", fila, colEstado);
                    this.editarDuales().apply(null);
                    break;
                }
                if (asistencia.equalsIgnoreCase("asiste")) {
                    tabla.setValueAt("REPROBADO", fila, colEstado);
                    this.sumarDual().apply(null);
                    this.editarDuales().apply("");
                    break;
                }
                tabla.setValueAt("REPROBADO", fila, colEstado);
                this.editarDuales().apply("");
                break;
            }
        }
    }

    private Function<String, Void> editarDuales() {
        return tipoNota -> {
            this.jTblDual.setEnabled(false);
            int fila = this.getSelectedRowDuales();
            int columna = this.getSelectedColumDuales();
            String estado = this.jTblDual.getValueAt(fila, 12).toString();
            String asistencia = this.jTblDual.getValueAt(fila, 15).toString();
            AlumnoCursoMD alumno = (AlumnoCursoMD)this.listaNotas.get(fila);
            if (tipoNota != null) {
                List<NotasBD> notas = alumno.getNotas();
                notas.stream().filter(this.buscar((String)tipoNota)).collect(Collectors.toList()).forEach(this.editarNota(fila, columna, this.tablaDuales));
                notas.stream().filter(this.buscar("TOTAL GESTION")).collect(Collectors.toList()).forEach(this.editarNota(fila, 8, this.tablaDuales));
                if (asistencia.equalsIgnoreCase("retirado")) {
                    estado = "RETIRADO";
                }
                alumno.setNotaFinal(Middlewares.conversor(this.jTblDual.getValueAt(fila, 11).toString()));
            }
            alumno.setEstado(estado);
            alumno.setAsistencia(asistencia);
            alumno.setNumFalta(Integer.valueOf(this.tablaDuales.getValueAt(fila, 13).toString()));
            this.almnCursoBD.editar(alumno);
            this.jTblDual.setEnabled(true);
            return null;
        };
    }

    private int carcularPorcentaje(int faltas, int horas) {
        if (horas == 0) {
            horas = 1;
        }
        return faltas * 100 / horas;
    }

    private void btnVerNotas(ActionEvent e) {
        if (this.cargarTabla) {
            if (this.getModalidad().equalsIgnoreCase("TRADICIONAL") || this.getModalidad().equalsIgnoreCase("PRESENCIAL") || this.getModalidad().equalsIgnoreCase("H\u00cdBRIDA") || this.getModalidad().equalsIgnoreCase("ESPECIAL")) {
                this.vista.getTabPane().setSelectedIndex(0);
                this.jTblTrad.clearSelection();
                this.jTblTrad.removeAll();
                this.tablaTrad.setRowCount(0);
                this.cargarTabla(this.agregarFilasTrad());
            } else {
                this.vista.getTabPane().setSelectedIndex(1);
                this.jTblDual.clearSelection();
                this.jTblDual.removeAll();
                this.tablaDuales.setRowCount(0);
                this.cargarTabla(this.agregarFilasDuales());
            }
        } else {
            JOptionPane.showMessageDialog(this.vista, "YA HAY UNA CARGA PENDIENTE!");
        }
        this.vista.setTitle("NOTAS " + this.vista.getCmbCiclo().getSelectedItem().toString());
    }

    private void btnImprimir(ActionEvent e) {
        new Thread(() -> {
            int r = JOptionPane.showOptionDialog(this.vista, "Reporte de Notas por Curso\n\u00bfElegir el tipo de Reporte?", "REPORTE NOTAS", 1, 1, null, new Object[]{"Alumnos con menos de 70", "Alumnos entre 70 a 80", "Alumnos entre 80 a 90", "Alumnos entre 90 a 100", "Reporte Completo", "Reporte Interciclo", "Tabla Final", "SIGA"}, "Cancelar");
            Effects.setLoadCursor(this.vista);
            ReportesCTR reportes = new ReportesCTR(this.vista, this.getIdDocente(), this.getModalidad());
            reportes.setModalidad(this.getModalidad());
            this.desktop.getLblEstado().setText("CARGANDO REPORTE....");
            switch (r) {
                case 0: {
                    reportes.generarReporteMenos70();
                    break;
                }
                case 1: {
                    reportes.generarReporteEntre70_80();
                    break;
                }
                case 2: {
                    reportes.generarReporteEntre80_90();
                    break;
                }
                case 3: {
                    reportes.generarReporteEntre90_100();
                    break;
                }
                case 4: {
                    reportes.generarReporteCompleto();
                    break;
                }
                case 5: {
                    reportes.generarReporteInterciclo();
                    break;
                }
                case 6: {
                    reportes.generarReporteInformeFinalTabla();
                    break;
                }
                case 7: {
                    reportes.generarReporteInformeFinalTablaSIGA();
                    break;
                }
            }
            this.desktop.getLblEstado().setText("COMPLETADO");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                System.out.println(ex.getMessage());
            }
            this.desktop.getLblEstado().setText("");
            Effects.setDefaultCursor(this.vista);
            this.vista.getBtnVerNotas().setEnabled(true);
        }).start();
    }

    private void buscarDocente() {
        this.activarForm(false);
        this.vista.getCmbDocente().setSelectedItem(this.listaDocentes.entrySet().stream().filter(entry -> ((DocenteMD)entry.getValue()).getIdentificacion().equals(this.vista.getTxtBuscar().getText())).map(c -> (String)c.getKey()).findFirst().orElse(""));
        this.activarForm(true);
    }
}

