/*
 * Decompiled with CFR 0.152.
 */
package controlador.notas;

import controlador.Libraries.Effects;
import controlador.Libraries.Validaciones;
import controlador.notas.Reportes_ubCRT;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import modelo.curso.CursoBD;
import modelo.curso.CursoMD;
import modelo.materia.MateriaBD;
import modelo.materia.MateriaMD;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.DocenteBD;
import modelo.persona.DocenteMD;
import modelo.usuario.RolBD;
import modelo.usuario.UsuarioBD;
import utils.CONS;
import vista.notas.VtnControlUB;
import vista.principal.VtnPrincipal;

public class VtnControlUBCTR {
    private final VtnPrincipal desktop;
    private static VtnControlUB vista;
    private UsuarioBD usuario;
    private static RolBD rolSeleccionado;
    private static Map<String, DocenteMD> listaDocentes;
    private static List<PeriodoLectivoMD> listaPeriodos;
    private static List<MateriaMD> listaMaterias;
    private String itemCombo;
    protected static int idDocente;
    protected static int idPeriodoLectivo;
    protected static int idCurso;
    private final PeriodoLectivoBD periodoBD = new PeriodoLectivoBD();
    private final CursoBD cursoBD = new CursoBD();
    private final MateriaBD materiaBD = new MateriaBD();
    private final DocenteBD docenteBD = new DocenteBD();

    public VtnControlUBCTR(VtnPrincipal desktop, VtnControlUB vista, UsuarioBD usuario, RolBD rolSeleccionado) {
        this.desktop = desktop;
        VtnControlUBCTR.vista = vista;
        this.usuario = usuario;
        VtnControlUBCTR.rolSeleccionado = rolSeleccionado;
    }

    public void Init() {
        listaDocentes = rolSeleccionado.getNombre().toLowerCase().contains("docente") ? this.docenteBD.selectAll(this.usuario.getUsername()) : this.docenteBD.selectAll();
        Effects.addInDesktopPane(vista, this.desktop.getDpnlPrincipal());
        VtnControlUBCTR.activarForm(false);
        this.cargarComboDocente();
        this.cargarComboPeriodos();
        this.setLblCarrera();
        this.cargarComboCiclo();
        this.cargarComboMaterias();
        this.InitEventos();
        VtnControlUBCTR.activarForm(true);
        this.InitPermisos();
    }

    private void InitEventos() {
        vista.getCmbDocente().addActionListener(e -> this.cargarComboPeriodos());
        vista.getCmbPeriodoLectivo().addActionListener(e -> this.cargarComboCiclo());
        vista.getCmbPeriodoLectivo().addItemListener(e -> this.setLblCarrera());
        vista.getCmbCiclo().addActionListener(e -> this.cargarComboMaterias());
        vista.getBtnReportesUB().addActionListener(e -> this.btnReportesUB(e));
        vista.getBtnBuscar().addActionListener(e -> this.btnBuscar());
        vista.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String texto;
                if (e.getKeyCode() == 10 && (texto = vista.getTxtBuscar().getText()).length() >= 10) {
                    VtnControlUBCTR.this.btnBuscar();
                }
            }
        });
        vista.getTxtBuscar().addKeyListener(Validaciones.validarNumeros());
    }

    private void cargarComboDocente() {
        listaDocentes.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            DocenteMD value = (DocenteMD)entry.getValue();
            vista.getCmbDocente().addItem(key);
        });
    }

    private void cargarComboPeriodos() {
        vista.getCmbPeriodoLectivo().removeAllItems();
        vista.getLblCarrera().setText("");
        listaPeriodos = this.periodoBD.selectPeriodoWhere(this.getIdDocente());
        listaPeriodos.stream().forEach(obj -> vista.getCmbPeriodoLectivo().addItem(obj.getNombre()));
    }

    private void setLblCarrera() {
        vista.getLblCarrera().setText(listaPeriodos.stream().filter(item -> item.getID() == this.getIdPeriodoLectivo()).map(c -> c.getCarrera().getNombre()).findFirst().orElse(""));
    }

    private void cargarComboCiclo() {
        try {
            vista.getCmbCiclo().removeAllItems();
            this.cursoBD.selectCicloWhere(this.getIdDocente(), this.getIdPeriodoLectivo()).stream().forEach(obj -> vista.getCmbCiclo().addItem(obj + ""));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void cargarComboMaterias() {
        try {
            vista.getCmbAsignatura().removeAllItems();
            CursoMD curso = new CursoMD();
            DocenteMD docente = new DocenteMD();
            docente.setIdDocente(this.getIdDocente());
            curso.setDocente(docente);
            PeriodoLectivoMD periodo = new PeriodoLectivoMD();
            periodo.setID(this.getIdPeriodoLectivo());
            curso.setPeriodo(periodo);
            curso.setNombre(vista.getCmbCiclo().getSelectedItem().toString());
            listaMaterias = this.materiaBD.selectWhere(curso);
            listaMaterias.stream().forEach(obj -> vista.getCmbAsignatura().addItem(obj.getNombre()));
            this.validarCombos();
        }
        catch (NullPointerException e) {
            vista.getCmbAsignatura().removeAllItems();
        }
    }

    private int getIdDocente() {
        return listaDocentes.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(vista.getCmbDocente().getSelectedItem().toString())).map(c -> ((DocenteMD)c.getValue()).getIdDocente()).findAny().get();
    }

    private void validarCombos() {
        if (vista.getCmbAsignatura().getItemCount() > 0) {
            vista.getBtnReportesUB().setEnabled(true);
        } else {
            vista.getBtnReportesUB().setEnabled(false);
        }
    }

    private int getIdPeriodoLectivo() {
        try {
            String periodo = vista.getCmbPeriodoLectivo().getSelectedItem().toString();
            return listaPeriodos.stream().filter(item -> item.getNombre().equals(periodo)).map(c -> c.getID()).findAny().orElse(-1);
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    private static void activarForm(boolean estado) {
        if (rolSeleccionado.getNombre().toLowerCase().contains("docente")) {
            vista.getTxtBuscar().setVisible(false);
            vista.getBtnBuscar().setVisible(false);
            vista.getCmbDocente().setEnabled(false);
        } else {
            vista.getTxtBuscar().setEnabled(estado);
            vista.getBtnBuscar().setEnabled(estado);
            vista.getCmbDocente().setEnabled(estado);
        }
        vista.getCmbPeriodoLectivo().setEnabled(estado);
        vista.getCmbCiclo().setEnabled(estado);
        vista.getCmbAsignatura().setEnabled(estado);
    }

    private void btnBuscar() {
        VtnControlUBCTR.activarForm(false);
        vista.getCmbDocente().setSelectedItem(listaDocentes.entrySet().stream().filter(entry -> ((DocenteMD)entry.getValue()).getIdentificacion().equals(vista.getTxtBuscar().getText())).map(c -> (String)c.getKey()).findFirst().orElse(""));
        VtnControlUBCTR.activarForm(true);
    }

    private void btnReportesUB(ActionEvent e) {
        new Thread(() -> {
            int b = JOptionPane.showOptionDialog(vista, "Reporte de Estado Estudiantil\n\u00bfElegir el tipo de Reporte?", "REPORTE UB", 1, 1, null, new Object[]{"Estado de Alumnos", "Rendimiento Interciclo", "Rendimiento Fin de Ciclo Menores a 70  "}, "Cancelar");
            Effects.setLoadCursor(vista);
            Reportes_ubCRT reportes = new Reportes_ubCRT(vista, this.getIdDocente());
            switch (b) {
                case 0: {
                    this.desktop.getLblEstado().setText("CARGANDO REPORTE....");
                    reportes.generarReporteEstadoAlumnos();
                    this.desktop.getLblEstado().setText("COMPLETADO");
                    break;
                }
                case 1: {
                    this.desktop.getLblEstado().setText("CARGANDO REPORTE....");
                    reportes.generarReporteRendimientoInterciclo();
                    this.desktop.getLblEstado().setText("COMPLETADO");
                    break;
                }
                case 2: {
                    this.desktop.getLblEstado().setText("CARGANDO REPORTE....");
                    reportes.generarReporteRendimientoCiclo();
                    this.desktop.getLblEstado().setText("COMPLETADO");
                    break;
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                System.out.println(ex.getMessage());
            }
            this.desktop.getLblEstado().setText("");
            Effects.setDefaultCursor(vista);
        }).start();
    }

    private void InitPermisos() {
        vista.getBtnReportesUB().getAccessibleContext().setAccessibleName("Notas-Rendimiento-Academico-Reporte UB");
        CONS.activarBtns(vista.getBtnReportesUB());
    }

    static {
        idPeriodoLectivo = -1;
        idCurso = -1;
    }
}

