/*
 * Decompiled with CFR 0.152.
 */
package controlador.notas;

import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.AlumnoCursoBD;
import modelo.alumno.AlumnoCursoMD;
import modelo.curso.CursoBD;
import modelo.curso.CursoMD;
import modelo.materia.MateriaBD;
import modelo.materia.MateriaMD;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.DocenteBD;
import modelo.persona.DocenteMD;
import modelo.tipoDeNota.TipoDeNotaBD;
import vista.notas.VtnNotas;
import vista.principal.VtnPrincipal;

public abstract class AbstractVtn {
    protected final VtnPrincipal desktop;
    protected final VtnNotas vista;
    protected Map<String, DocenteMD> listaDocentes;
    protected List<PeriodoLectivoMD> listaPeriodos;
    protected List<AlumnoCursoMD> listaNotas;
    protected List<MateriaMD> listaMaterias;
    protected List<TipoDeNotaBD> listaValidaciones;
    protected DefaultTableModel tablaTrad;
    protected DefaultTableModel tablaDuales;
    protected JTable jTblTrad;
    protected JTable jTblDual;
    protected boolean cargarTabla = true;
    protected final PeriodoLectivoBD peridoBD = new PeriodoLectivoBD();
    protected final AlumnoCursoBD almnCursoBD = new AlumnoCursoBD();
    protected final TipoDeNotaBD tipoNotaBD = new TipoDeNotaBD();
    protected final CursoBD cursoBD = new CursoBD();
    protected final MateriaBD materiaBD = new MateriaBD();
    protected final DocenteBD docenteBD = new DocenteBD();

    public AbstractVtn(VtnPrincipal desktop, VtnNotas vista) {
        this.desktop = desktop;
        this.vista = vista;
    }

    protected void cargarComboDocente() {
        this.listaDocentes.entrySet().stream().map(c -> (String)c.getKey()).forEach(this.vista.getCmbDocente()::addItem);
        this.tablaTrad.setRowCount(0);
        this.tablaDuales.setRowCount(0);
    }

    protected void cargarComboPeriodos() {
        this.vista.getCmbPeriodoLectivo().removeAllItems();
        this.vista.getLblCarrera().setText("");
        this.listaPeriodos = this.peridoBD.selectPeriodoWhere(this.getIdDocente());
        this.listaPeriodos.stream().map(c -> c.getNombre()).forEach(this.vista.getCmbPeriodoLectivo()::addItem);
        this.tablaTrad.setRowCount(0);
        this.tablaDuales.setRowCount(0);
    }

    protected void setLblCarrera() {
        this.vista.getLblCarrera().setText(this.listaPeriodos.stream().filter(item -> item.getID() == this.getIdPeriodoLectivo()).map(c -> c.getCarrera().getNombre()).findFirst().orElse(""));
    }

    protected void cargarComboCiclo() {
        try {
            this.vista.getCmbCiclo().removeAllItems();
            this.cursoBD.selectCicloWhere(this.getIdDocente(), this.getIdPeriodoLectivo()).stream().forEach(this.vista.getCmbCiclo()::addItem);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.tablaTrad.setRowCount(0);
        this.tablaDuales.setRowCount(0);
    }

    protected void cargarComboMaterias() {
        try {
            this.vista.getCmbAsignatura().removeAllItems();
            CursoMD curso = new CursoMD();
            DocenteMD docente = new DocenteMD();
            docente.setIdDocente(this.getIdDocente());
            curso.setDocente(docente);
            PeriodoLectivoMD periodo = new PeriodoLectivoMD();
            periodo.setID(this.getIdPeriodoLectivo());
            curso.setPeriodo(periodo);
            curso.setNombre(this.vista.getCmbCiclo().getSelectedItem().toString());
            this.listaMaterias = this.materiaBD.selectWhere(curso);
            this.listaMaterias.stream().map(c -> c.getNombre()).forEach(this.vista.getCmbAsignatura()::addItem);
            this.vista.getLblHoras().setText("" + this.listaMaterias.stream().filter(item -> item.getNombre().equals(this.vista.getCmbAsignatura().getSelectedItem().toString())).map(c -> c.getHorasPresenciales()).findFirst().orElse(-1));
            this.listaValidaciones = this.tipoNotaBD.selectWhere(this.getIdPeriodoLectivo());
            this.validarCombos();
        }
        catch (NullPointerException e) {
            this.vista.getCmbAsignatura().removeAllItems();
        }
        this.tablaTrad.setRowCount(0);
        this.tablaDuales.setRowCount(0);
    }

    protected int getIdDocente() {
        return this.listaDocentes.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(this.vista.getCmbDocente().getSelectedItem().toString())).map(c -> ((DocenteMD)c.getValue()).getIdDocente()).findAny().get();
    }

    protected int getIdPeriodoLectivo() {
        try {
            String periodo = this.vista.getCmbPeriodoLectivo().getSelectedItem().toString();
            return this.listaPeriodos.stream().filter(item -> item.getNombre().equals(periodo)).map(c -> c.getID()).findAny().orElse(-1);
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    private void validarCombos() {
        if (this.vista.getCmbAsignatura().getItemCount() > 0) {
            this.vista.getBtnVerNotas().setEnabled(true);
        } else {
            this.vista.getBtnVerNotas().setEnabled(false);
        }
    }

    protected boolean getEstado() {
        return this.listaPeriodos.stream().filter(item -> item.getNombre().equals(this.vista.getCmbPeriodoLectivo().getSelectedItem().toString())).map(c -> c.isEstado()).findFirst().orElse(false);
    }
}

