/*
 * Decompiled with CFR 0.152.
 */
package controlador.materia;

import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import modelo.materia.MateriaBD;
import modelo.materia.MateriaMD;
import modelo.materia.MateriaRequisitoBD;
import modelo.materia.MateriaRequisitoMD;
import vista.materia.FrmRequisitos;

public class VtnRequisitosCTR
extends DVtnCTR {
    private final FrmRequisitos frmreq;
    private final MateriaBD MTBD = MateriaBD.single();
    private final MateriaRequisitoBD MTRBD = MateriaRequisitoBD.single();
    private int idRequisito = -1;
    private boolean editar = false;
    private MateriaMD materia;
    private ArrayList<MateriaMD> materias;

    public VtnRequisitosCTR(VtnPrincipalCTR ctrPrin, FrmRequisitos frmreq, MateriaMD materia) {
        super(ctrPrin);
        this.frmreq = frmreq;
        this.materia = materia;
    }

    public void iniciar() {
        this.frmreq.getLblNombreMateria().setText(this.materia.getNombre());
        this.frmreq.getBtnGuardar().addActionListener(e -> this.guardarMateriaRequisito());
        this.ctrPrin.agregarVtn(this.frmreq);
        this.frmreq.getJrbCoRequisito().addActionListener(e -> this.cargarComboMaterias());
        this.frmreq.getJrbPrerequisito().addActionListener(e -> this.cargarComboMaterias());
    }

    private void cargarComboMaterias() {
        boolean co = this.frmreq.getJrbCoRequisito().isSelected();
        boolean pre = this.frmreq.getJrbPrerequisito().isSelected();
        if (co) {
            this.materias = this.MTBD.getMateriasParaCorequisito(this.materia.getId());
        }
        if (pre) {
            this.materias = this.MTBD.getMateriasParaPrequisitos(this.materia.getId());
        }
        this.frmreq.getCmbrequisitos().removeAllItems();
        this.frmreq.getCmbrequisitos().addItem("Seleccione");
        this.materias.forEach(m -> this.frmreq.getCmbrequisitos().addItem(m.getNombre()));
    }

    public void guardarMateriaRequisito() {
        boolean guardar = true;
        int posicion = this.frmreq.getCmbrequisitos().getSelectedIndex();
        MateriaRequisitoMD mr = new MateriaRequisitoMD();
        mr.setMateria(this.materia);
        if (posicion > 0) {
            this.materia = this.materias.get(posicion - 1);
            mr.setMateriaRequisito(this.materia);
        } else {
            guardar = false;
            JOptionPane.showMessageDialog(null, "Seleccione los datos");
        }
        if (this.frmreq.getJrbCoRequisito().isSelected()) {
            String tipo = "C";
            mr.setTipo(tipo);
        } else if (this.frmreq.getJrbPrerequisito().isSelected()) {
            String tipo = "P";
            mr.setTipo(tipo);
        } else {
            guardar = false;
        }
        if (guardar) {
            if (this.editar) {
                mr.setId(this.idRequisito);
                this.MTRBD.editar(mr);
            } else if (this.MTRBD.insertarMateriaRequisito(mr)) {
                JOptionPane.showMessageDialog(null, "Datos guardados correctamente");
                this.frmreq.dispose();
            } else {
                JOptionPane.showMessageDialog(null, "La Informacion existe, Por favor seleccione otros datos");
            }
        }
    }

    public void editar(MateriaRequisitoMD mr) {
        this.editar = true;
        this.idRequisito = mr.getId();
        if (mr.getTipo().equalsIgnoreCase("C")) {
            this.frmreq.getJrbCoRequisito().setSelected(true);
        } else {
            this.frmreq.getJrbPrerequisito().setSelected(true);
        }
        this.frmreq.getCmbrequisitos().setSelectedItem(mr.getMateria().getNombre());
    }
}

