/*
 * Decompiled with CFR 0.152.
 */
package controlador.materia;

import controlador.materia.FrmMateriasCTR;
import controlador.materia.JDMateriaInfoCTR;
import controlador.materia.VtnRequisitosCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.estilo.TblEstilo;
import modelo.materia.MateriaBD;
import modelo.materia.MateriaMD;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import vista.materia.FrmMaterias;
import vista.materia.FrmRequisitos;
import vista.materia.VtnMateria;

public class VtnMateriaCTR
extends DVtnCTR {
    private final VtnMateria vtnMateria;
    private final MateriaBD MTBD = MateriaBD.single();
    private final CarreraBD CRBD = CarreraBD.single();
    private ArrayList<MateriaMD> materias;
    private ArrayList<CarreraMD> carreras;
    private ArrayList<Integer> ciclos;

    public VtnMateriaCTR(VtnMateria vtnMateria, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnMateria = vtnMateria;
        this.InitPermisosDocente();
    }

    public void iniciar() {
        this.vtnMateria.getBtnPEA().addActionListener(l -> this.generaPEA());
        this.vtnMateria.getBtnRequisitos().addActionListener(e -> this.abrirFrmRequisito());
        String[] titulo = new String[]{"id", "Carrera", "C\u00f3digo", "Nombre", "Ciclo", "Docencia", "Pr\u00e1cticas", "Aut\u00f3nomas", "Presencial", "Total"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.vtnMateria.getTblMateria().setModel(this.mdTbl);
        TblEstilo.ocualtarID(this.vtnMateria.getTblMateria());
        TblEstilo.formatoTbl(this.vtnMateria.getTblMateria());
        TblEstilo.columnaMedida(this.vtnMateria.getTblMateria(), 1, 70);
        TblEstilo.columnaMedida(this.vtnMateria.getTblMateria(), 2, 70);
        TblEstilo.columnaMedida(this.vtnMateria.getTblMateria(), 4, 40);
        TblEstilo.columnaMedida(this.vtnMateria.getTblMateria(), 5, 70);
        TblEstilo.columnaMedida(this.vtnMateria.getTblMateria(), 6, 70);
        TblEstilo.columnaMedida(this.vtnMateria.getTblMateria(), 7, 70);
        TblEstilo.columnaMedida(this.vtnMateria.getTblMateria(), 8, 70);
        TblEstilo.columnaMedida(this.vtnMateria.getTblMateria(), 9, 40);
        this.vtnMateria.getCmbCiclo().removeAllItems();
        this.vtnMateria.getCmbCiclo().addItem("Todos");
        this.vtnMateria.getLblError().setVisible(false);
        this.cargarCmbCarreras();
        this.materias = this.MTBD.cargarMaterias();
        this.cargarTblMaterias();
        this.vtnMateria.getCmbCarreras().addActionListener(e -> this.filtrarPorCarrera());
        this.vtnMateria.getCmbCiclo().addActionListener(e -> this.filtrarPorCarreraPorCiclo());
        this.vtnMateria.getBtnIngresarMateria().addActionListener(e -> this.ingresarMaterias());
        this.vtnMateria.getBtnEditarMateria().addActionListener(e -> this.editarMaterias());
        this.vtnMateria.getBtnReporteMaterias().addActionListener(e -> this.llamaReporteMaterias());
        this.vtnMateria.getBtnBuscar().addActionListener(e -> this.buscarMaterias(this.vtnMateria.getTxtBuscar().getText().trim()));
        this.vtnMateria.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String b = VtnMateriaCTR.this.vtnMateria.getTxtBuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    VtnMateriaCTR.this.buscarMaterias(b);
                }
            }
        });
        this.vtnMateria.getTxtBuscar().addKeyListener(new TxtVBuscador(this.vtnMateria.getTxtBuscar(), this.vtnMateria.getBtnBuscar()));
        this.vtnMateria.getBtnInfo().addActionListener(e -> this.infoMateria());
        this.ctrPrin.agregarVtn(this.vtnMateria);
        this.vtnMateria.getBtnEliminarMateria().setVisible(false);
        this.InitPermisos();
    }

    private void generaPEA() {
        this.posFila = this.vtnMateria.getTblMateria().getSelectedRow();
        if (this.posFila >= 0) {
            this.vtnMateria.getLblError().setVisible(false);
            String path = "";
            String materia = this.vtnMateria.getTblMateria().getValueAt(this.posFila, 3).toString();
            String codigo = this.vtnMateria.getCmbCarreras().getSelectedItem().toString();
            path = "/vista/materia/reportes/repPEAMateria9_25.jasper";
            try {
                HashMap<String, String> parametro = new HashMap<String, String>();
                parametro.put("consulta", this.MTBD.getSqlm(Integer.parseInt(this.vtnMateria.getTblMateria().getValueAt(this.posFila, 0).toString())));
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "PEA: " + materia);
            }
            catch (JRException ex) {
                System.out.println(ex.getMessage() + ex.getMessageKey());
                JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
            }
            this.cargarTblMaterias();
        } else {
            this.vtnMateria.getLblError().setVisible(true);
        }
    }

    private void infoMateria() {
        int pos = this.vtnMateria.getTblMateria().getSelectedRow();
        if (pos >= 0) {
            MateriaMD mt = this.MTBD.buscarMateriaInfo(this.materias.get(pos).getId());
            JDMateriaInfoCTR info = new JDMateriaInfoCTR(mt, this.ctrPrin);
            info.iniciar();
        } else {
            JOptionPane.showMessageDialog(null, "Seleccione una materia");
        }
    }

    public void buscar() {
        String buscar = this.vtnMateria.getTxtBuscar().getText().trim();
        if (buscar.length() > 2) {
            this.buscarMaterias(buscar);
        }
    }

    public void buscarMaterias(String b) {
        if (Validar.esLetrasYNumeros(b)) {
            this.materias = this.MTBD.cargarMaterias(b);
            this.cargarTblMaterias();
        }
    }

    private void InitPermisosDocente() {
        if (CONS.ROL.getNombre().equalsIgnoreCase("Docente")) {
            this.vtnMateria.getBtnEliminarMateria().setEnabled(false);
        }
    }

    public void cargarCmbCarreras() {
        this.carreras = this.CRBD.cargarCarrerasCmb();
        this.vtnMateria.getCmbCarreras().removeAllItems();
        this.vtnMateria.getCmbCarreras().addItem("Seleccione una carrera");
        this.carreras.forEach(car -> this.vtnMateria.getCmbCarreras().addItem(car.getCodigo()));
    }

    private void filtrarPorCarrera() {
        int pos = this.vtnMateria.getCmbCarreras().getSelectedIndex();
        if (pos > 0) {
            this.materias = this.MTBD.cargarMateriaPorCarrera(this.carreras.get(pos - 1).getId());
            this.ciclos = this.MTBD.cargarCiclosCarrera(this.carreras.get(pos - 1).getId());
            this.vtnMateria.getCmbCiclo().removeAllItems();
            this.vtnMateria.getCmbCiclo().addItem("Todos");
            this.ciclos.forEach(c -> this.vtnMateria.getCmbCiclo().addItem(c + ""));
            this.vtnMateria.getCmbCiclo().setSelectedIndex(0);
        } else {
            this.materias = this.MTBD.cargarMaterias();
            this.vtnMateria.getCmbCiclo().removeAllItems();
        }
        this.cargarTblMaterias();
    }

    private void cargarTblMaterias() {
        this.mdTbl.setRowCount(0);
        this.vtnMateria.getLblResultados().setText(this.materias.size() + " Resultados obtenidos.");
        if (!this.materias.isEmpty()) {
            this.materias.forEach(mt -> {
                Object[] valores = new Object[]{mt.getId(), this.obtenerCodigoCarrera(mt.getCarrera().getId()), mt.getCodigo(), mt.getNombre(), mt.getCiclo(), mt.getHorasDocencia(), mt.getHorasPracticas(), mt.getHorasAutoEstudio(), mt.getHorasPresenciales(), mt.getTotalHoras()};
                this.mdTbl.addRow(valores);
            });
        }
    }

    private void filtrarPorCarreraPorCiclo() {
        int ciclo = this.vtnMateria.getCmbCiclo().getSelectedIndex();
        int posCar = this.vtnMateria.getCmbCarreras().getSelectedIndex();
        if (ciclo > 0) {
            this.materias = this.MTBD.cargarMateriaPorCarreraCiclo(this.carreras.get(posCar - 1).getId(), ciclo);
            this.cargarTblMaterias();
        } else {
            this.filtrarPorCarrera();
        }
    }

    public void llamaReporteMaterias() {
        this.MTBD.buscarMateria(this.posFila);
        String path = "/vista/reportes/repMaterias.jasper";
        try {
            HashMap<String, String> parametro = new HashMap<String, String>();
            parametro.put("consulta", this.MTBD.getSql());
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
            CON.mostrarReporte(jr, parametro, "Reporte de Materias por Carrera");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
        }
    }

    private void InitPermisos() {
        this.vtnMateria.getBtnIngresarMateria().getAccessibleContext().setAccessibleName("Materias-Ingresar");
        this.vtnMateria.getBtnRequisitos().getAccessibleContext().setAccessibleName("Materias-Requisitos");
        this.vtnMateria.getBtnInfo().getAccessibleContext().setAccessibleName("Materias-Informacion");
        this.vtnMateria.getBtnEditarMateria().getAccessibleContext().setAccessibleName("Materias-Editar");
        this.vtnMateria.getBtnEliminarMateria().getAccessibleContext().setAccessibleName("Materias-Eliminar");
        this.vtnMateria.getBtnReporteMaterias().getAccessibleContext().setAccessibleName("Materias-Reporte");
        CONS.activarBtns(this.vtnMateria.getBtnIngresarMateria(), this.vtnMateria.getBtnRequisitos(), this.vtnMateria.getBtnInfo(), this.vtnMateria.getBtnEditarMateria(), this.vtnMateria.getBtnEliminarMateria(), this.vtnMateria.getBtnReporteMaterias());
    }

    public void abrirFrmRequisito() {
        this.posFila = this.vtnMateria.getTblMateria().getSelectedRow();
        if (this.posFila >= 0) {
            FrmRequisitos frmreq = new FrmRequisitos();
            VtnRequisitosCTR vtnreq = new VtnRequisitosCTR(this.ctrPrin, frmreq, this.materias.get(this.posFila));
            vtnreq.iniciar();
        } else {
            JOptionPane.showMessageDialog(null, "Seleccione una materia");
        }
    }

    private void ingresarMaterias() {
        this.ctrPrin.abrirFrmMateria();
        this.vtnMateria.dispose();
        this.ctrPrin.cerradoJIF();
    }

    private void editarMaterias() {
        this.posFila = this.vtnMateria.getTblMateria().getSelectedRow();
        if (this.posFila >= 0) {
            this.vtnMateria.getLblError().setVisible(false);
            FrmMaterias frmMateria = new FrmMaterias();
            FrmMateriasCTR ctrFrm = new FrmMateriasCTR(frmMateria, this.ctrPrin, this);
            ctrFrm.iniciar();
            MateriaMD matEditar = this.MTBD.buscarMateria(Integer.parseInt(this.vtnMateria.getTblMateria().getValueAt(this.posFila, 0).toString()));
            ctrFrm.editarMaterias(matEditar);
            this.cargarTblMaterias();
        } else {
            this.vtnMateria.getLblError().setVisible(true);
        }
    }

    private void eliminarMaterias() {
        this.posFila = this.vtnMateria.getTblMateria().getSelectedRow();
        if (this.posFila >= 0) {
            System.out.println(Integer.valueOf(this.vtnMateria.getTblMateria().getValueAt(this.posFila, 0).toString()));
            MateriaMD mate = this.MTBD.buscarMateria(Integer.valueOf(this.vtnMateria.getTblMateria().getValueAt(this.posFila, 0).toString()));
            int dialog = 1;
            int result = JOptionPane.showConfirmDialog(null, "\u00bfEsta seguro que desea eliminar a \n" + this.vtnMateria.getTblMateria().getValueAt(this.posFila, 2) + "?", " Eliminar Materia", dialog);
            if (result == 0) {
                if (this.MTBD.elminarMateria(mate.getId())) {
                    JOptionPane.showMessageDialog(null, "Datos Eliminados Satisfactoriamente");
                    this.cargarTblMaterias();
                    this.vtnMateria.getTxtBuscar().setText("");
                } else {
                    JOptionPane.showMessageDialog(null, "NO SE PUDO ELIMINAR A LA MATERIA");
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "SELECCIONE UNA FILA PARA ELIMINAR A LA MATERIA");
        }
    }

    private String obtenerCodigoCarrera(int idCarrera) {
        String cod = "";
        for (int i = 0; i < this.carreras.size(); ++i) {
            if (this.carreras.get(i).getId() != idCarrera) continue;
            cod = this.carreras.get(i).getCodigo();
            break;
        }
        return cod;
    }

    public void actualizarVtn() {
        if (this.vtnMateria.getTxtBuscar().getText().length() > 0) {
            this.buscar();
        } else {
            this.filtrarPorCarreraPorCiclo();
        }
    }
}

