/*
 * Decompiled with CFR 0.152.
 */
package controlador.materia;

import controlador.materia.VtnRequisitosCTR;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.estilo.TblEstilo;
import modelo.materia.MateriaBD;
import modelo.materia.MateriaMD;
import modelo.materia.MateriaRequisitoBD;
import modelo.materia.MateriaRequisitoMD;
import vista.materia.FrmRequisitos;
import vista.materia.JDMateriaInfo;

public class JDMateriaInfoCTR
extends DCTR {
    private final JDMateriaInfo vtnInfo;
    private final MateriaRequisitoBD MTRBD = MateriaRequisitoBD.single();
    private final MateriaMD m;
    private ArrayList<MateriaRequisitoMD> preRequisitos;
    private ArrayList<MateriaRequisitoMD> coRequisitos;
    private int posFila;
    private String tipo;
    private String materia;
    private final MateriaBD MTBD = MateriaBD.single();
    private DefaultTableModel mdTblPre;
    private DefaultTableModel mdTblCo;

    public JDMateriaInfoCTR(MateriaMD m, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.m = m;
        this.vtnInfo = new JDMateriaInfo((Frame)ctrPrin.getVtnPrin(), false);
        this.vtnInfo.setLocationRelativeTo(ctrPrin.getVtnPrin());
    }

    public void iniciar() {
        this.vtnInfo.getLblMateria().setText(this.m.getNombre());
        this.vtnInfo.getLblCarrera().setText(this.m.getCarrera().getNombre());
        String[] titulo1 = new String[]{"Co-Requisitos"};
        String[] titulo2 = new String[]{"Pre-Requisitos"};
        String[][] datos1 = new String[][]{};
        this.mdTblCo = TblEstilo.modelTblSinEditar(datos1, titulo1);
        this.mdTblPre = TblEstilo.modelTblSinEditar(datos1, titulo2);
        TblEstilo.formatoTblConColor(this.vtnInfo.getTblCoRequisitos());
        TblEstilo.formatoTblConColor(this.vtnInfo.getTblPreRequisitos());
        this.vtnInfo.getTblCoRequisitos().setModel(this.mdTblCo);
        this.vtnInfo.getTblPreRequisitos().setModel(this.mdTblPre);
        this.llenarTblCoRequisitos();
        this.llenarTblPreRequisitos();
        this.vtnInfo.setVisible(true);
        this.vtnInfo.getTblCoRequisitos().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JDMateriaInfoCTR.this.clickCoRequisitos();
            }
        });
        this.vtnInfo.getTblPreRequisitos().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JDMateriaInfoCTR.this.clickPreRequisitos();
            }
        });
        this.vtnInfo.getBtnEliminar().addActionListener(e -> this.eliminar());
        this.vtnInfo.getBtnEditar().addActionListener(e -> this.editar());
    }

    private void editar() {
        try {
            if (this.posFila >= 0) {
                FrmRequisitos frmreq = new FrmRequisitos();
                VtnRequisitosCTR req = new VtnRequisitosCTR(this.ctrPrin, frmreq, this.m);
                req.iniciar();
                switch (this.tipo) {
                    case "co-requisito": {
                        req.editar(this.coRequisitos.get(this.posFila));
                        break;
                    }
                    case "pre-requisito": {
                        req.editar(this.preRequisitos.get(this.posFila));
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "Por favor seleccione una materia para continuar");
            }
        }
        catch (HeadlessException e) {
            System.out.println(e);
        }
    }

    private void eliminar() {
        try {
            if (this.posFila >= 0) {
                int r = JOptionPane.showConfirmDialog(this.ctrPrin.getVtnPrin(), "Esta seguro que desea eliminar " + this.materia + "\ncomo " + this.tipo);
                if (r == 0) {
                    switch (this.tipo) {
                        case "co-requisito": {
                            this.MTRBD.eliminar(this.coRequisitos.get(this.posFila).getId());
                            this.mdTblCo.removeRow(this.posFila);
                            break;
                        }
                        case "pre-requisito": {
                            this.MTRBD.eliminar(this.preRequisitos.get(this.posFila).getId());
                            this.mdTblPre.removeRow(this.posFila);
                        }
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "Por favor seleccione una materia para continuar");
            }
        }
        catch (HeadlessException e) {
            System.out.println(e);
        }
    }

    private void clickCoRequisitos() {
        this.posFila = this.vtnInfo.getTblCoRequisitos().getSelectedRow();
        if (this.posFila >= 0) {
            this.tipo = "co-requisito";
            this.materia = this.vtnInfo.getTblCoRequisitos().getValueAt(this.posFila, 0).toString();
        }
    }

    private void clickPreRequisitos() {
        this.posFila = this.vtnInfo.getTblPreRequisitos().getSelectedRow();
        if (this.posFila >= 0) {
            this.tipo = "pre-requisito";
            this.materia = this.vtnInfo.getTblPreRequisitos().getValueAt(this.posFila, 0).toString();
        }
    }

    private void llenarTblCoRequisitos() {
        this.coRequisitos = this.MTRBD.buscarCoRequisitosDe(this.m.getId());
        this.mdTblCo.setRowCount(0);
        if (this.coRequisitos != null) {
            this.coRequisitos.forEach(mt -> {
                Object[] valores = new Object[]{mt.getMateriaRequisito().getNombre()};
                this.mdTblCo.addRow(valores);
            });
        }
    }

    private void llenarTblPreRequisitos() {
        this.preRequisitos = this.MTRBD.buscarPreRequisitosDe(this.m.getId());
        this.mdTblPre.setRowCount(0);
        if (this.preRequisitos != null) {
            this.preRequisitos.forEach(mt -> {
                Object[] valores = new Object[]{mt.getMateriaRequisito().getNombre()};
                this.mdTblPre.addRow(valores);
            });
        }
    }
}

