/*
 * Decompiled with CFR 0.152.
 */
package controlador.materia;

import controlador.materia.VtnMateriaCTR;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.materia.AreaBD;
import modelo.materia.AreaMD;
import modelo.materia.EjeFormacionBD;
import modelo.materia.EjeFormacionMD;
import modelo.materia.MateriaBD;
import modelo.materia.MateriaMD;
import modelo.validaciones.CmbValidar;
import modelo.validaciones.TxtVNumeros_2;
import modelo.validaciones.Validar;
import vista.materia.FrmMaterias;

public class FrmMateriasCTR
extends DCTR {
    private final FrmMaterias frmMaterias;
    private final MateriaBD MTBD = MateriaBD.single();
    private final AreaBD areaBD = AreaBD.single();
    private boolean guardar = false;
    private int acceso = 0;
    private boolean editar = false;
    private String nombre_Materia;
    private ArrayList<CarreraMD> listaCarrera;
    private ArrayList<EjeFormacionMD> listaEje;
    private final CarreraBD carBD = null;
    private final EjeFormacionBD ejeBD = null;
    private int idEditar = 0;
    private final VtnMateriaCTR ctrVtnMat;

    public FrmMateriasCTR(FrmMaterias frmMaterias, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.frmMaterias = frmMaterias;
        this.ctrVtnMat = null;
    }

    public FrmMateriasCTR(FrmMaterias frmMaterias, VtnPrincipalCTR ctrPrin, VtnMateriaCTR ctrVtnMat) {
        super(ctrPrin);
        this.frmMaterias = frmMaterias;
        this.ctrVtnMat = ctrVtnMat;
    }

    public void iniciar() {
        this.ctrPrin.agregarVtn(this.frmMaterias);
        this.frmMaterias.getCbCarrera().addActionListener(e -> {
            int pos;
            this.acceso = 0;
            String nombre = this.frmMaterias.getCbCarrera().getSelectedItem().toString();
            List<EjeFormacionMD> ejes = this.MTBD.cargarEjes(this.MTBD.filtrarIdCarrera(nombre, 0).getId());
            this.frmMaterias.getCbEjeFormacion().removeAllItems();
            this.frmMaterias.getCbEjeFormacion().addItem("SELECCIONE");
            this.frmMaterias.getCbx_OrgCurricular().removeAllItems();
            this.frmMaterias.getCbx_OrgCurricular().addItem("SELECCIONE");
            if (!nombre.equals("SELECCIONE")) {
                this.frmMaterias.getCbEjeFormacion().setEnabled(true);
                for (int i = 0; i < ejes.size(); ++i) {
                    this.frmMaterias.getCbEjeFormacion().addItem(ejes.get(i).getNombre());
                    this.frmMaterias.getCbx_OrgCurricular().addItem(ejes.get(i).getNombre());
                }
                List<AreaMD> areas = this.areaBD.obtenerAreasPorCarrera(this.MTBD.filtrarIdCarrera(nombre, 0).getId());
                for (int i = 0; i < areas.size(); ++i) {
                    this.frmMaterias.getCbx_AreaAcademica().addItem(areas.get(i).getNombreArea());
                }
                this.habilitarGuardar();
            }
            if ((pos = this.frmMaterias.getCbCarrera().getSelectedIndex()) > 0) {
                this.frmMaterias.getCbCarrera().setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
                if (this.frmMaterias.getLblErrorCarrera() != null) {
                    this.frmMaterias.getLblErrorCarrera().setVisible(false);
                }
            } else {
                this.frmMaterias.getCbCarrera().setBorder(BorderFactory.createLineBorder(new Color(204, 0, 0)));
                if (this.frmMaterias.getLblErrorCarrera() != null) {
                    this.frmMaterias.getLblErrorCarrera().setVisible(true);
                }
            }
        });
        this.frmMaterias.getCbEjeFormacion().addActionListener(e -> {
            int pos;
            ++this.acceso;
            if (this.acceso > 1) {
                String nombre;
                switch (nombre = this.frmMaterias.getCbEjeFormacion().getSelectedItem().toString()) {
                    case "B\u00c1SICA": 
                    case "FORMACI\u00d3N B\u00c1SICA": 
                    case "UNIDAD B\u00c1SICA": {
                        this.frmMaterias.getCbx_OrgCurricular().setSelectedIndex(1);
                        break;
                    }
                    case "PROFESIONAL": 
                    case "FORMACI\u00d3N PROFESIONAL": 
                    case "UNIDAD PROFESIONAL": {
                        this.frmMaterias.getCbx_OrgCurricular().setSelectedIndex(2);
                        break;
                    }
                    case "TITULACI\u00d3N": {
                        this.frmMaterias.getCbx_OrgCurricular().setSelectedIndex(3);
                        break;
                    }
                }
                this.habilitarGuardar();
            }
            if ((pos = this.frmMaterias.getCbCarrera().getSelectedIndex()) > 0) {
                this.frmMaterias.getCbCarrera().setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
                if (this.frmMaterias.getLblErrorCarrera() != null) {
                    this.frmMaterias.getLblErrorCarrera().setVisible(false);
                }
            } else {
                this.frmMaterias.getCbCarrera().setBorder(BorderFactory.createLineBorder(new Color(204, 0, 0)));
                if (this.frmMaterias.getLblErrorCarrera() != null) {
                    this.frmMaterias.getLblErrorCarrera().setVisible(true);
                }
            }
        });
        this.frmMaterias.getBtnGuardar().addActionListener(e -> {
            if (this.guardar) {
                this.guardarMateria();
            }
        });
        this.frmMaterias.getBtnCancelar().addActionListener(e -> this.cancelar());
        this.iniciarValidaciones();
        this.iniciarComponentes();
        this.iniciarCarreras();
    }

    public void iniciarCarreras() {
        List<CarreraMD> carreras = this.MTBD.cargarCarreras();
        for (int i = 0; i < carreras.size(); ++i) {
            this.frmMaterias.getCbCarrera().addItem(carreras.get(i).getNombre());
        }
    }

    public void habilitarGuardar() {
        String Carrera = "SELECCIONE";
        String Eje = "SELECCIONE";
        Carrera = this.frmMaterias.getCbCarrera().getSelectedItem().toString();
        Eje = this.frmMaterias.getCbEjeFormacion().getSelectedItem().toString();
        String materiaCodigo = this.frmMaterias.getTxt_CodMateria().getText();
        String materiaNombre = this.frmMaterias.getTxtNombreMateria().getText();
        String materiaCiclo = this.frmMaterias.getCbx_Ciclo().getSelectedItem().toString();
        String tipoAcreditacion = this.frmMaterias.getCbTipoAcreditacion().getSelectedItem().toString();
        String creditos = this.frmMaterias.getTxtCreditos().getText();
        String horasDocencia = this.frmMaterias.getTxtHorasDocencia().getText();
        String horasPracticas = this.frmMaterias.getTxtHorasPracticas().getText();
        String horasPresenciales = this.frmMaterias.getTxtHorasPresenciales().getText();
        String horasAutoEstudio = this.frmMaterias.getTxtHorasAutoEstudio().getText();
        String totalHoras = this.frmMaterias.getTxtTotalHoras().getText();
        String objetivoGeneral = this.frmMaterias.getTxtObjetivoGeneral().getText();
        String objetivoEspecifico = this.frmMaterias.getTxtObjetivoEspecifico().getText();
        String descripcionMateria = this.frmMaterias.getTxtDescripcionMateria().getText();
        if (!(Carrera.equals("SELECCIONE") || Eje.equals("SELECCIONE") || materiaCodigo.equals("") || materiaNombre.equals("") || materiaCiclo.equals("SELECCIONE") || tipoAcreditacion.equals("SELECCIONE") || creditos.equals("") || horasDocencia.equals("") || horasPracticas.equals("") || horasPresenciales.equals("") || horasAutoEstudio.equals("") || totalHoras.equals("") || objetivoGeneral.equals("") || objetivoEspecifico.equals("") || descripcionMateria.equals(""))) {
            if (!(this.frmMaterias.getLblErrorCarrera().isVisible() || this.frmMaterias.getLblErrorEjeFormacion().isVisible() || this.frmMaterias.getLblErrorCodigoMateria().isVisible() || this.frmMaterias.getLblErrorNombreMateria().isVisible() || this.frmMaterias.getLblErrorTipoAcreditacion().isVisible() || this.frmMaterias.getLblErrorMateriaCiclo().isVisible() || this.frmMaterias.getLblErrorCreditos().isVisible() || this.frmMaterias.getLblErrorCampoFormacion().isVisible() || this.frmMaterias.getLblErrorOrganizacionCurricular().isVisible())) {
                this.frmMaterias.getBtnGuardar().setEnabled(true);
                this.guardar = true;
            } else {
                this.frmMaterias.getBtnGuardar().setEnabled(false);
            }
        } else {
            this.frmMaterias.getBtnGuardar().setEnabled(false);
        }
    }

    public void iniciarComponentes() {
        this.frmMaterias.getCbCarrera().setToolTipText("Seleccione un Carrera");
        this.frmMaterias.getCbEjeFormacion().setToolTipText("Seleccione un Eje de Formaci\u00f3n");
        this.frmMaterias.getTxt_CodMateria().setToolTipText("Escriba el C\u00f3digo perteneciente a la Materia, este C\u00f3digo debe ser \u00fanico");
        this.frmMaterias.getTxtNombreMateria().setToolTipText("Escriba el Nombre de la Materia");
        this.frmMaterias.getCbMateriaTipo().setToolTipText("Seleccione el Tipo de la Materia de la siguiente lista");
        this.frmMaterias.getCbTipoAcreditacion().setToolTipText("Seleccione un Tipo de Acreditaci\u00f3n de la siguiente lista");
        this.frmMaterias.getCbx_Ciclo().setToolTipText("Seleccione el Ciclo al que pertenece esta materia");
        this.frmMaterias.getTxtCreditos().setToolTipText("Escriba el total de horas o cr\u00e9ditos de la Materia");
        this.frmMaterias.getTxtHorasDocencia().setToolTipText("Escriba el n\u00famero de horas de Docencia de la materia");
        this.frmMaterias.getTxtHorasAutoEstudio().setToolTipText("Escriba el n\u00famero de horas Autoestudio de la materia");
        this.frmMaterias.getTxtHorasPracticas().setToolTipText("Escriba el n\u00famero de horas Pr\u00e1cticas de la materia");
        this.frmMaterias.getTxtObjetivoGeneral().setToolTipText("Escriba el Objetivo General de la materia");
        this.frmMaterias.getTxtObjetivoEspecifico().setToolTipText("Escriba el Objetivo Espec\u00edfico de la materia");
        this.frmMaterias.getCbx_OrgCurricular().setToolTipText("Seleccione la Unidad de Organizaci\u00f3n Curricular de la materia");
        this.frmMaterias.getTxtDescripcionMateria().setToolTipText("Escriba la Descripci\u00f3n de la materia");
        this.frmMaterias.getCbTipoAcreditacion().setToolTipText("Seleccione la Organizaci\u00f3n Curricular de la materia");
        this.frmMaterias.getLblErrorCarrera().setVisible(false);
        this.frmMaterias.getLblErrorEjeFormacion().setVisible(false);
        this.frmMaterias.getLblErrorCodigoMateria().setVisible(false);
        this.frmMaterias.getLblErrorMateriaTipo().setVisible(false);
        this.frmMaterias.getLblErrorNombreMateria().setVisible(false);
        this.frmMaterias.getLblErrorMateriaCiclo().setVisible(false);
        this.frmMaterias.getLblErrorTipoAcreditacion().setVisible(false);
        this.frmMaterias.getLblErrorCreditos().setVisible(false);
        this.frmMaterias.getLblErrorHorasDocencia().setVisible(false);
        this.frmMaterias.getLblErrorHorasPracticas().setVisible(false);
        this.frmMaterias.getLblErrorHorasPresenciales().setVisible(false);
        this.frmMaterias.getLblErrorHorasAutoEstudio().setVisible(false);
        this.frmMaterias.getLblErrorTotalHoras().setVisible(false);
        this.frmMaterias.getLblErrorObjetivoGeneral().setVisible(false);
        this.frmMaterias.getLblErrorObjetivoEspecifico().setVisible(false);
        this.frmMaterias.getLblErrorDescripcionMateria().setVisible(false);
        this.frmMaterias.getLblErrorOrganizacionCurricular().setVisible(false);
        this.frmMaterias.getLblErrorCampoFormacion().setVisible(false);
        this.frmMaterias.getBtnGuardar().setText("Guardar");
        this.frmMaterias.getCbEjeFormacion().setEnabled(false);
        this.frmMaterias.getBtnGuardar().setEnabled(false);
        this.frmMaterias.getTxtObjetivoGeneral().setLineWrap(true);
        this.frmMaterias.getTxtObjetivoGeneral().setWrapStyleWord(true);
        this.frmMaterias.getTxtObjetivoEspecifico().setLineWrap(true);
        this.frmMaterias.getTxtObjetivoEspecifico().setWrapStyleWord(true);
        this.frmMaterias.getTxtDescripcionMateria().setLineWrap(true);
        this.frmMaterias.getTxtDescripcionMateria().setWrapStyleWord(true);
        this.frmMaterias.getLblErrorMateriaModalidad().setVisible(false);
        this.frmMaterias.getLblErrorItinerario().setVisible(false);
        this.frmMaterias.getLblErrorApp().setVisible(false);
        this.frmMaterias.getLblErrorHorasTutoria().setVisible(false);
        this.frmMaterias.getLblErrorFormaEvide().setVisible(false);
        this.frmMaterias.getLblErrorAreaAcademica().setVisible(false);
        this.frmMaterias.getLblErrorEstrategias().setVisible(false);
        this.frmMaterias.getLblErrorRecursos().setVisible(false);
        this.frmMaterias.getLblErrorResultados().setVisible(false);
    }

    public void borrarCampos() {
        this.frmMaterias.getTxt_CodMateria().setText("");
        this.frmMaterias.getTxtCreditos().setText("");
        this.frmMaterias.getTxtDescripcionMateria().setText("");
        this.frmMaterias.getTxtHorasAutoEstudio().setText("");
        this.frmMaterias.getTxtHorasDocencia().setText("");
        this.frmMaterias.getTxtHorasPracticas().setText("");
        this.frmMaterias.getTxtHorasPresenciales().setText("");
        this.frmMaterias.getTxtNombreMateria().setText("");
        this.frmMaterias.getTxtObjetivoEspecifico().setText("");
        this.frmMaterias.getTxtObjetivoGeneral().setText("");
        this.frmMaterias.getTxtTotalHoras().setText("");
        this.frmMaterias.getCbCarrera().setSelectedIndex(0);
        this.frmMaterias.getCbEjeFormacion().setSelectedIndex(0);
        this.frmMaterias.getCbMateriaTipo().setSelectedIndex(0);
        this.frmMaterias.getCbTipoAcreditacion().setSelectedIndex(0);
        this.frmMaterias.getCbx_CamFormacion().setSelectedIndex(0);
        this.frmMaterias.getCbx_Ciclo().setSelectedIndex(0);
        this.frmMaterias.getCbx_OrgCurricular().setSelectedIndex(0);
        this.frmMaterias.getChBNucleo().setSelected(false);
    }

    private void guardarMateria() {
        String modalidad = this.frmMaterias.getCbx_Modalidad().getSelectedItem().toString();
        String itinerario = this.frmMaterias.getTxtItinerario().getText();
        String areaAcademica = this.frmMaterias.getCbx_AreaAcademica().getSelectedItem().toString();
        int horasTutoria = Integer.parseInt(this.frmMaterias.getTxtHorasTutoria().getText());
        String perfilEgreso = this.frmMaterias.getTxtPerfilEgreso().getText();
        String Evaluacion = this.frmMaterias.getTxtFormaEvidencia().getText();
        String actividadesPracticasProgramadas = this.frmMaterias.getTxtApp().getText();
        String estrategiasMetodologicas = this.frmMaterias.getTxtEstrategias().getText();
        String recursosDidacticos = this.frmMaterias.getTxtRecursos().getText();
        int materiaCiclo = 0;
        CarreraMD carreraMD = new CarreraMD();
        EjeFormacionMD ejeMD = new EjeFormacionMD();
        String carrera = this.frmMaterias.getCbCarrera().getSelectedItem().toString();
        String eje = this.frmMaterias.getCbEjeFormacion().getSelectedItem().toString();
        String materiaCodigo = this.frmMaterias.getTxt_CodMateria().getText().trim().toUpperCase();
        String materiaNombre = this.frmMaterias.getTxtNombreMateria().getText().trim().toUpperCase();
        switch (this.frmMaterias.getCbx_Ciclo().getSelectedItem().toString()) {
            case "SELECCIONE": {
                materiaCiclo = 0;
                break;
            }
            case "Ciclo 1": {
                materiaCiclo = 1;
                break;
            }
            case "Ciclo 2": {
                materiaCiclo = 2;
                break;
            }
            case "Ciclo 3": {
                materiaCiclo = 3;
                break;
            }
            case "Ciclo 4": {
                materiaCiclo = 4;
                break;
            }
            case "Ciclo 5": {
                materiaCiclo = 5;
                break;
            }
            case "Ciclo 6": {
                materiaCiclo = 6;
            }
        }
        String materiaTipo = this.frmMaterias.getCbMateriaTipo().getSelectedItem().toString();
        String tipoAcreditacion = this.frmMaterias.getCbTipoAcreditacion().getSelectedItem().toString();
        String creditos = this.frmMaterias.getTxtCreditos().getText();
        boolean materiaNucleo = this.frmMaterias.getChBNucleo().isSelected();
        int horasDocencia = Integer.parseInt(this.frmMaterias.getTxtHorasDocencia().getText().trim());
        int horasPracticas = Integer.parseInt(this.frmMaterias.getTxtHorasPracticas().getText().trim());
        int horasPresenciales = Integer.parseInt(this.frmMaterias.getTxtHorasPresenciales().getText().trim());
        int horasAutoEstudio = Integer.parseInt(this.frmMaterias.getTxtHorasAutoEstudio().getText().trim());
        int totalHoras = Integer.parseInt(this.frmMaterias.getTxtTotalHoras().getText().trim());
        String objetivoGeneral = this.frmMaterias.getTxtObjetivoGeneral().getText().trim();
        String objetivoEspecifico = this.frmMaterias.getTxtObjetivoEspecifico().getText().trim();
        String descripcionMateria = this.frmMaterias.getTxtDescripcionMateria().getText().trim();
        String organizacionCurricular = this.frmMaterias.getCbx_OrgCurricular().getSelectedItem().toString();
        String campoFormacion = this.frmMaterias.getCbx_CamFormacion().getSelectedItem().toString();
        if (this.guardar) {
            MateriaMD materia = new MateriaMD();
            carreraMD.setId(this.MTBD.filtrarIdCarrera(carrera, 0).getId());
            ejeMD.setId(this.MTBD.filtrarIdEje(eje, 0).getId());
            materia.setCarrera(carreraMD);
            materia.setEje(ejeMD);
            materia.setCodigo(materiaCodigo);
            materia.setNombre(materiaNombre);
            materia.setCiclo(materiaCiclo);
            materia.setCreditos(creditos);
            if (materiaTipo.equals("SELECCIONE")) {
                materia.setTipo(' ');
            } else {
                materia.setTipo(materiaTipo.charAt(0));
            }
            materia.setTipoAcreditacion(tipoAcreditacion.charAt(0));
            materia.setHorasDocencia(horasDocencia);
            materia.setHorasPracticas(horasPracticas);
            materia.setHorasPresenciales(horasPresenciales);
            materia.setHorasAutoEstudio(horasAutoEstudio);
            materia.setTotalHoras(totalHoras);
            materia.setObjetivo(objetivoGeneral);
            materia.setObjetivoespecifico(objetivoEspecifico);
            materia.setDescripcion(descripcionMateria);
            materia.setOrganizacioncurricular(organizacionCurricular);
            materia.setMateriacampoformacion(campoFormacion);
            materia.setMateriaNucleo(materiaNucleo);
            materia.setModalidad(modalidad);
            materia.setItinerario(itinerario);
            materia.setAreaAcademica(areaAcademica);
            materia.setHorasTutoria(horasTutoria);
            materia.setPerfilEgreso(perfilEgreso);
            materia.setEvaluacion(Evaluacion);
            materia.setActividadesPracticasProgramadas(actividadesPracticasProgramadas);
            materia.setEstrategiasMetodologicas(estrategiasMetodologicas);
            materia.setRecursosDidacticos(recursosDidacticos);
            if (this.editar) {
                materia.setId(this.idEditar);
                if (this.MTBD.editarMateria(materia)) {
                    JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Datos Editados Correctamente");
                    this.actualizarVtnMaterias();
                    this.frmMaterias.dispose();
                } else {
                    JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Los no se pudieron Editar Correctamente");
                }
                this.idEditar = 0;
                this.editar = false;
            } else if (this.MTBD.insertarMateria(materia)) {
                JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Datos Guardados Correctamente");
                this.actualizarVtnMaterias();
                this.frmMaterias.dispose();
            } else {
                JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Los datos no se pudieron Guardar Correctamente");
            }
            this.ctrPrin.cerradoJIF();
        } else {
            JOptionPane.showMessageDialog(null, "Existen errores en los campos\nRevise su informaci\u00f3n!!");
        }
    }

    public void cancelar() {
        this.frmMaterias.dispose();
    }

    public void buscarMateria() {
        String codigo = this.frmMaterias.getTxt_CodMateria().getText().trim();
        if (!codigo.equals("")) {
            MateriaMD materia = this.MTBD.buscarMateriaxCodigo(codigo);
            this.editar = true;
            if (materia == null) {
                this.editar = false;
                this.iniciarComponentes();
                this.borrarCampos();
                this.iniciarValidaciones();
                JOptionPane.showMessageDialog(null, "No se encuentra a la Materia");
            } else {
                this.editarMaterias(materia);
                this.iniciarValidaciones();
                this.habilitarGuardar();
            }
        }
    }

    public void iniciarValidaciones() {
        PropertyChangeListener habilitar = evt -> this.habilitarGuardar();
        KeyAdapter validarPalabras = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char car = e.getKeyChar();
                if (!Validar.esLetrasYNumeros2(car + "")) {
                    e.consume();
                }
                FrmMateriasCTR.this.habilitarGuardar();
            }
        };
        FocusAdapter horas = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                int horas_Docencia;
                String docencia = FrmMateriasCTR.this.frmMaterias.getTxtHorasDocencia().getText();
                String auto = FrmMateriasCTR.this.frmMaterias.getTxtHorasAutoEstudio().getText();
                String practicas = FrmMateriasCTR.this.frmMaterias.getTxtHorasPracticas().getText();
                if (!docencia.equals("") && !practicas.equals("")) {
                    horas_Docencia = Integer.valueOf(FrmMateriasCTR.this.frmMaterias.getTxtHorasDocencia().getText());
                    int horas_Practicas = Integer.valueOf(FrmMateriasCTR.this.frmMaterias.getTxtHorasPracticas().getText());
                    int horasPresenciales = horas_Docencia + horas_Practicas;
                    FrmMateriasCTR.this.frmMaterias.getTxtHorasPresenciales().setText(String.valueOf(horasPresenciales));
                }
                if (!(docencia.equals("") || practicas.equals("") || auto.equals(""))) {
                    horas_Docencia = Integer.valueOf(FrmMateriasCTR.this.frmMaterias.getTxtHorasDocencia().getText());
                    int horas_Auto = Integer.valueOf(FrmMateriasCTR.this.frmMaterias.getTxtHorasAutoEstudio().getText());
                    int horas_Practicas = Integer.valueOf(FrmMateriasCTR.this.frmMaterias.getTxtHorasPracticas().getText());
                    int horasTotales = horas_Docencia + horas_Practicas + horas_Auto;
                    FrmMateriasCTR.this.frmMaterias.getTxtTotalHoras().setText(String.valueOf(horasTotales));
                }
            }
        };
        KeyAdapter validarNombre = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char car = e.getKeyChar();
                if (!Validar.esLetras2(car + "")) {
                    e.consume();
                }
                FrmMateriasCTR.this.habilitarGuardar();
            }
        };
        KeyAdapter validarHorasDoc = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                String palabra = FrmMateriasCTR.this.frmMaterias.getTxtHorasDocencia().getText().trim();
                char car = e.getKeyChar();
                if (!Validar.esNumeros(car + "")) {
                    e.consume();
                }
                if (palabra != null && palabra.length() >= 3) {
                    e.consume();
                }
                FrmMateriasCTR.this.habilitarGuardar();
            }
        };
        this.frmMaterias.getCbEjeFormacion().addPropertyChangeListener(habilitar);
        this.frmMaterias.getCbMateriaTipo().addActionListener(new CmbValidar(this.frmMaterias.getCbMateriaTipo(), this.frmMaterias.getLblErrorMateriaTipo()));
        this.frmMaterias.getCbMateriaTipo().addPropertyChangeListener(habilitar);
        this.frmMaterias.getCbTipoAcreditacion().addActionListener(new CmbValidar(this.frmMaterias.getCbTipoAcreditacion(), this.frmMaterias.getLblErrorTipoAcreditacion()));
        this.frmMaterias.getCbTipoAcreditacion().addPropertyChangeListener(habilitar);
        this.frmMaterias.getCbx_Ciclo().addActionListener(new CmbValidar(this.frmMaterias.getCbx_Ciclo(), this.frmMaterias.getLblErrorMateriaCiclo()));
        this.frmMaterias.getCbx_Ciclo().addPropertyChangeListener(habilitar);
        this.frmMaterias.getCbx_OrgCurricular().addActionListener(new CmbValidar(this.frmMaterias.getCbx_OrgCurricular(), this.frmMaterias.getLblErrorOrganizacionCurricular()));
        this.frmMaterias.getCbx_OrgCurricular().addPropertyChangeListener(habilitar);
        this.frmMaterias.getCbx_CamFormacion().addActionListener(new CmbValidar(this.frmMaterias.getCbx_CamFormacion(), this.frmMaterias.getLblErrorCampoFormacion()));
        this.frmMaterias.getCbx_CamFormacion().addPropertyChangeListener(habilitar);
        this.frmMaterias.getTxt_CodMateria().addKeyListener(validarPalabras);
        this.frmMaterias.getTxtNombreMateria().addKeyListener(validarNombre);
        this.frmMaterias.getTxtCreditos().addPropertyChangeListener(habilitar);
        this.frmMaterias.getTxtHorasDocencia().addKeyListener(new TxtVNumeros_2(this.frmMaterias.getTxtHorasDocencia()));
        this.frmMaterias.getTxtHorasDocencia().addPropertyChangeListener(habilitar);
        this.frmMaterias.getTxtHorasPracticas().addKeyListener(new TxtVNumeros_2(this.frmMaterias.getTxtHorasPracticas()));
        this.frmMaterias.getTxtHorasPracticas().addPropertyChangeListener(habilitar);
        this.frmMaterias.getTxtHorasPresenciales().addKeyListener(new TxtVNumeros_2(this.frmMaterias.getTxtHorasPresenciales()));
        this.frmMaterias.getTxtHorasPresenciales().addPropertyChangeListener(habilitar);
        this.frmMaterias.getTxtHorasAutoEstudio().addKeyListener(new TxtVNumeros_2(this.frmMaterias.getTxtHorasAutoEstudio()));
        this.frmMaterias.getTxtHorasAutoEstudio().addPropertyChangeListener(habilitar);
        this.frmMaterias.getTxtTotalHoras().addKeyListener(new TxtVNumeros_2(this.frmMaterias.getTxtTotalHoras()));
        this.frmMaterias.getTxtTotalHoras().addPropertyChangeListener(habilitar);
        this.frmMaterias.getTxtHorasDocencia().addFocusListener(horas);
        this.frmMaterias.getTxtHorasAutoEstudio().addFocusListener(horas);
        this.frmMaterias.getTxtHorasPracticas().addFocusListener(horas);
        this.frmMaterias.getTxtHorasPresenciales().setEnabled(false);
        this.frmMaterias.getTxtTotalHoras().setEnabled(false);
        Font negrita = new Font("Tahoma", 1, 13);
        this.frmMaterias.getTxtHorasPresenciales().setFont(negrita);
        this.frmMaterias.getTxtTotalHoras().setFont(negrita);
        KeyAdapter validar = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char car = e.getKeyChar();
                if (!Validar.esObservacion(car + "")) {
                    e.consume();
                }
                FrmMateriasCTR.this.habilitarGuardar();
            }
        };
        this.frmMaterias.getTxtObjetivoGeneral().addKeyListener(validar);
        this.frmMaterias.getTxtObjetivoEspecifico().addKeyListener(validar);
        this.frmMaterias.getTxtDescripcionMateria().addKeyListener(validar);
    }

    public void editarMaterias(MateriaMD matEditar) {
        this.editar = true;
        this.idEditar = matEditar.getId();
        this.nombre_Materia = matEditar.getNombre();
        this.frmMaterias.getCbx_Modalidad().setSelectedItem(matEditar.getModalidad());
        this.frmMaterias.getTxtItinerario().setText(matEditar.getItinerario());
        this.frmMaterias.getCbx_AreaAcademica().setSelectedItem(matEditar.getAreaAcademica());
        this.frmMaterias.getTxtHorasTutoria().setText(String.valueOf(matEditar.getHorasTutoria()));
        this.frmMaterias.getTxtPerfilEgreso().setText(matEditar.getPerfilEgreso());
        this.frmMaterias.getTxtFormaEvidencia().setText(matEditar.getEvaluacion());
        this.frmMaterias.getTxtApp().setText(matEditar.getActividadesPracticasProgramadas());
        this.frmMaterias.getTxtEstrategias().setText(matEditar.getEstrategiasMetodologicas());
        this.frmMaterias.getTxtRecursos().setText(matEditar.getRecursosDidacticos());
        this.frmMaterias.getTxt_CodMateria().setText(matEditar.getCodigo());
        this.frmMaterias.getTxtNombreMateria().setText(matEditar.getNombre());
        this.frmMaterias.getTxtCreditos().setText(matEditar.getCreditos() + "");
        this.frmMaterias.getTxtDescripcionMateria().setText(matEditar.getDescripcion());
        this.frmMaterias.getTxtHorasAutoEstudio().setText(matEditar.getHorasAutoEstudio() + "");
        this.frmMaterias.getTxtHorasDocencia().setText(matEditar.getHorasDocencia() + "");
        this.frmMaterias.getTxtHorasPracticas().setText(matEditar.getHorasPracticas() + "");
        this.frmMaterias.getTxtHorasPresenciales().setText(matEditar.getHorasPresenciales() + "");
        this.frmMaterias.getTxtObjetivoEspecifico().setText(matEditar.getObjetivoespecifico());
        this.frmMaterias.getTxtObjetivoGeneral().setText(matEditar.getObjetivo());
        this.frmMaterias.getTxtTotalHoras().setText(matEditar.getTotalHoras() + "");
        this.frmMaterias.getChBNucleo().setSelected(matEditar.isMateriaNucleo());
        if (matEditar.getCarrera() == null) {
            this.frmMaterias.getCbCarrera().setSelectedItem("SELECCIONE");
        } else {
            this.frmMaterias.getCbCarrera().setSelectedItem(this.MTBD.filtrarIdCarrera("", matEditar.getCarrera().getId()).getNombre());
            this.frmMaterias.getCbCarrera().setEnabled(false);
        }
        List<AreaMD> areas = this.areaBD.obtenerAreasPorCarrera(matEditar.getCarrera().getId());
        this.frmMaterias.getCbx_AreaAcademica().removeAllItems();
        for (int i = 0; i < areas.size(); ++i) {
            this.frmMaterias.getCbx_AreaAcademica().addItem(areas.get(i).getNombreArea());
        }
        DefaultComboBoxModel modelo2 = (DefaultComboBoxModel)this.frmMaterias.getCbx_AreaAcademica().getModel();
        if (modelo2.getIndexOf(matEditar.getAreaAcademica()) != -1) {
            this.frmMaterias.getCbx_AreaAcademica().setSelectedItem(matEditar.getAreaAcademica());
        } else {
            modelo2.addElement(matEditar.getAreaAcademica());
            this.frmMaterias.getCbx_AreaAcademica().setSelectedItem(matEditar.getAreaAcademica());
        }
        if (matEditar.getEje().getId() > 40) {
            this.frmMaterias.getCbEjeFormacion().setSelectedItem(this.MTBD.filtrarIdEje("", matEditar.getEje().getId()).getNombre());
        } else {
            this.frmMaterias.getCbEjeFormacion().setSelectedItem("SELECCIONE");
        }
        int ciclo = matEditar.getCiclo();
        switch (ciclo) {
            case 1: {
                this.frmMaterias.getCbx_Ciclo().setSelectedItem("Ciclo 1");
                break;
            }
            case 2: {
                this.frmMaterias.getCbx_Ciclo().setSelectedItem("Ciclo 2");
                break;
            }
            case 3: {
                this.frmMaterias.getCbx_Ciclo().setSelectedItem("Ciclo 3");
                break;
            }
            case 4: {
                this.frmMaterias.getCbx_Ciclo().setSelectedItem("Ciclo 4");
                break;
            }
            case 5: {
                this.frmMaterias.getCbx_Ciclo().setSelectedItem("Ciclo 5");
            }
        }
        String materiaTipo = matEditar.getTipo() + "";
        if (null == materiaTipo) {
            materiaTipo = "H";
        } else {
            switch (materiaTipo) {
                case "M": {
                    materiaTipo = "M";
                    break;
                }
                case "C": {
                    materiaTipo = "C";
                    break;
                }
                case "H": {
                    materiaTipo = "H";
                    break;
                }
                default: {
                    materiaTipo = "SELECCIONE";
                }
            }
        }
        this.frmMaterias.getCbMateriaTipo().setSelectedItem(materiaTipo);
        String tipoAcreditacion = matEditar.getTipoAcreditacion() + "";
        if (null == tipoAcreditacion) {
            tipoAcreditacion = "T";
        } else {
            switch (tipoAcreditacion) {
                case "H": {
                    tipoAcreditacion = "H";
                    break;
                }
                case "C": {
                    tipoAcreditacion = "C";
                    break;
                }
                case "T": {
                    tipoAcreditacion = "T";
                    break;
                }
                default: {
                    tipoAcreditacion = "SELECCIONE";
                }
            }
        }
        this.frmMaterias.getCbTipoAcreditacion().setSelectedItem(tipoAcreditacion);
        this.frmMaterias.getCbx_OrgCurricular().setSelectedItem(matEditar.getOrganizacioncurricular());
        this.frmMaterias.getCbx_CamFormacion().setSelectedItem(matEditar.getMateriacampoformacion());
        this.iniciarValidaciones();
    }

    private void actualizarVtnMaterias() {
        if (this.ctrVtnMat != null) {
            this.ctrVtnMat.actualizarVtn();
        }
    }
}

