/*
 * Decompiled with CFR 0.152.
 */
package controlador.login;

import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import modelo.ConnDBPool;
import modelo.usuario.RolBD;
import modelo.usuario.UsuarioBD;
import utils.CONBD;
import utils.CONS;
import vista.usuario.VtnSelectRol;

public class VtnSelectRolCTR
extends CONBD {
    private final VtnSelectRol vista = new VtnSelectRol();
    private RolBD modelo = new RolBD();
    private final UsuarioBD usuario = CONS.USUARIO;
    private List<RolBD> rolesDelUsuario;

    public VtnSelectRolCTR() {
        this.vista.setIconImage(CONS.getImage());
        this.registroIngreso(this.vista);
    }

    private void registroIngreso(JFrame vtn) {
        vtn.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                VtnSelectRolCTR.this.inicioSesion();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                VtnSelectRolCTR.this.cierreSesion();
            }
        });
    }

    public void inicioSesion() {
        String nsql = "INSERT INTO public.\"HistorialUsuarios\"(\n\tusu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla)\n\tVALUES ('" + this.usuario.getUsername() + "', now(), 'INICIO SESION', 'SISTEMA', 0);";
        CON.executeNoSQL(nsql);
    }

    public void cierreSesion() {
        String nsql = " INSERT INTO public.\"HistorialUsuarios\"(\n  \tusu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla)\n  \tVALUES ('" + this.usuario.getUsername() + "', now(), 'CIERRE SESION', 'SISTEMA', 0);";
        CON.executeNoSQL(nsql);
        ConnDBPool pool = ConnDBPool.single();
        pool.closePool();
    }

    public void Init() {
        this.rolesDelUsuario = this.modelo.SelectWhereUSUARIOusername(this.usuario.getUsername());
        this.vista.getLblUsuario().setText(this.usuario.getUsername());
        this.rellenarCombo();
        this.InitEventos();
        this.vista.setVisible(true);
        this.vista.setLocationRelativeTo(null);
    }

    private void InitEventos() {
        this.vista.getBtnSeleccionar().addActionListener(e -> this.ingresar());
        this.vista.getBtnCancelar().addActionListener(e -> {
            this.cierreSesion();
            System.exit(0);
        });
        this.vista.getCmbRoles().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    VtnSelectRolCTR.this.ingresar();
                }
            }
        });
    }

    private void rellenarCombo() {
        this.vista.getCmbRoles().removeAllItems();
        this.rolesDelUsuario.forEach(obj -> this.vista.getCmbRoles().addItem(obj.getNombre()));
    }

    private void setModelo() {
        this.modelo = this.rolesDelUsuario.stream().filter(item -> item.getNombre().equals(this.vista.getCmbRoles().getSelectedItem().toString())).findFirst().orElse(null);
    }

    private void ingresar() {
        this.setModelo();
        CONS.setRol(this.modelo);
        CONS.refreshPermisos();
        VtnPrincipalCTR vtn = new VtnPrincipalCTR(this);
        vtn.iniciar();
        this.vista.dispose();
    }
}

