/*
 * Decompiled with CFR 0.152.
 */
package controlador.login;

import controlador.Libraries.Effects;
import controlador.login.VtnSelectRolCTR;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import modelo.usuario.UsuarioBD;
import utils.CONS;
import vista.Login;

public class LoginCTR {
    private final Login vista = new Login();
    private UsuarioBD modelo;
    private final boolean carga = true;

    public LoginCTR() {
        this.vista.setIconImage(CONS.getImage());
    }

    public void Init() {
        this.InitEventos();
        this.vista.setLocationRelativeTo(null);
        this.vista.setVisible(true);
    }

    private void InitEventos() {
        this.vista.getBtnIngresar().addActionListener(e -> this.login());
        Effects.btnHover(this.vista.getBtnIngresar(), this.vista.getLblBtnHover(), new Color(139, 195, 74), new Color(235, 192, 36));
        this.vista.getTxtPassword().addKeyListener(this.eventoText());
        this.vista.getTxtUsername().addKeyListener(this.eventoText());
        this.vista.getTxtUsername().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String txt = LoginCTR.this.vista.getTxtUsername().getText().trim();
                if (txt.length() <= 2) {
                    LoginCTR.this.ingresoVeloz(txt);
                }
            }
        });
    }

    private void activarForm(boolean estado) {
        this.vista.getTxtUsername().setEnabled(estado);
        this.vista.getTxtPassword().setEnabled(estado);
        this.vista.getBtnIngresar().setEnabled(estado);
    }

    private void login() {
        if (!this.vista.getTxtUsername().getText().isEmpty() && !this.vista.getTxtPassword().getText().isEmpty()) {
            new Thread(() -> {
                try {
                    Effects.setLoadCursor(this.vista);
                    String USERNAME = this.vista.getTxtUsername().getText().trim();
                    String PASSWORD = this.vista.getTxtPassword().getText().trim();
                    this.activarForm(false);
                    this.modelo = new UsuarioBD();
                    this.modelo.setUsername(USERNAME);
                    this.modelo.setPassword(PASSWORD);
                    this.modelo = this.modelo.selectWhereUsernamePassword();
                    if (this.modelo != null) {
                        this.vista.dispose();
                        CONS.setUsuario(this.modelo);
                        VtnSelectRolCTR vtn = new VtnSelectRolCTR();
                        vtn.Init();
                    } else {
                        Effects.setTextInLabel(this.vista.getLblAvisos(), "Revise la Informacion Ingresada", CONS.ERROR_COLOR, 2);
                        Effects.setDefaultCursor(this.vista);
                    }
                }
                catch (NullPointerException e) {
                    Effects.setDefaultCursor(this.vista);
                    Effects.setTextInLabel(this.vista.getLblAvisos(), "Revise la Informacion Ingresada", CONS.ERROR_COLOR, 2);
                }
                finally {
                    Effects.setDefaultCursor(this.vista);
                    this.activarForm(true);
                }
            }).start();
        } else {
            Effects.setTextInLabel(this.vista.getLblAvisos(), "RELLENE BIEN LA INFORMACION!!", CONS.ERROR_COLOR, 2);
        }
    }

    private KeyAdapter eventoText() {
        return new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LoginCTR.this.login();
                }
            }
        };
    }

    private void ingresoVeloz(String c) {
        if (c.length() > 1 && c.length() <= 2) {
            if (c.equalsIgnoreCase("J.")) {
                this.vista.getTxtUsername().setText("JOHNNY");
            } else if (c.equalsIgnoreCase("M.")) {
                this.vista.getTxtUsername().setText("MrRainx");
            } else if (c.equalsIgnoreCase("H.")) {
                this.vista.getTxtUsername().setText("0103156675");
            }
        }
    }
}

