/*
 * Decompiled with CFR 0.152.
 */
package controlador.docente;

import controlador.docente.FrmRolPeriodoCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.docente.RolPeriodoBD;
import modelo.docente.RolPeriodoMD;
import modelo.estilo.TblEstilo;
import modelo.periodolectivo.PeriodoLectivoMD;
import utils.CONS;
import vista.docente.FrmRolesPeriodos;
import vista.docente.VtnRolesPeriodos;

public class VtnRolPeriodosCTR
extends DVtnCTR {
    private final VtnRolesPeriodos vtnRolPe;
    private final RolPeriodoBD rolPer = RolPeriodoBD.single();
    private ArrayList<PeriodoLectivoMD> periodos;
    private ArrayList<RolPeriodoMD> roles;

    public VtnRolPeriodosCTR(VtnRolesPeriodos vtnRolPe, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnRolPe = vtnRolPe;
    }

    public void iniciar() {
        String[] titulo = new String[]{"Periodos Lectivos", "Roles"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.vtnRolPe.getTblAlumno().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.vtnRolPe.getTblAlumno());
        this.vtnRolPe.getTblAlumno().setModel(this.mdTbl);
        this.vtnRolPe.getBtnIngresar().addActionListener(e -> this.abrirFRM());
        this.vtnRolPe.getBtnEditar().addActionListener(e -> this.abrirFrmEditar());
        this.vtnRolPe.getBtnEliminar().addActionListener(e -> this.eliminarRolPeriodo());
        this.llenarTabla();
        this.ctrPrin.agregarVtn(this.vtnRolPe);
        this.InitPermisos();
    }

    private void abrirFRM() {
        this.ctrPrin.abrirFrmRolesPeriodos();
        this.vtnRolPe.dispose();
        this.ctrPrin.cerradoJIF();
    }

    public void abrirFrmEditar() {
        this.posFila = this.vtnRolPe.getTblAlumno().getSelectedRow();
        if (this.posFila >= 0) {
            FrmRolesPeriodos frm = new FrmRolesPeriodos();
            this.ctrPrin.eventoInternal(frm);
            FrmRolPeriodoCTR ctr = new FrmRolPeriodoCTR(frm, this.ctrPrin);
            ctr.iniciar();
            ctr.editarRolesPeriodos(this.roles.get(this.posFila));
            this.vtnRolPe.dispose();
            this.ctrPrin.cerradoJIF();
        } else {
            JOptionPane.showMessageDialog(null, "Seleccione una fila para editar");
        }
    }

    public void eliminarRolPeriodo() {
        this.posFila = this.vtnRolPe.getTblAlumno().getSelectedRow();
        if (this.posFila >= 0) {
            this.rolPer.eliminarRolPeriodo(this.roles.get(this.posFila).getId_rol());
            JOptionPane.showMessageDialog(null, "Datos eliminados correctamente");
            this.llenarTabla();
        } else {
            JOptionPane.showMessageDialog(null, "Seleccione una fila para eliminar");
        }
    }

    public void llenarTabla() {
        this.mdTbl = (DefaultTableModel)this.vtnRolPe.getTblAlumno().getModel();
        for (int i = this.vtnRolPe.getTblAlumno().getRowCount() - 1; i >= 0; --i) {
            this.mdTbl.removeRow(i);
        }
        this.roles = this.rolPer.llenarTabla();
        int columnas = this.mdTbl.getColumnCount();
        for (int i = 0; i < this.roles.size(); ++i) {
            this.mdTbl.addRow(new Object[columnas]);
            this.vtnRolPe.getTblAlumno().setValueAt(String.valueOf(this.roles.get(i).getPeriodo().getNombre()), i, 0);
            this.vtnRolPe.getTblAlumno().setValueAt(String.valueOf(this.roles.get(i).getNombre_rol()), i, 1);
        }
        this.vtnRolPe.getLblResultados().setText(String.valueOf(this.roles.size()) + " Resultados obtenidos.");
    }

    private void InitPermisos() {
        this.vtnRolPe.getBtnIngresar().getAccessibleContext().setAccessibleName("Roles-Periodo-Ingresar");
        this.vtnRolPe.getBtnEliminar().getAccessibleContext().setAccessibleName("Roles-Periodo-Eliminar ");
        this.vtnRolPe.getBtnEditar().getAccessibleContext().setAccessibleName("Roles-Periodo-Editar");
        CONS.activarBtns(this.vtnRolPe.getBtnIngresar(), this.vtnRolPe.getBtnEditar(), this.vtnRolPe.getBtnEliminar());
    }
}

