/*
 * Decompiled with CFR 0.152.
 */
package controlador.docente;

import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.docente.DocenteMateriaBD;
import modelo.docente.DocenteMateriaMD;
import modelo.estilo.TblEstilo;
import modelo.materia.MateriaBD;
import modelo.materia.MateriaMD;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import utils.CONS;
import vista.docente.VtnDocenteMateria;

public class VtnDocenteMateriaCTR
extends DVtnCTR {
    private final VtnDocenteMateria vtnDm;
    private final DocenteMateriaBD DMBD = DocenteMateriaBD.single();
    private final CarreraBD CRBD = CarreraBD.single();
    private final MateriaBD MTBD = MateriaBD.single();
    private ArrayList<CarreraMD> carreras;
    private ArrayList<MateriaMD> materias;
    private ArrayList<DocenteMateriaMD> dms;
    private ArrayList<Integer> ciclos;

    public VtnDocenteMateriaCTR(VtnDocenteMateria vtnDm, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnDm = vtnDm;
    }

    public void iniciar() {
        String[] titulo = new String[]{"C\u00e9dula", "Docente", "Materia"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.vtnDm.getTblDocentesMateria().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.vtnDm.getTblDocentesMateria());
        TblEstilo.columnaMedida(this.vtnDm.getTblDocentesMateria(), 0, 100);
        this.estadoCmbCicloYMateria(false);
        this.llenarCmbCarrera();
        this.vtnDm.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String b = VtnDocenteMateriaCTR.this.vtnDm.getTxtBuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    VtnDocenteMateriaCTR.this.buscar(b);
                } else if (b.length() == 0) {
                    VtnDocenteMateriaCTR.this.cargarDocenteMaterias();
                }
            }
        });
        this.vtnDm.getTxtBuscar().addKeyListener(new TxtVBuscador(this.vtnDm.getTxtBuscar(), this.vtnDm.getBtnBuscar()));
        this.vtnDm.getCmbCarrera().addActionListener(e -> this.clickCarreras());
        this.vtnDm.getCmbCiclo().addActionListener(e -> this.clickCiclo());
        this.vtnDm.getCmbMateria().addActionListener(e -> this.clickMateria());
        this.vtnDm.getBtnBuscar().addActionListener(e -> this.buscar(this.vtnDm.getTxtBuscar().getText().trim()));
        this.vtnDm.getBtnIngresar().addActionListener(e -> this.ingresar());
        this.vtnDm.getBtnEliminar().addActionListener(e -> this.eliminar());
        this.cargarDocenteMaterias();
        this.ctrPrin.agregarVtn(this.vtnDm);
        this.InitPermisos();
    }

    private void eliminar() {
        int pos = this.vtnDm.getTblDocentesMateria().getSelectedRow();
        if (pos >= 0) {
            this.DMBD.eliminar(this.dms.get(pos).getId());
            this.buscar(this.vtnDm.getTxtBuscar().getText().trim());
        } else {
            JOptionPane.showMessageDialog(null, "Debe seleccionar una fila primero.");
        }
    }

    private void buscar(String aguja) {
        if (Validar.esLetrasYNumeros(aguja)) {
            this.dms = this.DMBD.buscar(aguja);
            this.llenarTblDocenteMateria(this.dms);
        }
    }

    private void ingresar() {
        this.ctrPrin.abrirFrmDocenteMateria();
        this.vtnDm.dispose();
        this.ctrPrin.cerradoJIF();
    }

    private void cargarDocenteMaterias() {
        this.dms = this.DMBD.cargarDocenteMateria();
        this.llenarTblDocenteMateria(this.dms);
    }

    public void estadoCmbCicloYMateria(boolean estado) {
        this.vtnDm.getCmbCiclo().setEnabled(estado);
        this.vtnDm.getCmbCiclo().removeAllItems();
        this.vtnDm.getCmbMateria().setEnabled(estado);
        this.vtnDm.getCmbMateria().removeAllItems();
    }

    private void clickCarreras() {
        int posCar = this.vtnDm.getCmbCarrera().getSelectedIndex();
        if (posCar > 0) {
            this.estadoCmbCicloYMateria(true);
            int idCar = this.carreras.get(posCar - 1).getId();
            this.ciclos = this.MTBD.cargarCiclosCarrera(idCar);
            this.llenarCmbCiclo(this.ciclos);
            this.dms = this.DMBD.cargarDocenteMateriaPorCarrera(idCar);
            this.llenarTblDocenteMateria(this.dms);
        } else {
            this.estadoCmbCicloYMateria(false);
        }
    }

    private void clickCiclo() {
        int posCar = this.vtnDm.getCmbCarrera().getSelectedIndex();
        int posCic = this.vtnDm.getCmbCiclo().getSelectedIndex();
        if (posCar > 0 && posCic > 0) {
            this.materias = this.MTBD.cargarMateriaPorCarreraCiclo(this.carreras.get(posCar - 1).getId(), posCic);
            this.llenarCmbMaterias(this.materias);
            this.dms = this.DMBD.cargarDocenteMateriaPorCarreraYCiclo(this.carreras.get(posCar - 1).getId(), posCic);
            this.llenarTblDocenteMateria(this.dms);
        } else {
            this.clickCarreras();
        }
    }

    private void clickMateria() {
        int posMat = this.vtnDm.getCmbMateria().getSelectedIndex();
        if (posMat > 0) {
            this.dms = this.DMBD.cargarDocenteMateriaPorMateria(this.materias.get(posMat - 1).getId());
            this.llenarTblDocenteMateria(this.dms);
        } else {
            this.clickCiclo();
        }
    }

    private void llenarCmbCarrera() {
        this.vtnDm.getCmbCarrera().removeAllItems();
        this.carreras = this.CRBD.cargarCarrerasCmb();
        if (this.carreras != null) {
            this.vtnDm.getCmbCarrera().addItem("Todas");
            this.carreras.forEach(c -> this.vtnDm.getCmbCarrera().addItem(c.getCodigo()));
        }
    }

    private void llenarCmbMaterias(ArrayList<MateriaMD> materias) {
        this.vtnDm.getCmbMateria().removeAllItems();
        if (materias != null) {
            this.vtnDm.getCmbMateria().addItem("Todos");
            materias.forEach(m -> this.vtnDm.getCmbMateria().addItem(m.getNombre()));
            this.vtnDm.getCmbMateria().setSelectedIndex(0);
        }
    }

    private void llenarCmbCiclo(ArrayList<Integer> ciclos) {
        this.vtnDm.getCmbCiclo().removeAllItems();
        if (ciclos != null) {
            this.vtnDm.getCmbCiclo().addItem("Todos");
            ciclos.forEach(c -> this.vtnDm.getCmbCiclo().addItem(c + ""));
            this.vtnDm.getCmbCiclo().setSelectedIndex(0);
        }
    }

    private void llenarTblDocenteMateria(ArrayList<DocenteMateriaMD> dms) {
        this.mdTbl.setRowCount(0);
        if (dms != null) {
            dms.forEach(o -> {
                Object[] valores = new Object[]{o.getDocente().getIdentificacion(), o.getDocente().getPrimerNombre() + " " + o.getDocente().getPrimerApellido(), o.getMateria().getNombre()};
                this.mdTbl.addRow(valores);
            });
            this.vtnDm.getLblResultados().setText(dms.size() + " Resultados obtenidos.");
        }
    }

    private void InitPermisos() {
        this.vtnDm.getBtnIngresar().getAccessibleContext().setAccessibleName("Materia-Docentes-Ingresar");
        this.vtnDm.getBtnEliminar().getAccessibleContext().setAccessibleName("Materia-Docentes-Eliminar");
        CONS.activarBtns(this.vtnDm.getBtnIngresar(), this.vtnDm.getBtnEliminar());
    }
}

