/*
 * Decompiled with CFR 0.152.
 */
package controlador.docente;

import controlador.Libraries.Effects;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.ConnDBPool;
import modelo.persona.DocenteBD;
import modelo.persona.DocenteMD;
import modelo.usuario.HistorialUsuarioBD;
import modelo.usuario.ListaMarcacionesBD;
import modelo.usuario.ListaMarcacionesMD;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JasperViewer;
import utils.CONS;
import vista.docente.VtnConsultaMarcaciones;

public class VtnConsultaMarcacionesCTR {
    private final VtnPrincipalCTR desktop;
    private final VtnConsultaMarcaciones vista;
    private List<ListaMarcacionesMD> listaMarcaciones;
    private static DefaultTableModel tabla;
    private boolean cargarTabla = true;
    String consulta;
    Date fechaI;
    Date fechaF;
    String cedula;

    public VtnConsultaMarcacionesCTR(VtnPrincipalCTR desktop, VtnConsultaMarcaciones vista) {
        this.desktop = desktop;
        this.vista = vista;
    }

    public void Init() {
        Effects.addInDesktopPane(this.vista, this.desktop.getVtnPrin().getDpnlPrincipal());
        this.vista.setTitle("Reporte de Marcaciones");
        tabla = (DefaultTableModel)this.vista.getTblMarcaciones().getModel();
        this.vista.getDtcDesde().setDate(new Date());
        this.vista.getDtcHasta().setDate(new Date());
        this.initListeners();
        this.InitPermisos();
    }

    private void initListeners() {
        KeyListener txtlistener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                VtnConsultaMarcacionesCTR.this.cargaDocente();
            }
        };
        this.vista.getBtnAplicar().addActionListener(l -> this.cargarTabla());
        this.vista.getTxtCedulaDocente().addKeyListener(txtlistener);
        this.vista.getBtnImprimr().addActionListener(l -> this.reporteMarcaciones());
    }

    private void cargaDocente() {
        int largo = this.vista.getTxtCedulaDocente().getText().length();
        if (largo == 10) {
            String cedula = this.vista.getTxtCedulaDocente().getText();
            DocenteMD docente = DocenteBD.single().buscarDocenteNombres(cedula);
            if (docente != null) {
                this.vista.getLblNombreDocente().setText(docente.getNombreCompleto());
                this.vista.getBtnAplicar().requestFocus();
            } else {
                this.vista.getLblNombreDocente().setText("TODOS");
            }
        } else {
            this.vista.getLblNombreDocente().setText("TODOS");
        }
    }

    private void cargarTabla() {
        HistorialUsuarioBD.single().registroMarca(CONS.USUARIO.getUsername(), this.vista.getLblNombreDocente().getText());
        tabla.setRowCount(0);
        this.fechaI = this.vista.getDtcDesde().getDate();
        this.fechaF = this.vista.getDtcHasta().getDate();
        this.cedula = this.vista.getTxtCedulaDocente().getText();
        Effects.setLoadCursor(this.vista);
        this.listaMarcaciones = ListaMarcacionesBD.listadoMarcaciones(this.fechaI, this.fechaF, this.cedula);
        this.listaMarcaciones.stream().forEach(this.agregaFilas());
        Effects.setDefaultCursor(this.vista);
    }

    private Consumer<ListaMarcacionesMD> agregaFilas() {
        return obj -> tabla.addRow(new Object[]{obj.getFechaMarcacion(), obj.getCedulaDocente(), obj.getNombreDocente(), obj.getEntradaUno(), obj.getSalidaUno(), obj.getEntradaDos(), obj.getSalidaDos(), obj.getHoras(), obj.getMinutos(), VtnConsultaMarcacionesCTR.calculaTiempo(obj.getHoras(), obj.getMinutos(), obj.getTiempoDedicacion())});
    }

    public static String calculaTiempo(int hour, int minutes, int limite) {
        LocalTime targetTime;
        LocalTime currentTime = LocalTime.of(hour, minutes);
        long minutesDifference = currentTime.until(targetTime = LocalTime.of(limite, 0), ChronoUnit.MINUTES);
        if (minutesDifference <= 0L) {
            return "Alcanzado las " + limite + " horas.";
        }
        long hours = minutesDifference / 60L;
        long remainingMinutes = minutesDifference % 60L;
        return "Faltan " + hours + " horas y " + remainingMinutes + " minutos para " + limite + " horas.";
    }

    private void reporteMarcaciones() {
        this.cargarTabla();
        String path = "/vista/reportes/repMarcaciones2.jasper";
        try {
            ConnDBPool cpg = new ConnDBPool();
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
            HashMap<String, String> parametros = new HashMap<String, String>();
            parametros.put("fechai", this.fechaFormato(this.fechaI));
            parametros.put("fechaf", this.fechaFormato(this.fechaF));
            String filtroDocente = " ";
            if (this.vista.getLblNombreDocente().getText() != "TODOS") {
                filtroDocente = " and docente_id=(select id_docente from \"Docentes\" where docente_codigo='" + this.vista.getTxtCedulaDocente().getText() + "')";
            }
            parametros.put("filtro_docente", filtroDocente);
            parametros.put("consulta", " AND fecha_hora between '" + this.fechaFormato(this.fechaI) + " 00:00:00' and '" + this.fechaFormato(this.fechaF) + " 23:59:59'");
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)jr, parametros, (Connection)cpg.getConnection());
            jp.setName("Reporte de Marcaciones del " + this.fechaFormato(this.fechaI) + " al " + this.fechaFormato(this.fechaF) + " " + this.vista.getLblNombreDocente().getText());
            JasperViewer jv = new JasperViewer(jp, false);
            jv.setVisible(true);
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "Error en reporte: " + (Object)((Object)ex));
        }
    }

    private String fechaFormato(Date fecha) {
        SimpleDateFormat formato = new SimpleDateFormat("yyyy-MM-dd");
        String fechaHoraFormateada = formato.format(fecha);
        return fechaHoraFormateada;
    }

    private void InitPermisos() {
    }
}

