/*
 * Decompiled with CFR 0.152.
 */
package controlador.docente;

import java.awt.Color;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import modelo.docente.MarcacionDocenteBD;
import modelo.docente.MarcacionDocenteMD;
import modelo.persona.DocenteBD;
import modelo.persona.DocenteMD;
import modelo.usuario.UsuarioBD;
import utils.Mensajes;
import utils.Recursos;
import utils.RelojDigital;

public class MarcacionDocente {
    private vista.docente.MarcacionDocente vista;
    private RelojDigital reloj;
    private UsuarioBD usuario;
    private Mensajes mensajes;

    public MarcacionDocente(vista.docente.MarcacionDocente vista) {
        this.vista = vista;
        vista.setVisible(true);
        this.reloj = new RelojDigital(vista);
        this.reloj.iniciar();
        this.mensajes = new Mensajes(vista);
        this.iniciaControl();
    }

    public void iniciaControl() {
        this.vista.getClockFace1().setRomano(false);
        this.vista.getBntMarcar1().addActionListener(l -> this.registraMarcarcion());
        this.vista.getUsuario().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.validateTextLength();
            }

            private void validateTextLength() {
                String text = MarcacionDocente.this.vista.getUsuario().getText();
                if (text.length() > 9) {
                    MarcacionDocente.this.vista.getUsuario().setText(text.substring(0, 10));
                }
                if (text.length() == 10) {
                    MarcacionDocente.this.cargaDatosDocentes();
                }
            }
        });
        this.vista.getPassx().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MarcacionDocente.this.registraMarcarcion();
                }
            }
        });
    }

    private void cargaDatosDocentes() {
        if (this.vista.getUsuario().getText().length() == 10) {
            String usuarioMC = this.vista.getUsuario().getText();
            DocenteMD docente = DocenteBD.single().buscarDocente(usuarioMC);
            if (docente != null) {
                this.vista.getLblDocente().setText(docente.getNombreCompleto());
                this.vista.getPassx().requestFocus();
                if (docente.getFoto() != null) {
                    Image icono = docente.getFoto().getScaledInstance(this.vista.getLbFoto().getWidth(), this.vista.getLbFoto().getHeight(), 4);
                    this.vista.getLbFoto().setIcon(new ImageIcon(icono));
                    this.vista.getLbFoto().updateUI();
                } else {
                    this.vista.getLbFoto().setIcon(null);
                    this.vista.getLbFoto().updateUI();
                }
            } else {
                this.vista.getUsuario().setText("");
                this.vista.getTxtMensaje().setForeground(Color.red);
                new Thread(() -> {
                    Recursos.voz("audio3.wav", this.vista, "USUARIO NO ENCONTRADO");
                    Recursos.error("Atenci\u00f3n", "USUARIO NO ENCONTRADO");
                }).start();
                this.limpiar();
            }
        }
    }

    private void registraMarcarcion() {
        String usuarioMC = this.vista.getUsuario().getText();
        String passwordMC = this.vista.getPassx().getText();
        String entrad_salida = "ENTRADA";
        this.usuario = new UsuarioBD();
        this.usuario.setUsername(usuarioMC);
        this.usuario.setPassword(passwordMC);
        this.usuario = this.usuario.selectWhereUsernamePassword();
        if (this.usuario != null) {
            DocenteMD docente = DocenteBD.single().buscarDocente(usuarioMC);
            MarcacionDocenteMD marcacion = new MarcacionDocenteMD();
            marcacion.setDocente_id(docente.getIdDocente());
            marcacion.setFecha_hora(this.vista.getTxtReloj().getText());
            marcacion.setEntrada_salida(entrad_salida);
            MarcacionDocenteMD registro = MarcacionDocenteBD.single().obtenerUltimaMarcacion(docente);
            if (registro.getFecha_hora() != null) {
                if (registro.getEntrada_salida().equals("ENTRADA")) {
                    marcacion.setEntrada_salida("SALIDA");
                }
                if (MarcacionDocenteBD.single().validarTiempoMarcacion(marcacion, registro)) {
                    this.registrar(marcacion);
                } else {
                    this.vista.getTxtMensaje().setForeground(Color.red);
                    new Thread(() -> {
                        Recursos.warning("Atenci\u00f3n", "EL USUARIO YA SE ENCUENTRA REGISTRADO");
                        Recursos.voz("audio2.wav", this.vista, "EL USUARIO YA SE ENCUENTRA REGISTRADO");
                    }).start();
                    this.limpiar();
                }
            } else {
                this.registrar(marcacion);
            }
        } else {
            this.vista.getTxtMensaje().setForeground(Color.red);
            new Thread(() -> {
                Recursos.voz("audio3.wav", this.vista, "USUARIO O CONTRASE\u00d1A INCORRECTA");
                Recursos.error("Atenci\u00f3n", "USUARIO O CONTRASE\u00d1A INCORRECTA");
            }).start();
            this.limpiar();
        }
    }

    public void registrar(MarcacionDocenteMD marcacion) {
        MarcacionDocenteBD.single().guardar(marcacion);
        this.vista.getLblHora().setText(this.vista.getTxtReloj().getText());
        this.vista.getTxtMensaje().setForeground(Color.green);
        new Thread(() -> {
            Recursos.voz("audio1.wav", this.vista, "ACCESO CORRECTO");
            Recursos.success("Atenci\u00f3n", "ACCESO CORRECTO");
        }).start();
        this.limpiar();
    }

    public void limpiar() {
        this.vista.getLblHora().setText("");
        this.vista.getUsuario().setText("");
        this.vista.getLblDocente().setText("");
        this.vista.getPassx().setText("");
        this.vista.getLbFoto().setIcon(null);
        this.vista.getLbFoto().updateUI();
        this.vista.getUsuario().requestFocus();
    }
}

