/*
 * Decompiled with CFR 0.152.
 */
package controlador.docente;

import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.curso.CursoBD;
import modelo.curso.CursoMD;
import modelo.estilo.TblEstilo;
import modelo.materia.MateriaBD;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.persona.DocenteBD;
import modelo.persona.DocenteMD;
import modelo.validaciones.Validar;
import vista.docente.JDReasignarMaterias;

public class JDReasignarMateriasCTR
extends DVtnCTR {
    private final DocenteBD DBD = DocenteBD.single();
    private CursoMD cursoMD;
    private DocenteMD docenteMD;
    private final String materia;
    private final String curso;
    private final int periodo;
    private final int docente;
    private final JDReasignarMaterias frmReasignarMateria;
    private ArrayList<DocenteMD> docentesMD;

    public JDReasignarMateriasCTR(VtnPrincipalCTR ctrPrin, String materia, String curso, int periodo, int docente) {
        super(ctrPrin);
        this.materia = materia;
        this.curso = curso;
        this.periodo = periodo;
        this.docente = docente;
        this.frmReasignarMateria = new JDReasignarMaterias((Frame)ctrPrin.getVtnPrin(), false);
        this.frmReasignarMateria.setLocationRelativeTo(ctrPrin.getVtnPrin());
        this.frmReasignarMateria.setVisible(true);
        this.frmReasignarMateria.setTitle("Reasignar Materias");
    }

    public void iniciar() {
        this.frmReasignarMateria.getLblMateria().setText(this.materia);
        this.frmReasignarMateria.getBtnCancelar().addActionListener(e -> this.salir());
        this.frmReasignarMateria.getBtnReasignarMateria().addActionListener(e -> this.reasignarMaterias());
        String[] titulo = new String[]{"Cedula", "Nombres Completos", "Celular", "Correo", "Tipo Contrato"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.frmReasignarMateria.getTblDocentesDisponibles().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.frmReasignarMateria.getTblDocentesDisponibles());
        TblEstilo.columnaMedida(this.frmReasignarMateria.getTblDocentesDisponibles(), 0, 85);
        TblEstilo.columnaMedida(this.frmReasignarMateria.getTblDocentesDisponibles(), 1, 250);
        TblEstilo.columnaMedida(this.frmReasignarMateria.getTblDocentesDisponibles(), 2, 90);
        TblEstilo.columnaMedida(this.frmReasignarMateria.getTblDocentesDisponibles(), 3, 230);
        TblEstilo.columnaMedida(this.frmReasignarMateria.getTblDocentesDisponibles(), 4, 125);
        this.cargarDocentes();
        this.frmReasignarMateria.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String b = JDReasignarMateriasCTR.this.frmReasignarMateria.getTxtBuscar().getText().toUpperCase().trim();
                if (e.getKeyCode() == 10) {
                    JDReasignarMateriasCTR.this.buscaIncremental(b);
                } else if (b.length() == 0) {
                    JDReasignarMateriasCTR.this.cargarDocentes();
                }
            }
        });
    }

    private void salir() {
        this.frmReasignarMateria.dispose();
    }

    private void reasignarMaterias() {
        this.posFila = this.frmReasignarMateria.getTblDocentesDisponibles().getSelectedRow();
        if (this.posFila >= 0) {
            CursoBD bdCurso = CursoBD.single();
            DocenteMD d = new DocenteMD();
            MateriaBD bdMateria = MateriaBD.single();
            this.cursoMD = bdCurso.atraparCurso(bdMateria.buscarMateria(this.materia).getId(), this.periodo, this.docente, this.curso);
            d.setIdDocente(this.DBD.buscarDocente(this.frmReasignarMateria.getTblDocentesDisponibles().getValueAt(this.posFila, 0).toString()).getIdDocente());
            this.cursoMD.setDocente(d);
            System.out.println("docente " + d.getIdDocente());
            if (bdCurso.nuevoCurso(this.cursoMD)) {
                int curso_New = bdCurso.atraparCurso(bdMateria.buscarMateria(this.materia).getId(), this.periodo, d.getIdDocente(), this.curso).getId();
                if (this.DBD.reasignarAlumnoCurso(this.cursoMD.getId(), curso_New)) {
                    if (this.DBD.reasignarNotas(this.cursoMD.getId(), curso_New)) {
                        JOptionPane.showMessageDialog(null, "Se reasign\u00f3 con \u00e9xito las materias y notas al docente seleccionado");
                        this.frmReasignarMateria.dispose();
                    } else {
                        JOptionPane.showMessageDialog(null, "No se pudo reasignar las notas de esas materias al nuevo docente seleccionado");
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "No se pudo reasignar las materias al docente seleccionado");
                }
            } else {
                JOptionPane.showMessageDialog(null, "No se pudo finalizar el contrato de este docente");
            }
        } else {
            JOptionPane.showMessageDialog(null, "Debe seleccionar una fila ");
        }
    }

    public void buscaIncremental(String aguja) {
        if (Validar.esLetrasYNumeros(aguja)) {
            this.docentesMD = this.DBD.buscarReasignarMateria(aguja);
            this.llenarTabla(this.docentesMD);
        }
    }

    public void cargarTabla(String periodo) {
        DocenteBD d = DocenteBD.single();
        PeriodoLectivoBD p = PeriodoLectivoBD.single();
        DefaultTableModel modelo_Tabla = (DefaultTableModel)this.frmReasignarMateria.getTblDocentesDisponibles().getModel();
        for (int i = this.frmReasignarMateria.getTblDocentesDisponibles().getRowCount() - 1; i >= 0; --i) {
            modelo_Tabla.removeRow(i);
        }
        List<CursoMD> lista = d.capturarMaterias(p.buscarPeriodo(periodo).getID(), this.docenteMD.getIdDocente());
        int columnas = modelo_Tabla.getColumnCount();
        for (int i = 0; i < lista.size(); ++i) {
            modelo_Tabla.addRow(new Object[columnas]);
            this.frmReasignarMateria.getTblDocentesDisponibles().setValueAt(lista.get(i).getDocente().getNombreCompleto(), i, 0);
        }
        this.frmReasignarMateria.getLblResultados().setText(lista.size() + "resultados obtenidos.");
    }

    private void cargarDocentes() {
        this.docentesMD = this.DBD.cargarDocentesParaReasignarMaterias();
        this.llenarTabla(this.docentesMD);
    }

    public void llenarTabla(ArrayList<DocenteMD> docentesM) {
        this.mdTbl.setRowCount(0);
        if (docentesM != null) {
            docentesM.forEach(dc -> {
                Object[] valores = new Object[]{dc.getCodigo(), dc.getPrimerApellido() + " " + dc.getSegundoApellido() + " " + dc.getPrimerNombre() + " " + dc.getSegundoNombre(), dc.getCelular(), dc.getCorreo(), dc.getDocenteTipoTiempo()};
                this.mdTbl.addRow(valores);
            });
        }
    }
}

