/*
 * Decompiled with CFR 0.152.
 */
package controlador.docente;

import controlador.docente.JDReasignarMateriasCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.curso.CursoBD;
import modelo.curso.CursoMD;
import modelo.materia.MateriaBD;
import modelo.materia.MateriaMD;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.DocenteBD;
import modelo.persona.DocenteMD;
import modelo.validaciones.CmbValidar;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import vista.docente.JDFinContratacion;

public class JDFinContratacionCTR
extends DVtnCTR {
    private PeriodoLectivoBD periodoBD;
    private final DocenteBD DBD = DocenteBD.single();
    private DocenteMD docenteMD;
    private final int ID;
    private int periodo;
    private final JDFinContratacion frmFinContrato;
    private static LocalDate fechaInicio;
    private boolean guardar = false;
    private List<CursoMD> lista;

    public JDFinContratacionCTR(VtnPrincipalCTR ctrPrin, String cedula, int ID) {
        super(ctrPrin);
        this.ID = ID;
        this.frmFinContrato = new JDFinContratacion((Frame)ctrPrin.getVtnPrin(), false);
        this.frmFinContrato.setLocationRelativeTo(ctrPrin.getVtnPrin());
        this.frmFinContrato.setVisible(true);
        this.frmFinContrato.setTitle("Fin de Contrato");
    }

    public void iniciar() {
        this.docenteMD = this.DBD.buscarDocente(this.ID);
        this.frmFinContrato.getBtn_Cancelar().addActionListener(e -> this.cancelar());
        this.iniciarFinContrato();
        this.iniciarPeriodosDocente();
    }

    public void cancelar() {
        this.frmFinContrato.dispose();
    }

    public void iniciarPeriodosDocente() {
        this.frmFinContrato.getLbl_ErrPeriodos().setVisible(false);
        this.frmFinContrato.getJcbPeriodos().addActionListener(e -> {
            block3: {
                block2: {
                    int pos = this.frmFinContrato.getJcbPeriodos().getSelectedIndex();
                    if (pos <= 0) break block2;
                    this.frmFinContrato.getJcbPeriodos().setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
                    if (this.frmFinContrato.getLbl_ErrPeriodos() == null) break block3;
                    CursoBD CBD = CursoBD.single();
                    this.frmFinContrato.getLbl_ErrPeriodos().setVisible(false);
                    String periodo1 = this.frmFinContrato.getJcbPeriodos().getSelectedItem().toString();
                    List<Integer> IDs = CBD.consultaCursos();
                    this.filtrarMaterias(periodo1, IDs);
                    this.llenarTabla();
                    int num = this.frmFinContrato.getCbx_Periodos().getItemCount();
                    if (num >= 2) break block3;
                    JOptionPane.showMessageDialog(null, "No se filtr\u00f3 ning\u00fan Per\u00edodo Lectivo de este Docente");
                    break block3;
                }
                this.frmFinContrato.getJcbPeriodos().setBorder(BorderFactory.createLineBorder(new Color(204, 0, 0)));
                if (this.frmFinContrato.getLbl_ErrPeriodos() != null) {
                    this.frmFinContrato.getLbl_ErrPeriodos().setVisible(true);
                    DefaultTableModel modelo_Tabla = (DefaultTableModel)this.frmFinContrato.getTblMateriasCursos().getModel();
                    for (int i = this.frmFinContrato.getTblMateriasCursos().getRowCount() - 1; i >= 0; --i) {
                        modelo_Tabla.removeRow(i);
                    }
                }
            }
            this.habilitarGuardar();
        });
        this.listaPeriodos();
    }

    public void listaPeriodos() {
        this.periodoBD = PeriodoLectivoBD.single();
        List<PeriodoLectivoMD> listaPeriodos = this.periodoBD.periodoDocente(this.ID);
        for (int i = 0; i < listaPeriodos.size(); ++i) {
            this.frmFinContrato.getJcbPeriodos().addItem(listaPeriodos.get(i).getNombre());
        }
    }

    public void filtrarMaterias(String nombre_Periodo, List<Integer> num) {
        DocenteBD DBD = DocenteBD.single();
        PeriodoLectivoBD PLBD = PeriodoLectivoBD.single();
        this.lista = DBD.capturarMaterias(PLBD.capturarIdPeriodo(nombre_Periodo).getID(), this.docenteMD.getIdDocente());
        block0: for (int x = 0; x < num.size(); ++x) {
            for (int i = 0; i < this.lista.size(); ++i) {
                if (num.get(x).intValue() != this.lista.get(i).getMateria().getId()) continue;
                this.lista.remove(i);
                continue block0;
            }
        }
        if (this.lista.isEmpty()) {
            JOptionPane.showMessageDialog(null, "Todas las materias ya fueron reasignadas");
        }
        this.periodo = PLBD.capturarIdPeriodo(nombre_Periodo).getID();
    }

    public void llenarTabla() {
        DefaultTableModel modelo_Tabla = (DefaultTableModel)this.frmFinContrato.getTblMateriasCursos().getModel();
        for (int i = this.frmFinContrato.getTblMateriasCursos().getRowCount() - 1; i >= 0; --i) {
            modelo_Tabla.removeRow(i);
        }
        int columnas = modelo_Tabla.getColumnCount();
        for (int i = 0; i < this.lista.size(); ++i) {
            modelo_Tabla.addRow(new Object[columnas]);
            this.frmFinContrato.getTblMateriasCursos().setValueAt(this.lista.get(i).getMateria().getNombre(), i, 0);
            this.frmFinContrato.getTblMateriasCursos().setValueAt(this.lista.get(i).getNombre(), i, 1);
        }
    }

    private void aceptar() {
        this.frmFinContrato.getJcbPeriodos().getSelectedItem();
    }

    private void pnlAnterior() {
        this.frmFinContrato.getTpFrm().setSelectedIndex(0);
        this.frmFinContrato.getBtnGuardar().setEnabled(true);
        this.frmFinContrato.getBtnGuardar().setText("Siguiente");
        this.habilitarGuardar();
    }

    public void iniciarFinContrato() {
        this.frmFinContrato.getLblErrorFechaFinContratacion().setVisible(false);
        this.frmFinContrato.getLblErrorObservacion().setVisible(false);
        if (!this.docenteMD.isDocenteEnFuncion()) {
            this.frmFinContrato.getJdcFinContratacion().setEnabled(false);
            this.frmFinContrato.getTxtObservacion().setEnabled(false);
            this.frmFinContrato.getBtnGuardar().setEnabled(false);
            this.frmFinContrato.getBtnReasignarMateria().setEnabled(true);
            this.frmFinContrato.getBtnReasignarMateria().addActionListener(e -> this.reasignarMateria());
        } else {
            this.frmFinContrato.getBtnGuardar().setEnabled(false);
            this.frmFinContrato.getBtnReasignarMateria().setEnabled(false);
            this.frmFinContrato.getBtnGuardar().addActionListener(e -> this.guardarFinContratacion());
            this.frmFinContrato.getBtnReasignarMateria().addActionListener(e -> this.reasignarMateria());
        }
        this.frmFinContrato.getTxtObservacion().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String Observacion = JDFinContratacionCTR.this.frmFinContrato.getTxtObservacion().getText();
                if (!Validar.esObservacion(Observacion)) {
                    JDFinContratacionCTR.this.frmFinContrato.getLblErrorObservacion().setVisible(true);
                } else {
                    JDFinContratacionCTR.this.frmFinContrato.getLblErrorObservacion().setVisible(false);
                }
                JDFinContratacionCTR.this.habilitarGuardar();
            }
        });
        this.frmFinContrato.getJdcFinContratacion().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked() {
                if (JDFinContratacionCTR.this.validarFecha()) {
                    JDFinContratacionCTR.this.frmFinContrato.getLblErrorFechaFinContratacion().setVisible(false);
                } else {
                    JDFinContratacionCTR.this.frmFinContrato.getLblErrorFechaFinContratacion().setText("El inicio de contrato no puede ser \n mayor al de finalizaci\u00f3n");
                    JDFinContratacionCTR.this.frmFinContrato.getLblErrorFechaFinContratacion().setVisible(true);
                }
                JDFinContratacionCTR.this.habilitarGuardar();
            }
        });
        PropertyChangeListener habilitar = evt -> this.habilitarGuardar();
        this.frmFinContrato.getCbx_Periodos().addActionListener(new CmbValidar(this.frmFinContrato.getCbx_Periodos(), this.frmFinContrato.getLbl_ErrPeriodos()));
        this.frmFinContrato.getCbx_Periodos().addPropertyChangeListener(habilitar);
    }

    public void habilitarGuardar() {
        String observacion = this.frmFinContrato.getTxtObservacion().getText();
        Date fecha = this.frmFinContrato.getJdcFinContratacion().getDate();
        int posPrd = this.frmFinContrato.getCbx_Periodos().getSelectedIndex();
        int pos = this.frmFinContrato.getTpFrm().getSelectedIndex();
        if (!observacion.equals("") && fecha != null && posPrd > 0) {
            if (!this.frmFinContrato.getLblErrorObservacion().isVisible() && !this.frmFinContrato.getLbl_ErrPeriodos().isVisible() && this.lista != null) {
                this.frmFinContrato.getBtnGuardar().setEnabled(true);
                this.guardar = true;
            } else {
                this.frmFinContrato.getBtnGuardar().setEnabled(false);
            }
        } else {
            this.frmFinContrato.getBtnGuardar().setEnabled(false);
        }
    }

    private void guardarFinContratacion() {
        String Observacion = "";
        String periodo = "";
        Observacion = this.frmFinContrato.getTxtObservacion().getText().trim().toUpperCase();
        Date fecha = this.frmFinContrato.getJdcFinContratacion().getDate();
        periodo = this.frmFinContrato.getCbx_Periodos().getSelectedItem().toString();
        if (!this.docenteMD.getFechaInicioContratacion().isAfter(this.convertirDate(fecha)) && !this.docenteMD.getFechaInicioContratacion().isEqual(this.convertirDate(fecha))) {
            this.guardar = true;
            this.frmFinContrato.getLblErrorFechaFinContratacion().setVisible(false);
        } else {
            this.guardar = false;
            this.frmFinContrato.getLblErrorFechaFinContratacion().setText("La fecha de inicio de contrato no puede ser mayor a la de finalizaci\u00f3n");
            this.frmFinContrato.getLblErrorFechaFinContratacion().setVisible(true);
            JOptionPane.showMessageDialog(null, "No se puede guardar, revise la Fecha de Culminaci\u00f3n de Contrato");
        }
        if (this.guardar) {
            DocenteMD docente = new DocenteMD();
            CursoMD curso = new CursoMD();
            PeriodoLectivoMD periodoMD = new PeriodoLectivoMD();
            docente.setObservacion(Observacion);
            docente.setFechaFinContratacion(this.convertirDate(fecha));
            docente.setIdDocente(this.docenteMD.getIdDocente());
            periodoMD.setID(this.periodoBD.capturarIdPeriodo(periodo).getID());
            curso.setPeriodo(periodoMD);
            curso.setDocente(docente);
            if (this.DBD.terminarContrato(docente)) {
                System.out.println("Se finaliz\u00f3 contrato");
                if (this.lista != null) {
                    int cont = 0;
                    for (int i = 0; i < this.lista.size(); ++i) {
                        MateriaMD materia = new MateriaMD();
                        materia.setId(this.lista.get(i).getMateria().getId());
                        curso.setMateria(materia);
                        curso.setNombre(this.lista.get(i).getNombre());
                        if (!this.DBD.deshabilitarCursos(curso)) continue;
                        ++cont;
                    }
                    if (cont == this.lista.size()) {
                        JOptionPane.showMessageDialog(null, "Se finaliz\u00f3 el contrato del Docente con \u00e9xito");
                        this.frmFinContrato.getBtnReasignarMateria().setEnabled(true);
                        this.periodo = periodoMD.getID();
                        this.botoninformeDocente();
                    } else {
                        JOptionPane.showMessageDialog(null, "No se pudo finalizar el contrato de este Docente");
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Se finaliz\u00f3 el contrato del Docente");
                    this.frmFinContrato.getBtnReasignarMateria().setEnabled(true);
                    this.periodo = periodoMD.getID();
                    this.botoninformeDocente();
                }
            } else {
                JOptionPane.showMessageDialog(null, "No se pudo finalizar el contrato de este Docente");
            }
            System.out.println("Se guarda en base de datos");
        } else {
            this.frmFinContrato.getTpFrm().setSelectedIndex(1);
            this.habilitarGuardar();
        }
    }

    public boolean validarFecha() {
        Date fecha = this.frmFinContrato.getJdcFinContratacion().getDate();
        return !this.docenteMD.getFechaInicioContratacion().isAfter(this.convertirDate(fecha)) && !this.docenteMD.getFechaInicioContratacion().isEqual(this.convertirDate(fecha));
    }

    public LocalDate convertirDate(Date fecha) {
        return Instant.ofEpochMilli(fecha.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public void llamainformeDocente() {
        String path = "/vista/reportes/INFORME_DOCENTE_RETIRADO.jasper";
        try {
            HashMap<String, Object> parametro = new HashMap<String, Object>();
            parametro.put("iddocente", this.docenteMD.getIdDocente());
            parametro.put("periodolectivo", this.frmFinContrato.getJcbPeriodos());
            parametro.put("periodolectivo", this.frmFinContrato.getCbx_Periodos().getSelectedItem().toString());
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
            CON.mostrarReporte(jr, parametro, "Informe de Retiro");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
        }
    }

    public void botoninformeDocente() {
        int s = JOptionPane.showOptionDialog(this.ctrPrin.getVtnPrin(), "Registro de persona \n\u00bfDesea Imprimir el Registro realizado ?", "Informe de Retiro", 1, 1, null, new Object[]{"SI", "NO"}, "NO");
        switch (s) {
            case 0: {
                this.llamainformeDocente();
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private void reasignarMateria() {
        CursoBD bdCurso = CursoBD.single();
        CursoMD c = new CursoMD();
        MateriaBD bdMateria = MateriaBD.single();
        this.posFila = this.frmFinContrato.getTblMateriasCursos().getSelectedRow();
        if (this.posFila >= 0) {
            boolean activo = bdCurso.atraparCurso(bdMateria.buscarMateria(this.frmFinContrato.getTblMateriasCursos().getValueAt(this.posFila, 0).toString()).getId(), this.periodo, this.docenteMD.getIdDocente(), this.frmFinContrato.getTblMateriasCursos().getValueAt(this.posFila, 1).toString()).isActivo();
            if (activo) {
                JOptionPane.showMessageDialog(null, "Este curso est\u00e1 activo, para reasignarlo a un nuevo docente debe eliminarlo");
            } else {
                JDReasignarMateriasCTR ctr = new JDReasignarMateriasCTR(this.ctrPrin, this.frmFinContrato.getTblMateriasCursos().getValueAt(this.posFila, 0).toString(), this.frmFinContrato.getTblMateriasCursos().getValueAt(this.posFila, 1).toString(), this.periodo, this.docenteMD.getIdDocente());
                ctr.iniciar();
            }
        } else {
            JOptionPane.showMessageDialog(null, "Debe seleccionar una fila ");
        }
    }
}

