/*
 * Decompiled with CFR 0.152.
 */
package controlador.docente;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import modelo.docente.RolPeriodoBD;
import modelo.docente.RolPeriodoMD;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.validaciones.TxtVLetras;
import modelo.validaciones.Validar;
import vista.docente.FrmRolesPeriodos;

public class FrmRolPeriodoCTR
extends DCTR {
    private final FrmRolesPeriodos frmRolPer;
    private final RolPeriodoBD RPLBD = RolPeriodoBD.single();
    private ArrayList<PeriodoLectivoMD> periodos;
    private final PeriodoLectivoBD PRBD = PeriodoLectivoBD.single();
    private boolean editar = false;
    private int idRolPrd;

    public FrmRolPeriodoCTR(FrmRolesPeriodos frmRolPer, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.frmRolPer = frmRolPer;
    }

    public void iniciar() {
        this.cargarCmbPrdLectivo();
        this.frmRolPer.getLbl_error_roles().setVisible(false);
        this.iniciarValidaciones();
        this.frmRolPer.getBtnGuardar().addActionListener(e -> this.insertarRolesPeriodos());
        this.ctrPrin.agregarVtn(this.frmRolPer);
    }

    private void cargarCmbPrdLectivo() {
        this.periodos = this.PRBD.cargarPrdParaCmbFrm();
        if (this.periodos != null) {
            this.frmRolPer.getCmbPeriodoLectivo().removeAllItems();
            this.frmRolPer.getCmbPeriodoLectivo().addItem("Seleccione");
            this.periodos.forEach(p -> this.frmRolPer.getCmbPeriodoLectivo().addItem(p.getNombre()));
        }
    }

    public void insertarRolesPeriodos() {
        int posFila = this.frmRolPer.getCmbPeriodoLectivo().getSelectedIndex();
        boolean guardar = true;
        if (posFila == 0) {
            guardar = false;
        }
        if (!Validar.esLetras(this.frmRolPer.getTxtNombreRol().getText().trim())) {
            guardar = false;
        }
        if (guardar) {
            RolPeriodoMD rpl = new RolPeriodoMD();
            rpl.setPeriodo(this.periodos.get(posFila - 1));
            rpl.setNombre_rol(this.frmRolPer.getTxtNombreRol().getText());
            if (this.editar) {
                rpl.setId_rol(this.idRolPrd);
                this.RPLBD.editarRolPeriodo(rpl);
                JOptionPane.showMessageDialog(null, "Datos editados correctamente");
            } else if (this.RPLBD.InsertarRol(rpl)) {
                JOptionPane.showMessageDialog(null, "Datos grabados correctamente");
            } else {
                JOptionPane.showMessageDialog(null, "Error en grabar los datos");
            }
            this.frmRolPer.dispose();
            this.ctrPrin.abrirVtnRolesPeriodos();
        }
    }

    public void iniciarValidaciones() {
        this.frmRolPer.getTxtNombreRol().addKeyListener(new TxtVLetras(this.frmRolPer.getTxtNombreRol(), this.frmRolPer.getLbl_error_roles()));
    }

    public void editarRolesPeriodos(RolPeriodoMD rp) {
        this.idRolPrd = rp.getId_rol();
        this.editar = true;
        this.frmRolPer.getTxtNombreRol().setText(rp.getNombre_rol());
        this.frmRolPer.getCmbPeriodoLectivo().setSelectedItem(rp.getPeriodo().getNombre());
    }
}

