/*
 * Decompiled with CFR 0.152.
 */
package controlador.docente;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.docente.DocenteMateriaBD;
import modelo.docente.DocenteMateriaMD;
import modelo.estilo.TblEstilo;
import modelo.materia.MateriaBD;
import modelo.materia.MateriaMD;
import modelo.persona.DocenteBD;
import modelo.persona.DocenteMD;
import modelo.validaciones.CmbValidar;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import vista.docente.FrmDocenteMateria;

public class FrmDocenteMateriaCTR
extends DCTR {
    private final FrmDocenteMateria frmDM;
    private final DocenteMateriaBD DMBD = DocenteMateriaBD.single();
    private DocenteMateriaMD docenMat;
    private final DocenteBD DBD = DocenteBD.single();
    private final CarreraBD CRBD = CarreraBD.single();
    private final MateriaBD MTBD = MateriaBD.single();
    private ArrayList<DocenteMD> docentes;
    private ArrayList<CarreraMD> carreras;
    private ArrayList<MateriaMD> materias;
    private ArrayList<Integer> ciclos;
    DefaultTableModel mdTbl;

    public FrmDocenteMateriaCTR(FrmDocenteMateria frmDM, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.frmDM = frmDM;
    }

    public void iniciar() {
        this.frmDM.getLblError().setText("");
        String[] titulo = new String[]{"C\u00e9dula", "Docente"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.frmDM.getTblDocentes().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.frmDM.getTblDocentes());
        TblEstilo.columnaMedida(this.frmDM.getTblDocentes(), 0, 100);
        this.estadoCmbCicloYMateria(false);
        this.llenarCmbCarrera();
        this.frmDM.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String a = FrmDocenteMateriaCTR.this.frmDM.getTxtBuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    FrmDocenteMateriaCTR.this.buscarDocente(a);
                }
            }
        });
        this.frmDM.getCmbCarrera().addActionListener(e -> this.clickCarreras());
        this.frmDM.getCmbCiclo().addActionListener(e -> this.clickCiclo());
        this.frmDM.getBtnBuscar().addActionListener(e -> this.buscarDocente(this.frmDM.getTxtBuscar().getText().trim()));
        this.frmDM.getBtnGuardar().addActionListener(e -> this.guardarYSalir());
        this.iniciarValidaciones();
        this.ctrPrin.agregarVtn(this.frmDM);
    }

    private void iniciarValidaciones() {
        this.frmDM.getCmbCarrera().addActionListener(new CmbValidar(this.frmDM.getCmbCarrera()));
        this.frmDM.getCmbCiclo().addActionListener(new CmbValidar(this.frmDM.getCmbCiclo()));
        this.frmDM.getCmbMateria().addActionListener(new CmbValidar(this.frmDM.getCmbMateria()));
        this.frmDM.getTxtBuscar().addKeyListener(new TxtVBuscador(this.frmDM.getTxtBuscar()));
    }

    private void guardarYSalir() {
        if (this.guardar()) {
            this.frmDM.dispose();
            this.ctrPrin.cerradoJIF();
        }
    }

    private boolean guardar() {
        boolean guardar = true;
        int posMat = this.frmDM.getCmbMateria().getSelectedIndex();
        int posDoc = this.frmDM.getTblDocentes().getSelectedRow();
        if (posMat < 1) {
            guardar = false;
        }
        if (posDoc < 0) {
            guardar = false;
        }
        if (guardar) {
            this.docenMat = this.DMBD.existeDocenteMateria(this.docentes.get(posDoc).getIdDocente(), this.materias.get(posMat - 1).getId());
            if (this.docenMat != null) {
                int r;
                this.frmDM.getLblError().setText("Ya se asigno esta materia al docente.");
                guardar = false;
                if (!this.docenMat.isActivo() && (r = JOptionPane.showConfirmDialog(null, "Ya se asigno esta materia pero se\nencuentra eliminada, desea activala.")) == 0) {
                    this.DMBD.activar(this.docenMat.getId());
                    this.frmDM.dispose();
                    this.ctrPrin.cerradoJIF();
                    this.ctrPrin.abrirVtnDocenteMateria();
                }
            } else {
                this.frmDM.getLblError().setText("");
            }
        }
        if (guardar) {
            DocenteMateriaMD dcm = new DocenteMateriaMD();
            dcm.setDocente(this.docentes.get(posDoc));
            dcm.setMateria(this.materias.get(posMat - 1));
            guardar = this.DMBD.guardar(dcm);
        }
        return guardar;
    }

    private void buscarDocente(String aguja) {
        if (Validar.esLetrasYNumeros(aguja)) {
            this.docentes = this.DBD.buscar(aguja);
            this.llenarTblDocentes(this.docentes);
        }
    }

    public void estadoCmbCicloYMateria(boolean estado) {
        this.frmDM.getCmbCiclo().setEnabled(estado);
        this.frmDM.getCmbCiclo().removeAllItems();
        this.frmDM.getCmbMateria().setEnabled(estado);
        this.frmDM.getCmbMateria().removeAllItems();
    }

    private void clickCarreras() {
        int posCar = this.frmDM.getCmbCarrera().getSelectedIndex();
        if (posCar > 0) {
            this.estadoCmbCicloYMateria(true);
            int idCar = this.carreras.get(posCar - 1).getId();
            this.ciclos = this.MTBD.cargarCiclosCarrera(idCar);
            this.llenarCmbCiclo(this.ciclos);
        } else {
            this.estadoCmbCicloYMateria(false);
        }
    }

    private void clickCiclo() {
        int posCar = this.frmDM.getCmbCarrera().getSelectedIndex();
        int posCic = this.frmDM.getCmbCiclo().getSelectedIndex();
        if (posCar > 0 && posCic > 0) {
            this.materias = this.MTBD.cargarMateriaPorCarreraCiclo(this.carreras.get(posCar - 1).getId(), posCic);
            this.llenarCmbMaterias(this.materias);
        } else {
            this.clickCarreras();
        }
    }

    private void llenarCmbCarrera() {
        this.frmDM.getCmbCarrera().removeAllItems();
        this.carreras = this.CRBD.cargarCarreras();
        if (this.carreras != null) {
            this.frmDM.getCmbCarrera().addItem("Seleccione");
            this.carreras.forEach(c -> this.frmDM.getCmbCarrera().addItem(c.getCodigo()));
        }
    }

    private void llenarCmbMaterias(ArrayList<MateriaMD> materias) {
        this.frmDM.getCmbMateria().removeAllItems();
        if (materias != null) {
            this.frmDM.getCmbMateria().addItem("Todos");
            materias.forEach(m -> this.frmDM.getCmbMateria().addItem(m.getNombre()));
        }
    }

    private void llenarCmbCiclo(ArrayList<Integer> ciclos) {
        this.frmDM.getCmbCiclo().removeAllItems();
        if (ciclos != null) {
            this.frmDM.getCmbCiclo().addItem("Todos");
            ciclos.forEach(c -> this.frmDM.getCmbCiclo().addItem(c + ""));
            this.frmDM.getCmbCiclo().setSelectedIndex(0);
        }
    }

    private void llenarTblDocentes(ArrayList<DocenteMD> docentes) {
        this.mdTbl.setRowCount(0);
        if (docentes != null) {
            docentes.forEach(d -> {
                Object[] valores = new Object[]{d.getIdentificacion(), d.getNombreCompleto()};
                this.mdTbl.addRow(valores);
            });
        }
    }
}

