/*
 * Decompiled with CFR 0.152.
 */
package controlador.curso;

import controlador.curso.FrmCursoCTR;
import controlador.curso.JDHorarioCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import modelo.alumno.AlumnoCursoMD;
import modelo.curso.CursoBD;
import modelo.curso.CursoMD;
import modelo.estilo.TblEstilo;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import vista.curso.FrmCurso;
import vista.curso.VtnCurso;

public class VtnCursoCTR
extends DVtnCTR {
    private final VtnCurso vtnCurso;
    private ArrayList<AlumnoCursoMD> almns;
    private final CursoBD CBD = CursoBD.single();
    private ArrayList<CursoMD> cursos;
    private final PeriodoLectivoBD PLBD = PeriodoLectivoBD.single();
    private ArrayList<PeriodoLectivoMD> periodos;
    private ArrayList<String> nombresC;
    private String b;

    public VtnCursoCTR(VtnCurso vtnCurso, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnCurso = vtnCurso;
    }

    public void iniciar() {
        this.vtnCurso.getBtnListaAlumnos().setEnabled(false);
        this.vtnCurso.getBtnListaSilabos().setEnabled(false);
        String[] titulo = new String[]{"id", "Periodo", "Materia", "Cedula", "Docente", "Ciclo", "Curso", "Capacidad", "Matriculados"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.vtnCurso.getTblCurso().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.vtnCurso.getTblCurso());
        TblEstilo.ocualtarID(this.vtnCurso.getTblCurso());
        TblEstilo.columnaMedida(this.vtnCurso.getTblCurso(), 3, 100);
        TblEstilo.columnaMedida(this.vtnCurso.getTblCurso(), 5, 60);
        TblEstilo.columnaMedida(this.vtnCurso.getTblCurso(), 6, 60);
        TblEstilo.columnaMedida(this.vtnCurso.getTblCurso(), 7, 70);
        TblEstilo.columnaMedida(this.vtnCurso.getTblCurso(), 8, 70);
        this.cargarCmbPrdLectio();
        this.cargarNombreCursos();
        this.vtnCurso.getCmbPeriodoLectivo().setSelectedIndex(0);
        this.cargarCursosPorPeriodo();
        this.vtnCurso.getBtnIngresar().addActionListener(e -> this.abrirFrmCurso());
        this.vtnCurso.getBtnEditar().addActionListener(e -> this.editarCurso());
        this.vtnCurso.getBtnEliminar().addActionListener(e -> this.eliminarCurso());
        this.vtnCurso.getBtnHorario().addActionListener(e -> this.horario());
        this.vtnCurso.getCbxEliminados().addActionListener(e -> this.verCursosEliminados());
        this.vtnCurso.getCmbPeriodoLectivo().addActionListener(e -> this.cargarCursosPorPeriodo());
        this.vtnCurso.getCmbCurso().addActionListener(e -> this.cargarCursosPorNombre());
        this.vtnCurso.getBtnBuscar().addActionListener(e -> this.buscar(this.vtnCurso.getTxtBuscar().getText().trim()));
        this.vtnCurso.getBtnBuscar().addKeyListener(new TxtVBuscador(this.vtnCurso.getTxtBuscar(), this.vtnCurso.getBtnBuscar()));
        this.vtnCurso.getTblCurso().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VtnCursoCTR.this.validarBotonesReportes();
            }
        });
        this.vtnCurso.getBtnListaAlumnos().addActionListener(e -> this.reporteListaAlumnos());
        this.vtnCurso.getBtnListaSilabos().addActionListener(e -> this.reporteListaSilabos());
        this.iniciarBuscador();
        this.ctrPrin.agregarVtn(this.vtnCurso);
        this.InitPermisos();
    }

    private void iniciarBuscador() {
        this.vtnCurso.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VtnCursoCTR.this.b = VtnCursoCTR.this.vtnCurso.getTxtBuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    VtnCursoCTR.this.buscar(VtnCursoCTR.this.b);
                } else if (VtnCursoCTR.this.b.length() == 0) {
                    VtnCursoCTR.this.cargarCursos();
                }
            }
        });
    }

    public void abrirFrmCurso() {
        FrmCurso frmCurso = new FrmCurso();
        this.ctrPrin.eventoInternal(frmCurso);
        FrmCursoCTR ctrFrmCurso = new FrmCursoCTR(frmCurso, this.ctrPrin, this);
        ctrFrmCurso.iniciar();
        this.vtnCurso.setVisible(false);
    }

    private void editarCurso() {
        this.posFila = this.vtnCurso.getTblCurso().getSelectedRow();
        if (this.posFila >= 0) {
            FrmCurso frmCurso = new FrmCurso();
            FrmCursoCTR ctrFrmCurso = new FrmCursoCTR(frmCurso, this.ctrPrin, this);
            ctrFrmCurso.iniciar();
            this.ctrPrin.eventoInternal(frmCurso);
            ctrFrmCurso.editar(this.cursos.get(this.posFila));
            this.vtnCurso.setVisible(false);
        }
    }

    public void actualizarVtn() {
        int posPrd = this.vtnCurso.getCmbPeriodoLectivo().getSelectedIndex();
        int posCur = this.vtnCurso.getCmbCurso().getSelectedIndex();
        if (this.vtnCurso.getTxtBuscar().getText().length() > 0) {
            this.buscar(this.vtnCurso.getTxtBuscar().getText().trim());
        } else if (posPrd > 0 && posCur > 0) {
            this.cargarCursosPorNombre();
        } else if (posPrd > 0) {
            this.cargarCursosPorPeriodo();
        } else {
            this.cargarCursos();
        }
        this.vtnCurso.setVisible(true);
    }

    private void buscar(String b) {
        if (Validar.esLetrasYNumeros(b)) {
            this.cursos = this.CBD.buscarCursos(b);
            this.llenarTbl(this.cursos);
        } else {
            System.out.println("No ingrese caracteres especiales");
        }
    }

    public void cargarCursos() {
        this.cursos = this.CBD.cargarCursos();
        this.llenarTbl(this.cursos);
        System.out.println("Se cargaron cursos");
    }

    public void cargarNombreCursos() {
        this.nombresC = this.CBD.cargarNombreCursos();
        this.cargarCmbCursos(this.nombresC);
    }

    private void cargarCursosPorPeriodo() {
        this.vtnCurso.getTxtBuscar().setText("");
        int posPrd = this.vtnCurso.getCmbPeriodoLectivo().getSelectedIndex();
        if (posPrd >= 0) {
            this.nombresC = this.CBD.cargarNombreCursosPorPeriodo(this.periodos.get(posPrd).getID());
            this.cargarCmbCursos(this.nombresC);
            this.cursos = this.CBD.cargarCursosPorPeriodo(this.periodos.get(posPrd).getID());
            this.llenarTbl(this.cursos);
        } else {
            this.cargarCursos();
        }
    }

    private void cargarCursosPorNombre() {
        this.vtnCurso.getTxtBuscar().setText("");
        int posNom = this.vtnCurso.getCmbCurso().getSelectedIndex();
        int posPrd = this.vtnCurso.getCmbPeriodoLectivo().getSelectedIndex();
        if (posNom == 0) {
            this.cargarCursosPorPeriodo();
        } else if (posNom > 0 && posPrd == 0) {
            this.cursos = this.CBD.cargarCursosPorNombre(this.vtnCurso.getCmbCurso().getSelectedItem().toString());
            this.llenarTbl(this.cursos);
        } else if (posNom > 0 && posPrd >= 0) {
            this.cursos = this.CBD.cargarCursosPorNombreYPrdLectivo(this.vtnCurso.getCmbCurso().getSelectedItem().toString(), this.periodos.get(posPrd).getID());
            this.llenarTbl(this.cursos);
        }
    }

    private void llenarTbl(ArrayList<CursoMD> cursos) {
        this.mdTbl.setRowCount(0);
        if (cursos != null) {
            cursos.forEach(c -> {
                Object[] valores = new Object[]{c.getId(), c.getPeriodo().getNombre(), c.getMateria().getNombre(), c.getDocente().getIdentificacion(), c.getDocente().getPrimerNombre() + " " + c.getDocente().getPrimerApellido(), c.getCiclo(), c.getNombre(), c.getCapacidad(), c.getNumMatriculados()};
                this.mdTbl.addRow(valores);
            });
            this.vtnCurso.getLblResultados().setText(cursos.size() + " Resultados obtenidos.");
        } else {
            this.vtnCurso.getLblResultados().setText("0 Resultados obtenidos.");
        }
    }

    private void cargarCmbPrdLectio() {
        this.periodos = this.PLBD.cargarPrdParaCmbVtn();
        this.vtnCurso.getCmbPeriodoLectivo().removeAllItems();
        if (this.periodos != null) {
            this.periodos.forEach(p -> this.vtnCurso.getCmbPeriodoLectivo().addItem(p.getNombre()));
            this.vtnCurso.getCmbPeriodoLectivo().addItem("Todos");
        }
    }

    public void reporteListaAlumnos() {
        String path = "/vista/reportes/repListaAlumno.jasper";
        try {
            this.posFila = this.vtnCurso.getTblCurso().getSelectedRow();
            HashMap<String, Integer> parametro = new HashMap<String, Integer>();
            parametro.put("curso", this.cursos.get(this.posFila).getId());
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
            CON.mostrarReporte(jr, parametro, "Lista de estudiantes");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
        }
    }

    public void reporteListaSilabos() {
        String titleRepor = JOptionPane.showInputDialog("Escriba el t\u00edtulo para su reporte");
        if (titleRepor.length() > 5) {
            String path = "/vista/reportes/repListaSocializacion_1.jasper";
            try {
                this.posFila = this.vtnCurso.getTblCurso().getSelectedRow();
                HashMap<String, Object> parametro = new HashMap<String, Object>();
                parametro.put("curso", this.cursos.get(this.posFila).getId());
                parametro.put("titulo", titleRepor);
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Socializaci\u00f3n S\u00edlabos");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "error " + ex.getMessage() + ex.getMessageKey());
            }
        } else {
            JOptionPane.showMessageDialog(null, "Escriba primero un t\u00edtulo");
            this.reporteListaSilabos();
        }
    }

    private void cargarCmbCursos(ArrayList<String> nombresC) {
        this.vtnCurso.getCmbCurso().removeAllItems();
        if (nombresC != null) {
            this.vtnCurso.getCmbCurso().addItem("Todos");
            nombresC.forEach(n -> this.vtnCurso.getCmbCurso().addItem((String)n));
            this.vtnCurso.getCmbCurso().setSelectedIndex(0);
        }
    }

    private void eliminarCurso() {
        int posCur = this.vtnCurso.getTblCurso().getSelectedRow();
        if (posCur >= 0) {
            String nom = this.vtnCurso.getTblCurso().getValueAt(posCur, 5).toString();
            int num = this.CBD.numAlumnos(this.cursos.get(posCur).getId());
            int r = JOptionPane.showConfirmDialog(this.vtnCurso, "Seguro quiere " + this.vtnCurso.getBtnEliminar().getText().toLowerCase() + " el curso " + nom + "\nSe " + this.vtnCurso.getBtnEliminar().getText().toLowerCase() + "an todos los alumnos de este curso: " + num);
            if (r == 0) {
                if (this.vtnCurso.getCbxEliminados().isSelected()) {
                    this.CBD.activarCurso(this.cursos.get(posCur).getId());
                } else {
                    this.CBD.eliminarCurso(this.cursos.get(posCur).getId());
                }
                this.verCursosEliminados();
            }
        } else {
            JOptionPane.showMessageDialog(this.vtnCurso, "Debe seleccionar una final antes.");
        }
    }

    private void verCursosEliminados() {
        if (this.vtnCurso.getCbxEliminados().isSelected()) {
            this.cursos = this.CBD.cargarCursosEliminados();
            this.llenarTbl(this.cursos);
            this.vtnCurso.getBtnEliminar().setText("Activar");
        } else {
            this.cursos = this.CBD.cargarCursos();
            this.llenarTbl(this.cursos);
            this.vtnCurso.getBtnEliminar().setText("Eliminar");
        }
    }

    private void InitPermisos() {
        this.vtnCurso.getBtnHorario().getAccessibleContext().setAccessibleName("Cursos-Horarios");
        this.vtnCurso.getCbxEliminados().getAccessibleContext().setAccessibleName("Cursos-Ver Eliminados");
        this.vtnCurso.getBtnEliminar().getAccessibleContext().setAccessibleName("Cursos-Eliminar");
        this.vtnCurso.getBtnEditar().getAccessibleContext().setAccessibleName("Cursos-Editar");
        this.vtnCurso.getBtnIngresar().getAccessibleContext().setAccessibleName("Cursos-Ingresar");
        this.vtnCurso.getBtnListaSilabos().getAccessibleContext().setAccessibleName("Cursos-Reporte-Lista para silabos");
        this.vtnCurso.getBtnListaAlumnos().getAccessibleContext().setAccessibleName("Cursos-Reporte-Lista de alumnos");
        CONS.activarBtns(this.vtnCurso.getBtnHorario(), this.vtnCurso.getCbxEliminados(), this.vtnCurso.getBtnEliminar(), this.vtnCurso.getBtnEditar(), this.vtnCurso.getBtnIngresar(), this.vtnCurso.getBtnListaAlumnos(), this.vtnCurso.getBtnListaSilabos());
    }

    public void validarBotonesReportes() {
        int selecTabl = this.vtnCurso.getTblCurso().getSelectedRow();
        if (selecTabl >= 0) {
            this.vtnCurso.getBtnListaAlumnos().setEnabled(true);
            this.vtnCurso.getBtnListaSilabos().setEnabled(true);
        } else {
            this.vtnCurso.getBtnListaAlumnos().setEnabled(false);
            this.vtnCurso.getBtnListaSilabos().setEnabled(false);
        }
    }

    private void horario() {
        this.posFila = this.vtnCurso.getTblCurso().getSelectedRow();
        if (this.posFila >= 0) {
            JDHorarioCTR ctr = new JDHorarioCTR(this.ctrPrin, this.cursos.get(this.posFila));
            ctr.iniciar();
        } else {
            JOptionPane.showMessageDialog(this.vtnCurso, "Antes debe seleccionar un curso.");
        }
    }

    public void boton() {
    }
}

