/*
 * Decompiled with CFR 0.152.
 */
package controlador.curso;

import java.time.LocalTime;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import modelo.curso.CursoMD;
import modelo.curso.SesionClaseBD;
import modelo.curso.SesionClaseMD;
import modelo.estilo.TblEstilo;
import modelo.periodolectivo.PeriodoLectivoMD;
import vista.curso.PnlHorarioClase;

public class PnlHorarioCursoCTR {
    private final PnlHorarioClase pnl;
    private final CursoMD curso;
    private final SesionClaseBD SCBD = SesionClaseBD.single();
    private ArrayList<SesionClaseMD> sesionLunes;
    private ArrayList<SesionClaseMD> sesionMartes;
    private ArrayList<SesionClaseMD> sesionMiercoles;
    private ArrayList<SesionClaseMD> sesionJueves;
    private ArrayList<SesionClaseMD> sesionViernes;
    private ArrayList<SesionClaseMD> sesionSabado;
    private DefaultTableModel mdTbl;
    private final String[][] datos = new String[0][];
    private final String[] t = new String[]{"H", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sabado"};
    private final String[] tn = new String[]{"H", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sabado"};
    private final String[] hm = new String[]{"07:00", "08:00", "09:00", "10:00", "11:00", "12:00", "13:00", "14:00", "15:00", "16:00", "17:00", "18:00", "19:00", "20:00", "21:00", "22:00"};
    private final String[] hmc = new String[]{"<html>07:00<br>08:00</html>", "<html>08:00<br>09:00</html>", "<html>09:00<br>10:00</html>", "<html>10:00<br>11:00</html>", "<html>11:00<br>12:00</html>", "<html>12:00<br>13:00</html>", "<html>13:00<br>14:00</html>", "<html>14:00<br>15:00</html>", "<html>15:00<br>16:00</html>", "<html>16:00<br>17:00</html>", "<html>17:00<br>18:00</html>", "<html>18:00<br>19:00</html>", "<html>19:00<br>20:00</html>", "<html>20:00<br>21:00</html>", "<html>21:00<br>22:00</html>"};
    private String[] hSelec;
    private String[] jSelec;
    private String[] tSelec;
    private int posI;
    private int posF;
    private int posFila;
    private int posColum;
    private String horaString;
    private String minutoString;

    public PnlHorarioCursoCTR(PnlHorarioClase pnl, CursoMD curso) {
        this.pnl = pnl;
        this.curso = curso;
    }

    public PnlHorarioCursoCTR(PnlHorarioClase pnl, String nomCurso, int idPrd) {
        this.pnl = pnl;
        this.curso = new CursoMD();
        this.curso.setNombre(nomCurso);
        PeriodoLectivoMD p = new PeriodoLectivoMD();
        p.setID(idPrd);
        this.curso.setPeriodo(p);
    }

    public void iniciar() {
        this.iniciaTbl();
        this.eliminarFilasSinDatos();
        this.eliminarColumnasSinDatos();
    }

    private void iniciaTbl() {
        switch (this.curso.getNombre().charAt(0)) {
            case 'M': {
                this.mdTbl = TblEstilo.modelTblSinEditar(this.datos, this.t);
                this.formatoTbl(this.pnl.getTblHorario());
                this.llenarHoras(this.hmc);
                this.hSelec = this.hm;
                this.jSelec = this.t;
                this.llenarLunesSabado();
                break;
            }
            case 'V': {
                this.mdTbl = TblEstilo.modelTblSinEditar(this.datos, this.t);
                this.formatoTbl(this.pnl.getTblHorario());
                this.llenarHoras(this.hmc);
                this.hSelec = this.hm;
                this.jSelec = this.t;
                this.llenarLunesSabado();
                break;
            }
            case 'N': {
                this.mdTbl = TblEstilo.modelTblSinEditar(this.datos, this.tn);
                this.formatoTbl(this.pnl.getTblHorario());
                this.llenarHoras(this.hmc);
                this.hSelec = this.hm;
                this.jSelec = this.tn;
                this.llenarLunesSabado();
                break;
            }
            default: {
                this.mdTbl = TblEstilo.modelTblSinEditar(this.datos, this.tn);
                this.formatoTbl(this.pnl.getTblHorario());
                this.llenarHoras(this.hmc);
                this.hSelec = this.hm;
                this.jSelec = this.tn;
                this.llenarLunesSabado();
            }
        }
    }

    private void llenarLunesViernes() {
        this.actualizarLunes();
        this.actualizarMartes();
        this.actualizarMiercoles();
        this.actuatizarJueves();
        this.actualizarViernes();
    }

    private void llenarLunesSabado() {
        this.llenarLunesViernes();
        this.actualizarSabado();
    }

    private void formatoTbl(JTable tbl) {
        tbl.setModel(this.mdTbl);
        TblEstilo.formatoTblHCurso(tbl);
    }

    private void llenarHoras(String[] horas) {
        for (String h : horas) {
            Object[] v = new Object[]{h};
            this.mdTbl.addRow(v);
        }
    }

    private void llenarDia(ArrayList<SesionClaseMD> sesiones, int dia) {
        if (sesiones != null) {
            sesiones.forEach(s -> this.buscarClm((SesionClaseMD)s, dia));
        }
    }

    private void buscarClm(SesionClaseMD s, int dia) {
        int i;
        for (i = 0; i < this.hSelec.length; ++i) {
            if (!this.hSelec[i].equals(this.tranformar(s.getHoraIni()))) continue;
            this.posI = i;
            break;
        }
        for (i = 0; i < this.hSelec.length; ++i) {
            if (!this.hSelec[i].equals(this.tranformar(s.getHoraFin()))) continue;
            this.posF = i;
            break;
        }
        for (i = this.posI; i < this.posF; ++i) {
            this.mdTbl.setValueAt("<html> <center>" + s.getId() + "" + s.getCurso().getId() + "<br>" + s.getCurso().getMateria().getNombre() + "<br>" + s.getCurso().getDocente().getNombreCorto() + "</center></html>", i, dia);
        }
    }

    private String tranformar(LocalTime hora) {
        this.horaString = hora.getHour() < 10 ? "0" + hora.getHour() : "" + hora.getHour();
        this.minutoString = hora.getMinute() < 10 ? "0" + hora.getMinute() : "" + hora.getMinute();
        return this.horaString + ":" + this.minutoString;
    }

    public void actualizarLunes() {
        this.sesionLunes = this.SCBD.cargarHorarioCursoPorDia(this.curso.getNombre(), 1, this.curso.getPeriodo().getID());
        this.llenarDia(this.sesionLunes, 1);
    }

    public void actualizarMartes() {
        this.sesionMartes = this.SCBD.cargarHorarioCursoPorDia(this.curso.getNombre(), 2, this.curso.getPeriodo().getID());
        this.llenarDia(this.sesionMartes, 2);
    }

    public void actualizarMiercoles() {
        this.sesionMiercoles = this.SCBD.cargarHorarioCursoPorDia(this.curso.getNombre(), 3, this.curso.getPeriodo().getID());
        this.llenarDia(this.sesionMiercoles, 3);
    }

    public void actuatizarJueves() {
        this.sesionJueves = this.SCBD.cargarHorarioCursoPorDia(this.curso.getNombre(), 4, this.curso.getPeriodo().getID());
        this.llenarDia(this.sesionJueves, 4);
    }

    public void actualizarViernes() {
        this.sesionViernes = this.SCBD.cargarHorarioCursoPorDia(this.curso.getNombre(), 5, this.curso.getPeriodo().getID());
        this.llenarDia(this.sesionViernes, 5);
    }

    public void actualizarSabado() {
        this.sesionSabado = this.SCBD.cargarHorarioCursoPorDia(this.curso.getNombre(), 6, this.curso.getPeriodo().getID());
        this.llenarDia(this.sesionSabado, 6);
    }

    private void eliminarFilasSinDatos() {
        for (int i = 0; i < this.mdTbl.getRowCount(); ++i) {
            boolean borrar = true;
            for (int j = 1; j < this.mdTbl.getColumnCount(); ++j) {
                if (this.mdTbl.getValueAt(i, j) == null) continue;
                borrar = false;
            }
            if (!borrar) continue;
            this.mdTbl.removeRow(i);
            this.eliminarFilasSinDatos();
        }
    }

    private void eliminarColumnasSinDatos() {
        for (int i = 1; i < this.pnl.getTblHorario().getColumnCount(); ++i) {
            boolean borrar = true;
            for (int j = 0; j < this.mdTbl.getRowCount(); ++j) {
                if (this.mdTbl.getValueAt(j, i) == null) continue;
                borrar = false;
            }
            if (!borrar) continue;
            TableColumnModel tcm = this.pnl.getTblHorario().getColumnModel();
            TableColumn cb = tcm.getColumn(i);
            this.pnl.getTblHorario().removeColumn(cb);
            this.eliminarColumnasSinDatos();
        }
    }
}

