/*
 * Decompiled with CFR 0.152.
 */
package controlador.curso;

import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import modelo.curso.CursoMD;
import modelo.curso.SesionClaseBD;
import modelo.curso.SesionClaseMD;
import modelo.estilo.TblEstilo;
import utils.CONS;
import vista.curso.PnlHorarioClase;

public class PnlHorarioClaseCTR {
    private final PnlHorarioClase pnl;
    private final CursoMD curso;
    private final SesionClaseBD bd;
    private ArrayList<SesionClaseMD> sesiones;
    private DefaultTableModel mdTbl;
    private final String[][] datos = new String[0][];
    private final String[] t = new String[]{"Dia", "Hora Inicia", "Hora Fin", "Clase"};
    private final String[] hm = new String[]{"07:00", "08:00", "09:00", "10:00", "11:00", "12:00", "13:00", "14:00", "15:00", "16:00", "17:00", "18:00", "19:00", "20:00", "21:00", "22:00"};
    private String[] hSelec;
    private String[] jSelec;
    private String[] tSelec;

    public PnlHorarioClaseCTR(PnlHorarioClase pnl, CursoMD curso, SesionClaseBD bd) {
        this.pnl = pnl;
        this.curso = curso;
        this.bd = bd;
    }

    public void iniciar() {
        this.iniciaTbl();
    }

    private void iniciaTbl() {
        this.mdTbl = TblEstilo.modelTblSinEditar(this.datos, this.t);
        this.formatoTbl(this.pnl.getTblHorario());
        this.hSelec = this.hm;
        this.jSelec = this.t;
        this.llenarHorarios();
    }

    private void llenarHorarios() {
        this.mdTbl.setRowCount(0);
        this.sesiones = this.bd.cargarHorarioCurso(this.curso);
        if (this.sesiones != null) {
            System.out.println("---------");
            this.sesiones.forEach(s -> {
                System.out.println("Dia: " + s.getDia() + "  Horas: " + s.getHoraIni() + "    " + s.getHoraFin());
                Object[] v = new Object[]{CONS.getDia(s.getDia()), s.getHoraIni(), s.getHoraFin(), s.getId() + "%Clase \nEditar | Eliminar"};
                this.mdTbl.addRow(v);
            });
            System.out.println("---------");
        }
    }

    private void formatoTbl(JTable tbl) {
        tbl.setModel(this.mdTbl);
        TblEstilo.formatoTblFocus(tbl);
    }

    public String[] gethSelec() {
        return this.hSelec;
    }

    public String[] getjSelec() {
        return this.jSelec;
    }

    public String[] gettSelec() {
        return this.tSelec;
    }

    public void actualizar(int dia) {
        this.llenarHorarios();
    }
}

